/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

public class FIFOStringBuffer {
    private int size;
    private String[] buffer;
    private int nextPos = 0;
    private int lastPos = 0;
    private boolean looseData = false;
    private static final String newLine = System.getProperty("line.separator");

    public FIFOStringBuffer(int size) {
        this.size = size;
        this.buffer = new String[size];
    }

    public synchronized void reset() {
        this.buffer = new String[this.size];
        this.nextPos = 0;
        this.lastPos = 0;
        this.looseData = false;
    }

    public void append(String text) {
        this.buffer[this.nextPos] = text;
        if (this.looseData) {
            this.lastPos = this.loopIncrement(this.lastPos);
        }
        this.nextPos = this.loopIncrement(this.nextPos);
        if (this.nextPos == 0) {
            this.looseData = true;
        }
        System.out.print("");
    }

    public String toString() {
        int idx = this.lastPos;
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            if (this.buffer[idx] != null) {
                out.append(this.buffer[idx]);
            }
            out.append(newLine);
            idx = this.loopIncrement(idx);
            ++i;
        }
        return out.toString();
    }

    public int getCurrentLineNumber() {
        if (!this.looseData) {
            return this.nextPos;
        }
        return this.size;
    }

    public String toString(int top, int number) {
        if (top + number > this.size) {
            throw new IndexOutOfBoundsException("top:" + top + " number:" + number);
        }
        int idx = this.loopAdd(this.lastPos, top);
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < number) {
            if (this.buffer[idx] != null) {
                out.append(this.buffer[idx]);
            }
            out.append(newLine);
            idx = this.loopIncrement(idx);
            ++i;
        }
        return out.toString();
    }

    public String[] toStrings(int top, int number) {
        if (top + number > this.size) {
            throw new IndexOutOfBoundsException("top:" + top + " number:" + number);
        }
        String[] toReturn = new String[number];
        int idx = this.loopAdd(this.lastPos, top);
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < number) {
            if (this.buffer[idx] != null) {
                toReturn[i] = this.buffer[idx];
            }
            idx = this.loopIncrement(idx);
            ++i;
        }
        return toReturn;
    }

    private int loopIncrement(int val) {
        if (++val >= this.size) {
            val = 0;
        }
        return val;
    }

    private int loopAdd(int val, int add) {
        if ((val += add) >= this.size) {
            val = 0 + val - this.size;
        }
        return val;
    }

    public static void main(String[] args) {
        FIFOStringBuffer fifoBuf = new FIFOStringBuffer(7);
        int i = 0;
        while (i < 50) {
            fifoBuf.append(String.valueOf(i));
            System.out.println(fifoBuf.toString(0, 7));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }
}

