/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.tp23.gui.widget.TextBufferPanel;

public class SystemOutPanel
extends JScrollPane {
    BorderLayout borderLayout1 = new BorderLayout();
    TextBufferPanel textBufferPanel;

    public SystemOutPanel(int bufferSize) {
        this.textBufferPanel = new TextBufferPanel(bufferSize);
        this.textBufferPanel.setJScrollPane(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAsSystemErr() {
        System.setErr(this.textBufferPanel.getOut());
    }

    public void setAsSystemOut() {
        System.setOut(this.textBufferPanel.getOut());
    }

    public PrintStream getOut() {
        return this.textBufferPanel.getOut();
    }

    public static JFrame getSystemOutFrame() {
        return SystemOutPanel.getAsJFrame(false);
    }

    public static JFrame getSystemErrFrame() {
        return SystemOutPanel.getAsJFrame(true);
    }

    public static JFrame getSystemOutFrame(int bufferSize) {
        return SystemOutPanel.getAsJFrame(false, bufferSize);
    }

    public static JFrame getSystemErrFrame(int bufferSize) {
        return SystemOutPanel.getAsJFrame(true, bufferSize);
    }

    private static JFrame getAsJFrame(boolean err) {
        return SystemOutPanel.getAsJFrame(err, 1000);
    }

    private static JFrame getAsJFrame(boolean err, int bufferSize) {
        SystemOutPanel out = new SystemOutPanel(bufferSize);
        JFrame outFrame = new JFrame();
        if (err) {
            out.setAsSystemErr();
            outFrame.setTitle("System.err");
        } else {
            out.setAsSystemOut();
            outFrame.setTitle("System.out");
        }
        outFrame.getContentPane().add((Component)out, null);
        outFrame.setDefaultCloseOperation(1);
        outFrame.setLocation(230, 23);
        outFrame.setSize(450, 500);
        return outFrame;
    }

    public void setAntialiased(boolean antialiased) {
        this.textBufferPanel.setAntialiased(antialiased);
    }

    private void jbInit() throws Exception {
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.getViewport().setView(this.textBufferPanel);
        JButton jumpButton = new JButton("");
        this.setCorner("LOWER_RIGHT_CORNER", jumpButton);
        jumpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SystemOutPanel.this.textBufferPanel.scrollToEnd();
            }
        });
        jumpButton.setToolTipText("Click to jump to the end");
        this.setLocation(230, 23);
        this.setSize(450, 500);
        this.getViewport().setBackground(TextBufferPanel.BACK_COLOR);
        jumpButton.setFocusable(false);
        this.getVerticalScrollBar().setFocusable(false);
        this.getHorizontalScrollBar().setFocusable(false);
    }

    public static void main(String[] args) {
        try {
            JFrame testFrame = SystemOutPanel.getAsJFrame(false);
            testFrame.show();
            int i = 1;
            while (i <= 5000) {
                String longline = "";
                int width = 0;
                while (width < 100) {
                    longline = String.valueOf(longline) + " " + String.valueOf(i);
                    ++width;
                }
                System.out.println("hello world:" + longline);
                try {
                    Thread.sleep(1000L);
                    throw new Exception("test");
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

