/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.tp23.gui.widget.CallbackPrintStream;
import org.tp23.gui.widget.FIFOStringBuffer;
import org.tp23.gui.widget.SelectFileAction;

public class TextBufferPanel
extends JPanel
implements Scrollable {
    public static final Color BACK_COLOR = Color.white;
    public static final Color FORE_COLOR = Color.black;
    private int lineBufferSize;
    public int LINE_HEIGHT = 16;
    private int PANEL_WIDTH = 500;
    private int PANEL_HEIGHT = this.lineBufferSize * this.LINE_HEIGHT;
    private int LEFT_INDENT = 5;
    private FIFOStringBuffer lineBuffer = null;
    private int biggestLine = 0;
    private static final String newLine = System.getProperty("line.separator");
    private JScrollPane scrollPane = null;
    private boolean follow = false;
    private boolean antialiased;

    public TextBufferPanel(int size) {
        this.lineBufferSize = size;
        this.lineBuffer = new FIFOStringBuffer(this.lineBufferSize);
        this.PANEL_HEIGHT = this.lineBufferSize * this.LINE_HEIGHT;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getText() {
        return this.lineBuffer.toString();
    }

    public void resetText() {
        this.lineBuffer.reset();
        this.repaint();
    }

    public PrintStream getOut() {
        CallbackPrintStream writer = new CallbackPrintStream(this);
        return writer;
    }

    public synchronized void append(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, newLine);
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            this.lineBuffer.append(line);
            if (line.length() <= this.biggestLine) continue;
            this.biggestLine = line.length();
            int newWidth = this.biggestLine * 8;
            if (newWidth <= this.PANEL_WIDTH) continue;
            this.PANEL_WIDTH = newWidth;
            super.setSize(this.PANEL_WIDTH, this.PANEL_HEIGHT);
        }
        int currPos = this.getCurrentPos();
        if (this.follow) {
            this.scrollRectToVisible(new Rectangle(0, currPos, this.PANEL_WIDTH, this.LINE_HEIGHT));
            Container parent = this.getParent();
            if (parent != null) {
                parent.repaint();
            }
        } else {
            Rectangle r = this.getVisibleRect();
            if (r != null && r.intersects(0.0, currPos, this.PANEL_WIDTH, this.LINE_HEIGHT)) {
                this.getParent().repaint();
            }
        }
    }

    public int getCurrentLine() {
        return this.lineBuffer.getCurrentLineNumber();
    }

    public int getCurrentPos() {
        return this.lineBuffer.getCurrentLineNumber() * this.LINE_HEIGHT;
    }

    void jbInit() throws Exception {
        this.setBackground(BACK_COLOR);
        this.setForeground(FORE_COLOR);
        this.setLineHeight();
        this.setBounds(0, 0, this.PANEL_WIDTH, this.PANEL_HEIGHT);
        this.setAutoscrolls(true);
        final JPopupMenu popUp = this.getPopupMenu();
        this.add(popUp);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    popUp.show(TextBufferPanel.this, e.getX(), e.getY());
                }
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle areaToPaint = (Rectangle)g.getClip();
        int linesFromTop = (int)areaToPaint.getY() / this.LINE_HEIGHT;
        int linesToPaint = (int)areaToPaint.getHeight() / this.LINE_HEIGHT;
        if (areaToPaint.intersects(new Rectangle(0, this.PANEL_HEIGHT - 3, this.PANEL_WIDTH, Integer.MAX_VALUE))) {
            g.clearRect(areaToPaint.x, this.PANEL_HEIGHT - 3, areaToPaint.width, areaToPaint.height);
            g.setColor(this.getBackground());
            g.fillRect(areaToPaint.x, this.PANEL_HEIGHT - 3, areaToPaint.width, areaToPaint.height);
            g.setColor(this.getForeground());
        }
        this.paintTextArea(g, linesFromTop, linesToPaint + 1);
    }

    private void paintTextArea(Graphics g, int top, int number) {
        if (top > this.lineBufferSize) {
            top = this.lineBufferSize;
        }
        if (top + number > this.lineBufferSize) {
            number = this.lineBufferSize - top;
        }
        String[] linesToDisplay = this.lineBuffer.toStrings(top, number);
        this.drawLines(linesToDisplay, top, g);
    }

    private void drawLines(String[] linesToDisplay, int top, Graphics g) {
        int ypos = this.LINE_HEIGHT * top + this.LINE_HEIGHT;
        g.clearRect(0, this.LINE_HEIGHT * top, this.PANEL_WIDTH, linesToDisplay.length * this.LINE_HEIGHT);
        g.setColor(this.getBackground());
        g.fillRect(0, this.LINE_HEIGHT * top, this.PANEL_WIDTH, linesToDisplay.length * this.LINE_HEIGHT);
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        Graphics2D g2 = (Graphics2D)g;
        if (this.antialiased) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int i = 0;
        while (i < linesToDisplay.length) {
            if (linesToDisplay[i] != null) {
                g2.drawString(linesToDisplay[i], this.LEFT_INDENT, ypos);
            }
            ypos += this.LINE_HEIGHT;
            ++i;
        }
    }

    public void setMaximumSize(Dimension maximumSize) {
        super.setMaximumSize(new Dimension(this.PANEL_WIDTH, this.PANEL_HEIGHT));
    }

    public void setMinimumSize(Dimension minimumSize) {
        super.setMinimumSize(new Dimension(this.PANEL_WIDTH, this.PANEL_HEIGHT));
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(new Dimension(this.PANEL_WIDTH, this.PANEL_HEIGHT));
    }

    public void setSize(Dimension preferredSize) {
        super.setSize(new Dimension(preferredSize.width < 500 ? this.PANEL_WIDTH : preferredSize.width, this.PANEL_HEIGHT));
    }

    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        bounds.height = this.PANEL_HEIGHT;
        bounds.width = this.PANEL_WIDTH;
        return bounds;
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame();
        TextBufferPanel bufferPanel = new TextBufferPanel(10);
        bufferPanel.setBackground(Color.red);
        bufferPanel.setFont(new Font("dialog", 1, 36));
        testFrame.setDefaultCloseOperation(3);
        testFrame.getContentPane().setLayout(new BorderLayout());
        testFrame.getContentPane().add((Component)bufferPanel, "Center");
        testFrame.setLocation(23, 23);
        testFrame.setSize(500, 500);
        testFrame.pack();
        testFrame.show();
        int i = 1;
        while (i <= 500) {
            String longline = "";
            int width = 0;
            while (width < 500) {
                longline = String.valueOf(longline) + String.valueOf(i);
                ++width;
            }
            bufferPanel.append(longline);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    public int getHeight() {
        return this.PANEL_HEIGHT;
    }

    public Dimension getSize() {
        return new Dimension(super.getSize().width, this.getHeight());
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(500, 500);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.LINE_HEIGHT;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.LINE_HEIGHT;
    }

    public void setJScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.follow = true;
    }

    public synchronized void toggleFollow() {
        this.follow = !this.follow;
    }

    public void scrollToEnd() {
        this.scrollRectToVisible(new Rectangle(0, this.getCurrentPos(), this.PANEL_WIDTH, this.LINE_HEIGHT));
        this.getParent().repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setLineHeight();
    }

    private void setLineHeight() {
        this.LINE_HEIGHT = this.getFontMetrics(this.getFont()).getHeight();
        this.PANEL_HEIGHT = this.lineBufferSize * this.LINE_HEIGHT + 3;
    }

    public boolean isOpaque() {
        return false;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu contextMenu = new JPopupMenu("Options");
        JMenuItem saveMenu = new JMenuItem("Save Text");
        saveMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectFileAction action = new SelectFileAction("Save Output", null, TextBufferPanel.this);
                try {
                    action.actionPerformed(new ActionEvent(this, 0, "Save Output"));
                    if (action.selectedFile != null) {
                        FileWriter fos = new FileWriter(action.selectedFile);
                        fos.write(TextBufferPanel.this.getText());
                        fos.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    System.err.println("FileNotFoundException");
                }
                catch (IOException ex) {
                    System.err.println("IOException");
                }
            }
        });
        contextMenu.add(saveMenu);
        JMenuItem toggleFollowMenu = new JMenuItem("Toggle Follow");
        toggleFollowMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextBufferPanel.this.toggleFollow();
            }
        });
        contextMenu.add(toggleFollowMenu);
        JMenuItem jumpToEndMenu = new JMenuItem("Jump To End");
        jumpToEndMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextBufferPanel.this.scrollRectToVisible(new Rectangle(0, TextBufferPanel.this.getCurrentPos(), TextBufferPanel.this.PANEL_WIDTH, TextBufferPanel.this.LINE_HEIGHT));
                TextBufferPanel.this.getParent().repaint();
            }
        });
        contextMenu.add(toggleFollowMenu);
        JMenuItem clearTextMenu = new JMenuItem("Clear Text");
        clearTextMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextBufferPanel.this.resetText();
            }
        });
        contextMenu.add(clearTextMenu);
        return contextMenu;
    }

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
    }
}

