/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;
import org.tp23.antinstaller.runtime.ConfigurationLoader;

public class Installer
extends Jar {
    private static final String DEFAULT_LAF = "org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
    private String extractType;
    private File installConfig;
    private File buildFile;
    private File antInstallLib;
    private File xercesLib;
    private File antLib;
    private String laf;
    protected boolean failOnError = false;
    protected boolean validateConfig = false;

    public Installer() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    protected void cleanUp() {
        super.cleanUp();
    }

    public void reset() {
        super.reset();
        this.extractType = null;
        this.installConfig = null;
        this.buildFile = null;
    }

    public void setInstallConfig(File file) {
        this.installConfig = file;
        if (!file.exists()) {
            throw new BuildException("AntInstall config: " + file + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(file);
        zipFileSet.setFullpath("antinstall-config.xml");
        super.addFileset((FileSet)zipFileSet);
    }

    public void setBuildFile(File file) {
        this.buildFile = file;
        if (!file.exists()) {
            throw new BuildException("AntInstall build file: " + file + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(file);
        zipFileSet.setFullpath("build.xml");
        super.addFileset((FileSet)zipFileSet);
    }

    public void setExtractType(String string) {
        this.extractType = string;
    }

    public void setLaf(String string) {
        this.laf = string;
    }

    public String getLaf() {
        if (this.laf == null) {
            return DEFAULT_LAF;
        }
        return this.laf;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void setValidateConfig(boolean bl) {
        this.validateConfig = bl;
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.buildFile == null && !this.isInUpdateMode()) {
            throw new BuildException("buildFile attribute is required", this.getLocation());
        }
        if (this.installConfig == null && !this.isInUpdateMode()) {
            throw new BuildException("installConfig attribute is required", this.getLocation());
        }
        try {
            this.addConfiguredManifest(this.getManifest());
        }
        catch (ManifestException manifestException) {
            throw new BuildException("Cant add AntInstaller Manifest", (Throwable)manifestException, this.getLocation());
        }
        if (this.validateConfig) {
            this.validateConfig();
        }
        super.initZipOutputStream(zipOutputStream);
    }

    public void execute() {
        if (this.getLaf().equals(DEFAULT_LAF) || this.getLaf().equals("jgoodies")) {
            FileSet fileSet = new FileSet();
            fileSet.setFile(new File(this.antInstallLib, "jgoodies-edited-1_2_2.jar"));
            this.addZipGroupFileset(fileSet);
        }
        super.execute();
    }

    private Manifest getManifest() throws ManifestException {
        if (this.extractType.equalsIgnoreCase("NonExtractor")) {
            return this.getNonExtractorManifest();
        }
        return this.getSelfExtractorManifest();
    }

    private Manifest getNonExtractorManifest() throws ManifestException {
        return this.getCustomManifest("org.tp23.antinstaller.selfextract.NonExtractor");
    }

    private Manifest getSelfExtractorManifest() throws ManifestException {
        return this.getCustomManifest("org.tp23.antinstaller.selfextract.SelfExtractor");
    }

    private Manifest getCustomManifest(String string) throws ManifestException {
        Manifest manifest = new Manifest();
        Manifest.Section section = manifest.getMainSection();
        Manifest.Attribute attribute = new Manifest.Attribute();
        attribute.setName("Main-Class");
        attribute.setValue(string);
        section.addAttributeAndCheck(attribute);
        Manifest.Attribute attribute2 = new Manifest.Attribute();
        attribute2.setName("Look-And-Feel");
        attribute2.setValue(this.getLaf());
        section.addAttributeAndCheck(attribute2);
        return manifest;
    }

    public void setAntInstallLib(File file) {
        this.antInstallLib = file;
        FileSet fileSet = new FileSet();
        fileSet.setFile(new File(file, "ant-installer.jar"));
        fileSet.setFile(new File(file, "sysout.jar"));
        this.addZipGroupFileset(fileSet);
    }

    public void setAntLib(File file) {
        this.antLib = file;
        FileSet fileSet = new FileSet();
        fileSet.setFile(new File(file, "ant.jar"));
        fileSet.setFile(new File(file, "ant-launcher.jar"));
        this.addZipGroupFileset(fileSet);
    }

    public void setXercesLib(File file) {
        this.xercesLib = file;
        FileSet fileSet = new FileSet();
        fileSet.setFile(new File(this.antInstallLib, "xercesImpl.jar"));
        fileSet.setFile(new File(this.antInstallLib, "xml-apis.jar"));
        this.addZipGroupFileset(fileSet);
    }

    private void validateConfig() {
        int n = 1;
        try {
            n = ConfigurationLoader.validate((String)this.installConfig.getParent(), (String)this.installConfig.getName());
            if (n != 0) {
                this.err();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.err();
        }
    }

    private void err() {
        String string = "Error in config file:" + this.installConfig.getAbsolutePath();
        if (this.failOnError) {
            throw new BuildException(string);
        }
        this.log(string, 0);
    }
}

