/*
 * Copyright 2000-2005 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.jetspeed.tools.deploy;

import org.jdom.Document;
import org.jdom.Element;

/**
 * Utilities for manipulating the context.xml deployment descriptor
 * 
 * @author <a href="mailto:rwatler@apache.org">Randy Watler</a>
 * @version $Id: JetspeedContextRewriter.java 188300 2005-02-02 03:12:36Z rwatler $
 */
public class JetspeedContextRewriter
{
    private Document document;
    private String portletApplication;
    private boolean changed = false;
    
    public JetspeedContextRewriter(Document doc, String portletApplication)
    {
        this.document = doc;
        this.portletApplication = portletApplication;
    }

    public void processContextXML()
        throws Exception
    {
        if (document != null)
        {
            try
            {
                // get root Context
                Element root = null;
                if (!document.hasRootElement())
                {
                    root = new Element("Context");
                    document.setRootElement(root);
                }
                else
                {
                    root = document.getRootElement();
                }   
                
                // set Context path
                String pathAttribute = root.getAttributeValue("path");
                if ((pathAttribute == null) || !pathAttribute.equals("/" + portletApplication))
                {
                    root.setAttribute("path", "/" + portletApplication);
                    changed = true;
                }
                
                // set Context docBase
                String docBaseAttribute = root.getAttributeValue("docBase");
                if ((docBaseAttribute == null) || !docBaseAttribute.equals(portletApplication))
                {
                    root.setAttribute("docBase", portletApplication);
                    changed = true;
                }
            }
            catch (Exception e)
            {
                throw new Exception("Unable to process context.xml for infusion " + e.toString(), e);
            }
        }
    }
}
