/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.pipeline.valve;

import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.pipeline.PipelineException;

/**
 * Valve that can be used as the basis of Valve implementations.
 *
 * @author <a href="mailto:jvanzyl@apache.org">Jason van Zyl</a>
 * @version $Id: AbstractValve.java 186726 2004-06-05 05:13:09Z taylor $
 */
public abstract class AbstractValve 
    implements Valve
{
    public abstract void invoke(RequestContext request, ValveContext context)
        throws PipelineException;

    public void initialize()
        throws PipelineException
    {
    }

}