/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.statistics.impl;

import java.sql.Timestamp;

/**
 * LogRecord
 * <P>
 * Abstract class that holds the fields of a log entry generated by
 * implementations of the PortalStatistics interface.
 * <P>
 * Some of the fields are common to all types of log entries; those fields are
 * implemented in LogRecord. The fields that are specific to a particular type
 * of log entry need to be implemented in a class that extends LogRecord.
 * 
 * @author <a href="mailto:rklein@bluesunrise.com">Richard D. Klein </a>
 * @version $Id: LogRecord.java 188420 2005-03-23 22:25:50Z rdk $
 */
public abstract class LogRecord
{

    public static final String TYPE_PORTLET = "PORTLET";

    public static final String TYPE_PAGE = "PAGE";

    public static final String TYPE_USER = "USER";

    protected String ipAddress = null;

    protected String logType = null;

    protected long msElapsedTime = 0;

    protected int status = 0;

    protected Timestamp timeStamp = null;

    protected String userName = null;

    public LogRecord(String logType)
    {
        this.logType = logType;
    }

    /**
     * @return Returns the ipAddress.
     */
    public String getIpAddress()
    {
        return ipAddress;
    }

    /**
     * @param ipAddress
     *            The ipAddress to set.
     */
    public void setIpAddress(String ipAddress)
    {
        this.ipAddress = ipAddress;
    }

    /**
     * @return Returns the logType.
     */
    public String getLogType()
    {
        return logType;
    }

    /**
     * @param logType
     *            The logType to set.
     */
    public void setLogType(String logType)
    {
        this.logType = logType;
    }

    /**
     * @return Returns the msElapsedTime.
     */
    public long getMsElapsedTime()
    {
        return msElapsedTime;
    }

    /**
     * @param msElapsedTime
     *            The msElapsedTime to set.
     */
    public void setMsElapsedTime(long msElapsedTime)
    {
        this.msElapsedTime = msElapsedTime;
    }

    /**
     * @return Returns the status.
     */
    public int getStatus()
    {
        return status;
    }

    /**
     * @param status
     *            The status to set.
     */
    public void setStatus(int status)
    {
        this.status = status;
    }

    /**
     * @return Returns the timeStamp.
     */
    public Timestamp getTimeStamp()
    {
        return timeStamp;
    }

    /**
     * @param timeStamp
     *            The timeStamp to set.
     */
    public void setTimeStamp(Timestamp timeStamp)
    {
        this.timeStamp = timeStamp;
    }

    /**
     * @return Returns the userName.
     */
    public String getUserName()
    {
        return userName;
    }

    /**
     * @param userName
     *            The userName to set.
     */
    public void setUserName(String userName)
    {
        this.userName = userName;
    }
}
