/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.om;

import java.io.Serializable;
/**
 * SecurityReference
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: SecurityReference.java 186674 2004-05-28 18:54:08Z weaver $
 */
public interface SecurityReference extends Serializable, Cloneable
{
    
    /** Getter for property parent.
     * @return Value of property parent.
     */
    public String getParent();
    
    /** Setter for property parent.
     * @param parent New value of property parent.
     */
    public void setParent(String parent);
    
    /**
     * Create a clone of this object
     */
    public Object clone()
        throws java.lang.CloneNotSupportedException;
}

