/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.om.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;

import org.apache.pluto.om.common.Language;

/**
 * 
 * MutableLanguage
 * <br/>
 * Extension of <code>org.apache.pluto.om.common.Language</code>
 * with mutator methods for easy maintenance.
 * 
 * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
 * @version $Id: MutableLanguage.java 186724 2004-06-05 05:10:46Z taylor $
 *
 */
public interface MutableLanguage extends Language, Serializable
{
    void setKeywords(Collection keywords);

    /**
     * 
     * @param locale
     */
    public void setLocale(Locale locale);

    /**
     * 
     * @param title
     */
    void setTitle(String title);

    /**
     * 
     * @param title
     */
    void setShortTitle(String title);

}
