/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.om.common.servlet;

import org.apache.pluto.om.common.SecurityRole;
import org.apache.pluto.om.common.SecurityRoleSet;

/**
 * MutableSecurityRoleSet
 *
 * @author <a href="mailto:ate@douma.nu">Ate Douma</a>
 * @version $Id: MutableSecurityRoleSet.java 186724 2004-06-05 05:10:46Z taylor $
 *
 */
public interface MutableSecurityRoleSet extends SecurityRoleSet
{
    /**
     * Adds a SecurityRole to the set
     *
     * @param securityRole the security-role to be added
     *
     * @return the new SecurityRole
     */
    public SecurityRole add(SecurityRole securityRole);
}
