/*
 * Copyright 2005 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.om.folder;

/**
 * This interface describes the object used to define
 * portal site menu excluded menu options.
 * 
 * @author <a href="mailto:rwatler@apache.org">Randy Watler</a>
 * @version $Id: MenuExcludeDefinition.java 216120 2005-07-13 06:40:27Z rwatler $
 */
public interface MenuExcludeDefinition
{
    /**
     * getName - get menu name with options to exclude
     *
     * @return menu name
     */
    String getName();

    /**
     * setName - set menu name with options to exclude
     *
     * @param name menu name
     */
    void setName(String name);
}
