/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.page.document;

import org.apache.jetspeed.om.page.Document;

/**
 * <p>
 * DocumentHandler
 * </p>
 * <p>
 *
 * </p>
 * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
 * @version $Id: DocumentHandler.java 187962 2004-11-19 03:07:43Z taylor $
 *
 */
public interface DocumentHandler
{
    Document getDocument(String name) throws DocumentNotFoundException, NodeException;
    
    Document getDocument(String name, boolean fromCahe) throws DocumentNotFoundException, NodeException;
    
    void updateDocument(Document document) throws FailedToUpdateDocumentException;
    
    void removeDocument(Document document)  throws DocumentNotFoundException, FailedToDeleteDocumentException;
    
    String getType();

    DocumentHandlerFactory getHandlerFactory();

    void setHandlerFactory(DocumentHandlerFactory factory);
}
