package org.apache.jetspeed.portlet;

import java.util.List;
import java.util.LinkedList;

/**
 ** Instances of the <CODE>Capability</CODE> class correspond to particular
 ** properties which can be assigned to the client devices.
 **
 ** <P>
 ** The class has only a private constructor, so that it is not possible
 ** to dynamically create objects of this class from outside the class. A set
 ** of predefined isntances (ie. capabilities) is provided.
 **
 ** @see   Client
 **
 ** @author   <A HREF="mailto:tboehme@apache.org">Thomas F. Boehme</A>
 **/

public class Capability
{
    private List impliedCapabilities = new LinkedList ();

    private static List capabilities = new LinkedList ();

    public final static Capability HTML_2_0 = new Capability ("HTML 2.0", 1);
    public final static Capability HTML_3_0 = new Capability ("HTML 3.0", 2);
    public final static Capability HTML_3_2 = new Capability ("HTML 3.2", 3);
    public final static Capability HTML_4_0 = new Capability ("HTML 4.0", 4);

    public final static Capability HTML_JAVA     = new Capability ("HTML Java", 5);

    public final static Capability HTML_JAVASCRIPT     = new Capability ("HTML JavaScript", 6);

    public final static Capability HTML_TABLE        = new Capability ("HTML Table Support", 7);
    public final static Capability HTML_NESTED_TABLE = new Capability ("HTML Nested Table Support", 8);

    public final static Capability HTML_FRAME = new Capability ("HTML Frames Support", 9);

    public final static Capability HTML_IFRAME = new Capability ("HTML i-Frames Support", 10);

    public final static Capability HTML_CSS = new Capability ("HTML CSS Support", 11);

    public final static Capability WML_1_1 = new Capability ("WML 1.1", 12);
    public final static Capability WML_1_2 = new Capability ("WML 1.2", 13);

    public final static Capability WML_TABLE = new Capability ("WML Table Support", 14);

    /**
     ** Returns a hash code for this capability.
     **
     ** @return   the hash code
     **/

    public int hashCode ()
    {
        return (value);
    }

    /**
     ** Returns whether this and the given object represent the same
     ** capability.
     **
     ** @param   object
     **          the object to compare with
     **
     ** @return   <CODE>true</CODE> if the objects represent the same capability, <BR>
     **           <CODE>false</CODE> otherwise
     **/

    public boolean equals (Object object)
    {
        boolean result = false;

        if (object instanceof Capability)
        {
            result = (this.getClass () == object.getClass () &&
                      this.getValue () == ((Capability) object).getValue ());
        }

        return (result);
    }

    /**
     ** Returns the capability as a displayable string.
     **
     ** @return   the displayable string
     **/

    public String toString ()
    {
        return (identifier);
    }

    /**
     ** Returns the identifier of this capability.
     **
     ** @return   the capability
     **/

    public String getIdentifier ()
    {
        return (identifier);
    }

    /**
     ** Returns the integer value of this capability.
     **
     ** @return   the integer value
     **/

    protected int getValue ()
    {
        return (value);
    }

    private String identifier;

    private int value;

    /**
     ** Constructs a capability.
     **
     ** @param   identifier
     **          the identifier of the capability
     ** @param   value
     **          the integer value of the capability
     **/

    private Capability (String identifier, int value)
    {
        this.identifier = identifier;
        this.value      = value;

        capabilities.add (this);
    }
}

