package org.apache.jetspeed.portlet;

/**
 * The <CODE>DefaultPortletMessage</CODE> can be used for inter-portlet
 * communication beyond one portlet application. Therefore this is a
 * final class that can not be further extended.
 * 
 * A portlet that broadcasts messages should
 * publish its message object format in its documentation.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see PortletContext#send
 * @since Version 1.1
 */
public final class DefaultPortletMessage implements PortletMessage
{
    private String message = null;

    public DefaultPortletMessage()
    {
    }

    public DefaultPortletMessage(String message)
    {
        setMessage(message);
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    public String getMessage()
    {
        return message;
    }

    public String toString()
    {
        return "DefaultPortletMessage: message='"+message+"'";
    }
}
