package org.apache.jetspeed.portlet;

import java.io.IOException;

/**
 * This feature is an addition to the <CODE>Portlet</CODE> interface. To support
 * page features in the portlet, this interface has to be implemented
 * additionally to the <CODE>Portlet</CODE> interface.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @since Version 1.1
 */

public interface PortletPageListener
{

    /**
     * Called by the portlet container to give a portlet the opportunity to
     * process and output data at the beginning of each page.
     * <P>This could be setting of header fields, writing javascript, etc...</P>
     * 
     * @param request
     *                 the portlet request
     * @param response
     *                 the portlet response
     * @exception PortletException
     *                   if the portlet has trouble fulfilling the
     *                   request
     * @exception IOException
     *                   if the streaming causes an I/O problem
     */
    public void beginPage (PortletRequest request,
                           PortletResponse response) throws PortletException,
                                                            IOException;

    /**
     * Called by the portlet container to give a portlet the opportunity to
     * process and output data at the ending of each page.
     * <P>This could be writing javascript, etc...</P>
     * 
     * @param request
     *                 the portlet request
     * @param response
     *                 the portlet response
     * @exception PortletException
     *                   if the portlet has trouble fulfilling the
     *                   request
     * @exception IOException
     *                   if the streaming causes an I/O problem
     */
    public void endPage (PortletRequest request,
                         PortletResponse response) throws PortletException,
                                                          IOException;

}
