package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.PortletMessage;

/**
 ** A <CODE>MessageEvent</CODE> is sent by the portlet container if
 ** one portlets send a message to another.
 **
 ** @see   PortletMessage
 ** @see   MessageListener
 **
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public interface MessageEvent extends Event
{
    /**
     ** Event identifier indicating that a message has been received.
     **
     ** <P>
     ** An event with this id is fired when one portlet (the source)
     ** sends a message to another portlet (the target). The target
     ** portlet is specified by name.
     **/

    public final static int MESSAGE_RECEIVED = 1001;

    /**
     ** Returns the message that this event carries. The message format
     ** is entirely open and has to be defined and documented by the
     ** source portlet.
     **
     ** @return   the portlet message
     **/

    public PortletMessage getMessage ();
}