package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.PortletException;

/**
 * The <CODE>MessageListener</CODE> interface is an addition to the <CODE>Portlet</CODE>
 * interface. If an object wishes to receive message events in the portlet, 
 * this interface has to be implemented additionally to the
 * <CODE>Portlet</CODE> interface.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see MessageEvent
 */
public interface MessageListener
{
    /**
     ** Notifies this listener that the message which
     ** the listener is watching for has been performed.
     **
     ** @param   event
     **          the message event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void messageReceived (MessageEvent event) throws PortletException;
}