package org.apache.jetspeed.portlet.service;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.service.*;

import java.net.*;
import java.io.*;

/**
 * Service to access external and internal resources.
 *
 * @author <A HREF="mailto:peter.fischer@de.ibm.com">Peter Fischer</A>
 */

public interface ContentAccessService extends PortletService
{


    
    /**
     * returns an URL object after following redirects
     * using a proxy if necessary
     * 
     * @param urlString the start url
     * @param request
     * @param response
     * @return the URL object
     * @exception PortletServiceException
     * @exception MalformedURLException
     */
    public URL getURL(String urlString, 
                      PortletRequest request,
                      PortletResponse response) throws PortletServiceException, MalformedURLException;




    public InputStream getInputStream(String urlString,
                        PortletRequest req,
                        PortletResponse resp) throws PortletServiceException, MalformedURLException;

    public String getMarkup(String urlString,
                        PortletRequest req,
                        PortletResponse resp) throws PortletServiceException, MalformedURLException;



    /**
     * writes the content of the given url to the output
     * stream of the portlet following redirects and 
     * using a proxy if necessary
     * trying to use the RequestDispatcher to include local
     * servlets or JSPs
     * 
     * @param urlString
     * @param request
     * @param response
     * @exception PortletServiceException
     * @exception MalformedURLException
     */
    public void include(String urlString,
                        PortletRequest request,
                        PortletResponse response) throws PortletServiceException, MalformedURLException;


    
    

  
}
