package org.apache.jetspeed.portlet.service.spi;

import java.util.*;
import javax.servlet.ServletConfig;

/**
 * All interfaces in this Service Provider Interface (SPI) package are needed
 * by all implementations of services.
 *
 * <code>PortletServiceConfig</code> is the interface through which portlet services
 * access the configuration passed to them by the portlet container.
 *
 * @author <A HREF="mailto:peter.fischer@de.ibm.com">Peter Fischer</A>
 */
public interface PortletServiceConfig {

    
   /**
    * Gets the init parameter with the given name.
    *
    * @param name The name of the requested init parameter.
    */
    public String getInitParameter(String name);

   /**
    * Gets an enumeration with the names of all init parameters provided in the
    * portlet service configuration.
    */
    public Enumeration getInitParameterNames();


    /**
     * get the ServletConfig object
     * 
     * @return the ServletConfig
     */
    public ServletConfig getServletConfig();
}
