package org.apache.jetspeed.portlet.spi;

/**
 * The <CODE>SPIPortletInterceptor</CODE> has to be implemented by each service provider
 * to intercept the portlet's invokation.
 * <P>
 * There has to be one interceptor instance per portlet object instance with the
 * same lifecycle (init/service/destroy) as the portlet. Since the interceptor is
 * written by service providers, they have to take care of the lifecycle
 * of the interceptor on their own.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @version Version 1.1
 */
public interface SPIPortletInterceptor
{

    /**
     * This method is called before the portlet is taken into service with
     * <CODE>init()</CODE>
     * 
     * @param servlet the portlet servlet
     * @param portletConfig
     *                the portlet config
     * @exception javax.servlet.UnavailableException
     */
    public void init(javax.servlet.http.HttpServlet servlet,
                     org.apache.jetspeed.portlet.PortletConfig portletConfig)
        throws javax.servlet.UnavailableException;

    /**
     * This method is called before the portlet's <CODE>service()</CODE> method
     * is called
     * 
     * @param request  the http servlet request
     * @param response the http servlet response
     * @exception java.io.IOException
     * @exception javax.servlet.ServletException
     */
    public void preService(javax.servlet.http.HttpServletRequest request,
                           javax.servlet.http.HttpServletResponse response)
        throws java.io.IOException, javax.servlet.ServletException;

    /**
     * This method is called after the portlet's <CODE>service()</CODE> method
     * is called
     * 
     * @param request  the http servlet request
     * @param response the http servlet response
     * @exception java.io.IOException
     * @exception javax.servlet.ServletException
     */
    public void postService(javax.servlet.http.HttpServletRequest request,
                            javax.servlet.http.HttpServletResponse response)
        throws java.io.IOException, javax.servlet.ServletException;

    /**
     * This method is called before the portlet is taken out of service with
     * <CODE>destroy()</CODE>
     */
    public void destroy();

    /**
     * This method is called to handle events of the Portlet API
     * 
     * @param servlet the portlet servlet
     * @param request  the http servlet request
     * @exception java.io.IOException
     * @exception javax.servlet.ServletException
     */
    public void handleEvents(javax.servlet.http.HttpServlet servlet,
                             javax.servlet.http.HttpServletRequest request)
        throws java.io.IOException, javax.servlet.ServletException;

}
