package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.om.clientregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.filter.*;

// turbine
import org.apache.turbine.util.Log;
import org.apache.turbine.services.resources.TurbineResources;

// java
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.*;

public class PortletConfigImpl implements PortletConfig
{
    private ServletConfig servletConfig = null;
    private PortletEntry portletEntry = null;
    private PortalInformationProvider provider = null;
    
    private PortletContextImpl portletContext = null;

    private PortletConfigFilter configFilter = null;

    public PortletConfigImpl(PortletEntry portletEntry,
                             ServletConfig servletConfig,
                             PortalInformationProvider provider,
                             PortletContextImpl portletContext)
    {
        this.portletEntry = portletEntry;
        this.servletConfig = servletConfig;
        this.provider = provider;
        this.portletContext = portletContext;

        initFilter();
    }
    
    public String getName ()
    {
        return portletEntry.getName();
    }

    public boolean supports (PortletWindow.State state)
    {
        Enumeration states = portletEntry.getSupportedStates( );
        while (states.hasMoreElements()) {
            PortletWindow.State element = (PortletWindow.State)states.nextElement();
            if (element==state) return true;
        }
        return false;
    }

    public boolean supports (Portlet.Mode mode, Client client)
    {
        Enumeration modes = portletEntry.getSupportedModes( ((ClientImpl)client).getClientEntry() );
        while (modes.hasMoreElements()) {
            Portlet.Mode element = (Portlet.Mode)modes.nextElement();
            if (element==mode) return true;
        }
        return false;
    }

    public PortletContext getContext ()
    {
        return portletContext;
    }

    // intermediate methods ... between servlet and portlet

    public ServletContext getServletContext()
    {
        return portletContext;
    }

    // servlet methods

    public String getInitParameter(String name)
    {
        return configFilter.getInitParameter(name);
    }

    public Enumeration getInitParameterNames()
    {
        return configFilter.getInitParameterNames();
    }

    public String getServletName()
    {
        return configFilter.getServletName();
    }

    // additional methods

    public PortletEntry getPortletEntry()
    {
        return portletEntry;
    }

    public ServletConfig getProxiedServletConfig()
    {
        return servletConfig;
    }

    public void setProxiedServletConfig(ServletConfig config)
    {
        this.servletConfig = config;
        configFilter.setServletConfig(servletConfig);
    }

    public PortletContextImpl getPortletContextImpl()
    {
        return portletContext;
    }

    private void initFilter()
    {
        String filterClassName = TurbineResources.getString("portletcontainer.filter.config");
        if (filterClassName==null) {
            configFilter = new PortletConfigFilter(servletConfig,
                                                     this);
        }
        else {
            Class[] parameterClasses = {ServletConfig.class, PortletConfig.class};
            Constructor constructor = null;
            try {
                constructor = Class.forName(filterClassName).getConstructor(parameterClasses);
            }
            catch (NoSuchMethodException e) {
                Log.error("Invalid PortletConfigFilter defined in resources key portletcontainer.filter.config.",e);
                throw new IllegalArgumentException("Invalid PortletConfigFilter defined in resources key portletcontainer.filter.config.");
            }
            catch (ClassNotFoundException e) {
                Log.error("Invalid PortletConfigFilter defined in resources key portletcontainer.filter.config.",e);
                throw new IllegalArgumentException("Invalid PortletConfigFilter defined in resources key portletcontainer.filter.config.");
            }
            Object[] parameters = {servletConfig, this };
            try {
                Object filter = constructor.newInstance(parameters);
                if (!(filter instanceof PortletConfigFilter)) {
                    Log.error("PortletConfigFilter defined in resources key portletcontainer.filter.config does not derive from PortletConfigFilter.");
                    throw new IllegalArgumentException("PortletConfigFilter defined in resources key portletcontainer.filter.config does not derive from PortletConfigFilter.");
                }
                configFilter = (PortletConfigFilter)filter;
            }
            catch (InstantiationException e) {
                Log.error("PortletConfigFilter defined in resources key portletcontainer.filter.config could not be instantiated.",e);
                throw new IllegalArgumentException("PortletConfigFilter defined in resources key portletcontainer.filter.config could not be instantiated.");
            }
            catch (IllegalAccessException e) {
                Log.error("PortletConfigFilter defined in resources key portletcontainer.filter.config could not be instantiated.",e);
                throw new IllegalArgumentException("PortletConfigFilter defined in resources key portletcontainer.filter.config could not be instantiated.");
            }
            catch (InvocationTargetException e) {
                Log.error("PortletConfigFilter defined in resources key portletcontainer.filter.config could not be instantiated.",e);
                throw new IllegalArgumentException("PortletConfigFilter defined in resources key portletcontainer.filter.config could not be instantiated.");
            }
        }
    }

}
