package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portlet.event.WindowListener;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

import javax.servlet.*;
import javax.servlet.http.*;

public class PortletWindowImpl implements PortletWindow
{
    private boolean eventBasedRequest = false;
    private PortletInstanceEntry entry = null;
    private PortletRequest request = null;
    private PortletConfig config = null;
    private PortalInformationProvider provider = null;
    private PortletLayoutWindow layoutwindow = null;

    public PortletWindowImpl( PortletInstanceEntry entry,
                              PortletRequest request,
                              PortletConfig config,
                              PortalInformationProvider provider,
                              boolean eventBasedRequest )
    {
        this.entry = entry;
        this.request = request;
        this.config = config;
        this.provider = provider;
        this.layoutwindow = this.provider.getPortletLayoutWindow( entry );
        this.eventBasedRequest = eventBasedRequest;
    }

    public boolean isDetached ()
    {
        return (layoutwindow.getWindowState()==PortletWindow.State.DETACHED);
    }

    public boolean isMaximized ()
    {
        return (layoutwindow.getWindowState()==PortletWindow.State.MAXIMIZED);
    }

    public boolean isMinimized ()
    {
        return (layoutwindow.getWindowState()==PortletWindow.State.MINIMIZED);
    }

    public PortletWindow.State getWindowState ()
    {
        return layoutwindow.getWindowState();
    }

    public void setWindowState(PortletWindow.State state)
        throws AccessDeniedException
    {
        if (!eventBasedRequest)
            throw new AccessDeniedException();

        provider.changePortletWindowState(entry,state);
    }

}
