package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;

import javax.servlet.*;
import javax.servlet.http.*;

import java.util.*;

public interface EventEnvironment
{

    /**
     * Returns the PortletRequest of the given identifiers in the current EventProcessing
     * 
     * @param cpiid  the identifier of the concrete portlet instance
     * @param cpid   the identifier of the concrete portlet
     * @return the portlet request
     */
    public PortletRequest getPortletRequest(PortletInstanceEntry portletInstance);

    /**
     * Returns the PortalInformationProvider of the current EventProcessing
     * 
     * @return the PortalInformationProvider
     */
    public PortalInformationProvider getProvider();

    /**
     * Returns the ServletRequest of the current EventProcessing
     * 
     * @return the http servlet request
     */
    public HttpServletRequest getServletRequest();
    
    /**
     * Returns the ServletResponse of the current EventProcessing
     * 
     * @return the http servlet response
     */
    public HttpServletResponse getServletResponse();

    /**
     * Returns all Portlets on the current page of the current EventProcessing
     * 
     * @return map containing all portlets of this page as piid[string]/pid[string] pair
     */
    public Collection getPortletsOnPage();

    /**
     * Returns the PortletConfig of given concrete portlet entry
     * 
     * @param concretePortletEntry    the concrete portlet entry
     * @return the PortletConfig
     */
    public PortletConfig getPortletConfig(ConcretePortletEntry concretePortletEntry);

    /**
     * Returns the PortletConfig of given portlet entry
     * 
     * @param portletEntry    the portlet entry
     * @return the PortletConfig
     */
    public PortletConfig getPortletConfig(PortletEntry portletEntry);

    /**
     * Returns the PortletInvoker of the current EventProcessing
     * 
     * @return the PortletInvoker
     */
    public PortletInvokerService getPortletInvoker();

}