package org.apache.jetspeed.portletcontainer.filter;

import org.apache.jetspeed.portlet.*;

import org.apache.jetspeed.portletcontainer.*;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.net.*;

public class PortletContextFilter
{
    private ServletContext servletContext = null;
    private PortletContext portletContext = null;
    
    public PortletContextFilter(ServletContext servletContext,
                                PortletContext portletContext)
    {
        this.servletContext = servletContext;
        this.portletContext = portletContext;
    }

    public void setServletContext(ServletContext servletContext)
    {
        this.servletContext = servletContext;
    }

    public ServletContext getContext(String uripath)
    {
        // workaround for portlets to get the Portal's ServletContext
        if (Constants.GET_PORTAL_CONTEXT.equals(uripath))
        {
            uripath = org.apache.turbine.services.resources.TurbineResources.getString(
                com.ibm.wps.portletcontainer.managers.PortletApplicationManager.PORTAL_DEPLOYMENT_CONTEXT_ROOT,
                uripath);
            
        }
        return servletContext.getContext(uripath);
    }

    public RequestDispatcher getRequestDispatcher(String path)
    {
        return servletContext.getRequestDispatcher(path);
    }

    public String getMimeType(String file)
    {
        return servletContext.getMimeType(file);
    }

    public URL getResource(String path) throws MalformedURLException
    {
        return servletContext.getResource(path);
    }

    public RequestDispatcher getNamedDispatcher(String name)
    {
        return servletContext.getNamedDispatcher(name);
    }

    public void log(String msg)
    {
        portletContext.getLog().info(msg);
    }

    public void log(String message, Throwable throwable)
    {
        portletContext.getLog().error(message, throwable);
    }

    public String getRealPath(String path)
    {
        return servletContext.getRealPath(path);
    }

    public String getServerInfo()
    {
        return servletContext.getServerInfo();
    }

}
