package org.apache.jetspeed.portletcontainer.filter;

import org.apache.jetspeed.portlet.*;

import org.apache.jetspeed.portletcontainer.*;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class PortletRequestFilter
{
    private HttpServletRequest servletRequest = null;
    private PortletRequest portletRequest = null;
    
    public PortletRequestFilter(HttpServletRequest servletRequest,
                                PortletRequest portletRequest)
    {
        this.servletRequest = servletRequest;
        this.portletRequest = portletRequest;
    }
    
    public void setServletRequest(HttpServletRequest servletRequest)
    {
        this.servletRequest = servletRequest;
    }

    public String getAuthType()
    {
        return servletRequest.getAuthType();
    }

    public String getPathTranslated()
    {
        return null;
    }

    public boolean isUserInRole(String role)
    {
        return servletRequest.isUserInRole(role);
    }

    public String getPathInfo()
    {
        return null;
    }

    public String getServletPath()
    {
        return servletRequest.getServletPath();
    }

    public String getContextPath()
    {
        return servletRequest.getContextPath();
    }

    public String getQueryString()
    {
        return null;
    }

    public String getRemoteUser()
    {
        return servletRequest.getRemoteUser();
    }

    public boolean isRequestedSessionIdFromCookie()
    {
        return servletRequest.isRequestedSessionIdFromCookie();
    }

    public java.security.Principal getUserPrincipal()
    {
        return servletRequest.getUserPrincipal();
    }

    public String getRequestedSessionId()
    {
        // TODO: we should perhaps return a unique SessionID with PIID or AIID attached
        return servletRequest.getRequestedSessionId();
    }
    
    public String getRequestURI()
    {
        return servletRequest.getRequestURI();
    }

    public boolean isRequestedSessionIdValid()
    {
        // TODO
        return servletRequest.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromURL()
    {
        // TODO
        return servletRequest.isRequestedSessionIdFromURL();
    }

    public RequestDispatcher getRequestDispatcher(String path)
    {
        return servletRequest.getRequestDispatcher(path);
    }

    public String getCharacterEncoding()
    {
        return servletRequest.getCharacterEncoding();
    }

    public int getContentLength()
    {
        return -1;
    }

    public String getContentType()
    {
        return servletRequest.getContentType();
    }

    public String getProtocol()
    {
        return servletRequest.getProtocol();
    }

    public String getScheme()
    {
        return servletRequest.getScheme();
    }

    public java.io.BufferedReader getReader() throws java.io.IOException
    {
        throw new IllegalStateException();
    }

    public String getRemoteAddr()
    {
        return servletRequest.getRemoteAddr();
    }

    public String getServerName()
    {
        return servletRequest.getServerName();
    }

    public int getServerPort()
    {
        return servletRequest.getServerPort();
    }

    public String getRemoteHost()
    {
        return servletRequest.getRemoteHost();
    }

}
