package org.apache.jetspeed.portletcontainer.filter;

import org.apache.jetspeed.portlet.*;

import org.apache.jetspeed.portletcontainer.*;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class PortletSessionFilter
{
    private HttpSession httpSession = null;
    private PortletSession portletSession = null;
    
    public PortletSessionFilter(HttpSession httpSession,
                                PortletSession portletSession)
    {
        this.httpSession = httpSession;
        this.portletSession = portletSession;
    }

    public void setHttpSession(HttpSession httpSession)
    {
        this.httpSession = httpSession;
    }

    public String getId()
    {
        // TODO: to get a unique key we need to add the PIID or the AIID
        return httpSession.getId();
    }

    public void setMaxInactiveInterval(int interval)
    {
        httpSession.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval()
    {
        return httpSession.getMaxInactiveInterval();
    }

    public void invalidate()
    {
        httpSession.invalidate();
    }

    public boolean isNew()
    {
        // TODO
        return httpSession.isNew();
    }

}
