package org.apache.jetspeed.portletcontainer.information;

//jetspeed
import org.apache.jetspeed.portlet.*;

import org.apache.jetspeed.portletcontainer.om.applicationregistry.*;
import org.apache.jetspeed.portletcontainer.om.applicationinstanceregistry.*;
import org.apache.jetspeed.portletcontainer.om.clientregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;

import com.ibm.wps.util.ObjectID;

// java stuff
import javax.servlet.ServletRequest;
import java.io.*;
import java.util.Locale;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Collection;

/**
 * <P>
 * The <CODE>GeneralInformation</CODE> interface is accessed by the
 * portlet container to query low level information about the portal itself.
 * </P>
 * <P>
 * This abstraction layer helps to generalize the portlet container from
 * special implementations like data storage and moreover it is not bound
 * to a special Application Server.
 * </P>
 *
 * @author <a href="shesmer@raleigh.ibm.com">Stephan Hesmer</a>
 */
public interface PortalInformationProvider
{

    /**
     * Returns the locale of the preferred or selected language of the user.
     * <P>
     * If more than one language is preferred, the locale returned by
     * this method is the one with the highest preference.
     * </P>
     *
     * @param request the servlet request
     * @return the locale of the preferred or selected language
     */
    public Locale getLocale ( );

    /**
     * Returns the locale of the preferred or selected language of the user.
     * <P>
     * If more than one language is preferred, the locale returned by
     * this method is the one with the highest preference.
     * </P>
     *
     * @param request the servlet request
     * @return the locales of the preferred or selected language
     */
    public Collection getLocales ( );

    /**
     * Returns the content type
     *
     * @return the content type
     */
    public String getContentType();

    /**
     * Returns the character set
     *
     * @return the character set
     */
    public String getCharacterSet();

    /**
     * Returns the context root of the main portal module such as /wps
     *
     * @return the main portal context root
     */
    public String getPortalContextRoot();

    /**
     * Returns the web application base directory
     * as it is accessed by the browser
     *
     * @return the web application base directory
     */
    public String getWebAppBaseDir();

    /**
     ** Returns a map of the parameters of this request.
     ** Please note that the value for each name is an array
     ** of strings. In case of a multi-value parameter, this array
     ** contains all values of that parameter.
     **
     ** @return   a map of parameters
     **/

    public Map getParameterMap ();

    /**
     * Returns the <CODE>PortletLayoutWindow</CODE> with useful information
     * of the portlet window defined by the portlet container and the portlet itself
     *
     * @param entry    the concrete portlet instance
     * @return the PortletLayoutWndow
     */
    public PortletLayoutWindow getPortletLayoutWindow( PortletInstanceEntry entry );

    /**
     * Returns an URI pointing to the given portlet and the given portlet mode.
     *
     * @param entry    the concrete portlet instance
     * @param mode   the portlet mode the URI should point to. This value is <CODE>null</CODE> if the current mode must not change.
     * @param state  the portlet window state in which the portlet should be shown. This value is <CODE>null</CODE> if the current state must not change.
     * @param actionreference  the action to be performed. This value can be <CODE>null</CODE>.
     * @return the URI to the given portlet with the given mode
     */
    public String getPortletURI( PortletInstanceEntry entry,
                                 PortletWindow.State state,
                                 String actionreference );

    /**
     * Returns an URI pointing to the return URI of the given portlet.
     * If no return URI exists, this method returns to the homepage of the portal.
     *
     * @param entry    the concrete portlet instance
     * @param actionreference  the action to be performed. This value can be <CODE>null</CODE>.
     * @return the URI pointing to the return URI of the given portlet
     */
    public String getReturnPortletURI( PortletInstanceEntry entry,
                                       String actionreference );

    /**
     * Returns the <CODE>Portlet.Mode</CODE> of the given portlet.
     * The layout system can either look at the request URL or at the
     * session.
     *
     * @param entry    the concrete portlet instance
     * @return the portlet mode
     */
    public Portlet.Mode getPortletMode( PortletInstanceEntry entry );

    /**
     * Returns the previous <CODE>Portlet.Mode</CODE> of the given portlet.
     * The layout system can either look at the request URL or at the
     * session.
     *
     * @param entry    the concrete portlet instance
     * @return the previous portlet mode
     */
    public Portlet.Mode getPreviousPortletMode( PortletInstanceEntry entry );

    /**
     * Changes the portlet mode to be displayed next.
     * This method is called by actions.
     *
     * @param entry    the concrete portlet instance
     * @param mode   the portlet mode modifier defining in which mode the portlet should be shown next.
     */
    public void changePortletMode( PortletInstanceEntry entry,
                                   Portlet.ModeModifier modeModifier );

    /**
     * Changes the portlet window state to be displayed next.
     * This method is only called by actions
     *
     * @param entry    the concrete portlet instance
     * @param state  the portlet window state in which the portlet should be shown next.
     */
    public void changePortletWindowState(PortletInstanceEntry entry,
                                         PortletWindow.State state);

    /**
     * Returns all portlet applications definied in the registry
     * as an enumeration of <CODE>ApplicationEntry</CODE> and 
     * <CODE>ConcreteApplicationEntry</CODE> elements.
     *
     * @return an enumeration of <CODE>ApplicationEntry</CODE> elements
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public Enumeration getApplications() throws IOException;

    /**
     * Returns the portlet application with the given name.
     *
     * @param aid   the identifier of the portlet application to be returned
     * @return the portlet application
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public ApplicationEntry getApplicationEntry(ObjectID aid) throws IOException;

    /**
     * Returns the concrete portlet application with the given name.
     *
     * @param caid   the identifier of the concrete portlet application to be returned
     * @return the concrete portlet application
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public ConcreteApplicationEntry getConcreteApplicationEntry(ObjectID caid) throws IOException;

    /**
     * Replaces the concrete portlet application at the given index with the new one
     *
     * @param entry  the new concrete portlet application
     * @exception IOException
     *                   if an error occured trying to save data
     */
    public void setConcretePortletApplicationEntry(ConcreteApplicationEntry entry) throws IOException;

    /**
     * Returns the portlet application instance entry of the given piid
     *
     * @param cpiid   the identifier of the concrete portlet application instance
     * @return the portlet instance entry
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public ApplicationInstanceEntry getPortletApplicationInstanceEntry(ObjectID caiid) throws IOException;

    /**
     * Replaces the portlet application instance entry at the given index with the new one
     *
     * @param entry  the new portlet application instance entry
     * @exception IOException
     *                   if an error occured trying to save data
     */
    public void setPortletApplicationInstanceEntry(ApplicationInstanceEntry entry) throws IOException;

    /**
     * Returns the portlet with the given portlet identifier.
     *
     * @param pid   the portlet identifier
     * @return the portlet
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public PortletEntry getPortletEntry(ObjectID pid) throws IOException;

    /**
     * Returns the concrete portlet with the given portlet identifier.
     *
     * @param cpid   the concrete portlet identifier
     * @return the concrete portlet
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public ConcretePortletEntry getConcretePortletEntry(ObjectID cpid) throws IOException;

    /**
     * Replaces the concrete portlet at the given index with the new one
     *
     * @param entry  the new concrete portlet
     * @exception IOException
     *                   if an error occured trying to save data
     */
    public void setConcretePortletEntry(ConcretePortletEntry entry) throws IOException;

    /**
     * Returns the portlet instance entry of the given piid
     *
     * @param cpiid   the identifier of the concrete portlet instance
     * @return the portlet instance entry
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public PortletInstanceEntry getPortletInstanceEntry(ObjectID cpiid) throws IOException;

    /**
     * Replaces the portlet instance entry at the given index with the new one
     *
     * @param entry  the new portlet instance entry
     * @exception IOException
     *                   if an error occured trying to save data
     */
    public void setPortletInstanceEntry(PortletInstanceEntry entry) throws IOException;

    /**
     * Returns the client which matches the given useragent or <CODE>NULL</CODE>
     * if no user agent was found.
     *
     * @param useragent the useragent to match
     * @return the found client
     * @exception IOException
     *                   if an error occured trying to load data
     */
    public ClientEntry findClientEntry() throws IOException;

    /** uuuugh! IBM specific begin */
    public com.ibm.wps.engine.Client getFrameworkClient();
    /** uuuugh! IBM specific end */
}
