package org.apache.jetspeed.portletcontainer.invoker;

/**
 ** The <CODE>PortletInvokerException</CODE> class defines a general exception
 ** that the invoker can throw when it encounters difficulty.
 **
 ** @author   <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public class PortletInvokerException extends Exception
{
    private Throwable cause;

    /**
     ** Constructs a new portlet exception.
     **/

    public PortletInvokerException ()
    {
    }

    /**
     ** Constructs a new portlet invoker exception with the given text. The
     ** layout system may use the text write it to a log.
     **
     ** @param   text
     **          the exception text
     **/

    public PortletInvokerException (String text)
    {
        super (text);
    }

    /**
     ** Constructs a new portlet invoker exception when the invoker needs to throw an
     ** exception and include a message about the "root case" that interfered
     ** with its normal operation, including a description message.
     **
     ** @param   text
     **          the exception text
     ** @param   cause
     **          the root cause
     **/

    public PortletInvokerException (String text, Throwable cause)
    {
        super (text); //, cause);

        this.cause = cause;
    }

    /**
     ** Constructs a new portlet invoker exception when the portlet needs to throw an
     ** exception. The exception's message is based on the localized message
     ** of the underlying exception.
     **
     ** @param   cause
     **          the root cause
     **/

    public PortletInvokerException (Throwable cause)
    {
        super (cause.getLocalizedMessage ());

        this.cause = cause;
    }

    /**
     ** Returns the exception that cause this portlet exception.
     **
     ** @return   the <CODE>Throwable</CODE> that caused this portlet exception.
     **/

    public Throwable getRootCause ()
    {
        return (cause);
    }
}
