
package org.apache.jetspeed.portlets;

//Jetspeed stuff
import org.apache.jetspeed.portlet.*;


//XML stuff
import org.xml.sax.SAXException;
import javax.xml.transform.stream.*;

//java stuff
import java.io.IOException;
import java.util.Hashtable;


public class JetspeedContent extends TransformPortlet
{

    public static final String PROVIDER_NAME_KEY = "provider-name";

    public void init (PortletConfig portletConfig) throws UnavailableException
    {
        super.init( portletConfig );

    }


    public void doView (PortletRequest request,
                        PortletResponse response) throws PortletException,IOException
    {
        if (getPortletLog().isDebugEnabled())
        {
            getPortletLog().debug("JetspeedContent:doView");
        }

        this.parse( request, response );


    }



    private void parse( PortletRequest request,
                        PortletResponse response )
    throws PortletException, IOException
    {

        if (getPortletLog().isDebugEnabled())
        {
            getPortletLog().debug("JetspeedContent:Start parsing the content");
        }

        // get settings

        String provider = "";
        String stylesheet = "";
        String url = null;

        //Reading provider name from portletConfig
        provider = (String)request.getPortletSettings().getAttribute(PROVIDER_NAME_KEY);

        if (getPortletLog().isInfoEnabled())
        {
            getPortletLog().info("JetspeedContent:Provider: "+provider);
        }

        if ( provider == null )
        {
            throw new UnavailableException( "JetspeedContent:You need to specify " + PROVIDER_NAME_KEY );
        }

        //Reading portlet proberties from portletConfig
        url = request.getPortletSettings().getAttribute( "content.provider." + provider + ".url" );
        stylesheet = request.getPortletSettings().getAttribute( "content.provider." + provider + ".stylesheet.url" );
        if (getPortletLog().isInfoEnabled())
        {
            getPortletLog().info("JetspeedContent:Content-URL: "+url);
            getPortletLog().info("JetspeedContent:Stylesheet-URL: "+stylesheet);
        }

        String title = request.getPortletSettings().getAttribute( "content.provider." + provider + ".title" );

        //now make sure that url and stylesheet were defined
        if ( url == null || stylesheet == null )
        {
            getPortletLog().error("JetspeedContent:Either url or stylesheet were not defined");
            throw new UnavailableException( "JetspeedContent:Not all properties defined in PortletConfig." );
        }


        // really begin parse

        PortletContext context = this.getPortletConfig().getContext();

        try
        {
            Hashtable params = new Hashtable();
            // add base url as style sheet parameter
            params.put("base",response.encodeURI("/"));


            response.getWriter().println( transform(
                                                   new StreamSource(context.getResourceAsStream(url) ),
                                                   new StreamSource(context.getResourceAsStream(stylesheet) ),
                                                   params ) );
        }
        catch (SAXException e)
        {
            getPortletLog().error("JetspeedContent:Couldn't transform content.  Please see error log",e);
            throw new PortletException("JetspeedContent:Couldn't transform content.  Please see error log");
        }

        if (getPortletLog().isDebugEnabled())
        {
            getPortletLog().debug("JetspeedContent:End parsing the content");
        }

    }
}
