/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlets;

//standard java stuff
import java.io.*;
import java.util.*;

//standard Jetspeed stuff
import org.apache.jetspeed.portlet.*;

//SAX
import org.xml.sax.*;
import javax.xml.transform.stream.*;

/**
Simple portlet which does a basic XSLT transform with the stylesheet parameter
and the given portlet URL.

@author <A HREF="mailto:raphael@apache.org">Raphal Luta</A>
@version $Id: XSLPortlet.java,v 1.5 2001/03/07 06:47:18 taylor Exp $
*/
public class XSLPortlet extends TransformPortlet
{

    /**
    The stylesheet parameter
    */
    public static final String STYLESHEET_KEY = "stylesheet";
    public static final String URL_KEY = "url";
    public static final String DEFAULT_MARKUP = "html";


    public final static String ERROR_NOT_VALID = "This does not appear to be an RSS document";
    public final static String INVALID_TYPE = "Unable to display for this browser";

    public void init (PortletConfig portletConfig) throws UnavailableException
    {
        super.init(portletConfig);

        if (this.getPortletLog().isInfoEnabled())
        {
            this.getPortletLog().info("XSLPortlet:init! started");
        }

    }

    public void initConcrete(PortletSettings portletSettings) throws UnavailableException
    {
        try
        {
            setVariable("stylesheets",new Hashtable());

            String url = null;

            // load stylesheets available
            Hashtable stylesheets = (Hashtable)getVariable("stylesheets");
            Enumeration en = portletSettings.getAttributeNames();

            while (en.hasMoreElements())
            {
                String name = (String)en.nextElement();
                String base = DEFAULT_MARKUP;
                if (name.startsWith(STYLESHEET_KEY))
                {
                    int idx=-1;
                    if ((idx=name.indexOf("."))>-1)
                    {
                        base= name.substring(idx+1,name.length());
                    }

                    if (this.getPortletLog().isDebugEnabled())
                    {
                        this.getPortletLog().debug("XSLPortlet:adding stylesheet entry " + name);
                    }

                    stylesheets.put(base, portletSettings.getAttribute(name));
                }
            }

            if (this.getPortletLog().isInfoEnabled())
            {
                this.getPortletLog().info("XSLPortlet:init! ended");
            }
        }
        catch (AccessDeniedException e)
        {
            throw new UnavailableException("Could not set/get a variable in the concrete namespace.");
        }
    }



    public void doView (PortletRequest request, PortletResponse response)
    throws PortletException, IOException
    {
        try
        {
            Hashtable stylesheets = (Hashtable)getVariable("stylesheets");

            String stylesheet = (String)stylesheets.get(request.getClient().getMimeType());
            if (stylesheet != null)
            {
                try
                {
                    response.getWriter().println( transform(
                                                           new StreamSource(this.getPortletConfig().getContext().getResourceAsStream(request.getPortletSettings().getAttribute(URL_KEY))),
                                                           new StreamSource(this.getPortletConfig().getContext().getResourceAsStream(stylesheet)),
                                                           null));

                }
                catch (SAXException exc)
                {
                    String message = "XSLPortlet: Could not Parse content from " +
                                     request.getPortletSettings().getAttribute(URL_KEY) +
                                     " with stylesheet " +
                                     stylesheet;
                    this.getPortletLog().error(message , exc);
                    throw new PortletException(message , exc);
                }

            }
            else
            {
                if (this.getPortletLog().isInfoEnabled())
                {
                    this.getPortletLog().info("XSLPortlet: No stylesheet for mimeType" + request.getClient().getMimeType());
                }
            }
        }
        catch (AccessDeniedException e)
        {
            throw new PortletException();
        }

    }

    /**
    This portlet supports has many types as those
    it has stylesheets defined for in its parameters

    @see Portlet.supportsType
    @param mimeType the MIME type queried
    @return true if the portlet knows how to display
    content for mimeType
    */
    /*public boolean supportsType( MimeType mimeType ) {

        Enumeration en = stylesheets.keys();
        while(en.hasMoreElements()) {
            String type = (String)en.nextElement();
            if (type.equals(mimeType.toString())) return true;
        }

        return false;
    } */

}
