/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef KSIMNET_H
#define KSIMNET_H

#include <pluginmodule.h>
#include "netdevices.h"
#include <stdio.h>

class QTimer;
class QVBoxLayout;
class QTextStream;
namespace KSim
{
  class Chart;
  class LedLabel;
  class Label;
};

class NetPlugin : public KSim::PluginObject
{
  public:
    NetPlugin(const char *name);
    ~NetPlugin();

    virtual KSim::PluginView *createView(const char *);
    virtual KSim::PluginPage *createConfigPage(const char *);

    virtual void showAbout();
};

class NetView : public KSim::PluginView
{
  Q_OBJECT
  public:
    NetView(KSim::PluginObject *parent, const char *name);
    ~NetView();

    virtual void reparseConfig();

  private slots:
    void cleanup();
    void init(int amount);
    void updateLights();
    void updateGraph();
    void newNetMonitor(const NetDevice &device, int value);
    void runConnectCommand(int);
    void runDisconnectCommand(int);

  private:
    class NetData
    {
      public:
        NetData() : in(0), out(0) {}
        NetData &operator=(const NetData &rhs)
        {
          in = rhs.in;
          out = rhs.out;
          return *this;
        }

        NetData &operator=(int value)
        {
          in = out = value;
          return *this;
        }

        unsigned long in;
        unsigned long out;
    };

    DeviceList createDeviceList(int amount) const;
    KSim::Chart *addChart();
    KSim::LedLabel *addLedLabel(const QString &device);
    KSim::Label *addLabel();
    QPopupMenu *addPopupMenu(const QString &device, int value);
    void netStatistics(const QString &device, NetData &data);
    bool isOnline(const QString &device);

    NetData *m_data;
    NetData *m_oldData;
    unsigned long *m_max;
    int m_firstTime;
    DeviceList m_deviceList;
    DeviceList m_widgetList;
    QTimer *m_netTimer;
    QTimer *m_lightTimer;
    QVBoxLayout *m_netLayout;
#ifdef __linux__
    FILE *m_procFile;
    QTextStream *m_procStream;
#endif
#ifdef __FreeBSD__
    char *m_buf;
    int m_allocSize;
#endif	
};
#endif
