/****************************************************************************
**
** This file is part of the KD Soap library.
**
** SPDX-FileCopyrightText: 2011-2020 Klarälvdalens Datakonsult AB, a KDAB Group company <info@kdab.com>
**
** SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDAB-KDSoap OR LicenseRef-KDAB-KDSoap-US
**
** Licensees holding valid commercial KD Soap licenses may use this file in
** accordance with the KD Soap Commercial License Agreement provided with
** the Software.
**
** Contact info@kdab.com if any conditions of this licensing are not clear to you.
**
****************************************************************************/

/*!

  \mainpage KD Soap Reference Documentation

  \image html xmldiagram2.png

KD SOAP is a tool for creating client applications for web services. It makes it possible to interact with applications which have APIs that can be exported as SOAP objects. The web service then provides a machine-accessible interface to its functionality via HTTP. The remote method calls are handled with the SOAP standard, which describes method calls, their parameters and return values as XML documents.
KD SOAP is used by a variety of programs for a variety of different purposes - for example, one application uses KD SOAP to access data from a CRM system such as SugarCRM or Salesforce.

\section Features

\li The KD SOAP library provides an abstraction layer for both the actual transport, as well as, the construction of data objects and method calls. (The latter relieves application developers from manually writing XML marshalling and demarshalling code, allowing them to build arbitrary complex data structures using simple C++ classes.)
\li The transport abstraction provides both synchronous as well as Qt signal/slot based asynchronous remote method call and response handling.
\li Alongside the library, KD SOAP ships with the kdwsdl2cpp code generator, providing additional means for increasing developer productivity by generating a proxy API for a target web service based on its formal WSDL service description. Using classes generated by this approach adds build-time type checking and “in process”-like object behavior (i.e. using C++ data types as parameters and return values of each of the web service’s methods).
*/

