/////////////////////////////////////////////////////////////////////////////
// Name:        dialog_general_options.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     21/01/2006 18:28:47
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 21/01/2006 18:28:47

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "dialog_general_options.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "fctsys.h"
#include "common.h"
#include "pcbnew.h"

#include "id.h"

#include "dialog_general_options.h"

////@begin XPM images
////@end XPM images



/*****************************************************************/
void WinEDA_PcbFrame::OnSelectOptionToolbar(wxCommandEvent& event)
/*****************************************************************/
/* Mises a jour de differentes variables de gestion d'options apres action sur
le toolbar d'options
*/
{
int id = event.GetId();
wxClientDC dc(DrawPanel);

    DrawPanel->CursorOff(&dc);
    DrawPanel->PrepareGraphicContext(&dc);

    switch ( id )
    {
    case ID_TB_OPTIONS_DRC_OFF:
        Drc_On = m_OptionsToolBar->GetToolState(id) ? FALSE : TRUE;
        break;

    case ID_TB_OPTIONS_SHOW_GRID:
        m_Draw_Grid = g_ShowGrid = m_OptionsToolBar->GetToolState(id);
        DrawPanel->ReDraw(&dc, TRUE);
        break;

    case ID_TB_OPTIONS_SHOW_RATSNEST:
        g_Show_Ratsnest = m_OptionsToolBar->GetToolState(id);
        Ratsnest_On_Off(&dc);
        break;

    case ID_TB_OPTIONS_SHOW_MODULE_RATSNEST:
        g_Show_Module_Ratsnest = m_OptionsToolBar->GetToolState(id);
        break;

    case ID_TB_OPTIONS_SELECT_UNIT_MM:
        g_UnitMetric = MILLIMETRE;
    case ID_TB_OPTIONS_SELECT_UNIT_INCH:
        if ( id == ID_TB_OPTIONS_SELECT_UNIT_INCH )
            g_UnitMetric = INCHES;
        m_SelTrackWidthBox_Changed = TRUE;
        Affiche_Status_Box();    /* Reaffichage des coord curseur */
        ReCreateAuxiliaryToolbar();
        DisplayUnitsMsg();
        break;

    case ID_TB_OPTIONS_SHOW_POLAR_COORD:
        Affiche_Message(wxEmptyString);
        DisplayOpt.DisplayPolarCood = m_OptionsToolBar->GetToolState(id);
        Affiche_Status_Box();    /* Reaffichage des coord curseur */
        break;

    case ID_TB_OPTIONS_SELECT_CURSOR:
        g_CursorShape = m_OptionsToolBar->GetToolState(id);
        break;

    case ID_TB_OPTIONS_AUTO_DEL_TRACK:
        g_AutoDeleteOldTrack = m_OptionsToolBar->GetToolState(id);
        break;

    case ID_TB_OPTIONS_SHOW_ZONES:
        DisplayOpt.DisplayZones = m_OptionsToolBar->GetToolState(id);
        DrawPanel->ReDraw(&dc, TRUE);
        break;

    case ID_TB_OPTIONS_SHOW_PADS_SKETCH:
        m_DisplayPadFill = DisplayOpt.DisplayPadFill =
             ! m_OptionsToolBar->GetToolState(id);
        DrawPanel->ReDraw(&dc, TRUE);
        break;

    case ID_TB_OPTIONS_SHOW_TRACKS_SKETCH:
        m_DisplayPcbTrackFill = DisplayOpt.DisplayPcbTrackFill =
            ! m_OptionsToolBar->GetToolState(id);
        DrawPanel->ReDraw(&dc, TRUE);
        break;

    case ID_TB_OPTIONS_SHOW_HIGHT_CONTRAST_MODE:
        DisplayOpt.ContrastModeDisplay =
            m_OptionsToolBar->GetToolState(id);
        DrawPanel->ReDraw(&dc, TRUE);
        break;

    case ID_TB_OPTIONS_SHOW_EXTRA_VERTICAL_TOOLBAR1:
        if ( m_OptionsToolBar->GetToolState(id) ) // show aux V toolbar (Microwave tool)
            ReCreateAuxVToolbar();
        else
        {
            delete m_AuxVToolBar;
            m_AuxVToolBar = NULL;
        }
        {
            wxSizeEvent SizeEv(GetSize());
            OnSize(SizeEv);
        }
        break;

    default:
        DisplayError(this, wxT("WinEDA_PcbFrame::OnSelectOptionToolbar error \n (event not handled!)"));
        break;
    }

    SetToolbars();
    DrawPanel->CursorOn(&dc);
}


/*!
 * WinEDA_PcbGeneralOptionsFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_PcbGeneralOptionsFrame, wxDialog )

/*!
 * WinEDA_PcbGeneralOptionsFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_PcbGeneralOptionsFrame, wxDialog )

////@begin WinEDA_PcbGeneralOptionsFrame event table entries
    EVT_BUTTON( wxID_OK, WinEDA_PcbGeneralOptionsFrame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_PcbGeneralOptionsFrame::OnCancelClick )

////@end WinEDA_PcbGeneralOptionsFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_PcbGeneralOptionsFrame constructors
 */

WinEDA_PcbGeneralOptionsFrame::WinEDA_PcbGeneralOptionsFrame( )
{
}

WinEDA_PcbGeneralOptionsFrame::WinEDA_PcbGeneralOptionsFrame( WinEDA_PcbFrame* parent, wxDC * DC,
    wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    m_Parent = parent;
    m_DC = DC;

    Create(parent, id, caption, pos, size, style);
    
    /* Set display options */
    m_PolarDisplay->SetSelection(DisplayOpt.DisplayPolarCood ? 1 : 0);
    m_BoxUnits->SetSelection( g_UnitMetric ? 1 : 0);
    m_CursorShape->SetSelection( g_CursorShape ? 1 : 0);
    
wxString timevalue;
    timevalue << g_TimeOut / 60;
    m_SaveTime->SetValue(timevalue);
    m_LayerNumber->SetValue(g_DesignSettings.m_CopperLayerCount);
    m_MaxShowLinks->SetValue(g_MaxLinksShowed);

    m_DrcOn->SetValue(Drc_On );
    m_ShowModuleRatsnest->SetValue(g_Show_Module_Ratsnest);
    m_ShowGlobalRatsnest->SetValue(g_Show_Ratsnest);
    m_TrackAutodel->SetValue(g_AutoDeleteOldTrack);
    m_Track_45_Only_Ctrl->SetValue(Track_45_Only);
    m_Segments_45_Only_Ctrl->SetValue(Segments_45_Only);
    m_AutoPANOpt->SetValue(m_Parent->DrawPanel-> m_AutoPAN_Enable);
    m_Segments_45_Only_Ctrl->SetValue(Segments_45_Only);
    m_Track_DoubleSegm_Ctrl->SetValue(g_TwoSegmentTrackBuild);
}

/*!
 * WinEDA_PcbGeneralOptionsFrame creator
 */

bool WinEDA_PcbGeneralOptionsFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_PcbGeneralOptionsFrame member initialisation
    m_PolarDisplay = NULL;
    m_BoxUnits = NULL;
    m_CursorShape = NULL;
    m_LayerNumber = NULL;
    m_MaxShowLinks = NULL;
    m_SaveTime = NULL;
    m_DrcOn = NULL;
    m_ShowGlobalRatsnest = NULL;
    m_ShowModuleRatsnest = NULL;
    m_TrackAutodel = NULL;
    m_Track_45_Only_Ctrl = NULL;
    m_Segments_45_Only_Ctrl = NULL;
    m_AutoPANOpt = NULL;
    m_Track_DoubleSegm_Ctrl = NULL;
    m_MagneticPadOptCtrl = NULL;
    m_MagneticTrackOptCtrl = NULL;
////@end WinEDA_PcbGeneralOptionsFrame member initialisation

////@begin WinEDA_PcbGeneralOptionsFrame creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_PcbGeneralOptionsFrame creation
    SetFont(*g_DialogFont);
    return true;
}

/*!
 * Control creation for WinEDA_PcbGeneralOptionsFrame
 */

void WinEDA_PcbGeneralOptionsFrame::CreateControls()
{    
////@begin WinEDA_PcbGeneralOptionsFrame content construction
    // Generated by DialogBlocks, Mon 03 Mar 2008 04:27:22 PM EST (unregistered)

    WinEDA_PcbGeneralOptionsFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxGROW|wxALL, 5);

    wxArrayString m_PolarDisplayStrings;
    m_PolarDisplayStrings.Add(_("No Display"));
    m_PolarDisplayStrings.Add(_("Display"));
    m_PolarDisplay = new wxRadioBox( itemDialog1, ID_RADIOBOX, _("Display Polar Coord"), wxDefaultPosition, wxDefaultSize, m_PolarDisplayStrings, 1, wxRA_SPECIFY_COLS );
    m_PolarDisplay->SetSelection(0);
    itemBoxSizer3->Add(m_PolarDisplay, 0, wxALIGN_LEFT|wxALL, 5);

    wxArrayString m_BoxUnitsStrings;
    m_BoxUnitsStrings.Add(_("Inches"));
    m_BoxUnitsStrings.Add(_("millimeters"));
    m_BoxUnits = new wxRadioBox( itemDialog1, ID_RADIOBOX1, _("Units"), wxDefaultPosition, wxDefaultSize, m_BoxUnitsStrings, 1, wxRA_SPECIFY_COLS );
    m_BoxUnits->SetSelection(0);
    itemBoxSizer3->Add(m_BoxUnits, 0, wxALIGN_LEFT|wxALL, 5);

    wxArrayString m_CursorShapeStrings;
    m_CursorShapeStrings.Add(_("Small"));
    m_CursorShapeStrings.Add(_("Big"));
    m_CursorShape = new wxRadioBox( itemDialog1, ID_RADIOBOX2, _("Cursor"), wxDefaultPosition, wxDefaultSize, m_CursorShapeStrings, 1, wxRA_SPECIFY_COLS );
    m_CursorShape->SetSelection(0);
    itemBoxSizer3->Add(m_CursorShape, 0, wxALIGN_LEFT|wxALL, 5);

    wxBoxSizer* itemBoxSizer7 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer7, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer8Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Number of Layers:"));
    wxStaticBoxSizer* itemStaticBoxSizer8 = new wxStaticBoxSizer(itemStaticBoxSizer8Static, wxVERTICAL);
    itemBoxSizer7->Add(itemStaticBoxSizer8, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    m_LayerNumber = new wxSpinCtrl( itemDialog1, ID_SPINCTRL1, _T("1"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 16, 1 );
    itemStaticBoxSizer8->Add(m_LayerNumber, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer10Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Max Links:"));
    wxStaticBoxSizer* itemStaticBoxSizer10 = new wxStaticBoxSizer(itemStaticBoxSizer10Static, wxVERTICAL);
    itemBoxSizer7->Add(itemStaticBoxSizer10, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    m_MaxShowLinks = new wxSpinCtrl( itemDialog1, ID_SPINCTRL2, _T("1"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 5, 1 );
    itemStaticBoxSizer10->Add(m_MaxShowLinks, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer12Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Auto Save (minuts):"));
    wxStaticBoxSizer* itemStaticBoxSizer12 = new wxStaticBoxSizer(itemStaticBoxSizer12Static, wxVERTICAL);
    itemBoxSizer7->Add(itemStaticBoxSizer12, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    m_SaveTime = new wxSpinCtrl( itemDialog1, ID_SPINCTRL3, _T("0"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 60, 0 );
    itemStaticBoxSizer12->Add(m_SaveTime, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer14 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer14, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer15Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Options:"));
    wxStaticBoxSizer* itemStaticBoxSizer15 = new wxStaticBoxSizer(itemStaticBoxSizer15Static, wxVERTICAL);
    itemBoxSizer14->Add(itemStaticBoxSizer15, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    m_DrcOn = new wxCheckBox( itemDialog1, ID_CHECKBOX, _("Drc ON"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_DrcOn->SetValue(false);
    m_DrcOn->SetForegroundColour(wxColour(198, 0, 0));
    itemStaticBoxSizer15->Add(m_DrcOn, 0, wxALIGN_LEFT|wxALL, 5);

    m_ShowGlobalRatsnest = new wxCheckBox( itemDialog1, ID_CHECKBOX1, _("Show Ratsnest"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_ShowGlobalRatsnest->SetValue(false);
    itemStaticBoxSizer15->Add(m_ShowGlobalRatsnest, 0, wxALIGN_LEFT|wxALL, 5);

    m_ShowModuleRatsnest = new wxCheckBox( itemDialog1, ID_CHECKBOX2, _("Show Mod Ratsnest"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_ShowModuleRatsnest->SetValue(false);
    itemStaticBoxSizer15->Add(m_ShowModuleRatsnest, 0, wxALIGN_LEFT|wxALL, 5);

    m_TrackAutodel = new wxCheckBox( itemDialog1, ID_CHECKBOX3, _("Tracks Auto Del"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_TrackAutodel->SetValue(false);
    itemStaticBoxSizer15->Add(m_TrackAutodel, 0, wxALIGN_LEFT|wxALL, 5);

    m_Track_45_Only_Ctrl = new wxCheckBox( itemDialog1, ID_CHECKBOX4, _("Track 45 Only"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_Track_45_Only_Ctrl->SetValue(false);
    itemStaticBoxSizer15->Add(m_Track_45_Only_Ctrl, 0, wxALIGN_LEFT|wxALL, 5);

    m_Segments_45_Only_Ctrl = new wxCheckBox( itemDialog1, ID_CHECKBOX5, _("Segments 45 Only"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_Segments_45_Only_Ctrl->SetValue(false);
    itemStaticBoxSizer15->Add(m_Segments_45_Only_Ctrl, 0, wxALIGN_LEFT|wxALL, 5);

    m_AutoPANOpt = new wxCheckBox( itemDialog1, ID_CHECKBOX6, _("Auto PAN"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AutoPANOpt->SetValue(false);
    m_AutoPANOpt->SetForegroundColour(wxColour(0, 0, 255));
    itemStaticBoxSizer15->Add(m_AutoPANOpt, 0, wxALIGN_LEFT|wxALL, 5);

    m_Track_DoubleSegm_Ctrl = new wxCheckBox( itemDialog1, ID_CHECKBOX7, _("Double Segm Track"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_Track_DoubleSegm_Ctrl->SetValue(false);
    m_Track_DoubleSegm_Ctrl->SetForegroundColour(wxColour(0, 144, 0));
    itemStaticBoxSizer15->Add(m_Track_DoubleSegm_Ctrl, 0, wxALIGN_LEFT|wxALL, 5);

    wxBoxSizer* itemBoxSizer24 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer24, 0, wxALIGN_TOP|wxALL, 5);

    wxArrayString m_MagneticPadOptCtrlStrings;
    m_MagneticPadOptCtrlStrings.Add(_("Never"));
    m_MagneticPadOptCtrlStrings.Add(_("When creating tracks"));
    m_MagneticPadOptCtrlStrings.Add(_("Always"));
    m_MagneticPadOptCtrl = new wxRadioBox( itemDialog1, ID_RADIOBOX4, _("Magnetic Pads"), wxDefaultPosition, wxDefaultSize, m_MagneticPadOptCtrlStrings, 1, wxRA_SPECIFY_COLS );
    m_MagneticPadOptCtrl->SetSelection(0);
    if (WinEDA_PcbGeneralOptionsFrame::ShowToolTips())
        m_MagneticPadOptCtrl->SetToolTip(_("control the capture of the pcb cursor when the mouse cursor enters a pad area"));
    itemBoxSizer24->Add(m_MagneticPadOptCtrl, 0, wxGROW|wxALL, 5);

    wxArrayString m_MagneticTrackOptCtrlStrings;
    m_MagneticTrackOptCtrlStrings.Add(_("Never"));
    m_MagneticTrackOptCtrlStrings.Add(_("When creating tracks"));
    m_MagneticTrackOptCtrlStrings.Add(_("Always"));
    m_MagneticTrackOptCtrl = new wxRadioBox( itemDialog1, ID_RADIOBOX3, _("Magnetic Tracks"), wxDefaultPosition, wxDefaultSize, m_MagneticTrackOptCtrlStrings, 1, wxRA_SPECIFY_COLS );
    m_MagneticTrackOptCtrl->SetSelection(0);
    if (WinEDA_PcbGeneralOptionsFrame::ShowToolTips())
        m_MagneticTrackOptCtrl->SetToolTip(_("control the capture of the pcb cursor when the mouse cursor enters a track"));
    itemBoxSizer24->Add(m_MagneticTrackOptCtrl, 0, wxGROW|wxALL, 5);

    wxButton* itemButton27 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton27->SetForegroundColour(wxColour(221, 0, 0));
    itemBoxSizer24->Add(itemButton27, 0, wxGROW|wxALL, 5);

    wxButton* itemButton28 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton28->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer24->Add(itemButton28, 0, wxGROW|wxALL, 5);

    // Set validators
    m_MagneticPadOptCtrl->SetValidator( wxGenericValidator(& g_MagneticPadOption) );
    m_MagneticTrackOptCtrl->SetValidator( wxGenericValidator(& g_MagneticTrackOption) );
////@end WinEDA_PcbGeneralOptionsFrame content construction
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_PcbGeneralOptionsFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_PcbGeneralOptionsFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_PcbGeneralOptionsFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_PcbGeneralOptionsFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_PcbGeneralOptionsFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_PcbGeneralOptionsFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_PcbGeneralOptionsFrame icon retrieval
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_PcbGeneralOptionsFrame::OnCancelClick( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK in WinEDA_PcbGeneralOptionsFrame.
    // Before editing this code, remove the block markers.
    event.Skip();
////@end wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK in WinEDA_PcbGeneralOptionsFrame. 
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_PcbGeneralOptionsFrame::OnOkClick( wxCommandEvent& event )
{
    AcceptPcbOptions(event);
////@begin wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK in WinEDA_PcbGeneralOptionsFrame.
    // Before editing this code, remove the block markers.
    event.Skip();
////@end wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK in WinEDA_PcbGeneralOptionsFrame. 
}



/**************************************************************************/
void WinEDA_PcbGeneralOptionsFrame::AcceptPcbOptions(wxCommandEvent& event)
/**************************************************************************/
{
int ii;

    DisplayOpt.DisplayPolarCood =
        (m_PolarDisplay->GetSelection() == 0) ? FALSE : TRUE;
    ii = g_UnitMetric;
    g_UnitMetric = (m_BoxUnits->GetSelection() == 0)  ? 0 : 1;
    if ( ii != g_UnitMetric ) m_Parent->ReCreateAuxiliaryToolbar();

    g_CursorShape = m_CursorShape->GetSelection();
    g_TimeOut = 60 * m_SaveTime->GetValue();

    /* Mise a jour de la combobox d'affichage de la couche active */
    g_DesignSettings.m_CopperLayerCount = m_LayerNumber->GetValue();
    m_Parent->ReCreateLayerBox(NULL);

    g_MaxLinksShowed = m_MaxShowLinks->GetValue();
    Drc_On = m_DrcOn->GetValue();
    if ( g_Show_Ratsnest != m_ShowGlobalRatsnest->GetValue() )
    {
        g_Show_Ratsnest = m_ShowGlobalRatsnest->GetValue();
        m_Parent->Ratsnest_On_Off(m_DC);
    }
    g_Show_Module_Ratsnest = m_ShowModuleRatsnest->GetValue();
    g_AutoDeleteOldTrack = m_TrackAutodel->GetValue();
    Segments_45_Only = m_Segments_45_Only_Ctrl->GetValue();
    Track_45_Only = m_Track_45_Only_Ctrl->GetValue();
    m_Parent->DrawPanel->m_AutoPAN_Enable = m_AutoPANOpt->GetValue();
    g_TwoSegmentTrackBuild = m_Track_DoubleSegm_Ctrl->GetValue();

    EndModal(1);
}


enum id_optpcb
{
    ID_ACCEPT_OPT = 1000,
    ID_CANCEL_OPT
};

#include "dialog_track_options.cpp"
#include "dialog_display_options.cpp"
#include "dialog_graphic_items_options.cpp"

/*****************************************************************/
void WinEDA_PcbFrame::InstallPcbOptionsFrame(const wxPoint & pos,
            wxDC * DC, int id)
/*****************************************************************/
{

    switch ( id )
    {
    case ID_PCB_TRACK_SIZE_SETUP:
        {
        WinEDA_PcbTracksDialog * OptionsFrame =
            new WinEDA_PcbTracksDialog(this);
        OptionsFrame->ShowModal(); OptionsFrame->Destroy();
        }
        break;

    case ID_PCB_DRAWINGS_WIDTHS_SETUP:
        {
        WinEDA_GraphicItemsOptionsDialog * OptionsFrame =
            new WinEDA_GraphicItemsOptionsDialog(this);
        OptionsFrame->ShowModal(); OptionsFrame->Destroy();
        }
        break;

    case ID_PCB_LOOK_SETUP:
        {
        WinEDA_DisplayOptionsDialog * OptionsFrame =
            new WinEDA_DisplayOptionsDialog(this);
        OptionsFrame->ShowModal(); OptionsFrame->Destroy();
        }
        break;

    case ID_OPTIONS_SETUP:
        {
        WinEDA_PcbGeneralOptionsFrame * OptionsFrame =
            new WinEDA_PcbGeneralOptionsFrame(this, DC);
        OptionsFrame->ShowModal(); OptionsFrame->Destroy();
        }
        break;
    }
}


/*******************************************************************/
void WinEDA_ModuleEditFrame::InstallOptionsFrame(const wxPoint & pos)
/*******************************************************************/
{
WinEDA_GraphicItemsOptionsDialog OptionsFrame (this);
    OptionsFrame.ShowModal();
}

