/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2022 Mikolaj Wielgus
 * Copyright (C) 2022 KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <sim/sim_model_ngspice.h>


// This script was originally autogenerated using the a bash script called
// generate_sim_Model_ngspice_data.bash, later heavily modified manually. The script can be found
// in the Git history if needed for reference purposes.

// We don't use the param flags anymore, so replace them with dummies to save compilation time.
#define U() SIM_MODEL::PARAM::FLAGS()
#define UR() SIM_MODEL::PARAM::FLAGS()
#define P() SIM_MODEL::PARAM::FLAGS()
#define PR() SIM_MODEL::PARAM::FLAGS()
#define A() SIM_MODEL::PARAM::FLAGS()
#define AR() SIM_MODEL::PARAM::FLAGS()
#define AU() SIM_MODEL::PARAM::FLAGS()
#define AP() SIM_MODEL::PARAM::FLAGS()
#define APR() SIM_MODEL::PARAM::FLAGS()
#define AA() SIM_MODEL::PARAM::FLAGS()
#define AAU() SIM_MODEL::PARAM::FLAGS()
#define PAA() SIM_MODEL::PARAM::FLAGS()
#define N() SIM_MODEL::PARAM::FLAGS()
#define R() SIM_MODEL::PARAM::FLAGS()
#define X() SIM_MODEL::PARAM::FLAGS()
#define XR() SIM_MODEL::PARAM::FLAGS()
#define XU() SIM_MODEL::PARAM::FLAGS()
#define Q() SIM_MODEL::PARAM::FLAGS()
#define QR() SIM_MODEL::PARAM::FLAGS()
#define QU() SIM_MODEL::PARAM::FLAGS()
#define Z() SIM_MODEL::PARAM::FLAGS()
#define ZR() SIM_MODEL::PARAM::FLAGS()
#define ZU() SIM_MODEL::PARAM::FLAGS()
#define QO() SIM_MODEL::PARAM::FLAGS()
#define QOR() SIM_MODEL::PARAM::FLAGS()


struct MODEL_INFO_MAP
{
    using MODEL_TYPE = SIM_MODEL_NGSPICE::MODEL_TYPE;
    using MODEL_INFO = SIM_MODEL_NGSPICE::MODEL_INFO;

    std::unordered_map<MODEL_TYPE, MODEL_INFO> modelInfos;

    MODEL_INFO_MAP()
    {
        modelInfos[MODEL_TYPE::NONE] = {};
        /*modelInfos[MODEL_TYPE::SWITCH] = { "Switch", "SW", "", { "+", "-", "Ctrl+", "Ctrl-" }, "Ideal voltage controlled switch", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "sw", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "", "Switch model" );
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "vt", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "0", "", "Threshold voltage" );
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "vh", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "0", "", "Hysteresis voltage" );
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "ron", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "Ω", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "1", "", "Resistance when closed" );
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "gon", 106, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "1", "", "Conductance when closed" );
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "roff", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "Ω", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "1e+12", "", "Resistance when open" );
        modelInfos[MODEL_TYPE::SWITCH].modelParams.emplace_back( "goff", 107, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "1e-12", "", "Conductance when open" );
        // Instance parameters
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "on", 1, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Switch initially closed", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "off", 2, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Switch initially open", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "pos_node", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Positive node of switch", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "neg_node", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Negative node of switch", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "cont_p_node", 5, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Positive contr. node of switch", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "cont_n_node", 6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Positive contr. node of switch", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "i", 7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Switch current", true );
        modelInfos[MODEL_TYPE::SWITCH].instanceParams.emplace_back( "p", 8, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Switch power", true );

        modelInfos[MODEL_TYPE::CSWITCH] = { "CSwitch", "CSW", "", { "+", "-", "Ctrl+", "Ctrl-" }, "Current controlled ideal switch", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "csw", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "", "Current controlled switch model" );
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "it", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "0", "", "Threshold current" );
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "ih", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "0", "", "Hysterisis current" );
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "ron", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "Ω", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "1", "", "Closed resistance" );
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "roff", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "Ω", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "1e+12", "", "Open resistance" );
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "gon", 106, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Closed conductance" );
        modelInfos[MODEL_TYPE::CSWITCH].modelParams.emplace_back( "goff", 107, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Open conductance" );
        // Instance parameters
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "control", 1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING /SIM_VALUE::TYPE::INSTANCE/, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Name of controlling source", true );
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "on", 2, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initially closed", true );
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "off", 3, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initially open", true );
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "pos_node", 4, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Positive node of switch", true );
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "neg_node", 5, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Negative node of switch", true );
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "i", 6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Switch current", true );
        modelInfos[MODEL_TYPE::CSWITCH].instanceParams.emplace_back( "p", 7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instantaneous power", true );*/


        modelInfos[MODEL_TYPE::DIODE] = { "Diode", "D", "", { "A", "K" }, "Junction Diode model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "level",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "", "Diode level selector" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "is",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "", "Saturation current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "js",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "jsw",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Sidewall Saturation current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tnom",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tref",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, UR(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "27", "", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "rs",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Ohmic resistance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "trs",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Ohmic resistance 1st order temp. coeff." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "trs1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "trs2",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Ohmic resistance 2nd order temp. coeff." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "n",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Emission Coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ns",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Sidewall emission Coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tt",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Transit Time" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ttt1",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "s", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Transit Time 1st order temp. coeff." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ttt2",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "s", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Transit Time 2nd order temp. coeff." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cjo",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "", "Junction capacitance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cj0",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "Junction capacitance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cj",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "Junction capacitance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "vj",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Junction potential" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "pb",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "m_",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "", "Grading coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "mj",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.5", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tm1",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/°C²", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Grading coefficient 1st temp. coeff." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tm2",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Grading coefficient 2nd temp. coeff." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cjp",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "", "Sidewall junction capacitance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cjsw",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "php",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Sidewall junction potential" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "mjsw",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "", "Sidewall Grading coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ikf",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Forward Knee current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ik",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ikr",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Reverse Knee current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "nbv",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Breakdown Emission Coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "area_",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Area factor" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "pj_",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Perimeter factor" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tlev",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Diode temperature equation selector" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tlevc",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Diode temperature equation selector" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "eg",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.11", "", "Activation energy" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "xti",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "", "Saturation current temperature exp." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cta",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Area junction temperature coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ctc",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ctp",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Perimeter junction capacitance temperature coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tpb",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Area junction potential temperature coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tvj",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tphp",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Perimeter junction potential temperature coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "jtun",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Tunneling saturation current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "jtunsw",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Tunneling sidewall saturation current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ntun",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "30", "", "Tunneling emission coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "xtitun",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "", "Tunneling saturation current exponential" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "keg",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "EG correction factor for tunneling" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "kf",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "", "flicker noise coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "af",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "", "flicker noise exponent" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "fc",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "", "Forward bias junction fit parameter" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "fcs",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "", "Forward bias sidewall junction fit parameter" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "bv",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Reverse breakdown voltage" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ibv",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.001", "", "Current at reverse breakdown voltage" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "ib",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.001", "", "n.a." );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "tcv",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Reverse breakdown voltage temperature coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cond",  114, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Ohmic conductance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "isr",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "", "Recombination saturation current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "nr",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "", "Recombination current emission coefficient" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "fv_max",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "", "maximum voltage in forward direction" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "bv_max",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "", "maximum voltage in reverse direction" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "id_max",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "", "maximum current" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "te_max",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "", "temperature" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "pd_max",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "", "maximum power dissipation" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "rth0",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "", "Self-heating thermal resistance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "cth0",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "", "Self-heating thermal capacitance" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "lm_",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Length of metal capacitor (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "lp_",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Length of polysilicon capacitor (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "wm_",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Width of metal capacitor (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "wp_",  159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Width of polysilicon capacitor (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "xom",  160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "", "Thickness of the metal to bulk oxide (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "xoi",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "", "Thickness of the polysilicon to bulk oxide (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "xm",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Masking and etching effects in metal (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "xp",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "", "Masking and etching effects in polysilicon (level=3)" );
        modelInfos[MODEL_TYPE::DIODE].modelParams.emplace_back( "d",  113, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode model" );
        // Instance parameters
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "off",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initially off", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "temp",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "dtemp",  23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance delta temperature", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "ic",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial device voltage", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "m",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0.5", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "area",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "1", "", "Area factor", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "pj",  19, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0", "", "Perimeter factor", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "w",  20, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Diode width", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "l",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Diode length", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "lm",  25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0", "", "Length of metal capacitor (level=3)", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "lp",  26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0", "", "Length of polysilicon capacitor (level=3)", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "wm",  27, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0", "", "Width of metal capacitor (level=3)", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "wp",  28, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0", "", "Width of polysilicon capacitor (level=3)", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "thermal",  24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Self heating mode selector", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_area",  9, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT area", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "vd",  5, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode voltage", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "id",  4, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode current", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "c",  4, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, R(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode current", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "gd",  8, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode conductance", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "cd",  18, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode capacitance", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "charge",  6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode capacitor charge", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "qd",  6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, UR(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode capacitor charge", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "capcur",  7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode capacitor current", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "p",  10, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Diode power", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_dc",  17, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_real",  12, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sens. and real part of ac sensitivity", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_imag",  13, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_mag",  14, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity of ac magnitude", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_ph",  15, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity of ac phase", true );
        modelInfos[MODEL_TYPE::DIODE].instanceParams.emplace_back( "sens_cplx",  16, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity", true );


        modelInfos[MODEL_TYPE::BJT] = { "BJT", "NPN", "PNP", { "C", "B", "E" }, "Bipolar Junction Transistor", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "type",  309, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "npn", "pnp", "NPN or PNP" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "npn",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "NPN type device" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "pnp",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "PNP type device" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "subs",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-1721368256", "-514428616", "Vertical or Lateral device" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnom",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tref",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "27", "27", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "is_",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-16", "1e-16", "Saturation Current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ibe",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Base-Emitter saturation Current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ibc",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Base-Collector saturation Current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "bf",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Ideal forward beta" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "nf",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Forward emission coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vaf",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forward Early voltage" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "va",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ikf",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forward beta roll-off corner current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ik",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ise",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "B-E leakage saturation current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "c2",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ne",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "1.5", "B-E leakage emission coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "br",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Ideal reverse beta" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "nr",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Reverse emission coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "var",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse Early voltage" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vb",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ikr",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "reverse beta roll-off corner current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "isc",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "B-C leakage saturation current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "c4",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "nc",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "B-C leakage emission coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "rb",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Zero bias base resistance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "irb",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Current for base resistance=(rb+rbm)/2" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "rbm",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum base resistance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "re",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Emitter resistance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "rc",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Collector resistance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "cje",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Zero bias B-E depletion capacitance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vje",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "B-E built in potential" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "pe",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.75", "0.75", "B-E built in potential" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "mje",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "B-E junction grading coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "me",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.33", "0.33", "B-E junction grading coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tf",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ideal forward transit time" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "xtf",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coefficient for bias dependence of TF" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vtf",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage giving VBC dependence of TF" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "itf",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High current dependence of TF" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ptf",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "deg", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Excess phase" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "cjc",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Zero bias B-C depletion capacitance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vjc",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "B-C built in potential" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "pc",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.75", "0.75", "B-C built in potential" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "mjc",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "B-C junction grading coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "mc",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.33", "0.33", "B-C junction grading coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "xcjc",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fraction of B-C cap to internal base" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tr",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ideal reverse transit time" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "cjs",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Zero bias Substrate capacitance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "csub_",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Zero bias Substrate capacitance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ccs",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Zero bias Substrate capacitance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vjs",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "Substrate junction built in potential" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ps",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.75", "0.75", "Substrate junction built in potential" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "mjs",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate junction grading coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ms",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AR(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Substrate junction grading coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "xtb",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forward and reverse beta temp. exp." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "eg",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.11", "1.11", "Energy gap for IS temp. dependency" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "xti",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "Temp. exponent for IS" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "fc",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias junction fit parameter" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "kf",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker Noise Coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "af",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker Noise Exponent" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "invearlyvoltf",  301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Inverse early voltage:forward" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "invearlyvoltr",  302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Inverse early voltage:reverse" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "invrollofff",  303, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Inverse roll off - forward" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "invrolloffr",  304, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Inverse roll off - reverse" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "collectorconduct",  305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Collector conductance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "emitterconduct",  306, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Emitter conductance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "transtimevbcfact",  307, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Transit time VBC factor" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "excessphasefactor",  308, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "deg", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Excess phase fact." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "iss",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate Jct. Saturation Current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ns",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Substrate current emission coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "rco",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Intrinsic coll. resistance" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vo",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Epi drift saturation voltage" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "gamma",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-11", "1e-11", "Epi doping parameter" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "qco",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "C", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Epi Charge parameter" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tlev",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature equation selector" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tlevc",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature equation selector" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tbf1",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "BF 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tbf2",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "BF 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tbr1",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "BR 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tbr2",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "BR 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tikf1",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IKF 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tikf2",  159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IKF 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tikr1",  160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IKR 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tikr2",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IKR 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tirb1",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IRB 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tirb2",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IRB 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NC 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NC 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tne1",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NE 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tne2",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NE 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnf1",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NF 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnf2",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NF 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnr1",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NR 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tnr2",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NR 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trb1",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RB 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trb",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trb2",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RB 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trc1",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RC 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trc",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trc2",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RC 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tre1",  176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RE 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tre",  176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tre2",  177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RE 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trm1",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RBM 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "trm2",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "RBM 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvaf1",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VAF 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvaf2",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VAF 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvar1",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VAR 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvar2",  183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VAR 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ctc",  184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "CJC temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "cte",  185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "CJE temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "cts",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "CJS temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvjc",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VJC temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvje",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VJE temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tvjs",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "VJS temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "titf1",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ITF 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "titf2",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ITF 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ttf1",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "TF 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ttf2",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "TF 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ttr1",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "TR 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ttr2",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "TR 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tmje1",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "MJE 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tmje2",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "MJE 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tmjc1",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "MJC 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tmjc2",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "MJC 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tmjs1",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "MJS 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tmjs2",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "MJS 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tns1",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NS 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tns2",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "NS 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "nkf",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "NKF High current beta rolloff exponent" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "nk",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.5", "0.5", "n.a." );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tis1",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IS 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tis2",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "IS 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tise1",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ISE 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tise2",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ISE 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tisc1",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ISC 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tisc2",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ISC 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tiss1",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ISS 1. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "tiss2",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "ISS 2. temperature coefficient" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "quasimod",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature equation selector" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vg",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.206", "1.206", "Energy gap for QS temp. dependency" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "cn",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "2.42", "2.2", "Temperature exponent of RCI" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "d",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.87", "0.52", "Temperature exponent of VO" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vbe_max",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-E junction" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vbc_max",  219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-C junction" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "vce_max",  220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage C-E branch" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "pd_max",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum device power dissipation" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ic_max",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum collector current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "ib_max",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum base current" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "te_max",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum temperature" );
        modelInfos[MODEL_TYPE::BJT].modelParams.emplace_back( "rth0",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "thermal resistance juntion to ambient" );
        // Instance parameters
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "off",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "icvbe",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-E voltage", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "icvce",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial C-E voltage", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "m",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "area",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "(Emitter) Area factor", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "areab",  10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Base area factor", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "areac",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Collector area factor", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "ic",  5, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial condition vector", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_area",  6, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT area", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "colnode",  212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of collector node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "basenode",  213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of base node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "emitnode",  214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of emitter node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "substnode",  215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of substrate node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "colprimenode",  217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal collector node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "baseprimenode",  218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "emitprimenode",  219, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal emitter node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "ic",  222, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current at collector node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "ib",  223, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current at base node", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "ie",  247, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Emitter current", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "is",  248, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-16", "1e-16", "Substrate current", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "vbe",  220, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-E voltage", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "vbc",  221, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-C voltage", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "gm",  226, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal transconductance", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "gpi",  224, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal input conductance - pi", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "gmu",  225, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal conductance - mu", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "gx",  236, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance from base to internal base", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "go",  227, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal output conductance", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "geqcb",  238, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "d(Ibe)/d(Vbc)", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "gcsub",  239, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal Subs. cap. equiv. cond.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "gdsub",  254, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal Subs. Diode equiv. cond.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "geqbx",  240, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal C-B-base cap. equiv. cond.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cpi",  250, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base to emitter capacitance", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cmu",  251, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base to collector capacitance", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cbx",  252, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Base to collector capacitance", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "csub",  253, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Substrate capacitance", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cqbe",  229, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in B-E jct.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cqbc",  231, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in B-C jct.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cqsub",  233, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in Subs. jct.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cqbx",  235, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in B-X jct.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "cexbc",  237, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Total Capacitance in B-X junction", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "qbe",  228, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage B-E junction", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "qbc",  230, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage B-C junction", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "qsub",  232, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage Subs. junction", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "qbx",  234, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage B-X junction", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "p",  249, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipation", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_dc",  246, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_real",  241, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_imag",  242, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sens. & imag part of ac sens.", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_mag",  243, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity of ac magnitude", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_ph",  244, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity of ac phase", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "sens_cplx",  245, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "temp",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "instance temperature", true );
        modelInfos[MODEL_TYPE::BJT].instanceParams.emplace_back( "dtemp",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "instance temperature delta from circuit", true );


        modelInfos[MODEL_TYPE::VBIC] = { "VBIC", "NPN", "PNP", { "C", "B", "E" }, "Vertical Bipolar Inter-Company Model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "type",  305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "npn", "pnp", "NPN or PNP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "npn",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "NPN type device" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "pnp",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "PNP type device" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tnom",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tref",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "27", "27", "n.a." );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rcx",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic coll resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rci",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Intrinsic coll resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vo",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Epi drift saturation voltage" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "gamm",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Epi doping parameter" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "hrcf",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "High current RC factor" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rbx",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic base resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rbi",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Intrinsic base resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "re",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic emitter resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rs",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic substrate resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rbp",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Parasitic base resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "is_",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-16", "1e-16", "Transport saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nf",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Forward emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nr",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Reverse emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "fc",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.9", "0.9", "Fwd bias depletion capacitance limit" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cbeo",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Extrinsic B-E overlap capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cje",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Zero bias B-E depletion capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "pe",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "B-E built in potential" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "me",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "B-E junction grading coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "aje",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "-0.5", "-0.5", "B-E capacitance smoothing factor" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cbco",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Extrinsic B-C overlap capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cjc",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Zero bias B-C depletion capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "qco",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "C", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Epi charge parameter" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cjep",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-C extrinsic zero bias capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "pc",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "B-C built in potential" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "mc",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "B-C junction grading coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ajc",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "-0.5", "-0.5", "B-C capacitance smoothing factor" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cjcp",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Zero bias S-C capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ps",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "S-C junction built in potential" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ms",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "S-C junction grading coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ajs",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "-0.5", "-0.5", "S-C capacitance smoothing factor" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibei",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-18", "1e-18", "Ideal B-E saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "wbe",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Portion of IBEI from Vbei, 1-WBE from Vbex" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nei",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Ideal B-E emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "iben",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-ideal B-E saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nen",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Non-ideal B-E emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibci",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-16", "1e-16", "Ideal B-C saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nci",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Ideal B-C emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibcn",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-ideal B-C saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ncn",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Non-ideal B-C emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "avc1",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "B-C weak avalanche parameter 1" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "avc2",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "B-C weak avalanche parameter 2" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "isp",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parasitic transport saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "wsp",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Portion of ICCP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nfp",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parasitic fwd emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibeip",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ideal parasitic B-E saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibenp",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-ideal parasitic B-E saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibcip",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ideal parasitic B-C saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ncip",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Ideal parasitic B-C emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibcnp",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Nonideal parasitic B-C saturation current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ncnp",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Nonideal parasitic B-C emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vef",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forward Early voltage" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ver",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse Early voltage" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ikf",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forward knee current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ikr",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse knee current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ikp",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parasitic knee current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tf",  159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ideal forward transit time" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "qtf",  160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Variation of TF with base-width modulation" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xtf",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coefficient for bias dependence of TF" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vtf",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage giving VBC dependence of TF" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "itf",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High current dependence of TF" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tr",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ideal reverse transit time" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "td",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forward excess-phase delay time" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "kfn",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "B-E Flicker Noise Coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "afn",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "B-E Flicker Noise Exponent" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "bfn",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "B-E Flicker Noise 1/f dependence" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xre",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RE" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrb",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RB" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrbi",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RBI" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrc",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RC" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrci",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RCI" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrs",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RS" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xvo",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of VO" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ea",  176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IS" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eaie",  177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IBEI" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eaic",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IBCI/IBEIP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eais",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IBCIP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eane",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IBEN" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eanc",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IBCN/IBENP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eans",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Activation energy for IBCNP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xis",  183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Temperature exponent of IS" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xii",  184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Temperature exponent of IBEI,IBCI,IBEIP,IBCIP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xin",  185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Temperature exponent of IBEN,IBCN,IBENP,IBCNP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tnf",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of NF" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tavc",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of AVC2" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "rth",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Thermal resistance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "cth",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Thermal capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vrt",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Punch-through voltage of internal B-C junction" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "art",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Smoothing parameter for reach-through" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ccso",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Fixed C-S capacitance" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "qbm",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Select SGP qb formulation" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nkf",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "High current beta rolloff" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xikf",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of IKF" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrcx",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RCX" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrbx",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RBX" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xrbp",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of RBP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "isrr",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Separate IS for fwd and rev" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "xisr",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of ISR" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "dear",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta activation energy for ISRR" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "eap",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "eV", SIM_MODEL::PARAM::CATEGORY::DC, "1.12", "1.12", "Exitivation energy for ISP" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vbbe",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "B-E breakdown voltage" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "nbbe",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "B-E breakdown emission coefficient" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ibbe",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "B-E breakdown current" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tvbbe1",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Linear temperature coefficient of VBBE" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tvbbe2",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Quadratic temperature coefficient of VBBE" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "tnbbe",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of NBBE" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "ebbe",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "exp(-VBBE/(NBBE*Vtv))" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "dtemp_",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Locale Temperature difference" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vers",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "Revision Version" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vref",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reference Version" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vbe_max",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-E junction" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vbc_max",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-C junction" );
        modelInfos[MODEL_TYPE::VBIC].modelParams.emplace_back( "vce_max",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage C-E branch" );
        // Instance parameters
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "m",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "area",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Area factor", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "off",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "ic",  3, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial condition vector", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "icvbe",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-E voltage", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "icvce",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial C-E voltage", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "temp",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "dtemp",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance delta temperature", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "collnode",  222, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of collector node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "basenode",  223, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of base node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "emitnode",  224, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of emitter node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "subsnode",  225, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of substrate node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "collcxnode",  226, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal collector node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "collcinode",  227, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal collector node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "basebxnode",  228, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "basebinode",  229, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "basebpnode",  230, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "emiteinode",  231, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal emitter node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "subssinode",  232, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal substrate node", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "vbe",  233, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-E voltage", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "vbc",  234, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-C voltage", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "ic",  235, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Collector current", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "ib",  236, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Base current", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "ie",  237, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Emitter current", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "is",  238, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-16", "1e-16", "Substrate current", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "gm",  239, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal transconductance dIc/dVbe", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "go",  240, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal output conductance dIc/dVbc", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "gpi",  241, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal input conductance dIb/dVbe", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "gmu",  242, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal conductance dIb/dVbc", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "gx",  243, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance from base to internal base", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cbe",  257, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base to emitter capacitance", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cbex",  258, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External base to emitter capacitance", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cbc",  259, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base to collector capacitance", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cbcx",  260, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External Base to collector capacitance", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cbep",  261, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Parasitic Base to emitter capacitance", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cbcp",  262, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Parasitic Base to collector capacitance", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "p",  263, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipation", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "geqcb",  253, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal C-B-base cap. equiv. cond.", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "geqbx",  256, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External C-B-base cap. equiv. cond.", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "qbe",  244, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage B-E junction", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cqbe",  245, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in B-E jct.", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "qbc",  246, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage B-C junction", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cqbc",  247, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in B-C jct.", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "qbx",  248, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage B-X junction", true );
        modelInfos[MODEL_TYPE::VBIC].instanceParams.emplace_back( "cqbx",  249, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cap. due to charge storage in B-X jct.", true );


        modelInfos[MODEL_TYPE::HICUM2] = { "hicum2", "NPN", "PNP", { "C", "B", "E" }, "High Current Model for BJT" , {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "type", 305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "npn", "pnp", "For transistor type NPN(+1) or PNP (-1)" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "npn", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "NPN type device" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "pnp", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "PNP type device" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tnom", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Temperature at which parameters are specified" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tref", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "300.15", "300.15", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "version", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.4.0", "2.4.0", "parameter for model version" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "c10", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-30", "2e-30", "GICCR constant" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "qp0", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-14", "2e-14", "Zero-bias hole charge" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ich", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High-current correction for 2D and 3D effects" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "hf0", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Weight factor for the low current minority charge" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "hfe", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emitter minority charge weighting factor in HBTs" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "hfc", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Collector minority charge weighting factor in HBTs" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "hjei", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "B-E depletion charge weighting factor in HBTs" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ahjei", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter describing the slope of hjEi(VBE)" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rhjei", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Smoothing parameter for hjEi(VBE) at high voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "hjci", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "B-C depletion charge weighting factor in HBTs" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ibeis", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-18", "1e-18", "Internal B-E saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mbei", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Internal B-E current ideality factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ireis", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Internal B-E recombination saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mrei", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Internal B-E recombination current ideality factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ibeps", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Peripheral B-E saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mbep", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Peripheral B-E current ideality factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ireps", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Peripheral B-E recombination saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mrep", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Peripheral B-E recombination current ideality factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mcf", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-ideality factor for III-V HBTs" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tbhrec", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Base current recombination time constant at B-C barrier for high forward injection" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ibcis", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-16", "1e-16", "Internal B-C saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mbci", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Internal B-C current ideality factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ibcxs", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "External B-C saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "mbcx", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "External B-C current ideality factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ibets", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "B-E tunneling saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "abet", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "40", "40", "Exponent factor for tunneling current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tunode", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Specifies the base node connection for the tunneling current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "favl", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Avalanche current factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "qavl", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Exponent factor for avalanche current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "kavl", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flag/factor for turning strong avalanche on" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alfav", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Relative TC for FAVL" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alqav", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Relative TC for QAVL" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alkav", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Relative TC for KAVL" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rbi0", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Zero bias internal base resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rbx", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "External base series resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fgeo", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.6557", "0.6557", "Factor for geometry dependence of emitter current crowding" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fdqr0", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Correction factor for modulation by B-E and B-C space charge layer" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fcrbi", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Ratio of HF shunt to total internal capacitance (lateral NQS effect)" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fqi", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Ration of internal to total minority charge" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "re", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Emitter series resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rcx", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "External collector series resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "itss", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate transistor transfer saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "msf", 147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Forward ideality factor of substrate transfer current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "iscs", 148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "C-S diode saturation current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "msc", 149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Ideality factor of C-S diode current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tsf", 150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Transit time for forward operation of substrate transistor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rsu", 151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate series resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "csu", 152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate shunt capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cjei0", 153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-20", "1e-20", "Internal B-E zero-bias depletion capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vdei", 154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Internal B-E built-in potential" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zei", 155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Internal B-E grading coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ajei", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "2.5", "2.5", "Ratio of maximum to zero-bias value of internal B-E capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "aljei", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "2.5", "2.5", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cjep0", 157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-20", "1e-20", "Peripheral B-E zero-bias depletion capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vdep", 158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Peripheral B-E built-in potential" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zep", 159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Peripheral B-E grading coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ajep", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "2.5", "2.5", "Ratio of maximum to zero-bias value of peripheral B-E capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "aljep", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "2.5", "2.5", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cjci0", 161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-20", "1e-20", "Internal B-C zero-bias depletion capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vdci", 162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "Internal B-C built-in potential" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zci", 163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.4", "0.4", "Internal B-C grading coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vptci", 164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Internal B-C punch-through voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cjcx0", 165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-20", "1e-20", "External B-C zero-bias depletion capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vdcx", 166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "External B-C built-in potential" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zcx", 167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.4", "0.4", "External B-C grading coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vptcx", 168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "External B-C punch-through voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fbcpar", 169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Partitioning factor of parasitic B-C cap" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fbc", 169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fbepar", 170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Partitioning factor of parasitic B-E cap" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fbe", 170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "1", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cjs0", 171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "C-S zero-bias depletion capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vds", 172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "C-S built-in potential" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zs", 173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "C-S grading coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vpts", 174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "C-S punch-through voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cscp0", 175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Perimeter S-C zero-bias depletion capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vdsp", 176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Perimeter S-C built-in potential" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zsp", 177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Perimeter S-C grading coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vptsp", 178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Perimeter S-C punch-through voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "t0", 179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Low current forward transit time at VBC=0V" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "dt0h", 180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Time constant for base and B-C space charge layer width modulation" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tbvl", 181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Time constant for modeling carrier jam at low VCE" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tef0", 182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Neutral emitter storage time" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "gtfe", 183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponent factor for current dependence of neutral emitter storage time" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "thcs", 184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation time constant at high current densities" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ahc", 185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Smoothing factor for current dependence of base and collector transit time" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alhc", 185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.1", "0.1", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "fthc", 186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Partitioning factor for base and collector portion" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rci0", 187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "150", "150", "Internal collector resistance at low electric field" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vlim", 188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Voltage separating ohmic and saturation velocity regime" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vces", 189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Internal C-E saturation voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vpt", 190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Collector punch-through voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "aick", 191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.001", "0.001", "Smoothing term for ICK" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "delck", 192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Fitting factor for critical current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "tr", 193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Storage time for inverse operation" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vcbar", 194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Barrier voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "icbar", 195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Normalization parameter" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "acbar", 196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Smoothing parameter for barrier voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cbepar", 197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Total parasitic B-E capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ceox", 197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cbcpar", 198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Total parasitic B-C capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "ccox", 198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alqf", 199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0.167", "0.167", "Factor for additional delay time of minority charge" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alit", 200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.333", "0.333", "Factor for additional delay time of transfer current" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "flnqs", 201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flag for turning on and off of vertical NQS effect" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "kf", 202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "af", 203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "2", "2", "Flicker noise exponent factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cfbe", 204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flag for determining where to tag the flicker noise source" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "flcono", 205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flag for turning on and off of correlated noise implementation" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "kfre", 206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Emitter resistance flicker noise coefficient" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "afre", 207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "2", "2", "Emitter resistance flicker noise exponent factor" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "latb", 208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Scaling factor for collector minority charge in direction of emitter width" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "latl", 209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Scaling factor for collector minority charge in direction of emitter length" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vgb", 210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.17", "1.17", "Bandgap voltage extrapolated to 0 K" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alt0", 211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First order relative TC of parameter T0" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "kt0", 212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second order relative TC of parameter T0" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetaci", 213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent for RCI0" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alvs", 214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Relative TC of saturation drift velocity" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alces", 215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Relative TC of VCES" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetarbi", 216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of internal base resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetarbx", 217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of external base resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetarcx", 218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of external collector resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetare", 219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature exponent of emitter resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetacx", 220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature exponent of mobility in substrate transistor transit time" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vge", 221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.17", "1.17", "Effective emitter bandgap voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vgc", 222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.17", "1.17", "Effective collector bandgap voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vgs", 223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.17", "1.17", "Effective substrate bandgap voltage" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "f1vg", 224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.000102377", "-0.000102377", "Coefficient K1 in T-dependent band-gap equation" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "f2vg", 225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00043215", "0.00043215", "Coefficient K2 in T-dependent band-gap equation" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetact", 226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Exponent coefficient in transfer current temperature dependence" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetabet", 227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3.5", "3.5", "Exponent coefficient in B-E junction current temperature dependence" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alb", 228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Relative TC of forward current gain for V2.1 model" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "dvgbe", 229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bandgap difference between B and B-E junction used for hjEi0 and hf0" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetahjei", 230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for ahjEi" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetavgbe", 231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for hjEi0" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "flsh", 232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flag for turning on and off self-heating effect" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "rth", 233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Thermal resistance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "zetarth", 234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Rth" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "alrth", 235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First order relative TC of parameter Rth" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "cth", 236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Thermal capacitance" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "flcomp", 237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flag for compatibility with v2.1 model (0=v2.1)" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vbe_max", 238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-E junction" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vbc_max", 239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-C junction" );
        modelInfos[MODEL_TYPE::HICUM2].modelParams.emplace_back( "vce_max", 240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage C-E branch" );
        // Instance parameters
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "area", 1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Area factor", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "off", 2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ic", 3, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial condition vector", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "m", 6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "temp", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "dt", 5, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance delta temperature", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "tk", 264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Actual device temperature", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "dtsh", 265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Temperature increase due to self-heating", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "it", 284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "transfer current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "collnode", 251, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of collector node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "basenode", 252, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of base node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "emitnode", 253, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of emitter node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "subsnode", 254, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of substrate node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "tempnode", 255, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of temperature node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "collcinode", 256, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal collector node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "basebpnode", 257, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External base node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "basebinode", 258, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "emiteinode", 259, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal emitter node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "subssinode", 260, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal substrate node", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "xfnode", 261, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal phase node xf", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "xf1node", 262, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal phase node xf1", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "xf2node", 263, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal phase node xf2", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vbe", 266, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External BE voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vbbp", 267, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BBP voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vbc", 268, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External BC voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vce", 269, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External CE voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vsc", 270, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External SC voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vbiei", 271, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal BE voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vbpbi", 272, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Peripheral Base to internal Base voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vbici", 273, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal BC voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "vciei", 274, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal CE voltage", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ic", 275, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Collector current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "iavl", 276, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Avalanche current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ib", 277, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Base current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ibei", 280, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Intenral Base Emitter current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ibci", 281, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal Base Collector current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ie", 278, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Emitter current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "is", 279, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Substrate current", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rcx_t", 282, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External (saturated) collector series resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "re_t", 283, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Emitter series resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rbi", 285, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base resistance as calculated in the model", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rb", 286, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Total base resistance as calculated in the model", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "betadc", 287, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Common emitter forward current gain", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "gmi", 288, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal transconductance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "gms", 289, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance of the parasitic substrate PNP", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rpii", 290, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal base-emitter (input) resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rpix", 291, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External base-emitter (input) resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rmui", 292, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal feedback resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "rmux", 293, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "External feedback resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "roi", 294, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Output resistance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "cpii", 295, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Total internal BE capacitance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "cpix", 296, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Total external BE capacitance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "cmui", 297, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Total internal BC capacitance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "cmux", 298, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Total external BC capacitance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ccs", 299, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CS junction capacitance", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "betaac", 300, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Small signal current gain", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "crbi", 301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Shunt capacitance across RBI as calculated in the model", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "tf", 302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Forward transit time", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ft", 303, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Hz", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transit frequency", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "ick", 304, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Hz", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transit frequency", true );
        modelInfos[MODEL_TYPE::HICUM2].instanceParams.emplace_back( "p", 305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipation", true );


        modelInfos[MODEL_TYPE::JFET] = { "JFET", "NJF", "PJF", { "D", "G", "S" }, "Junction Field effect transistor", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "type",  305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "njf", "pjf", "N-type or P-type JFET model" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "njf",  111, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type JFET model" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "pjf",  112, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type JFET model" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-2", "-2", "Threshold voltage" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-2", "-2", "n.a." );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "beta",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "lambda",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation param." );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "rd",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "gd",  301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain conductance" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "rs",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "gs",  302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source conductance" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "cgs",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-S junction capactance" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "cgd",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-D junction cap" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "pb",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate junction potential" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "is_",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Gate junction saturation current" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "fc",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias junction fit parm." );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "b",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Doping tail parameter" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "tnom",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "parameter measurement temperature" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "tcv",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Threshold voltage temperature coefficient" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "vtotc",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Threshold voltage temperature coefficient alternative" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "bex",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Mobility temperature exponent" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "betatce",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "%/°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Mobility temperature exponent alternative" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "xti",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Gate junction saturation current temperature exponent" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "eg",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.11", "1.11", "Bandgap voltage" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "kf",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker Noise Coefficient" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "af",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker Noise Exponent" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "nlev",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "2", "2", "Noise equation selector" );
        modelInfos[MODEL_TYPE::JFET].modelParams.emplace_back( "gdsnoi",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Channel noise coefficient" );
        // Instance parameters
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "off",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "ic",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT_VECTOR, AU(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial VDS,VGS vector", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "m",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel multiplier", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "area",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Area factor", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "ic-vds",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "ic-vgs",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S volrage", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "temp",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "dtemp",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "drain-node",  301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "gate-node",  302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "source-node",  303, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "drain-prime-node",  304, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal drain node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "source-prime-node",  305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal source node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "vgs",  306, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Voltage G-S", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "vgd",  307, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Voltage G-D", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "ig",  308, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current at gate node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "id",  309, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current at drain node", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "is",  319, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "igd",  310, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current G-D", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "gm",  311, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "gds",  312, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance D-S", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "ggs",  313, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance G-S", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "ggd",  314, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance G-D", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "qgs",  315, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage G-S junction", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "qgd",  317, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage G-D junction", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "cqgs",  316, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to charge storage G-S junction", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "cqgd",  318, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to charge storage G-D junction", true );
        modelInfos[MODEL_TYPE::JFET].instanceParams.emplace_back( "p",  320, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipated by the JFET", true );


        modelInfos[MODEL_TYPE::JFET2] = { "JFET2", "NJF", "PJF", { "D", "G", "S" }, "Short channel field effect transistor", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "type", 305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "njf", "pjf", "N-type or P-type JFET2 model" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "njf", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "N type JFET2 model" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "pjf", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NaN", "NaN", "P type JFET2 model" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "acgam", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "af", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker Noise Exponent" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "beta", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V^2", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "cds", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "D-S junction capacitance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "cgd", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-D junction capacitance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "cgs", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-S junction capacitance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "delta", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/W", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coef of thermal current reduction" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "hfeta", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "drain feedback modulation" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "hfe1", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "hfe2", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "hfg1", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "hfg2", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "mvst", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "modulation index for subtreshold current" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "mxi", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "saturation potential modulation parameter" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "fc", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias junction fit parm." );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "ibd", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Breakdown current of diode jnc" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "is_", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Gate junction saturation current" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "kf", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker Noise Coefficient" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "lambda", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation param." );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "lfgam", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "drain feedback parameter" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "lfg1", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "lfg2", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "n", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "gate junction ideality factor" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "p_", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Power law (triode region)" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "vbi", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate junction potential" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "pb", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "1", "n.a." );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "q", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Power Law (Saturated region)" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "rd", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "rs", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "taud", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Thermal relaxation time" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "taug", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain feedback relaxation time" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "vbd", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Breakdown potential of diode jnc" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "ver", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "version number of PS model" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "vst", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Crit Poten subthreshold conductn" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "vt0", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-2", "-2", "Threshold voltage" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "vto", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-2", "-2", "n.a." );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "xc", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "amount of cap. red at pinch-off" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "xi", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "velocity saturation index" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "z", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "rate of velocity saturation" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "hfgam", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "high freq drain feedback parm" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "gd", 301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain conductance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "gs", 302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source conductance" );
        modelInfos[MODEL_TYPE::JFET2].modelParams.emplace_back( "tnom", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "parameter measurement temperature" );
        // Instance parameters
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "off", 5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "ic", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT_VECTOR, AU(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial VDS,VGS vector", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "m", 8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "area", 1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Area factor", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "ic-vds", 2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "ic-vgs", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S volrage", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "temp", 6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "dtemp", 7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "drain-node", 301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "gate-node", 302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "source-node", 303, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "drain-prime-node", 304, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal drain node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "source-prime-node", 305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Internal source node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "vgs", 306, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Voltage G-S", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "vgd", 307, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Voltage G-D", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "ig", 308, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current at gate node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "id", 309, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current at drain node", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "is", 319, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "igd", 310, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Current G-D", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "gm", 311, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "gds", 312, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance D-S", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "ggs", 313, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance G-S", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "ggd", 314, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance G-D", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "qgs", 315, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage G-S junction", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "qgd", 317, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Charge storage G-D junction", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "cqgs", 316, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to charge storage G-S junction", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "cqgd", 318, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to charge storage G-D junction", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "p", 320, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "2", "2", "Power dissipated by the JFET2", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "vtrap", 321, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Quiescent drain feedback potential", true );
        modelInfos[MODEL_TYPE::JFET2].instanceParams.emplace_back( "vpave", 322, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Quiescent power dissipation", true );


        modelInfos[MODEL_TYPE::MES] = { "MES", "NMF", "PMF", { "D", "G", "S" }, "GaAs MESFET model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "type",  305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-693161728", "116101380", "N-type or P-type MESfet model" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "nmf",  113, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MESfet model" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "pmf",  114, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MESfet model" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-2", "-2", "Pinch-off voltage" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-2", "-2", "n.a." );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "alpha",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Saturation voltage parameter" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "beta",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0025", "0.0025", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "lambda",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation parm." );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "b",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Doping tail extending parameter" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "rd",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "gd",  301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain conductance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "rs",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "gs",  302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source conductance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "cgs",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-S junction capacitance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "cgd_",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-D junction capacitance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "pb",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate junction potential" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "is_",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Junction saturation current" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "fc",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias junction fit parm." );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "depl_cap",  303, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Depletion capacitance" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "vcrit",  304, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.730289", "0.730289", "Critical voltage" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "kf",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "NaN", "NaN", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::MES].modelParams.emplace_back( "af",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "NaN", "NaN", "Flicker noise exponent" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "off",  5, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_BOOL, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "m",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, UR(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "area",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Area factor", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "icvds",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "icvgs",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "dnode",  201, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "gnode",  202, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "snode",  203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "dprimenode",  204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "sprimenode",  205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "vgs",  206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "vgd",  207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain voltage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "cg",  208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate capacitance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "cd",  209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain capacitance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "cgd",  210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Gate-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "gm",  211, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "gds",  212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "ggs",  213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source conductance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "ggd",  214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain conductance", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "cqgs",  216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "cqgd",  218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "qgs",  215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "qgd",  217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "is",  6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::MES].instanceParams.emplace_back( "p",  7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipated by the mesfet", true );


        modelInfos[MODEL_TYPE::MESA] = { "MESA", "NMF", "PMF", { "D", "G", "S" }, "GaAs MESFET model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "type", 165, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "nmf", "nmf", "N-type or P-type MESfet model" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vto", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1.26", "-1.26", "Pinch-off voltage" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vt0", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-1.26", "-1.26", "n.a." );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "lambda", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.045", "0.045", "Output conductance parameter" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "lambdahf", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.045", "0.045", "Output conductance parameter at high frequencies" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "beta", 153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V^2", SIM_MODEL::PARAM::CATEGORY::DC, "0.0085", "0.0085", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vs", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "150000", "150000", "Saturation velocity" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rd", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rs", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rg", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "ri", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-source ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rf", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rdi", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic source ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rsi", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "phib", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "8.01088e-20", "8.01088e-20", "Effective Schottky barrier height at room temperature" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "phib1", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tphib", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "astar", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "40000", "40000", "Effective Richardson constant" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "ggr", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "40", "40", "Reverse diode conductance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "del", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.04", "0.04", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "xchi", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.033", "0.033", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tggr", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.033", "0.033", "n.a." );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "n", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emission coefficient" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "eta", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.73", "1.73", "Subthreshold ideality factor" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "m_", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.5", "2.5", "Knee shape parameter" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "mc", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "Knee shape parameter" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "alpha", 149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "sigma0", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.081", "0.081", "Threshold voltage coefficient" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vsigmat", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.01", "1.01", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vsigma", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "mu", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.23", "0.23", "Mobility" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "theta", 148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "mu1", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second moblity parameter" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "mu2", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third moblity parameter" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "d", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2e-07", "1.2e-07", "Depth of device" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "nd", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2e+23", "2e+23", "Doping density" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "du", 154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3.5e-08", "3.5e-08", "Depth of device" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "ndu", 155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+22", "1e+22", "Doping density" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "th", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Thickness of delta doped layer" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "ndelta", 157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "6e+24", "6e+24", "Delta doped layer doping density" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "delta", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tc", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Transconductance compression factor" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tvto", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for vto" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "alphat", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tlambda", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1.79769e+308", "1.79769e+308", "Temperature coefficient for lambda" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "teta0", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1.79769e+308", "1.79769e+308", "First temperature coefficient for eta" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "teta1", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Second temperature coefficient for eta" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tmu", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Temperature coefficient for mobility" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "xtm0", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First exponent for temp dependence of mobility" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "xtm1", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second exponent for temp dependence of mobility" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "xtm2", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third exponent for temp dependence of mobility" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "ks", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sidegating coefficient" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vsg", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sidegating voltage" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "tf", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Characteristic temperature determined by traps" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "flo", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "delfo", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "ag", 147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rtc1", 150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "rtc2", 151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "zeta", 152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "level", 158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "2", "2", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "nmax", 159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2e+16", "2e+16", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "gamma", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "epsi", 161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.08411e-10", "1.08411e-10", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "cas", 163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "cbs", 162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "pmf", 164, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MESfet model" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "nmf", 131, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MESfet model" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "gd", 301, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.79769e+308", "1.79769e+308", "Drain conductance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "gs", 302, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.79769e+308", "1.79769e+308", "Source conductance" );
        modelInfos[MODEL_TYPE::MESA].modelParams.emplace_back( "vcrit", 305, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Critical voltage" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "off", 8, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "m", 12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "2.5", "2.5", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "l", 1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length of device", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "w", 2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width of device", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "icvds", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "icvgs", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "td", 5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance drain temperature", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "ts", 6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance source temperature", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "dtemp", 11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "dnode", 201, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "gnode", 202, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "snode", 203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "dprimenode", 204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "sprimenode", 205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "gprimenode", 206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal gate node", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "vgs", 207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "vgd", 208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain voltage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "cg", 209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate capacitance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "cd", 210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain capacitance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "cgd", 211, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate_Drain capacitance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "gm", 212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "gds", 213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "ggs", 214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source conductance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "ggd", 215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain conductance", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "qgs", 216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "cqgs", 217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "qgd", 218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "cqgd", 219, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "cs", 9, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source current", true );
        modelInfos[MODEL_TYPE::MESA].instanceParams.emplace_back( "p", 10, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipated by the mesfet", true );


        modelInfos[MODEL_TYPE::HFET1] = { "HFET1", "NMF", "PMF", { "D", "G", "S", "B" }, "HFET1 Model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vt0", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "Pinch-off voltage" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vto", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "n.a." );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "lambda", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Output conductance parameter" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rd", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rs", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rg", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Gate ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rdi", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rsi", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rgs", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Gate-source ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rgd", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "Gate-drain ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "ri", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "rf", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "eta", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Subthreshold ideality factor" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "m_", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Knee shape parameter" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "mc", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Knee shape parameter" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "gamma", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Knee shape parameter" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "sigma0", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "Threshold voltage coefficient" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vsigmat", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vsigma", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "mu", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Moblity" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "di", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "Depth of device" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "delta", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vs", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "Saturation velocity" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "nmax", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "deltad", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "Thickness correction" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "js1d", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "js2d", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "js1s", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "js2s", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "m1d", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "m2d", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "m1s", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "m2s", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "epsi", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "p_", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "cm3", 152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "a1", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "a2", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "mv1", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "kappa", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "delf", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "fgds", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "tf", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "cds", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "phib", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "talpha", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "mt1", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "mt2", 147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "ck1", 148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "ck2", 149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "cm1", 150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "cm2", 151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "astar", 153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "eta1", 154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "d1", 155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vt1", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "eta2", 157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "d2", 158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "vt2", 159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "ggr", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "del", 161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "gatemod", 162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "klambda", 163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "kmu", 164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "kvto", 165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "type", 168, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "NHFET or PHFET" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "nhfet", 166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "N HFET device" );
        modelInfos[MODEL_TYPE::HFET1].modelParams.emplace_back( "phfet", 167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "P HFET device" );
        // Instance parameters
    // FIXME: Default values were lost for some reason, filled them with "".
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "off", 7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "m", 11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "l", 1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length of device", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "w", 2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width of device", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "icvds", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "icvgs", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "temp", 5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "dtemp", 10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "dnode", 201, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "gnode", 202, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "snode", 203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "dprimenode", 204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "sprimenode", 205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "vgs", 206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "vgd", 207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain voltage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "cg", 208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate capacitance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "cd", 209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain capacitance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "cgd", 210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate_Drain capacitance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "gm", 211, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "gds", 212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "ggs", 213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source conductance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "ggd", 214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain conductance", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "qgs", 215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "cqgs", 216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "qgd", 217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "cqgd", 218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "cs", 8, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source current", true );
        modelInfos[MODEL_TYPE::HFET1].instanceParams.emplace_back( "p", 9, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipated by the mesfet", true );


        modelInfos[MODEL_TYPE::HFET2] = { "HFET2", "NMF", "PMF", { "D", "G", "S", "B" }, "HFET2 Model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "type", 139, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "664639780", "-1511458520", "NHFET or PHFET" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "nhfet", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type HFET model" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "phfet", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type HFET model" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "cf", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "d1", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "d2", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "del", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "delta", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "deltad", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Thickness correction" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "di", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Depth of device" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "epsi", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "eta", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Subthreshold ideality factor" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "eta1", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "eta2", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "gamma", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Knee shape parameter" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "ggr", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "js", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "klambda", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "kmu", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "knmax", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "kvto", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "lambda", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Output conductance parameter" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "m_", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Knee shape parameter" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "mc", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Knee shape parameter" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "mu", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Moblity" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "n", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "nmax", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "p_", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "rd", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "rdi", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "rs", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "rsi", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "sigma0", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "DIBL parameter" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vs", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "Saturation velocity" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vsigma", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vsigmat", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vt0", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-2", "-2", "Pinch-off voltage" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vto", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-2", "-2", "n.a." );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vt1", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        modelInfos[MODEL_TYPE::HFET2].modelParams.emplace_back( "vt2", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "", "", "" );
        // Instance parameters
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "off", 6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initialli OFF", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "m", 11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "l", 1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length of device", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "w", 2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width of device", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "icvds", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "icvgs", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "temp", 9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "dtemp", 10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "dnode", 201, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "gnode", 202, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "snode", 203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "dprimenode", 204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "sprimenode", 205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "vgs", 206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "vgd", 207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain voltage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "cg", 208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate capacitance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "cd", 209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain capacitance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "cgd", 210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Gate_Drain capacitance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "gm", 211, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "gds", 212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "ggs", 213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source conductance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "ggd", 214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain conductance", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "qgs", 215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "cqgs", 216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "qgd", 217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "cqgd", 218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "cs", 7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source current", true );
        modelInfos[MODEL_TYPE::HFET2].instanceParams.emplace_back( "p", 8, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Power dissipated by the mesfet", true );


        modelInfos[MODEL_TYPE::VDMOS] = { "VDMOS", "NCHAN", "PCHAN", { "D", "G", "S" }, "DMOS model based on Level 1 MOSFET model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "type", 116, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "vdmosn", "vdmosp", "N-channel or P-channel MOS" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vto", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vth0", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "kp", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V^2", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "phi", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Surface potential" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "lambda", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "theta", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vgs dependence on mobility" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rd_", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rs_", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rg", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate ohmic resistance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "tnom", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "deg C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "kf", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "af", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise exponent" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vdmosn", 111, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type DMOSfet model" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vdmosp", 112, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type DMOSfet model" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vdmos", 117, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "DMOS transistor" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rq", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Quasi saturation resistance fitting parameter" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vq", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Quasi saturation voltage fitting parameter" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "mtriode", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Conductance multiplier in triode region" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "tcvth", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "deg C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Linear Vth0 temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vtotc", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "mu", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Exponent of gain temperature dependency" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "bex", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-1.5", "-1.5", "n.a." );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "texp0", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1.5", "1.5", "Drain resistance rd0 temperature exponent" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "texp1", 147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.3", "0.3", "Drain resistance rd1 temperature exponent" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trd1", 148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Drain resistance linear temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trd2", 149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Drain resistance quadratic temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trg1", 150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Gate resistance linear temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trg2", 151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Gate resistance quadratic temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trs1", 152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Source resistance linear temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trs2", 153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Source resistance quadratic temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trb1", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Body resistance linear temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "trb2", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Body resistance quadratic temperature coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "subshift", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Shift of weak inversion plot on the vgs axis" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "ksubthres", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Slope of weak inversion log current versus vgs" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "tksubthres1", 154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "deg C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Linear temperature coefficient of ksubthres" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "tksubthres2", 155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "deg C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Quadratic temperature coefficient of ksubthres" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "bv", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1e+99", "1e+99", "Vds breakdown voltage" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "ibv", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-10", "1e-10", "Current at Vds=bv" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "nbv", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Vds breakdown emission coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rds", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "Drain-source shunt resistance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rb", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body diode ohmic resistance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "n", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Body diode emission coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "tt", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body diode transit time" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "eg", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "deg C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1.11", "1.11", "Body diode activation energy for temperature effect on Is" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "xti", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Body diode saturation current temperature exponent" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "is_", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Body diode saturation current" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vj", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Body diode junction potential" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "cjo", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Zero-bias body diode junction capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "m_", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Body diode grading coefficient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "fc", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Body diode coefficient for forward-bias depletion capacitance formula" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "cgdmin", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum non-linear G-D capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "cgdmax", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Maximum non-linear G-D capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "a", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-linear Cgd capacitance parameter" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "cgs_", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-source capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rthjc", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Self-heating thermal resistance, junction-to-case" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rthca", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1000", "1000", "Self-heating thermal resistance, case-to-ambient" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "cthj", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Self-heating thermal capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vgs_max", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vgd_max", 157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vds_max", 158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vgsr_max", 159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "vgdr_max", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "pd_max", 161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum device power dissipation" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "id_max", 162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "0", "0", "maximum drain/source current" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "idr_max", 163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum drain/source reverse current" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "te_max", 164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "deg C", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum temperature" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "rth_ext", 165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1000", "1000", "thermal resistance case to ambient, incl. heat sink" );
        modelInfos[MODEL_TYPE::VDMOS].modelParams.emplace_back( "derating", 166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "thermal derating for power" );
        // Instance parameters
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "m", 9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0.5", "0.5", "Multiplier" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "off", 1, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::FLAGS, "", "", "Device initially off" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "icvds", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "icvgs", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "temp", 8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "deg C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "dtemp", 10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "deg C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "ic", 2, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of D-S, G-S voltages" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "thermal", 11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::FLAGS, "", "", "Thermal model switch on/off" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "id", 214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "is", 6, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "ig", 5, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate current" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "vgs", 217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "vds", 218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source voltage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "cgs", 201, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Gate-Source capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "cgd", 202, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "cds", 203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source capacitance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "idio", 223, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Body diode current" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "dnode", 204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the drain node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "gnode", 205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the gate node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "snode", 206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the source node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "tempnode", 207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of temperature node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "tcasenode", 208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of 2nd temperature node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "dnodeprime", 209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of int. drain node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "snodeprime", 210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of int. source node" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "von", 213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device on state voltage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "rs", 224, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "ohm", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Source resistance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "sourceconductance", 211, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance of source" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "rd", 225, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Drain conductance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "drainconductance", 212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance of drain" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "gm", 215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "gds", 216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "cqgs", 220, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "cqgd", 222, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "qgs", 219, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "qgd", 221, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage" );
        modelInfos[MODEL_TYPE::VDMOS].instanceParams.emplace_back( "p", 7, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instantaneous power" );


        modelInfos[MODEL_TYPE::MOS1] = { "Mos1", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Level 1 MOSfet model with Meyer capacitance model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "type",  133, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "nmos", "pmos", "N-channel or P-channel MOS" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "kp",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V²", SIM_MODEL::PARAM::CATEGORY::DC, "2e-05", "2e-05", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "gamma",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk threshold parameter" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "phi",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Surface potential" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "lambda",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "rd_",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "rs_",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cbd_",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-D junction capacitance" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cbs_",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-S junction capacitance" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "is_",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Bulk junction sat. current" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "pb",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Bulk junction potential" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cgso",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-source overlap cap." );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cgdo",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-drain overlap cap." );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cgbo",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bulk overlap cap." );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "rsh",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sheet resistance" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cj",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bottom junction cap per area" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "mj",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom grading coefficient" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "cjsw",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side junction cap per area" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "mjsw",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Side grading coefficient" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "js",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk jct. sat. current density" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "tox",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Oxide thickness" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "ld",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "u0",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "cm²/V s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface mobility" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "uo",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "fc",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias jct. fit parm." );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "nmos",  128, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "pmos",  129, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "nsub",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate doping" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "tpg",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate type" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "nss",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface state density" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "tnom",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "kf",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "NaN", "NaN", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::MOS1].modelParams.emplace_back( "af",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "NaN", "NaN", "Flicker noise exponent" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "m",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain squares", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source squares", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "icvds",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "icvgs",  13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "icvbs",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "temp",  20, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "dtemp",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ic",  10, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of D-S, G-S, B-S voltages", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l",  15, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT length", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w",  14, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT width", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "id",  215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "is",  18, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ig",  17, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate current", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ib",  16, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk current", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ibd",  217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-D junction current", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "ibs",  216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-S junction current", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "vgs",  231, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "vds",  232, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "vbs",  230, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "vbd",  229, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "dnode",  203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the drain node", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "gnode",  204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the gate node", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "snode",  205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the source node", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "bnode",  206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the node", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "dnodeprime",  207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of int. drain node", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "snodeprime",  208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of int. source node", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "vdsat",  212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Saturation drain voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sourcevcrit",  213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical source voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "drainvcrit",  214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical drain voltage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "rs",  258, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Source resistance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sourceconductance",  209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance of source", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "rd",  259, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "drainconductance",  210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Conductance of drain", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "gm",  219, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "gds",  220, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "gmb",  218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "gbd",  221, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "gbs",  222, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cbd",  223, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cbs",  224, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cgs",  233, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cgd",  236, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cgb",  239, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cqgs",  235, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cqgd",  238, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cqgb",  241, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cqbd",  243, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cqbs",  245, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cbd0",  225, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "cbs0",  227, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "qgs",  234, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "qgd",  237, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "qgb",  240, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "qbd",  242, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "qbs",  244, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "p",  19, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instaneous power", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l_dc",  256, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l_real",  246, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l_imag",  247, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l_mag",  248, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l_ph",  249, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac phase", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_l_cplx",  250, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w_dc",  257, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w_real",  251, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w_imag",  252, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w_mag",  253, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w_ph",  254, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac phase", true );
        modelInfos[MODEL_TYPE::MOS1].instanceParams.emplace_back( "sens_w_cplx",  255, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt width", true );


        modelInfos[MODEL_TYPE::MOS2] = { "Mos2", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Level 2 MOSfet model with Meyer capacitance model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "type",  141, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "nmos", "pmos", "N-channel or P-channel MOS" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "kp",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V²", SIM_MODEL::PARAM::CATEGORY::DC, "2.07189e-05", "2.07189e-05", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "gamma",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk threshold parameter" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "phi",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Surface potential" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "lambda",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "rd_",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "rs_",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cbd_",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-D junction capacitance" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cbs_",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-S junction capacitance" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "is_",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Bulk junction sat. current" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "pb",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Bulk junction potential" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cgso",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-source overlap cap." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cgdo",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-drain overlap cap." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cgbo",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-bulk overlap cap." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "rsh",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sheet resistance" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cj",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bottom junction cap per area" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "mj",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom grading coefficient" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "cjsw",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side junction cap per area" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "mjsw",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Side grading coefficient" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "js",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk jct. sat. current density" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "tox",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Oxide thickness" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "ld",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "u0",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "cm²/V s", SIM_MODEL::PARAM::CATEGORY::DC, "600", "600", "Surface mobility" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "uo",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "600", "600", "n.a." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "fc",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias jct. fit parm." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "nmos",  135, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "pmos",  136, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "nsub",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate doping" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "tpg",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate type" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "nss",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface state density" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "delta",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width effect on threshold" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "uexp",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Crit. field exp for mob. deg." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "ucrit",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V/cm", SIM_MODEL::PARAM::CATEGORY::DC, "10000", "10000", "Crit. field for mob. degradation" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "vmax",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Maximum carrier drift velocity" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "xj",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Junction depth" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "neff",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Total channel charge coeff." );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "nfs",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fast surface state density" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "tnom",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "kf",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::MOS2].modelParams.emplace_back( "af",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "m",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "id",  34, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ibd",  36, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-D junction current", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ibs",  35, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-S junction current", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "is",  18, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ig",  17, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate current", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ib",  16, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk current", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "vgs",  50, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "vds",  51, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "vbs",  49, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "vbd",  48, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain squares", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source squares", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "icvds",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "icvgs",  13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "icvbs",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "temp",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance operating temperature", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "dtemp",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "ic",  10, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of D-S, G-S, B-S voltages", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l",  15, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT length", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w",  14, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT width", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "dnode",  22, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "gnode",  23, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "snode",  24, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "bnode",  25, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of bulk node", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "dnodeprime",  26, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "snodeprime",  27, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "vdsat",  31, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Saturation drain voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sourcevcrit",  32, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical source voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "drainvcrit",  33, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical drain voltage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "rs",  78, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Source resistance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sourceconductance",  28, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source conductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "rd",  79, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Drain resistance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "drainconductance",  29, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "gm",  38, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "gds",  39, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "gmb",  37, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "gbd",  40, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "gbs",  41, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cbd",  42, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cbs",  43, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cgs",  52, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cgd",  55, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cgb",  58, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cbd0",  44, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cbs0",  46, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cqgs",  54, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cqgd",  57, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cqgb",  60, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cqbd",  62, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "cqbs",  64, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "qgs",  53, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "qgd",  56, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "qgb",  59, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "qbd",  61, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "qbs",  63, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "p",  19, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instantaneous power", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l_dc",  75, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l_real",  70, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l_imag",  71, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l_cplx",  74, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l_mag",  72, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_l_ph",  73, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac phase", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w_dc",  76, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w_real",  65, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity and real part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w_imag",  66, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w_mag",  67, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w_ph",  68, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac phase", true );
        modelInfos[MODEL_TYPE::MOS2].instanceParams.emplace_back( "sens_w_cplx",  69, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt width", true );


        modelInfos[MODEL_TYPE::MOS3] = { "Mos3", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Level 3 MOSfet model with Meyer capacitance model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "type",  144, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "nmos", "pmos", "N-channel or P-channel MOS" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "nmos",  133, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "pmos",  134, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "kp",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V²", SIM_MODEL::PARAM::CATEGORY::DC, "2.07189e-05", "2.07189e-05", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "gamma",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk threshold parameter" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "phi",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Surface potential" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "rd_",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "rs_",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cbd_",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-D junction capacitance" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cbs_",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-S junction capacitance" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "is_",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Bulk junction sat. current" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "pb",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Bulk junction potential" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cgso",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-source overlap cap." );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cgdo",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-drain overlap cap." );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cgbo",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bulk overlap cap." );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "rsh",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sheet resistance" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cj",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bottom junction cap per area" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "mj",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom grading coefficient" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "cjsw",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side junction cap per area" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "mjsw",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Side grading coefficient" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "js",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk jct. sat. current density" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "tox",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Oxide thickness" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "ld",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "xl",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length mask adjustment" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "wd",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width Narrowing (Diffusion)" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "xw",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width mask adjustment" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "delvto",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage Adjust" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "delvt0",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, UR(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Threshold voltage Adjust" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "u0",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "cm²/V s", SIM_MODEL::PARAM::CATEGORY::DC, "600", "600", "Surface mobility" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "uo",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "600", "600", "n.a." );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "fc",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias jct. fit parm." );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "nsub",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate doping" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "tpg",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate type" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "nss",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface state density" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "vmax",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Maximum carrier drift velocity" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "xj",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Junction depth" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "nfs",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fast surface state density" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "xd",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Depletion layer width" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "alpha",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Alpha" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "eta",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of threshold voltage" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "delta",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width effect on threshold" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "theta",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vgs dependence on mobility" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "kappa",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Kappa" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "tnom",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "kf",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::MOS3].modelParams.emplace_back( "af",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "m",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "id",  34, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cd",  34, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, R(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ibd",  36, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-D junction current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ibs",  35, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-S junction current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "is",  18, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ig",  17, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ib",  16, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk current", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "vgs",  50, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "vds",  51, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "vbs",  49, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "vbd",  48, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain squares", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source squares", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "icvds",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "icvgs",  13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "icvbs",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "ic",  10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT_VECTOR, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of D-S, G-S, B-S voltages", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "temp",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance operating temperature", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "dtemp",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l",  15, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT length", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w",  14, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT width", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "dnode",  22, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gnode",  23, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "snode",  24, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "bnode",  25, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of bulk node", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "dnodeprime",  26, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "snodeprime",  27, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "von",  30, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Turn-on voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "vdsat",  31, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Saturation drain voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sourcevcrit",  32, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical source voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "drainvcrit",  33, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical drain voltage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "rs",  78, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Source resistance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sourceconductance",  28, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source conductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "rd",  79, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Drain resistance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "drainconductance",  29, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gm",  38, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gds",  39, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gmb",  37, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gmbs",  37, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gbd",  40, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "gbs",  41, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cbd",  42, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cbs",  43, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cgs",  52, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cgd",  55, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cgb",  58, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cqgs",  54, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cqgd",  57, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cqgb",  60, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cqbd",  62, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cqbs",  64, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cbd0",  44, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cbdsw0",  45, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D sidewall capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cbs0",  46, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "cbssw0",  47, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S sidewall capacitance", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "qbs",  63, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "qgs",  53, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "qgd",  56, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "qgb",  59, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "qbd",  61, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "p",  19, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instantaneous power", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l_dc",  76, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l_real",  70, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l_imag",  71, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l_cplx",  74, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l_mag",  72, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_l_ph",  73, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac phase", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w_dc",  75, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w_real",  65, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w_imag",  66, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w_mag",  67, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w_ph",  68, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac phase", true );
        modelInfos[MODEL_TYPE::MOS3].instanceParams.emplace_back( "sens_w_cplx",  69, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt width", true );


        modelInfos[MODEL_TYPE::BSIM1] = { "BSIM1", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley Short Channel IGFET Model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "vfb",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flat band voltage" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lvfb",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wvfb",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "phi",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Strong inversion surface potential" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lphi",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of phi" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wphi",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of phi" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "k1",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lk1",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wk1",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "k2",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lk2",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wk2",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "eta",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of threshold voltage" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "leta",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "weta",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x2e",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of eta" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx2e",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x2e" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx2e",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of x2e" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x3e",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of eta" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx3e",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x3e" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx3e",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of x3e" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "dl",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length reduction in um" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "dw",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel width reduction in um" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "muz",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "cm²/V s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Zero field mobility at VDS=0 VGS=VTH" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x2mz",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of muz" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx2mz",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x2mz" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx2mz",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of x2mz" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "mus",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility at VDS=VDD VGS=VTH, channel length modulation" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lmus",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mus" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wmus",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mus" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x2ms",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of mus" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx2ms",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x2ms" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx2ms",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of x2ms" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x3ms",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of mus" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx3ms",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x3ms" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx3ms",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of x3ms" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "u0",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VGS dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lu0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wu0",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x2u0",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx2u0",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x2u0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx2u0",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of x2u0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "u1",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS depence of mobility, velocity saturation" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lu1",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wu1",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x2u1",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS depence of u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx2u1",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length depence of x2u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx2u1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width depence of x2u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "x3u1",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um/V²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS depence of u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lx3u1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of x3u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wx3u1",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width depence of x3u1" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "n0",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Subthreshold slope" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "ln0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of n0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wn0",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of n0" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "nb",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of subthreshold slope" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lnb",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nb" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wnb",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nb" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "nd",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of subthreshold slope" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "lnd",  159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nd" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wnd",  160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nd" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "tox",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate oxide thickness in um" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "temp",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "0", "0", "Temperature in degree Celcius" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "vdd",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Supply voltage to specify mus" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "cgso",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate source overlap capacitance per unit channel width(m)" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "cgdo",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate drain overlap capacitance per unit channel width(m)" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "cgbo",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate bulk overlap capacitance per unit channel length(m)" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "xpart",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::FLAGS, "0", "0", "Flag for channel charge partitioning" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "rsh",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source drain diffusion sheet resistance in ohm per square" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "js",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source drain junction saturation current per unit area" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "pb",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Source drain junction built in potential" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "mj",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain bottom junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "pbsw",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.1", "0.1", "Source drain side junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "mjsw",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain side junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "cj",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain bottom junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "cjsw",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain side junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "wdf",  176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Default width of source drain diffusion in um" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "dell",  177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction of source drain diffusion" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "kf",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "af",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "nmos",  178, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
        modelInfos[MODEL_TYPE::BSIM1].modelParams.emplace_back( "pmos",  179, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
        // Instance parameters
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "m",  14, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "vds",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "vgs",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "vbs",  10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::BSIM1].instanceParams.emplace_back( "ic",  13, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR /*SIM_VALUE::TYPE::VECTOR*/, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );


        modelInfos[MODEL_TYPE::BSIM2] = { "BSIM2", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley Short Channel IGFET Model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vfb",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat band voltage" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lvfb",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wvfb",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "phi",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.75", "0.75", "Strong inversion surface potential" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lphi",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of phi" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wphi",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of phi" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "k1",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Bulk effect coefficient 1" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lk1",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wk1",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "k2",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lk2",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wk2",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "eta0",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of threshold voltage at VDD=0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "leta0",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "weta0",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "etab",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of eta" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "letab",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of etab" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wetab",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "dl",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "1.23516e-322", "1.23516e-322", "Channel length reduction in um" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "dw",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "1.23516e-322", "1.23516e-322", "Channel width reduction in um" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu0",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "400", "400", "Low-field mobility, at VDS=0 VGS=VTH" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu0b",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of low-field mobility" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu0b",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu0b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu0b",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu0b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mus0",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "500", "500", "Mobility at VDS=VDD VGS=VTH" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmus0",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mus0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmus0",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mus" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "musb",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of mus" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmusb",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of musb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmusb",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of musb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu20",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "1.5", "VDS dependence of mu in tanh term" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu20",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu20" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu20",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu20" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu2b",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of mu2" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu2b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu2b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu2b",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu2b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu2g",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VGS dependence of mu2" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu2g",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu2g" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu2g",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu2g" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu30",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "VDS dependence of mu in linear term" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu30",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu30" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu30",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu30" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu3b",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of mu3" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu3b",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu3b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu3b",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu3b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu3g",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VGS dependence of mu3" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu3g",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu3g" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu3g",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu3g" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu40",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of mu in linear term" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu40",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu40" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu40",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu40" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu4b",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of mu4" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu4b",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu4b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu4b",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu4b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mu4g",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VGS dependence of mu4" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lmu4g",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mu4g" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wmu4g",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mu4g" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "ua0",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Linear VGS dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lua0",  159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wua0",  160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "uab",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of ua" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "luab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uab" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wuab",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uab" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "ub0",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Quadratic VGS dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lub0",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wub0",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "ubb",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of ub" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lubb",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ubb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wubb",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ubb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "u10",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "VDS depence of mobility" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lu10",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u10" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wu10",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u10" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "u1b",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS depence of u1" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lu1b",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length depence of u1b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wu1b",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width depence of u1b" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "u1d",  176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um/V²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS depence of u1" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lu1d",  177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length depence of u1d" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wu1d",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width depence of u1d" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "n0",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.4", "1.4", "Subthreshold slope at VDS=0 VBS=0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "ln0",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of n0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wn0",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of n0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "nb",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "VBS dependence of n" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lnb",  183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wnb",  184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "nd",  185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of n" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lnd",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nd" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wnd",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nd" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vof0",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.8", "1.8", "Threshold voltage offset AT VDS=0 VBS=0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lvof0",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vof0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wvof0",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vof0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vofb",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of vof" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lvofb",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vofb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wvofb",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vofb" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vofd",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VDS dependence of vof" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lvofd",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vofd" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wvofd",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vofd" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "ai0",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pre-factor of hot-electron effect." );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lai0",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ai0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wai0",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ai0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "aib",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of ai" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "laib",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aib" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "waib",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aib" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "bi0",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Exponential factor of hot-electron effect." );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lbi0",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bi0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wbi0",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bi0" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "bib",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "VBS dependence of bi" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lbib",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bib" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wbib",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bib" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vghigh",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Upper bound of the cubic spline function." );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lvghigh",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vghigh" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wvghigh",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vghigh" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vglow",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.15", "-0.15", "Lower bound of the cubic spline function." );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "lvglow",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vglow" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wvglow",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vglow" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "tox",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "0.03", "0.03", "Gate oxide thickness in um" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "temp",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "27", "27", "Temperature in degree Celcius" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vdd",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "Maximum Vds" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vgg",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "Maximum Vgs" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "vbb",  219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "Maximum Vbs" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "cgso",  220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate source overlap capacitance per unit channel width(m)" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "cgdo",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate drain overlap capacitance per unit channel width(m)" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "cgbo",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate bulk overlap capacitance per unit channel length(m)" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "xpart",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flag for channel charge partitioning" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "rsh",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source drain diffusion sheet resistance in ohm per square" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "js",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source drain junction saturation current per unit area" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "pb",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Source drain junction built in potential" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mj",  227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain bottom junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "pbsw",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.1", "0.1", "Source drain side junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "mjsw",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain side junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "cj",  230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain bottom junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "cjsw",  231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source drain side junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "wdf",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "um", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Default width of source drain diffusion in um" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "dell",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction of source drain diffusion" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "kf",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "af",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise exponent" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "nmos",  234, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
        modelInfos[MODEL_TYPE::BSIM2].modelParams.emplace_back( "pmos",  235, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
        // Instance parameters
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "m",  14, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "vds",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "vgs",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "vbs",  10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::BSIM2].instanceParams.emplace_back( "ic",  13, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR /*SIM_VALUE::TYPE::VECTOR*/, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );


        modelInfos[MODEL_TYPE::MOS6] = { "Mos6", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Level 6 MOSfet model with Meyer capacitance model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "type",  140, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "nmos", "pmos", "N-channel or P-channel MOS" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "kv",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Saturation voltage factor" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "nv",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Saturation voltage coeff." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "kc",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "5e-05", "5e-05", "Saturation current factor" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "nc",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Saturation current coeff." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "nvth",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Threshold voltage coeff." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "ps_",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sat. current modification  par." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "gamma",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk threshold parameter" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "gamma1",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk threshold parameter 1" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "sigma",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "static const feedback effect par." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "phi",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Surface potential" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "lambda",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation param." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "lambda0",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation param. 0" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "lambda1",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length modulation param. 1" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "rd_",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "rs_",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cbd_",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-D junction capacitance" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cbs_",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-S junction capacitance" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "is_",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Bulk junction sat. current" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "pb",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Bulk junction potential" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cgso",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-source overlap cap." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cgdo",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-drain overlap cap." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cgbo",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bulk overlap cap." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "rsh",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sheet resistance" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cj",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bottom junction cap per area" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "mj",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom grading coefficient" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "cjsw",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side junction cap per area" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "mjsw",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Side grading coefficient" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "js",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk jct. sat. current density" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "ld",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "tox",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Oxide thickness" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "u0",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "cm²/V s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface mobility" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "uo",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "fc",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias jct. fit parm." );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "nmos",  137, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "pmos",  138, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "tpg",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate type" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "nsub",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate doping" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "nss",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface state density" );
        modelInfos[MODEL_TYPE::MOS6].modelParams.emplace_back( "tnom",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "m",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "0", "0", "Source perimeter", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "id",  215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cd",  215, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, R(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "is",  18, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ig",  17, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate current", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ib",  16, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk current", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ibs",  216, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-S junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ibd",  217, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-D junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "vgs",  231, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "vds",  232, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "vbs",  230, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "vbd",  229, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain squares", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source squares", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "icvds",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "icvgs",  13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "icvbs",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "temp",  20, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance temperature", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "dtemp",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance temperature difference", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "ic",  10, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of D-S, G-S, B-S voltages", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l",  15, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT length", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w",  14, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT width", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "dnode",  203, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the drain node", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "gnode",  204, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the gate node", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "snode",  205, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the source node", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "bnode",  206, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of the node", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "dnodeprime",  207, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of int. drain node", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "snodeprime",  208, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of int. source node", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "rs",  258, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Source resistance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sourceconductance",  209, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source conductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "rd",  259, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Drain resistance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "drainconductance",  210, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "von",  211, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Turn-on voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "vdsat",  212, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Saturation drain voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sourcevcrit",  213, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical source voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "drainvcrit",  214, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical drain voltage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "gmbs",  218, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "gm",  219, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "gds",  220, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "gbd",  221, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "gbs",  222, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cgs",  233, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cgd",  236, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cgb",  239, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cbd",  223, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cbs",  224, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cbd0",  225, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cbs0",  227, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cqgs",  235, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cqgd",  238, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cqgb",  241, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cqbd",  243, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "cqbs",  245, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "qgs",  234, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "qgd",  237, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "qgb",  240, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "qbd",  242, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "qbs",  244, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "p",  19, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instaneous power", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l_dc",  256, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l_real",  246, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l_imag",  247, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l_mag",  248, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l_ph",  249, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac phase", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_l_cplx",  250, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w_dc",  257, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w_real",  251, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w_imag",  252, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w_mag",  253, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w_ph",  254, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac phase", true );
        modelInfos[MODEL_TYPE::MOS6].instanceParams.emplace_back( "sens_w_cplx",  255, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt width", true );


        modelInfos[MODEL_TYPE::BSIM3] = { "BSIM3", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley Short Channel IGFET Model Version-3", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "capmod",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "3", "3", "Capacitance model selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noimod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nqsmod_",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-quasi-static const model selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "acnqsmod_",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "AC NQS model selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "acm",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Area calculation method selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "calcacm",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Area calculation method ACM=12" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "binunit",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3.3.0", "3.3.0", "parameter for model version" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tox",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-08", "1.5e-08", "Gate oxide thickness in meters" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "toxm",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-08", "1.5e-08", "Gate oxide thickness used in extraction" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cdsc",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cdscb",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cit",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nfactor",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xj",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-07", "1.5e-07", "Junction depth in meters" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vsat",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "at",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "a0",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "a1",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "a2",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "keta",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.047", "-0.047", "Body-bias coefficient of non-uniform depletion width effect." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nsub",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nch",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ngate",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "gamma1",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "gamma2",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbx",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbm",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xt",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "80", "80", "Narrow width effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nlx",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tnom",  651, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgso",  652, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgdo",  653, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgbo",  654, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-bulk overlap capacitance per length" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xpart",  655, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "elm",  185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "Non-quasi-static const Elmore Constant Parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rsh",  656, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain resistance per width" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pscbe1",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "4.24e+08", "4.24e+08", "Substrate current body-effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pscbe2",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Substrate current body-effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "js",  657, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Source/drain junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "jsw",  696, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sidewall junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pb",  658, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain junction built-in potential" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nj",  691, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain junction emission coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xti",  692, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Junction current temperature exponent" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mj",  659, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source/drain bottom junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pbsw",  660, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source/drain sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mjsw",  661, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source/drain sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pbswg",  693, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source/drain (gate side) sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mjswg",  694, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source/drain (gate side) sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cj",  662, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Source/drain bottom junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vfbcv",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage parameter for capmod=0 only" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vfb",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flat Band Voltage" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cjsw",  663, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source/drain sidewall junction capacitance per unit periphery" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cjswg",  695, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source/drain (gate side) sidewall junction capacitance per unit width" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tpb",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tcj",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cj" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tpbsw",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbsw" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tcjsw",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjsw" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tpbswg",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbswg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tcjswg",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjswg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "acde",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for finite charge thickness" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "moin",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for gate-bias dependent surface potential" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noff",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "C-V turn-on/off parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "voffcv",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "C-V lateral-shift parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lintnoi",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "lint offset for noise calculation" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lint",  669, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ll",  670, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "llc",  697, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lln",  671, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lw",  672, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwc",  698, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwn",  673, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwl",  674, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwlc",  699, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lmin",  675, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lmax",  676, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xl",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length correction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xw",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width correction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wint",  677, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wl",  678, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wlc",  700, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wln",  679, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ww",  680, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwc",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwn",  681, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwl",  682, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwlc",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmin",  683, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmax",  684, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "7.29897e-11", "7.29897e-11", "Fringe capacitance parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Vdsat parameter for C-V model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Vdsat parameter for C-V model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dwc",  685, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dlc",  686, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "hdif",  711, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Distance Gate - contact" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldif",  712, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Length of LDD Gate-Source/Drain" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ld",  713, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Length of LDD under Gate" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rd",  714, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance of LDD drain side" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rs",  715, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance of LDD source side" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rdc",  716, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance contact drain side" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rsc",  717, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance contact source side" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmlt",  718, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "ACM Parameter: Width shrink factor" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "alpha1",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "beta0",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "30", "30", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ijth",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Diode limiting current" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcdsc",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcdscb",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcdscd",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcit",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnfactor",  254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lxj",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xj" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvsat",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lat",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of at" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "la0",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lags",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "la1",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "la2",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lketa",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnsub",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnch",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lngate",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lgamma1",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lgamma2",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvbx",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbx" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvbm",  270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lxt",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xt" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk1",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lkt1",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lkt1l",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1l" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lkt2",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk2",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk3",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk3b",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lw0",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnlx",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nlx" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt0",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt1",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt2",  286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt0w",  287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt1w",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt2w",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldrout",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldsub",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvth0",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvtho",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lua",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lua1",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lub",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lub1",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "luc",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "luc1",  298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lu0",  299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lute",  300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ute" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvoff",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lelm",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of elm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldelta",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lrdsw",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lprwg",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lprwb",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lprt",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prt" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "leta0",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "letab",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0", "-0", "Length dependence of etab" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpclm",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpdiblc1",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpdiblc2",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpdiblcb",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpscbe1",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpscbe2",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpvag",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwr",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldwg",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldwb",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lb0",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lb1",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcgsl",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgsl" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcgdl",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdl" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lckappa",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappa" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcf",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cf" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lclc",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcle",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cle" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lalpha0",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lalpha1",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lbeta0",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvfbcv",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbcv" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvfb",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lacde",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lmoin",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of moin" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnoff",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of noff" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvoffcv",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voffcv" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcdsc",  381, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcdscb",  382, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcdscd",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcit",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnfactor",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wxj",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xj" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvsat",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wat",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of at" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wa0",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wags",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wa1",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wa2",  390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wketa",  391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnsub",  392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnch",  393, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wngate",  395, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wgamma1",  396, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wgamma2",  397, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvbx",  398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbx" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvbm",  400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wxt",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xt" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wkt1",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wkt1l",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1l" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wkt2",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk2",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk3",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk3b",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ww0",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnlx",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nlx" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt0",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt1",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt2",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt0w",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt1w",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt2w",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdrout",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdsub",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvth0",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvtho",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wua",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wua1",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wub",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wub1",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wuc",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wuc1",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wu0",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wute",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ute" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvoff",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "welm",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of elm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdelta",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wrdsw",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wprwg",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wprwb",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wprt",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prt" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "weta0",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wetab",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpclm",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpdiblc1",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpdiblc2",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpdiblcb",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpscbe1",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pscbe1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpscbe2",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pscbe2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpvag",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwr",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdwg",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdwb",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wb0",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wb1",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcgsl",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgsl" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcgdl",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdl" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wckappa",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ckappa" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcf",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cf" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wclc",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcle",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cle" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "walpha0",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "walpha1",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wbeta0",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvfbcv",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbcv" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvfb",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wacde",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of acde" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmoin",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of moin" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnoff",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of noff" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvoffcv",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voffcv" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcdsc",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcdscb",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcdscd",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcit",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnfactor",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pxj",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xj" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvsat",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pat",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of at" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pa0",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pags",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pa1",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pa2",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pketa",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnsub",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnch",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pngate",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pgamma1",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gamma1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pgamma2",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gamma2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvbx",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbx" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvbm",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pxt",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xt" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk1",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pkt1",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pkt1l",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1l" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pkt2",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk2",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk3",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk3b",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pw0",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnlx",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nlx" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt0",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt1",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt2",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt0w",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt1w",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt2w",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdrout",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdsub",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvth0",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvtho",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pua",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pua1",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pub",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pub1",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "puc",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "puc1",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pu0",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pute",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ute" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvoff",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pelm",  592, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of elm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdelta",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prdsw",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pprwg",  585, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pprwb",  586, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pprt",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prt" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "peta0",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "petab",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppclm",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppdiblc1",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppdiblc2",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppdiblcb",  584, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppscbe1",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pscbe1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppscbe2",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pscbe2" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppvag",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pwr",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdwg",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdwb",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pb0",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pb1",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcgsl",  593, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgsl" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcgdl",  594, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdl" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pckappa",  595, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ckappa" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcf",  596, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cf" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pclc",  597, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clc" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcle",  598, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cle" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "palpha0",  580, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "palpha1",  604, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha1" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pbeta0",  581, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvfbcv",  599, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbcv" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvfb",  605, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pacde",  600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of acde" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pmoin",  601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of moin" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnoff",  602, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of noff" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvoffcv",  606, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voffcv" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noia",  666, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e+20", "9.9e+18", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noib",  667, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "50000", "2400", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noic",  668, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "-1.4e-12", "1.4e-12", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "em",  687, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ef",  688, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "af",  689, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kf",  690, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgs_max",  801, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgd_max",  802, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgb_max",  803, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vds_max",  804, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbs_max",  805, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbd_max",  806, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgsr_max",  807, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgdr_max",  808, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgbr_max",  809, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbsr_max",  810, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbdr_max",  811, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nmos",  664, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
        modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pmos",  665, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
        // Instance parameters
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "m",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel multiplier", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "nqsmod",  14, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Non-quasi-static const model selector", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "acnqsmod",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "AC NQS model selector", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "geo",  19, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ACM model drain/source connection", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "delvto",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero bias threshold voltage variation", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "mulu0",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Low field mobility multiplier", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ic",  13, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gmbs",  766, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gm",  764, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gds",  765, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vdsat",  787, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vth",  786, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "id",  761, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vbs",  758, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vgs",  759, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vds",  760, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ibd",  763, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ibs",  762, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gbd",  767, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "gbd", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gbs",  768, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "gbs", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "qb",  769, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qbulk", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cqb",  770, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CQbulk", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "qg",  771, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qgate", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cqg",  772, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CQgate", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "qd",  773, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qdrain", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cqd",  774, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CQdrain", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cgg",  775, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cggb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cgd",  776, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgdb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cgs",  777, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgsb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cdg",  783, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdgb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cdd",  784, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cddb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cds",  785, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdsb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cbg",  778, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbgb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cbd",  792, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbdb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cbs",  793, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbsb", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "capbd",  779, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
        modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "capbs",  781, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );


        modelInfos[MODEL_TYPE::MOS9] = { "Mos9", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Modified Level 3 MOSfet model", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "type",  144, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "nmos", "pmos", "N-channel or P-channel MOS" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "nmos",  133, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "N type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "pmos",  134, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "P type MOSfet model" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "vto",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "vt0",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "kp",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/V²", SIM_MODEL::PARAM::CATEGORY::DC, "2.07189e-05", "2.07189e-05", "Transconductance parameter" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "gamma",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk threshold parameter" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "phi",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Surface potential" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "rd_",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "rs_",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source ohmic resistance" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cbd_",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-D junction capacitance" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cbs_",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "B-S junction capacitance" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "is_",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-14", "1e-14", "Bulk junction sat. current" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "pb",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Bulk junction potential" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cgso",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-source overlap cap." );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cgdo",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-drain overlap cap." );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cgbo",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bulk overlap cap." );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "rsh",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sheet resistance" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cj",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bottom junction cap per area" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "mj",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom grading coefficient" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "cjsw",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, A(), "F/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side junction cap per area" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "mjsw",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Side grading coefficient" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "js",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk jct. sat. current density" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "tox",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Oxide thickness" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "ld",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "xl",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length mask adjustment" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "wd",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width Narrowing (Diffusion)" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "xw",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width mask adjustment" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "delvto",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage Adjust" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "delvt0",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, UR(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Threshold voltage Adjust" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "u0",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "cm²/V s", SIM_MODEL::PARAM::CATEGORY::DC, "600", "600", "Surface mobility" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "uo",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "600", "600", "n.a." );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "fc",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Forward bias jct. fit parm." );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "nsub",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Substrate doping" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "tpg",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate type" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "nss",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface state density" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "vmax",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Maximum carrier drift velocity" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "xj",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Junction depth" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "nfs",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fast surface state density" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "xd",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Depletion layer width" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "alpha",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Alpha" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "eta",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of threshold voltage" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "delta",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width effect on threshold" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "theta",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vgs dependence on mobility" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "kappa",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Kappa" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "tnom",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "kf",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::MOS9].modelParams.emplace_back( "af",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
        // Instance parameters
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "m",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplier", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m²", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "id",  34, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cd",  34, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, R(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ibd",  36, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-D junction current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ibs",  35, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "B-S junction current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "is",  18, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-14", "1e-14", "Source current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ig",  17, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ib",  16, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk current", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "vgs",  50, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "vds",  51, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "vbs",  49, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "vbd",  48, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain squares", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source squares", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device initially off", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "icvds",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial D-S voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "icvgs",  13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial G-S voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "icvbs",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, AU(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Initial B-S voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "ic",  10, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT_VECTOR, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of D-S, G-S, B-S voltages", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "temp",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Instance operating temperature", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "dtemp",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, U(), "°C", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instance operating temperature difference", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l",  15, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT length", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w",  14, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "flag to request sensitivity WRT width", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "dnode",  22, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of drain node", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gnode",  23, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate node", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "snode",  24, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of source node", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "bnode",  25, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of bulk node", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "dnodeprime",  26, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal drain node", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "snodeprime",  27, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_INT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of internal source node", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "von",  30, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Turn-on voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "vdsat",  31, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Saturation drain voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sourcevcrit",  32, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical source voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "drainvcrit",  33, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Critical drain voltage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "rs",  78, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Source resistance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sourceconductance",  28, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Source conductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "rd",  79, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Drain resistance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "drainconductance",  29, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gm",  38, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Transconductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gds",  39, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Drain-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gmb",  37, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gmbs",  37, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source transconductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gbd",  40, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain conductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "gbs",  41, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source conductance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cbd",  42, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cbs",  43, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Bulk-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cgs",  52, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cgd",  55, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cgb",  58, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cqgs",  54, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cqgd",  57, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cqgb",  60, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to gate-bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cqbd",  62, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cqbs",  64, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capacitance due to bulk-source charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cbd0",  44, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cbdsw0",  45, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-D sidewall capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cbs0",  46, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S junction capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "cbssw0",  47, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero-Bias B-S sidewall capacitance", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "qbs",  63, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "qgs",  53, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Source charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "qgd",  56, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "qgb",  59, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate-Bulk charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "qbd",  61, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Bulk-Drain charge storage", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "p",  19, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Instantaneous power", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l_dc",  76, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l_real",  70, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l_imag",  71, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l_cplx",  74, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt length", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l_mag",  72, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_l_ph",  73, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt l of ac phase", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w_dc",  75, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "dc sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w_real",  65, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "real part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w_imag",  66, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "imag part of ac sensitivity wrt width", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w_mag",  67, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac magnitude", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w_ph",  68, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "sensitivity wrt w of ac phase", true );
        modelInfos[MODEL_TYPE::MOS9].instanceParams.emplace_back( "sens_w_cplx",  69, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_COMPLEX, U(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ac sensitivity wrt width", true );


        modelInfos[MODEL_TYPE::B4SOI] = { "B4SOI", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley SOI MOSFET model version 4.4.0", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mtrlmod",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for non-silicon substrate or metal gate selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgstcvmod",  1224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Improved VgsteffCV selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gidlmod",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for GIDL selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "iiimod",  4000, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for III selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "eot",  97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Effective SiO2 thickness" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "epsrox",  98, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "Dielectric constant of the gate oxide relative to vacuum" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "epsrsub",  99, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of substrate relative to vacuum" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ni0sub",  87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.45e+10", "1.45e+10", "Intrinsic carrier concentration of substrate at Tnom" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bg0sub",  86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.16", "1.16", "Band-gap of substrate at T=0K" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tbgasub",  85, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.000702", "0.000702", "First parameter of band-gap change due to temperature" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tbgbsub",  84, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1108", "1108", "Second parameter of band-gap change due to temperature" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "phig",  82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Work function of gate" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "easub",  83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Electron affinity of substrate" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "leffeot",  91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Effective length for extraction of EOT" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "weffeot",  92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Effective width for extraction of EOT" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vddeot",  93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "-1.5", "Voltage for extraction of EOT" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tempeot",  94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Temperature for extraction of EOT" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ados",  89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bdos",  90, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "epsrgate",  88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of gate relative to vacuum" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "capmod",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "binunit",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "4.4", "4.4", "parameter for model version" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tox",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness in meters" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxp",  95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Physical gate oxide thickness" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxm",  962, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness used in extraction" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dtoxcv",  847, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta oxide thickness in meters in CapMod3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdsc",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdscb",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cit",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nfactor",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsat",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "at",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "a0",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "a1",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "a2",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "keta",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.6", "-0.6", "Body-bias coefficient of non-uniform depletion width effect." );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nsub",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration with polarity" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nch",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ngate",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nsd",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+20", "1e+20", "S/D doping concentration" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gamma1",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gamma2",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbx",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbm",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xt",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow width effect coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpe0",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpeb",  604, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral non-uniform doping effect for body bias" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vfb",  1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "eu",  3500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Mobility exponent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ucs",  3504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Mobility exponent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ucste",  3508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.004775", "-0.004775", "Temperature coefficient of UCS" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ud",  3400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coulomb scattering factor of mobility" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ud1",  3404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of ud" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnom",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgso",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgdo",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xpart",  705, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rsh",  706, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source-drain resistance per width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rsw",  677, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Source resistance per width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdw",  673, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Drain resistance per width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rswmin",  682, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source resistance per width at high Vg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdwmin",  681, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain resistance per width at hight Vg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "shmod",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Self heating mode selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tbox",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-07", "3e-07", "Back gate oxide thickness in meters" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tsi",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Silicon-on-insulator thickness in meters" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "etsi",  96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Effective Silicon-on-insulator thickness in meters" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xj",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Junction Depth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rth0_",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Self-heating thermal resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cth0_",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Self-heating thermal capacitance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cfrcoeff",  394, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fringe Cap parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "egidl",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "GIDL first parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "agidl",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL second parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bgidl",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "GIDL third parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgidl",  600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "GIDL vb parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rgidl",  76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GIDL vg parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kgidl",  72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL vb parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fgidl",  68, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL vb parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "egisl",  2500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "GISL first parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "agisl",  2501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL second parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bgisl",  2502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "GISL third parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgisl",  2503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "GISL vb parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rgisl",  2504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GISL vg parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kgisl",  2505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL vb parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fgisl",  2506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL vb parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ndiode",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ndioded",  633, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xbjt",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xdif",  870, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrec",  871, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xtun",  872, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Istun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xdifd",  873, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Iddif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrecd",  874, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Idrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xtund",  875, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Idtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbswg",  860, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Source(gate side) sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbswgd",  991, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Drain(gate side) sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mjswg",  861, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source (gate side) sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mjswgd",  989, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Drain (gate side) sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cjswg",  862, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Source(gate side) sidewall junction capacitance per unit width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cjswgd",  990, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Drain (gate side) sidewall junction capacitance per unit width" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lint",  819, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ll",  820, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llc",  842, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lln",  821, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lw",  822, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwc",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwn",  823, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwl",  824, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwlc",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wint",  827, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wl",  828, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlc",  845, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wln",  829, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ww",  830, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwc",  846, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwn",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwl",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwlc",  844, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "8.16367e-11", "8.16367e-11", "Fringe capacitance parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Vdsat parameter for C-V model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vdsat parameter for C-V model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwc",  848, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlc",  849, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noia",  816, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "6.25e+41", "6.188e+40", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noib",  817, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "3.125e+26", "1.5e+25", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noic",  818, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "8.75e+09", "8.75e+09", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fnoimod",  956, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnoimod",  957, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Thermal noise model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnoia",  951, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1.5", "1.5", "Thermal noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnoib",  952, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "3.5", "3.5", "Thermal noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rnoia",  953, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.577", "0.577", "Thermal noise coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rnoib",  954, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.37", "0.37", "Thermal noise coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntnoi",  955, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Thermal noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "saref",  965, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance between OD edge to poly of one side" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sbref",  966, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance between OD edge to poly of the other side" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlod",  981, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for stress effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ku0",  967, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility degradation/enhancement coefficient for LOD" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kvsat",  968, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity degradation/enhancement parameter for LOD" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kvth0",  977, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold degradation/enhancement parameter for LOD" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tku0",  969, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of KU0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llodku0",  970, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length parameter for u0 LOD effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlodku0",  971, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for u0 LOD effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llodvth",  972, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length parameter for vth LOD effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlodvth",  973, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for vth LOD effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lku0",  974, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ku0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wku0",  975, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ku0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pku0",  976, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ku0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkvth0",  978, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kvth0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkvth0",  979, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kvth0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkvth0",  980, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kvth0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "stk2",  982, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "K2 shift factor related to stress effect on vth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lodk2",  983, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "K2 shift modification factor for stress effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "steta0",  984, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "eta0 shift factor related to stress effect on vth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lodeta0",  985, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "eta0 shift modification factor for stress effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gbmin",  986, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "Minimum body conductance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbdb_",  987, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and dbNode" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbsb_",  988, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and sbNode" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bf",  597, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "2", "2", "Flicker noise length dependence exponent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "w0flk",  598, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e-05", "1e-05", "Flicker noise width dependence" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "frbody_",  599, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Layout dependent rbody multiplier" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp0",  608, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp0",  609, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp0",  610, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp0",  611, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp1",  612, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp1",  613, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp1",  614, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp1",  615, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp2",  687, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp2",  688, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp2",  689, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp2",  690, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp3",  691, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp3",  692, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp3",  693, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp3",  694, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp4",  695, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forth parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp4",  696, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp4" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp4",  697, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp4" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp4",  698, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp4" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "minv",  616, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "For moderate invversion in Vgsteff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lminv",  617, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wminv",  618, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "width dependence of minv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pminv",  619, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of minv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdits",  624, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-20", "1e-20", "Coefficient for drain-induced Vth shifts" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pditsl",  632, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drain-induced Vth shifts" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pditsd",  628, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of drain-induced Vth shifts" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fprout",  620, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Rout degradation coefficient for pocket devices" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfprout",  621, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdits",  625, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdits" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpditsd",  629, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pditsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfprout",  622, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdits",  626, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdits" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpditsd",  630, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pditsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfprout",  623, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdits",  627, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdits" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppditsd",  631, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pditsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "em",  592, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ef",  593, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "af",  594, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kf",  595, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noif",  596, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Floating body excess noise ideality factor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1w1",  239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First Body effect width dependent parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1w2",  240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second Boby effect width dependent parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ketas",  241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface potential adjustment for bulk charge effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwbc",  242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width offset for body contact isolation edge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "beta0",  243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First Vds dependent parameter of impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "beta1",  244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second Vds dependent parameter of impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "beta2",  245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Third Vds dependent parameter of impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vdsatii0",  246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Nominal drain saturation voltage at threshold for impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tii",  247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependent parameter for impact ionizition" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lii",  248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length dependent parameter at threshold for impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sii0",  249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "First Vgs dependent parameter for impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sii1",  250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Second Vgs dependent parameter for impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sii2",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third Vgs dependent parameter for impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "siid",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependent parameter of drain saturation voltage for impact ionizition current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fbjtii",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fraction of bipolar current affecting the impact ionization" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ebjtii",  4002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact ionization parameter for BJT part" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cbjtii",  4003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length scaling parameter for II BJT part" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbci",  4004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Internal B-C built-in potential" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "abjtii",  4005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Exponent factor for avalanche current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mbjtii",  4006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.4", "0.4", "Internal B-C grading coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tvbci",  4001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for VBCI" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "esatii",  238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Saturation electric field for impact ionization" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntun",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntund",  669, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecf0",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Recombination non-ideality factor at forward bias" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecf0d",  653, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Recombination non-ideality factor at forward bias" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecr0",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Recombination non-ideality factor at reversed bias" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecr0d",  657, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Recombination non-ideality factor at reversed bias" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "isbjt",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT injection saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "idbjt",  641, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT injection saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "isdif",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to source/drain injection saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "iddif",  637, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to source/drain injection saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "isrec",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "idrec",  645, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "istun",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse tunneling saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "idtun",  649, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse tunneling saturation current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ln",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "Electron/hole diffusion length" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vrec0",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for recombination current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vrec0d",  661, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for recombination current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vtun0",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for tunneling current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vtun0d",  665, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for tunneling current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nbjt",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Power coefficient of channel length dependency for bipolar current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbjt0",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "Refferenc channel length for bipolar cuurent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldif0",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Channel-length dependency coefficient of diffusion cap" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vabjt",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Early voltage for bipolar current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aely",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length dependency of early voltage for bipolar cuurent" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ahli",  264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High level injection parameter for bipolar current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ahlid",  683, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High level injection parameter for bipolar current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbody",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic body contact sheet resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbsh",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic body contact sheet resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgeo",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate substrate overlap capacitance per unit channel length" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tt",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-12", "1e-12", "Diffusion capacitance transit time coefficient" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ndif",  269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "-1", "-1", "Power coefficient of channel length dependency for diffusion capacitance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsdfb",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain bottom diffusion capacitance flatband voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsdth",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain bottom diffusion capacitance threshold voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "csdmin",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.000100544", "0.000100544", "Source/drain bottom diffusion minimum capacitance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "asd",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Source/drain bottom diffusion smoothing parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "csdesw",  863, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain sidewall fringing capacitance per unit length" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntrecf",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Nrecf" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntrecr",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Nrecr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlcb",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length offset fitting parameter for body charge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fbody",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Scaling factor for body charge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tcjswg",  894, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Cjswgs" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tpbswg",  895, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Pbswgs" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tcjswgd",  896, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Cjswgd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tpbswgd",  897, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Pbswgd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "acde",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for charge thickness in capMod=3 for accumulation and depletion regions" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "moin",  273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for the gate-bias dependent surface potential" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noff",  958, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "C-V turn-on/off parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "delvt",  274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage adjust for CV" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kb1",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Scaling factor for backgate charge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlbg",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length offset fitting parameter for backgate charge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "igmod",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate-body tunneling current model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "igbmod",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "igcmod",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate-channel tunneling current model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxqm",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "effective oxide thickness considering quantum effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wth0",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Minimum width for thermal resistance calculation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rhalo",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "body halo sheet resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntox",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "power term of gate current" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxref",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-09", "2.5e-09", "target oxide thickness" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ebg",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "effective bandgap in gate current calcula." );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vevb",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.075", "Vaux parameter for valence-band electron tunneling" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "alphagb1",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.35", "0.35", "First Vox dependent parameter for gate current in inversion" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "betagb1",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.03", "0.03", "Second Vox dependent parameter for gate current in inversion" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgb1",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "300", "300", "Third Vox dependent parameter for gate current in inversion" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vecb",  286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.026", "0.026", "Vaux parameter for conduction-band electron tunneling" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "alphagb2",  287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.43", "First Vox dependent parameter for gate current in accumulation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "betagb2",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.05", "0.05", "Second Vox dependent parameter for gate current in accumulation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgb2",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "17", "17", "Third Vox dependent parameter for gate current in accumulation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aigbcp2",  10001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.043", "0.043", "First Vgp dependent parameter for gate current in accumulation in AGBCP2 region" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bigbcp2",  10005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.0054", "0.0054", "Second Vgp dependent parameter for gate current in accumulation in AGBCP2 region" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cigbcp2",  10009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.0075", "0.0075", "Third Vgp dependent parameter for gate current in accumulation in AGBCP2 region" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "voxh",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "the limit of Vox in gate current calculation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "deltavox",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "the smoothing parameter in the Vox smoothing function" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aigc",  1021, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.31", "Parameter for Igc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bigc",  1022, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.054", "0.024", "Parameter for Igc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cigc",  1023, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aigsd",  1024, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.31", "Parameter for Igs,d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bigsd",  1025, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.054", "0.024", "Parameter for Igs,d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cigsd",  1026, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igs,d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nigc",  1027, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc slope" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pigcd",  1028, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc partition" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "poxedge",  1029, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Factor for the gate edge Tox" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlcig",  1030, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for Ig model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "soimod_",  1001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "model selector for SOI technology" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbs0pd",  963, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Upper bound of built-in potential lowering for PD operation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbs0fd",  964, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Lower bound of built-in potential lowering for FD operation" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbsa",  1002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vbs0t offset voltage" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nofffd",  1003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "smoothing parameter in FD module" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vofffd",  1004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "smoothing parameter in FD module" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1b",  1005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "first backgate body effect parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k2b",  1006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "second backgate body effect parameter for short channel effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dk2b",  1007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "third backgate body effect parameter for short channel effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvbd0",  1008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "first short-channel effect parameter in FD module" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvbd1",  1009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "second short-channel effect parameter in FD module" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "moinfd",  1010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "Coefficient for the gate-bias dependent surface potential in FD" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rgatemod_",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate R model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrcrg1",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "12", "12", "First fitting parameter the bias-dependent Rg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrcrg2",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Second fitting parameter the bias-dependent Rg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rshg",  298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Gate sheet resistance" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ngcon",  299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Number of gate contacts" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xgw",  392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance from gate contact center to device edge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xgl",  393, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Variation in Ldrawn" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbodymod_",  300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body R model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdsmod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias-dependent S/D resistance model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fdmod",  1221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Improved dVbi model selector" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsce",  1222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "SCE parameter for improved dVbi model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdsbs",  1223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coupling from Vd to Vbs for improved dVbi model" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "minvcv",  1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "For moderate invversion in VgsteffCV" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lminvcv",  1226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minvcv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wminvcv",  1227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "width dependence of minvcv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pminvcv",  1228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of minvcv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "voffcv",  1229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "CV Threshold voltage offset" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvoffcv",  1230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voffcv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvoffcv",  1231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voffcv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvoffcv",  1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voffcv" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxj",  1061, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xj" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lalphagb1",  1062, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alphagb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbetagb1",  1064, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of betagb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lalphagb2",  1063, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alphagb2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbetagb2",  1065, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of betagb2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laigbcp2",  10002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbigbcp2",  10006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcigbcp2",  10010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgsl",  1074, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgsl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgdl",  1073, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lckappa",  1075, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappa" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lndif",  1066, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lute",  1078, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ute" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkt1",  1079, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkt1l",  1081, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1l" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkt2",  1080, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lua1",  1082, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lub1",  1083, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "luc1",  1084, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lat",  1085, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of at" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lprt",  1086, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntrecf",  1067, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntrecf" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntrecr",  1068, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntrecr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxbjt",  1069, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxdif",  876, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrec",  877, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxtun",  878, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxdifd",  879, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xdifd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrecd",  880, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrecd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxtund",  881, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xtund" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laigc",  1031, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbigc",  1032, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcigc",  1033, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laigsd",  1034, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbigsd",  1035, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcigsd",  1036, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnigc",  1037, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpigcd",  1038, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for pigcd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpoxedge",  1039, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for poxedge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnch",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnsub",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lngate",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnsd",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvth0",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvfb",  1202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk1",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk1w1",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1w1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk1w2",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1w2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk2",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk3",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk3b",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkb1",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lw0",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llpe0",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpe0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llpeb",  605, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpeb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt0",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt1",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt2",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt0w",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt1w",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt2w",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lu0",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "leu",  3501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eu" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lua",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lub",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "luc",  323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lud",  3401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lud1",  3405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lucste",  3509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ucste" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lucs",  3505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lucs" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvsat",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "la0",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lags",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lb0",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lb1",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lketa",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lketas",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ketas" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "la1",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "la2",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrdsw",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrsw",  678, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rsw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrdw",  674, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lprwb",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lprwg",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwr",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnfactor",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldwg",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldwb",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvoff",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "leta0",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "letab",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of etab" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldsub",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcit",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcdsc",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcdscb",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcdscd",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpclm",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdiblc1",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdiblc2",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdiblcb",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldrout",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpvag",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldelta",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lalpha0",  355, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfbjtii",  356, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "labjtii",  4010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of abjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcbjtii",  4008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lebjtii",  4007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ebjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lmbjtii",  4011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvbci",  4009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbci" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbeta0",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbeta1",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbeta2",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvdsatii0",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdsatii0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llii",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lesatii",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of esatii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsii0",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsii1",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsii2",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsiid",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of siid" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lagidl",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbgidl",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgidl",  601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "legidl",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrgidl",  75, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkgidl",  71, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfgidl",  67, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lagisl",  2510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbgisl",  2513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgisl",  2516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "legisl",  2507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrgisl",  2519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkgisl",  2522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfgisl",  2525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntun",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntund",  670, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntund" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lndiode",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndiode" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lndioded",  634, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndioded" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecf0",  372, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecf0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecf0d",  654, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecf0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecr0",  373, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecr0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecr0d",  658, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecr0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lisbjt",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lidbjt",  642, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of idbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lisdif",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "liddif",  638, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of iddif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lisrec",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lidrec",  646, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of idrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "listun",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of istun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lidtun",  650, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of idtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvrec0",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vrec0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvrec0d",  662, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vrec0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvtun0",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtun0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvtun0d",  666, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtun0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnbjt",  380, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llbjt0",  381, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lbjt0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvabjt",  382, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vabjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laely",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aely" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lahli",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ahli" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lahlid",  684, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ahlid" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvsdfb",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdfb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvsdth",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldelvt",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delvt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lacde",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lmoin",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of moin" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnoff",  959, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of noff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrcrg1",  390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of xrcrg1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrcrg2",  391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of xrcrg2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxj",  1091, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xj" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "walphagb1",  1092, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alphagb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbetagb1",  1094, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of betagb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "walphagb2",  1093, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alphagb2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbetagb2",  1095, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of betagb2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waigbcp2",  10003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbigbcp2",  10007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcigbcp2",  10011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgsl",  2004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgsl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgdl",  2003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wckappa",  2005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ckappa" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wndif",  1096, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wute",  2008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ute" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkt1",  2009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkt1l",  2011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1l" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkt2",  2010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wua1",  2012, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wub1",  2013, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wuc1",  2014, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wat",  2015, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of at" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wprt",  2016, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntrecf",  1097, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntrecf" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntrecr",  1098, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntrecr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxbjt",  1099, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxdif",  882, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrec",  883, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxtun",  884, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxdifd",  885, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xdifd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrecd",  886, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xrecd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxtund",  887, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xtund" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waigc",  1041, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbigc",  1042, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcigc",  1043, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waigsd",  1044, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbigsd",  1045, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcigsd",  1046, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnigc",  1047, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpigcd",  1048, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for pigcd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpoxedge",  1049, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for poxedge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnch",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnsub",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wngate",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnsd",  79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvth0",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvfb",  1203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk1w1",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1w1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk1w2",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1w2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk2",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk3",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk3b",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkb1",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ww0",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlpe0",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpe0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlpeb",  606, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpeb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt0",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt1",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt2",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt0w",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt1w",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt2w",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wu0",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "weu",  3502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eu" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wua",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wub",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wuc",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wud",  3402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wud1",  3406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wucste",  3510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucste" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wucs",  3506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucs" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvsat",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wa0",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wags",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wb0",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wb1",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wketa",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wketas",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ketas" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wa1",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wa2",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrdsw",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrsw",  679, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rsw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrdw",  675, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wprwb",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wprwg",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwr",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnfactor",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdwg",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdwb",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvoff",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "weta0",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wetab",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdsub",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcit",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcdsc",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcdscb",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcdscd",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpclm",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdiblc1",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdiblc2",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdiblcb",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdrout",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpvag",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdelta",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "walpha0",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfbjtii",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wabjtii",  4015, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of abjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcbjtii",  4013, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "webjtii",  4012, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ebjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wmbjtii",  4016, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvbci",  4014, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbci" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbeta0",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbeta1",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbeta2",  459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvdsatii0",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vdsatii0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlii",  461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wesatii",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of esatii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsii0",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsii1",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsii2",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsiid",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of siid" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wagidl",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbgidl",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgidl",  602, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wegidl",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of egidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrgidl",  74, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkgidl",  70, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfgidl",  66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wagisl",  2511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbgisl",  2514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgisl",  2517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wegisl",  2508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of egisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrgisl",  2520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkgisl",  2523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfgisl",  2526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntun",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntund",  671, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntund" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wndiode",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndiode" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wndioded",  635, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndioded" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecf0",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecf0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecf0d",  655, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecf0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecr0",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecr0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecr0d",  659, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecr0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wisbjt",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widbjt",  643, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of idbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wisdif",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widdif",  639, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of iddif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wisrec",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widrec",  647, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of idrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wistun",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of istun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widtun",  651, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of idtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvrec0",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vrec0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvrec0d",  663, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vrec0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvtun0",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtun0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvtun0d",  667, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtun0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnbjt",  480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlbjt0",  481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lbjt0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvabjt",  482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vabjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waely",  483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aely" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wahli",  484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ahli" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wahlid",  685, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ahlid" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvsdfb",  485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdfb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvsdth",  486, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdelvt",  487, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delvt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wacde",  488, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of acde" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wmoin",  489, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of moin" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnoff",  960, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of noff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrcrg1",  490, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of xrcrg1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrcrg2",  491, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of xrcrg2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxj",  2021, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xj" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "palphagb1",  2022, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alphagb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbetagb1",  2024, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of betagb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "palphagb2",  2023, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alphagb2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbetagb2",  2025, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of betagb2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paigbcp2",  10004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbigbcp2",  10008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcigbcp2",  10012, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigbcp2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgsl",  2034, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgsl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgdl",  2033, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pckappa",  2035, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ckappa" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pndif",  2026, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pute",  2038, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ute" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkt1",  2039, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkt1l",  2041, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1l" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkt2",  2040, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pua1",  2042, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pub1",  2043, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "puc1",  2044, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pat",  2045, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of at" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pprt",  2046, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntrecf",  2027, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntrecf" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntrecr",  2028, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntrecr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxbjt",  2029, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxdif",  888, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrec",  889, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxtun",  890, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxdifd",  891, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xdifd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrecd",  892, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xrecd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxtund",  893, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xtund" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paigc",  1051, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbigc",  1052, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcigc",  1053, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paigsd",  1054, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbigsd",  1055, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcigsd",  1056, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnigc",  1057, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nigc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppigcd",  1058, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for pigcd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppoxedge",  1059, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for poxedge" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnch",  501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnsub",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnsd",  78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pngate",  503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvth0",  504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvfb",  1204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk1w1",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1w1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk1w2",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1w2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk2",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk3",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk3b",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkb1",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kb1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pw0",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plpe0",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lpe0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plpeb",  607, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lpeb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt0",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt1",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt2",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt0w",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt1w",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt2w",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pu0",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "peu",  3503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eu" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pua",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pub",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "puc",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pud",  3403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ud" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pud1",  3407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ud1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pucste",  3511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ucste" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pucs",  3507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ucs" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvsat",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pa0",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pags",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pb0",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pb1",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pketa",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pketas",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ketas" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pa1",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pa2",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prdsw",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prsw",  680, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rsw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prdw",  676, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdw" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pprwb",  534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pprwg",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pwr",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnfactor",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdwg",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdwb",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvoff",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "peta0",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "petab",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdsub",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcit",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcdsc",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcdscb",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcdscd",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppclm",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdiblc1",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdiblc2",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdiblcb",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdrout",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppvag",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdelta",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "palpha0",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfbjtii",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pabjtii",  4020, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of abjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcbjtii",  4018, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pebjtii",  4017, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ebjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pmbjtii",  4021, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mbjtii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvbci",  4019, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbci" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbeta0",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbeta1",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbeta2",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvdsatii0",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdsatii0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plii",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pesatii",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of esatii" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psii0",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psii1",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psii2",  565, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psiid",  566, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of siid" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pagidl",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbgidl",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgidl",  603, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pegidl",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of egidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prgidl",  73, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkgidl",  69, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfgidl",  65, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fgidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pagisl",  2512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbgisl",  2515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgisl",  2518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pegisl",  2509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of egisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prgisl",  2521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkgisl",  2524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfgisl",  2527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fgisl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntun",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntund",  672, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntund" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pndiode",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pndioded",  636, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecf0",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecf0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecf0d",  656, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecf0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecr0",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecr0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecr0d",  660, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecr0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pisbjt",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pidbjt",  644, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of idbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pisdif",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isdif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "piddif",  640, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of iddif" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pisrec",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pidrec",  648, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of idrec" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pistun",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of istun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pidtun",  652, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of idtun" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvrec0",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vrec0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvrec0d",  664, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vrec0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvtun0",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtun0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvtun0d",  668, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtun0d" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnbjt",  580, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nbjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plbjt0",  581, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lbjt0" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvabjt",  582, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vabjt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paely",  583, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aely" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pahli",  584, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "X-term dependence of ahli" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pahlid",  686, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "X-term dependence of ahlid" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvsdfb",  585, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdfb" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvsdth",  586, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdth" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdelvt",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delvt" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pacde",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of acde" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pmoin",  589, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of moin" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnoff",  961, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of noff" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrcrg1",  590, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of xrcrg1" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrcrg2",  591, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of xrcrg2" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nlx",  2104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Lateral non-uniform doping effect" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnlx",  2105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of nlx" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnlx",  2106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of nlx" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnlx",  2107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of nlx" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ngidl",  2100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL first parameter" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lngidl",  2101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of ngidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wngidl",  2102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of ngidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pngidl",  2103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of ngidl" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgs_max",  2201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgd_max",  2202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgb_max",  2203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vds_max",  2204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbs_max",  2205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbd_max",  2206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgsr_max",  2207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgdr_max",  2208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgbr_max",  2209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbsr_max",  2210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbdr_max",  2211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nmos",  814, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
        modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pmos",  815, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
        // Instance parameters
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "m",  47, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nf",  33, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of fingers", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "sa",  41, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between  OD edge to poly of one side", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "sb",  42, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between  OD edge to poly of the other side", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "sd",  43, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between neighbour fingers", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ic",  19, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gmbs",  918, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gm",  916, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gmids",  946, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm/Ids", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gds",  917, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vdsat",  939, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vth",  938, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ids",  913, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vbs",  909, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vgs",  910, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vds",  912, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ves",  911, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ves", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ibd",  3003, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ibs",  3002, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "isub",  3004, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Isub", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igidl",  3005, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igidl", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igisl",  3001, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igisl", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igs",  3006, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igs", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igd",  3007, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igd", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igb",  3008, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igcs",  3009, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igcs", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igcd",  3010, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igcd", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cgg",  927, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cggb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cgs",  929, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgsb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cgd",  928, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgdb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cbg",  930, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbgb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cbd",  915, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbdb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cbs",  914, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbsb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cdg",  935, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdgb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cdd",  936, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cddb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cds",  937, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdsb", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "capbd",  931, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "capbs",  933, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qg",  923, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qgate", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qb",  921, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qbulk", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qd",  925, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qdrain", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qs",  955, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qsource", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "bjtoff",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "debug",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "DEBUG on/off flag", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rth0",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Resistance", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cth0",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-05", "1e-05", "Instance Thermal Capacitance", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nrb",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of squares in body", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "frbody",  30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "1", "layout dependent body-resistance coefficient", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rbdb",  35, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rbsb",  36, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "delvto",  44, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero bias threshold voltage variation", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "delvt0",  44, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "n.a.", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "soimod",  32, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance model selector for PD/FD operation", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nbc",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of body contact isolation edge", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nseg",  23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number segments for width partitioning", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "pdbcp",  24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Perimeter length for bc parasitics at drain side", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "psbcp",  25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Perimeter length for bc parasitics at source side", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "agbcp",  26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate to body overlap area for bc parasitics", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "agbcp2",  46, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Parasitic Gate to body overlap area for bc parasitics", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "agbcpd",  45, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate to body overlap area for bc parasitics in DC", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "aebcp",  27, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Substrate to body overlap area for bc prasitics", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vbsusr",  28, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs specified by user", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "tnodeout",  29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag indicating external temp node", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rgatemod",  31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Gate resistance model selector", true );
        modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rbodymod",  34, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Body R model selector", true );


        modelInfos[MODEL_TYPE::BSIM4] = { "BSIM4", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley Short Channel IGFET Model-4", {}, {} };
        // Model parameters
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cvchargemod",  76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Capacitance Charge model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "capmod",  92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "diomod",  86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode IV model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdsmod",  85, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias-dependent S/D resistance model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "trnqsmod_",  93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Transient NQS model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "acnqsmod_",  83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "AC NQS model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mobmod",  94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbodymod_",  91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distributed body R model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgatemod_",  90, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate R model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "permod",  87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Pd and Ps model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "geomod_",  88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Geometry dependent parasitics model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgeomod_",  89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "S/D resistance and contact model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fnoimod",  84, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnoimod",  95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Thermal noise model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mtrlmod",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for non-silicon substrate or metal gate selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mtrlcompatmod",  380, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New Material Mod backward compatibility selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "igcmod",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-to-channel Ig model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "igbmod",  82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-to-body Ig model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tempmod",  79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature model selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gidlmod",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for GIDL selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Model parameter checking selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "binunit",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "4.8.1", "4.8.1", "parameter for model version" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eot",  96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-09", "1.5e-09", "Equivalent gate oxide thickness in meters" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vddeot",  97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "-1.5", "Voltage for extraction of Equivalent gate oxide thickness" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tempeot",  65, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Temperature for extraction of EOT" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leffeot",  66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Effective length for extraction of EOT" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "weffeot",  67, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Effective width for extraction of EOT" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ados",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bdos",  78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxe",  98, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Electrical gate oxide thickness in meters" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxp",  230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Physical gate oxide thickness in meters" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxm",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Gate oxide thickness at which parameters are extracted" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxref",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Target tox value" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dtox",  231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Defined as (toxe - toxp)" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "epsrox",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "Dielectric constant of the gate oxide relative to vacuum" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cdsc",  99, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cdscb",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cit",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nfactor",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xj",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-07", "1.5e-07", "Junction depth in meters" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vsat",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "at",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "a0",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "a1",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "a2",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "keta",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.047", "-0.047", "Body-bias coefficient of non-uniform depletion width effect." );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "phig",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Work function of gate" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "epsrgate",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of gate relative to vacuum" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "easub",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Electron affinity of substrate" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "epsrsub",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of substrate relative to vacuum" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ni0sub",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.45e+10", "1.45e+10", "Intrinsic carrier concentration of substrate at 300.15K" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bg0sub",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.16", "1.16", "Band-gap of substrate at T=0K" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tbgasub",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.000702", "0.000702", "First parameter of band-gap change due to temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tbgbsub",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1108", "1108", "Second parameter of band-gap change due to temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nsub",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ndep",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration at the depletion edge" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nsd",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+20", "1e+20", "S/D doping concentration" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "phin",  250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Adjusting parameter for surface potential due to non-uniform vertical doping" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ngate",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gamma1",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gamma2",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbx",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbm",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xt",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "80", "80", "Narrow width effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp0",  247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp1",  248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp2",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "3rd parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp3",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "4th parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp4",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "5th parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp5",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "6th parameter for Vth shift due to pocket" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpe0",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Equivalent length of pocket region at zero bias" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpeb",  246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Equivalent length of pocket region accounting for body bias" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-09", "1e-09", "Linear gate dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1e-09", "1e-09", "Temperature coefficient of ua" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-19", "1e-19", "Quadratic gate dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1e-18", "-1e-18", "Temperature coefficient of ub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ud",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coulomb scattering factor of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ud1",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of ud" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "up",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length linear factor of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lp",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Channel length exponential factor of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eu",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Mobility exponent" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ucs",  72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Colombic scattering exponent" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ucste",  68, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.004775", "-0.004775", "Temperature coefficient of colombic mobility" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "minv",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fitting parameter for moderate inversion in Vgsteff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "minvcv",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fitting parameter for moderate inversion in Vgsteffcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voffl",  238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence parameter for Vth offset" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voffcvl",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence parameter for Vth offset in CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnom",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgso",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1.03594e-09", "1.03594e-09", "Gate-source overlap capacitance per width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgdo",  833, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1.03594e-09", "1.03594e-09", "Gate-drain overlap capacitance per width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgbo",  834, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-bulk overlap capacitance per length" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xpart",  835, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rsh",  836, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "200", "200", "Source-drain resistance per width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdswmin",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain resistance per width at high Vg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rsw",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source resistance per width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdw",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Drain resistance per width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdwmin",  254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain resistance per width at high Vg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rswmin",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source resistance per width at high Vg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate-bias effect on parasitic resistance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fprout",  245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Rout degradation coefficient for pocket devices" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdits",  239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coefficient for drain-induced Vth shifts" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pditsl",  241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drain-induced Vth shifts" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pditsd",  240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of drain-induced Vth shifts" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pscbe1",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "4.24e+08", "4.24e+08", "Substrate current body-effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pscbe2",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Substrate current body-effect coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jss",  837, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Bottom source junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jsws",  878, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Isolation edge sidewall source junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jswgs",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate edge source junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbs",  838, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source junction built-in potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njs",  873, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source junction emission coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtis",  874, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Source junction current temperature exponent" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjs",  839, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source bottom junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbsws",  840, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjsws",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbswgs",  875, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source (gate side) sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjswgs",  876, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source (gate side) sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjs",  842, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Source bottom junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjsws",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source sidewall junction capacitance per unit periphery" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjswgs",  877, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source (gate side) sidewall junction capacitance per unit width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jsd",  886, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Bottom drain junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jswd",  898, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Isolation edge sidewall drain junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jswgd",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate edge drain junction reverse saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbd",  887, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Drain junction built-in potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njd",  893, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Drain junction emission coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtid",  894, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Drainjunction current temperature exponent" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjd",  888, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Drain bottom junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbswd",  889, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Drain sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjswd",  890, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Drain sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbswgd",  895, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Drain (gate side) sidewall junction capacitance built in potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjswgd",  896, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Drain (gate side) sidewall junction capacitance grading coefficient" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjd",  891, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Drain bottom junction capacitance per unit area" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjswd",  892, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Drain sidewall junction capacitance per unit periphery" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjswgd",  897, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Drain (gate side) sidewall junction capacitance per unit width" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vfbcv",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage parameter for capmod=0 only" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vfb",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tpb",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tcj",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cj" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tpbsw",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbsw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tcjsw",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjsw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tpbswg",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbswg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tcjswg",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjswg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "acde",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for finite charge thickness" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "moin",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for gate-bias dependent surface potential" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "noff",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "C-V turn-on/off parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voffcv",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "C-V lateral-shift parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmcg",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Contact to Gate edge" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmci",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Contact to Isolation" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmdg",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Diffusion to Gate edge" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmcgt",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Contact to Gate edge in Test structures" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xgw_",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance from gate contact center to device edge" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xgl",  219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Variation in Ldrawn" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rshg",  220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Gate sheet resistance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ngcon_",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Number of gate contacts" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xrcrg1",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "12", "12", "First fitting parameter the bias-dependent Rg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xrcrg2",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Second fitting parameter the bias-dependent Rg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lambda",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Velocity overshoot parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtl",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "200000", "200000", "thermal velocity" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lc",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "5e-09", "5e-09", "back scattering parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xn",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "back scattering parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vfbsdoff",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "S/D flatband voltage offset" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tvfbsdoff",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for vfbsdoff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tvoff",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for voff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnfactor",  1256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for nfactor" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "teta0",  1257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for eta0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tvoffcv",  1258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for tvoffcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lintnoi",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "lint offset for noise calculation" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lint",  849, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ll",  850, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llc",  879, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lln",  851, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lw",  852, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwc",  880, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwn",  853, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwl",  854, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwlc",  881, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lmin",  855, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lmax",  856, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wint",  857, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wl",  858, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlc",  882, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wln",  859, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ww",  860, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwc",  883, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwn",  861, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwl",  862, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwlc",  884, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wmin",  863, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wmax",  864, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ckappas",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "S/G overlap C-V parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ckappad",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "D/G overlap C-V parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1.07725e-10", "1.07725e-10", "Fringe capacitance parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Vdsat parameter for C-V model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Vdsat parameter for C-V model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwc",  865, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dlc",  866, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xw",  868, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "W offset for channel width due to mask/etch effect" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xl",  867, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "L offset for channel length due to mask/etch effect" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dlcig",  899, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for Ig model" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dlcigd",  1244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for Ig model drain side" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwj",  885, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for S/D junctions" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "alpha1",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "beta0",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "agidl",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pre-exponential constant for GIDL" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bgidl",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "Exponential constant for GIDL" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgidl",  249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Parameter for body-bias dependence of GIDL" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgidl",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GIDL vg parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kgidl",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL vb parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fgidl",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GIDL vb parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "egidl",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Fitting parameter for Bandbending" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "agisl",  1200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pre-exponential constant for GISL" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bgisl",  1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "Exponential constant for GISL" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgisl",  1203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Parameter for body-bias dependence of GISL" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgisl",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GISL vg parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kgisl",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL vb parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fgisl",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GISL vb parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "egisl",  1202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Fitting parameter for Bandbending" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigc",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigc",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigc",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigsd",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igs,d" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigsd",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igs,d" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigsd",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igs,d" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigs",  1220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigs",  1221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigs",  1222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigd",  1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigd",  1233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigd",  1234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigbacc",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0136", "Parameter for Igb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigbacc",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.00171", "Parameter for Igb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigbacc",  264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.075", "Parameter for Igb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigbinv",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0111", "0.0111", "Parameter for Igb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigbinv",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.000949", "0.000949", "Parameter for Igb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigbinv",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "0.006", "0.006", "Parameter for Igb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nigc",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc slope" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nigbinv",  270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "Parameter for Igbinv slope" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nigbacc",  269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igbacc slope" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ntox",  271, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponent for Tox ratio" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eigbinv",  273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1.1", "1.1", "Parameter for the Si bandgap for Igbinv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pigcd",  274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc partition" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "poxedge",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Factor for the gate edge Tox" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthdfwd",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Forward drain diode forward limiting current" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthsfwd",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Forward source diode forward limiting current" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthdrev",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Reverse drain diode forward limiting current" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthsrev",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Reverse source diode forward limiting current" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xjbvd",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fitting parameter for drain diode breakdown current" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xjbvs",  227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fitting parameter for source diode breakdown current" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bvd",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain diode breakdown voltage" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bvs",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source diode breakdown voltage" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtss",  900, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source bottom trap-assisted saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsd",  901, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain bottom trap-assisted saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtssws",  902, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source STI sidewall trap-assisted saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsswd",  903, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain STI sidewall trap-assisted saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsswgs",  904, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source gate-edge sidewall trap-assisted saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsswgd",  905, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain gate-edge sidewall trap-assisted saturation current density" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtweff",  928, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "TAT current width dependence" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njts",  906, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for bottom junction" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtssw",  907, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for STI sidewall junction" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsswg",  908, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for gate-edge sidewall junction" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsd",  1250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for bottom junction drain side" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsswd",  1251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for STI sidewall junction drain side" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsswgd",  1252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for gate-edge sidewall junction drain side" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtss",  909, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSS on temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsd",  910, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSD on temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtssws",  911, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWS on temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsswd",  912, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWD on temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsswgs",  913, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWGS on temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsswgd",  914, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWGD on temperature" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjts",  915, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTS" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtssw",  916, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSW" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsswg",  917, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSWG" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsd",  1253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSD" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsswd",  1254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSWD" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsswgd",  1255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSWGD" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtss",  918, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source bottom trap-assisted voltage dependent parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsd",  919, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain bottom trap-assisted voltage dependent parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtssws",  920, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source STI sidewall trap-assisted voltage dependent parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsswd",  921, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain STI sidewall trap-assisted voltage dependent parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsswgs",  922, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source gate-edge sidewall trap-assisted voltage dependent parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsswgd",  923, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain gate-edge sidewall trap-assisted voltage dependent parameter" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gbmin",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "Minimum body conductance" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbdb",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and dbNode" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpb",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNodePrime and bNode" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsb",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and sbNode" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbps",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNodePrime and sbNode" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpd",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNodePrime and bNode" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbps0",  1101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Body resistance RBPS scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpsl",  1102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPS L scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpsw",  1103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPS W scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpsnf",  1104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPS NF scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpd0",  1105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Body resistance RBPD scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpdl",  1106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPD L scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpdw",  1107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPD W scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpdnf",  1108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPD NF scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbx0",  1109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBPBX  scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbxl",  1110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBX L scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbxw",  1111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBX W scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbxnf",  1112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBX NF scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpby0",  1113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBPBY  scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbyl",  1114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBY L scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbyw",  1115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBY W scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbynf",  1116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBY NF scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsbx0",  1117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBSBX  scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsby0",  1118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBSBY  scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbdbx0",  1119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBDBX  scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbdby0",  1120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBDBY  scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbxl",  1121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBX L scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbxw",  1122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBX W scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbxnf",  1123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBX NF scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbyl",  1124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBY L scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbyw",  1125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBY W scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbynf",  1126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBY NF scaling" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcdsc",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcdscb",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcdscd",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcit",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnfactor",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxj",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xj" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvsat",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lat",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of at" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "la0",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lags",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "la1",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "la2",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lketa",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnsub",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lndep",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndep" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnsd",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lphin",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of phin" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lngate",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lgamma1",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lgamma2",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvbx",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbx" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvbm",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbm" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxt",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xt" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk1",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkt1",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkt1l",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1l" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkt2",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk2",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk3",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk3b",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lw0",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp0",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp1",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp2",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp3",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp3" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp4",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp4" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp5",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp5" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llpe0",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpe0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llpeb",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpeb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt0",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt1",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt2",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt0w",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt1w",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt2w",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldrout",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldsub",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvth0",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvtho",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lua",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lua1",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lub",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lub1",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "luc",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "luc1",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lud",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lud1",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lup",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of up" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llp",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lp" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lu0",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lute",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ute" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lucste",  69, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ucste" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvoff",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lminv",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lminvcv",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minvcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldelta",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrdsw",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrsw",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rsw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrdw",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lprwg",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lprwb",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lprt",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prt" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leta0",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "letab",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0", "-0", "Length dependence of etab" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpclm",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdiblc1",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdiblc2",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdiblcb",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lfprout",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdits",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdits" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpditsd",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pditsd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpscbe1",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpscbe2",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpvag",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwr",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldwg",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldwb",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lb0",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lb1",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgsl",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgsl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgdl",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lckappas",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappas" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lckappad",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappad" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcf",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cf" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lclc",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcle",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cle" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lalpha0",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lalpha1",  394, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbeta0",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lagidl",  397, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbgidl",  398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgidl",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrgidl",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkgidl",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lfgidl",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "legidl",  399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egidl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lagisl",  1204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbgisl",  1205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgisl",  1207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrgisl",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkgisl",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lfgisl",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "legisl",  1206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egisl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigc",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigc",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigc",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigsd",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigsd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigsd",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigsd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigsd",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigsd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigs",  1223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigs",  1224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigs",  1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigd",  1235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigd",  1236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigd",  1237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigbacc",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigbacc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigbacc",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigbacc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigbacc",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigbacc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigbinv",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigbinv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigbinv",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigbinv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigbinv",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigbinv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnigc",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnigbinv",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigbinv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnigbacc",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigbacc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lntox",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntox" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leigbinv",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for eigbinv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpigcd",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for pigcd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpoxedge",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for poxedge" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvfbcv",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvfb",  395, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lacde",  390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lmoin",  391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of moin" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnoff",  392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of noff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvoffcv",  396, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voffcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxrcrg1",  400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrcrg1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxrcrg2",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrcrg2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llambda",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lambda" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvtl",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtl" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxn",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xn" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leu",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eu" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lucs",  73, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lucs" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvfbsdoff",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbsdoff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltvfbsdoff",  1052, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tvfbsdoff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltvoff",  1051, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tvoff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltnfactor",  1260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tnfactor" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lteta0",  1261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of teta0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltvoffcv",  1262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tvoffcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcdsc",  481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcdscb",  482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcdscd",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcit",  483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnfactor",  484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxj",  485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xj" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvsat",  486, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wat",  487, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of at" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wa0",  488, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wags",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wa1",  489, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wa2",  490, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wketa",  491, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnsub",  492, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wndep",  493, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndep" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnsd",  594, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsd" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wphin",  591, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of phin" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wngate",  495, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wgamma1",  496, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wgamma2",  497, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvbx",  498, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbx" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvbm",  500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbm" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxt",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xt" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkt1",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkt1l",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1l" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkt2",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk2",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk3",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk3b",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ww0",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp0",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp1",  589, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp2",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp3",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp3" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp4",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp4" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp5",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp5" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlpe0",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpe0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlpeb",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpeb" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt0",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt1",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt2",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt0w",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt1w",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt2w",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdrout",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdsub",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvth0",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvtho",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, R(), "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wua",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wua1",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wub",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wub1",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wuc",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wuc1",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wud",  619, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wud1",  620, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud1" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wup",  621, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of up" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlp",  622, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lp" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wu0",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wute",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ute" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wucste",  70, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucste" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvoff",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wminv",  583, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of minv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wminvcv",  623, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of minvcv" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdelta",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrdsw",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrsw",  592, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rsw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrdw",  593, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdw" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wprwg",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, SIM_MODEL::PARAM::FLAGS(), "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
        modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wprwb",  556, SIM_MODEL: