/////////////////////////////////////////////////////////////////////////////
// Name:        setpage.h
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     13/11/2007 09:11:27
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

/* The "Page Settings" dialog box created by this file (and setpage.cpp)
 * contains seven checkboxes which *are* provided when that dialog box is
 * invoked in EESchema, but which are *not* provided when that dialog box is
 * invoked in Pcbnew instead. As such, various lines within this file
 * (and setpage.cpp) are included on an appropriately conditional basis.
 * (That aspect should be noted if the contents of this file (and setpage.cpp)
 * are ever consequently modified as a consequence of setpage.pjd being
 * opened in DialogBlocks (as that file now incorporates those checkboxes).)
 */

// Generated by DialogBlocks (unregistered), 13/11/2007 09:11:27

#ifndef _SETPAGE_H_
#define _SETPAGE_H_

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma interface "setpage.h"
#endif

/*!
 * Includes
 */

////@begin includes
#include "wx/valgen.h"
#include "wx/valtext.h"
#include "wx/statline.h"
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxBoxSizer;
class wxFlexGridSizer;
class wxStaticLine;
class wxStdDialogButtonSizer;
////@end forward declarations

/*!
 * Control identifiers
 */

// NOTE: The following code has been modified by listing the seven checkbox-
// related definitions *only* within the EESchema version of this dialog box.

////@begin control identifiers
#define ID_DIALOG 10000
#define ID_RADIOBOX_PAGE_SIZE 10001
#define ID_TEXTCTRL_USER_PAGE_SIZE_X 10002
#define ID_TEXTCTRL_USER_PAGE_SIZE_Y 10003
#define ID_TEXTCTRL_REVISION 10004
#define ID_TEXTCTRL_TITLE 10005
#define ID_TEXTCTRL_COMPANY 10006
#define ID_TEXTCTRL_COMMENT1 10007
#define ID_TEXTCTRL_COMMENT2 10008
#define ID_TEXTCTRL_COMMENT3 10009
#define ID_TEXTCTRL_COMMENT4 10010

#ifdef EESCHEMA
#define ID_CHECKBOX_REVISION 10011
#define ID_CHECKBOX_TITLE 10012
#define ID_CHECKBOX_COMPANY 10013
#define ID_CHECKBOX_COMMENT1 10014
#define ID_CHECKBOX_COMMENT2 10015
#define ID_CHECKBOX_COMMENT3 10016
#define ID_CHECKBOX_COMMENT4 10017
#endif

#define ID_STATICLINE 10018
#define SYMBOL_WINEDA_SETPAGEFRAME_STYLE wxDEFAULT_DIALOG_STYLE|MAYBE_RESIZE_BORDER
#define SYMBOL_WINEDA_SETPAGEFRAME_TITLE _("Page Settings")
#define SYMBOL_WINEDA_SETPAGEFRAME_IDNAME ID_DIALOG
#define SYMBOL_WINEDA_SETPAGEFRAME_SIZE wxSize(400, 300)
#define SYMBOL_WINEDA_SETPAGEFRAME_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * WinEDA_SetPageFrame class declaration
 */

class WinEDA_SetPageFrame: public wxDialog
{    
    DECLARE_DYNAMIC_CLASS( WinEDA_SetPageFrame )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    WinEDA_SetPageFrame( );
    WinEDA_SetPageFrame( WinEDA_DrawFrame* parent,
                         wxWindowID id = SYMBOL_WINEDA_SETPAGEFRAME_IDNAME,
                         const wxString& caption = SYMBOL_WINEDA_SETPAGEFRAME_TITLE,
                         const wxPoint& pos = SYMBOL_WINEDA_SETPAGEFRAME_POSITION,
                         const wxSize& size = SYMBOL_WINEDA_SETPAGEFRAME_SIZE,
                         long style = SYMBOL_WINEDA_SETPAGEFRAME_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_WINEDA_SETPAGEFRAME_IDNAME,
                 const wxString& caption = SYMBOL_WINEDA_SETPAGEFRAME_TITLE,
                 const wxPoint& pos = SYMBOL_WINEDA_SETPAGEFRAME_POSITION,
                 const wxSize& size = SYMBOL_WINEDA_SETPAGEFRAME_SIZE,
                 long style = SYMBOL_WINEDA_SETPAGEFRAME_STYLE );

    /// Destructor
    ~WinEDA_SetPageFrame();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin WinEDA_SetPageFrame event handler declarations
    /// wxEVT_CLOSE_WINDOW event handler for ID_DIALOG
    void OnCloseWindow( wxCloseEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
    void OnOkClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
    void OnCancelClick( wxCommandEvent& event );

////@end WinEDA_SetPageFrame event handler declarations

////@begin WinEDA_SetPageFrame member function declarations
    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end WinEDA_SetPageFrame member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

    void SearchPageSizeSelection();
    void SavePageSettings(wxCommandEvent& event);
    void ReturnSizeSelected(wxCommandEvent& event);

// NOTE: The following code has been modified by listing the seven
// checkboxes *only* within the EESchema version of this dialog box.

////@begin WinEDA_SetPageFrame member variables
    wxBoxSizer* OuterSizer;
    wxBoxSizer* MainSizer;
    wxFlexGridSizer* LeftColumnSizer;
    wxRadioBox* m_PageSizeBox;
    wxBoxSizer* UserSizeXSizer;
    wxStaticText* UserPageSizeX;
    wxTextCtrl* m_TextUserSizeX;
    wxBoxSizer* UserSizeYSizer;
    wxStaticText* UserPageSizeY;
    wxTextCtrl* m_TextUserSizeY;
    wxFlexGridSizer* RightColumnSizer;
    wxBoxSizer* SheetInfoSizer;
    wxStaticText* m_TextSheetCount;
    wxStaticText* m_TextSheetNumber;
    wxStaticBoxSizer* RevisionSizer;
    wxTextCtrl* m_TextRevision;
    wxStaticBoxSizer* TitleSizer;
    wxTextCtrl* m_TextTitle;
    wxStaticBoxSizer* CompanySizer;
    wxTextCtrl* m_TextCompany;
    wxStaticBoxSizer* Comment1Sizer;
    wxTextCtrl* m_TextComment1;
    wxStaticBoxSizer* Comment2Sizer;
    wxTextCtrl* m_TextComment2;
    wxStaticBoxSizer* Comment3Sizer;
    wxTextCtrl* m_TextComment3;
    wxStaticBoxSizer* Comment4Sizer;
    wxTextCtrl* m_TextComment4;
    wxStaticLine* Line;
    wxStdDialogButtonSizer* StdDialogButtonSizer;
    wxButton* Button_OK;
    wxButton* Button_Cancel;

#ifdef EESCHEMA
    wxCheckBox* m_RevisionExport;
    wxCheckBox* m_TitleExport;
    wxCheckBox* m_CompanyExport;
    wxCheckBox* m_Comment1Export;
    wxCheckBox* m_Comment2Export;
    wxCheckBox* m_Comment3Export;
    wxCheckBox* m_Comment4Export;
#endif

////@end WinEDA_SetPageFrame member variables

    WinEDA_DrawFrame *m_ParentDrawFrame;
    BASE_SCREEN * m_Screen;
    int m_Modified;
    Ki_PageDescr * m_SelectedSheet;
    float UserSizeX, UserSizeY;
    int m_CurrentSelection;
};

#endif
    // _SETPAGE_H_
