/***************************************************************************
begin                : Mon Jan 28 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFDOC_H
#define KMFDOC_H

//project includes
#include "iptchain.h"
#include "iptrule.h"
#include "iptruleoption.h"
#include "iptable.h"
#include "netfilterobject.h"

// qt includes
#include "qdict.h"
#include "qvaluelist.h"
#include "qptrlist.h"
#include "qstring.h"
#include "qobject.h"

// kde includes
#include "kurl.h"

/**
  *@author Christian Hubinger
  */
class KMFErrorHandler;
class KMFError;
class KURL;


//############# Start class KMFDoc ###############
/**
	KMFDoc is the base class for all document classes in KMyFirewall.
	It provides the most common features a document class should have
	e.g. undo/redo setUrl() setFilename() etc. and lots of abstarct methods
	that need to be implemented by a document class.
*/

class KDE_EXPORT KMFDoc : public QObject {
	Q_OBJECT
	//############# Beginn static stuff ##############
protected:
	static uint MAX_UNDO;
public:
	/** Set the numbers of undo/redo steps stored */
	static void setMaxUndo( uint );
	/** Get the numbers of undo/redo steps stored */
	static uint maxUndo() {
		return MAX_UNDO;
	};
	//############# End static stuff ##############
public:
	KMFDoc( QObject*, const char* );
	virtual ~KMFDoc();


	/** resets the document to the initial values */
	virtual void clear() = 0;

	/** return a QString containing the documents script to 
		setup the firewall configuration */
	virtual const QString& compile() = 0;
	
	/** Writes the xml-representation of this document a String and returns it. */
	virtual const QString& getXMLRuleset();

	/** return true if the document is in it's initial state */
	virtual bool isEmpty() = 0;

	/** Return DomDocument of this Chain */
	virtual const QDomDocument& getDOMTree() = 0;

	/** Return String representation of the DomDocument generated by const QDomDocument& getDOMTree() */
	virtual const QString& getXMLSniplet();

	/** Load configuratuion from the QDomDocument */
	virtual void loadXML( const QDomDocument& ) = 0;

	/** Save the rule set to the given file defined by the KURL */
	KMFError* exportXMLRuleset( const KURL& );

	/** Load the ruleset from the given url */
	virtual KMFDoc* parseXMLRuleset( const KURL& ) = 0;



	/** return the documents KURL pointer */
	const KURL& url() const {
		return m_url;
	};

	/** set the Documents url */
	void setUrl( const KURL& url );

	/** set the Documents url */
	void setFileName( const QString& );
	
	/** Set Description for this Object */
	virtual void setDescription( const QString& );
	
	/** Return the Object's Description */
	const QString description() const {
		return m_description;
	};
	
	/** Set Name for this Object */
	virtual void setName( const QString& );
	
	/** Return the Object's Description */
	const QString name() const {
		return m_name;
	};
	
	/** update the View */
	void updateView();
	
	/** Check if the doc is saved */
	bool isSaved();
	void saved();
	
	/** When called the state is changed to unsaved */
	void changed();

	/** store the provided id in the changes list. */
	void changed( int id );

	/** Start a transaction e.g. collection of changes that will
		be tracked to allow undo/redo */
	void startTransaction();
	
	/** End a transaction e.g. collection of changes that will
		be tracked to allow undo/redo */
	void endTransaction();
	
	/** Check if we are inside a transaction */
	bool inTransaction() const {
		return m_in_transaction;
	};

	void undo();
	void redo();

protected:
	virtual void initDoc() = 0;

	KURL m_url;

	KMFErrorHandler *m_err_handler;
	KMFError *m_err;

	protected: bool is_saved;
	protected: bool m_in_transaction;
	protected: QString m_description;
	protected: QString m_name;
	protected: QValueList<QValueList<int> > m_undo_transactions;
	protected: QValueList<QValueList<int> > m_redo_transactions;
	protected: QValueList<int> m_changed_objects;

signals:
	void documentChanged();
	void documentChanged( KMFDoc* );
	void sigEnableUndo( bool );
	void sigEnableRedo( bool );

};





#endif
