//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterface.h"

// qt includes
#include <qstring.h>
#include <qlayout.h>
#include <qtabwidget.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>


// project includes
#include "../core/kmfgenericdoc.h"

#include "kmfgenericinterfaceprotocol.h"
#include "kmfgenericinterfaceeditprotocol.h"
#include "kmfgenericinterfacenat.h"
#include "kmfgenericinterfacehost.h"
#include "kmfgenericinterfacelogging.h"
#include "kmfgenericinterfaceicmp.h"


KMFGenericInterface::KMFGenericInterface( QWidget *parent, const char *name ) : KJanusWidget( parent, name,  KJanusWidget::IconList ) {
	connect( this,SIGNAL( aboutToShowPage( QWidget* ) ),
		this,SLOT( slotPageChanged( QWidget* ) ) );
	loadIcons();
	//###################### Access Control PAGE #################################
	protocolFrame = addPage(i18n("Access Control"), i18n("Access configuration for incoming and outgoing connection"), icon_protocol_page );

	m_protocolPageZones = new KMFGenericInterfaceProtocol( protocolFrame, "m_protocolPageIncoming");
	m_protocolPageZones->setType( KMFGenericInterfaceProtocol::INCOMING );
	QGridLayout *protocoLayout = new QGridLayout( protocolFrame, 1, 1, 2, 2 );
	protocoLayout->addWidget( m_protocolPageZones,0,0 );

	//###################### HOSTS PAGE ###################################
	hostFrame = addPage(i18n("Special Hosts"), i18n("Define Hosts that should be treated specially."), icon_host_page );
	m_hostPage = new KMFGenericInterfaceHost(hostFrame,"m_hostPageTrusted");

	QGridLayout *hostLayout = new QGridLayout( hostFrame, 1, 1, 2, 2 );
	hostLayout->addWidget( m_hostPage,0,0 );

	//###################### ICMP PAGE #################################
	icmpFrame = addPage(i18n("ICMP Options"), i18n("Define how ICMP packets should be handled."), icon_icmp_page );
	QGridLayout *icmpLayout = new QGridLayout( icmpFrame, 1, 1, 2, 2 );
	m_icmpPage = new KMFGenericInterfaceIcmp(icmpFrame,"m_icmpPage");
	icmpLayout->addWidget( m_icmpPage,0,0 );


	//###################### NAT PAGE ###################################
	natFrame = addPage(i18n("NAT Configuration"), i18n("Configure NAT (Network Address Translation) here."), icon_nat_page );
	QGridLayout *natLayout = new QGridLayout( natFrame, 1, 1, 2, 2 );
	m_natPage = new KMFGenericInterfaceNat(natFrame,"m_natPage");
	natLayout->addWidget( m_natPage,0,0 );

	//###################### LOGGING PAGE ###################################
	logFrame = addPage(i18n("Logging"), i18n("Configure your firewall's logging behavior here."), icon_logging_page );
	QGridLayout *logLayout = new QGridLayout( logFrame, 1, 1, 2, 2 );
	m_loggingPage = new KMFGenericInterfaceLogging(logFrame,"m_loggingPage");
	logLayout->addWidget( m_loggingPage,0,0 );
	setEnabled( false );

	//###################### EDIT PROTOCOL PAGE ############################
	// FIXME: Implement
/*	editProtocolFrame = addPage(i18n("Custom Protocols"), i18n("Define your Custom Protocols here"), icon_edit_protocol_page );
	QGridLayout *editProtocolLayout = new QGridLayout( editProtocolFrame, 1, 1, 2, 2 );
	m_protocolPageEditProtocol = new KMFGenericInterfaceEditProtocol( editProtocolFrame ,"m_protocolPageEditProtocol");
	editProtocolLayout->addWidget( m_protocolPageEditProtocol,0,0 );*/
}

KMFGenericInterface::~KMFGenericInterface() {}

void KMFGenericInterface::loadDoc( KMFGenericDoc* doc ) {
	kdDebug() << "void KMFGenericInterface::loadDoc( KMFGenericDoc* )" << endl;
	if ( ! doc )
		return;

	setEnabled( true );
	m_doc = doc;

	m_protocolPageZones->loadDoc( m_doc );
	m_protocolPageZones->slotUpdateView();
	m_hostPage->loadDoc( m_doc );
	m_hostPage->slotUpdateView();

// 	m_zonePageIncoming->loadDoc( m_doc );
// 	m_zonePageIncoming->slotUpdateView();
// 	m_zonePageOutgoing->loadDoc( m_doc );
// 	m_zonePageOutgoing->slotUpdateView();

// 	m_protocolPageEditProtocol->loadDoc( m_doc );
// 	m_protocolPageEditProtocol->slotUpdateView();

	m_icmpPage->loadDoc( m_doc );
	m_icmpPage->slotUpdateView();

// 	m_hostPageTrusted->loadDoc( m_doc );
// 	m_hostPageTrusted->slotUpdateView();
// 	m_hostPageMalicous->loadDoc( m_doc );
// 	m_hostPageMalicous->slotUpdateView();
// 	m_hostPageServers->loadDoc( m_doc );
// 	m_hostPageServers->slotUpdateView();
// 	m_hostPageClients->loadDoc( m_doc );
// 	m_hostPageClients->slotUpdateView();

	m_natPage->loadDoc( m_doc );
	m_natPage->slotUpdateView();

	m_loggingPage->loadDoc( m_doc );
	m_loggingPage->slotUpdateView();
}

void KMFGenericInterface::slotUpdateView() {
		m_protocolPageZones->slotUpdateView();
// 		m_protocolPageEditProtocol->slotUpdateView();
		m_hostPage->slotUpdateView();

		m_icmpPage->slotUpdateView();

// 		m_hostPageTrusted->slotUpdateView();
// 		m_hostPageMalicous->slotUpdateView();
// 		m_hostPageServers->slotUpdateView();
// 		m_hostPageClients->slotUpdateView();

		m_natPage->slotUpdateView();

		m_loggingPage->slotUpdateView();
}

void KMFGenericInterface::slotPageChanged( QWidget* /*wid*/ ){
	slotUpdateView();
// FIXME: Reenable widget specific updates
// 	if ( wid == zoneFrame ) {
// 		m_zonePageIncoming->slotUpdateView();
// 		m_zonePageOutgoing->slotUpdateView();
// 	}
// 	if ( wid == protocolFrame ) {
// 		m_protocolPageIncoming->slotUpdateView();
// 		m_protocolPageOutgoing->slotUpdateView();
// 	}
// 	if ( wid ==icmpFrame ) {
// 		m_icmpPage->slotUpdateView();
// 	}
//
// 	if ( wid == hostFrame ) {
// 		m_hostPageTrusted->slotUpdateView();
// 		m_hostPageMalicous->slotUpdateView();
// 		m_hostPageServers->slotUpdateView();
// 		m_hostPageClients->slotUpdateView();
// 	}
//
// 	if ( wid == natFrame ) {
// 		m_natPage->slotUpdateView();
// 	}
// 	if ( wid == logFrame ) {
// 		m_loggingPage->slotUpdateView();
// 	}

}

void KMFGenericInterface::loadIcons() {
	kdDebug() << "void KMFGenericInterface::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "network";
	icon_zone_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "services";
	icon_protocol_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "nfs_unmount";
	icon_edit_protocol_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "pipe";
	icon_icmp_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "log";
	icon_logging_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "network_local";
	icon_host_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "filesaveas";
	icon_nat_page = loader->loadIcon( icon_name, KIcon::Desktop );
}

#include "kmfgenericinterface.moc"
