/***************************************************************************
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFIPTINSTALLER_H
#define KMFIPTINSTALLER_H
#include <qobject.h>
#include <qpixmap.h>

#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>



#include "../../interfaces/kmfplugin.h"
#include "../../interfaces/kmfiptinstallerinterface.h"

#include "../../kmyfirewall.h"




class QString;
class QLabel;
class QPushButton;
class QGridLayout;
class KMFProcOut;
class KMFError;
class KMFErrorHandler;
class KTempFile;

class KMFIPTInstaller :  public KMFPlugin, public KMFIPTInstallerInterface {
	Q_OBJECT

public:
	KMFIPTInstaller( QObject* parent = 0, const char* name = 0 );
	~KMFIPTInstaller();
	// void loadDoc( KMFIPTDoc *doc );
	
	void loadScript( const QString& );
	
	QString cmdRunFW();
	QString cmdStopFW();
	QString cmdShowScript();
	QString cmdInstallFW();
	QString cmdUninstallFW();
	QString cmdShowRunningConfig( const QString& );
	void generateInstallerPackage( const KURL& );


public slots:
	void slotCloseWindow();
	void slotJobFinished( bool, const QString& );

private:    // functions
/* 	void initGUI(); */
	void loadIcons();
	KMFProcOut* execWidget();
	KMFError* createInitScript( const QString& file, const QString& systemtype );
	KMFError* createFirewallScript( const QString& file );
	
	const QString& KDEsuCMD() const {
		return m_kdesuCommand;
	}
	
	QString cmdShowAll();
	QString cmdShowFilter();
	QString cmdShowNat();
	QString cmdShowMangle();
	
	void parseFileHeaders( const QString& source_file_path, const QString& target_file_path ); 
	
private:    // data
	QString m_script;
	QString m_kdesuCommand;
	bool fw_is_running;
	QLabel *m_lrun;
	QLabel *m_lshow;
	QLabel *m_lconf;
	QLabel *m_linstall;
	QPushButton *m_brun_fw;
	QPushButton *m_bstop_fw;
	QPushButton *m_bshow_sript;
	QPushButton *m_bshow_all;
	QPushButton *m_bshow_filter;
	QPushButton *m_bshow_nat;
	QPushButton *m_bshow_mangle;
	QPushButton *m_binstall;
	QPushButton *m_buninstall;
	QPushButton *m_bclose;
	QGridLayout *m_layout;
	QPixmap icon_run, icon_stop, icon_show;
//	KMFIPTDoc *m_doc;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KTempFile *temp_file, *temp_file2;
	KMFProcOut *m_execWidget;
	
	
	
signals:
	void sigStatusChanged();
	void sigHideMe();
	void sigShowMe();
};


class KInstance;

class KMFIPTInstallerFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFIPTInstallerFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFIPTInstallerFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};


#endif // KMFIPTINSTALLER_H
