/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/

#ifndef _KMFIPTEDITORPART_H_
#define _KMFIPTEDITORPART_H_

#include <kparts/part.h>
#include <kparts/factory.h>

class QWidget;
class QPainter;
class KURL;
class KMFRuleEdit;
class KMFIPTDoc;
class KAction;
class KActionMenu;
class KMFIPTDocOptions;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Chris <chubinger@gmail.com>
 * @version 0.1
 */
class KMFIPTEditorPart : public KParts::ReadWritePart
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    KMFIPTEditorPart(QWidget *parentWidget, const char *widgetName,
                    QObject *parent, const char *name);

    /**
     * Destructor
     */
    virtual ~KMFIPTEditorPart();

    /**
     * This is a virtual function inherited from KParts::ReadWritePart.
     * A shell will use this to inform this Part if it should act
     * read-only
     */
    virtual void setReadWrite(bool rw);

    /**
     * Reimplemented to disable and enable Save action
     */
    virtual void setModified(bool modified);

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();

    /**
     * This must be implemented by each read-write part
     */
    virtual bool saveFile();

public slots:
	void slotEnableActions( bool );

protected slots:
    void fileOpen();
    void fileSaveAs();
	void slotEditChain();
	void slotNewChain();
	void slotDelChain();
	void slotNewRule();
	void slotDelRule();
	void slotEditDocOptions();

private:
    KMFRuleEdit *m_ruleedit;
	KMFIPTDoc* m_doc;
	KMFIPTDocOptions *m_editdoc;
	KAction* m_actionEditChain;
	KAction* m_actionNewChain;
	KAction* m_actionNewRule;
	KAction* m_actionDelChain;
	KAction* m_actionDelRule;
	KAction* m_actionEditDocOptions;
};

class KInstance;
class KAboutData;

class KMFIPTEditorPartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    KMFIPTEditorPartFactory();
    virtual ~KMFIPTEditorPartFactory();
    virtual KParts::Part* createPartObject( QWidget *parentWidget, const char *widgetName,
                                            QObject *parent, const char *name,
                                            const char *classname, const QStringList &args );
    static KInstance* instance();

private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};

#endif // _KMFRULEEDITPART_H_
