//
// C++ Implementation: kmfnetworkwidget
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfnetworkwidget.h"

// QT includes
#include <qlabel.h>

// KDE includes
#include <kdebug.h>
#include <knuminput.h>

// project includes




KMFNetworkWidget::KMFNetworkWidget(QWidget *parent, const char *name)
		: KMyFirewallNetworkWidget(parent, name) {
	m_allowEdit = true;
	connect( m_sb_from_1,SIGNAL( valueChanged( const QString& ) ),
		this,SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_from_2,SIGNAL( valueChanged( const QString& ) ),
		this,SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_from_3,SIGNAL( valueChanged( const QString& ) ),
		this,SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_from_4,SIGNAL( valueChanged( const QString& ) ),
		this,SLOT( slotAddressChanged( const QString& ) ) );
	
	connect( m_sb_mask,SIGNAL( valueChanged( int ) ),
		this,SLOT( slotShortMaskChanged( int ) ) );
}


KMFNetworkWidget::~KMFNetworkWidget() {}


void KMFNetworkWidget::loadZone( KMFNetZone* zone ) {
	blockAllSignals( true );	
	m_zone = zone;
	m_sb_from_1->setEnabled( true );
	m_sb_from_2->setEnabled( true );
	m_sb_from_3->setEnabled( true );
	m_sb_from_4->setEnabled( true );
	m_sb_mask->setEnabled( true );
	
	m_sb_from_1->setValue( zone->address()->getDigit( 0 ) );
	m_sb_from_2->setValue( zone->address()->getDigit( 1 ) );
	m_sb_from_3->setValue( zone->address()->getDigit( 2 ) );
	m_sb_from_4->setValue( zone->address()->getDigit( 3 ) );

	lbl_mask->setText( zone->mask()->toString() );
	
	m_sb_mask->setValue( IPAddress::calcLenthToMask( *zone->mask() ) );
	blockAllSignals( false );	
}

void KMFNetworkWidget::slotAddressChanged( const QString& ) {
	kdDebug() << "void KMFNetworkWidget::slotAddressChanged( const QString& )" << endl;
	blockAllSignals( true );
	if ( m_allowEdit ) {
		m_zone->address()->setAddress( m_sb_from_1->value(), m_sb_from_2->value(), m_sb_from_3->value(), m_sb_from_4->value() );
	}
	blockAllSignals( false );
	emit sigZoneChanged( m_zone );
}
void KMFNetworkWidget::slotLongMaskChanged( const QString& ) {
	kdDebug() << "void KMFNetworkWidget::slotLongMaskChanged( const QString& )" << endl;

}
void KMFNetworkWidget::slotShortMaskChanged( int len ) {
	kdDebug() << "void KMFNetworkWidget::slotShortMaskChanged( const QString& )" << endl;
	IPAddress addr = IPAddress::calcNetworkMaskFromLength( len );
	blockAllSignals( true );
	lbl_mask->setText( addr.toString() );
	if ( m_allowEdit ) {
		m_zone->setMaskLength( len );
	}
	blockAllSignals( false );
	emit sigZoneChanged( m_zone );
}


void KMFNetworkWidget::blockAllSignals( bool onOff ) {
	m_sb_from_1->blockSignals( onOff );
	m_sb_from_2->blockSignals( onOff );
	m_sb_from_3->blockSignals( onOff );
	m_sb_from_4->blockSignals( onOff );
	
	m_sb_mask->blockSignals( onOff );
}	

void KMFNetworkWidget::allowEdit( bool allow ) {
	m_allowEdit = allow;
	m_sb_from_1->setEnabled( allow );
	m_sb_from_2->setEnabled( allow );
	m_sb_from_3->setEnabled( allow );
	m_sb_from_4->setEnabled( allow );
	m_sb_mask->setEnabled( allow );
}






#include "kmfnetworkwidget.moc"
