

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmc" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/Player.h"
#include "interfaces/legacy/RenderCapture.h"
#include "interfaces/legacy/Keyboard.h"
#include "interfaces/legacy/ModuleXbmc.h"
#include "interfaces/legacy/Monitor.h"

using namespace XBMCAddon;
using namespace xbmc;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif


namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Player
  TypeInfo TyXBMCAddon_xbmc_Player_Type(typeid(XBMCAddon::xbmc::Player));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::RenderCapture
  TypeInfo TyXBMCAddon_xbmc_RenderCapture_Type(typeid(XBMCAddon::xbmc::RenderCapture));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagMusic
  TypeInfo TyXBMCAddon_xbmc_InfoTagMusic_Type(typeid(XBMCAddon::xbmc::InfoTagMusic));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagVideo
  TypeInfo TyXBMCAddon_xbmc_InfoTagVideo_Type(typeid(XBMCAddon::xbmc::InfoTagVideo));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Keyboard
  TypeInfo TyXBMCAddon_xbmc_Keyboard_Type(typeid(XBMCAddon::xbmc::Keyboard));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::PlayList
  TypeInfo TyXBMCAddon_xbmc_PlayList_Type(typeid(XBMCAddon::xbmc::PlayList));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Monitor
  TypeInfo TyXBMCAddon_xbmc_Monitor_Type(typeid(XBMCAddon::xbmc::Monitor));
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmc::PlayListItem from another module 
  extern TypeInfo TyXBMCAddon_xbmc_PlayListItem_Type;
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmcgui::ListItem from another module 
  extern TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type;
  //=========================================================================



  //=========================================================================
  // This class is the Director for XBMCAddon::xbmc::Player. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmc_Player_Director : public Director, public XBMCAddon::xbmc::Player
  {
    public:

      inline XBMCAddon_xbmc_Player_Director(int  playerCore ) : XBMCAddon::xbmc::Player( playerCore ) { } 

      virtual void  onPlayBackStarted(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackStarted",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackEnded(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackEnded",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackStopped(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackStopped",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackPaused(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackPaused",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackResumed(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackResumed",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onQueueNextItem(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onQueueNextItem",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSpeedChanged(  int  speed  )
      { 
        PyObject* pyspeed = NULL;
        pyspeed = Py_BuildValue((char*)"i", speed);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSpeedChanged",(char*)"(O)", pyspeed );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSeek(  int  time,  int  seekOffset  )
      { 
        PyObject* pytime = NULL;
        pytime = Py_BuildValue((char*)"i", time);
        PyObject* pyseekOffset = NULL;
        pyseekOffset = Py_BuildValue((char*)"i", seekOffset);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSeek",(char*)"(OO)", pytime , pyseekOffset );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSeekChapter(  int  chapter  )
      { 
        PyObject* pychapter = NULL;
        pychapter = Py_BuildValue((char*)"i", chapter);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSeekChapter",(char*)"(O)", pychapter );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmc::Monitor. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmc_Monitor_Director : public Director, public XBMCAddon::xbmc::Monitor
  {
    public:

      inline XBMCAddon_xbmc_Monitor_Director() : XBMCAddon::xbmc::Monitor() { } 

      virtual void  onSettingsChanged(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onSettingsChanged",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScreensaverActivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScreensaverActivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScreensaverDeactivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScreensaverDeactivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDPMSActivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDPMSActivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDPMSDeactivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDPMSDeactivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScanStarted(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        
pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScanStarted",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScanFinished(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        
pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScanFinished",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDatabaseScanStarted(  XBMCAddon::String const  database  )
      { 
        PyObject* pydatabase = NULL;
        
pydatabase = PyString_FromStringAndSize(database.c_str(), database.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDatabaseScanStarted",(char*)"(O)", pydatabase );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDatabaseUpdated(  XBMCAddon::String const  database  )
      { 
        PyObject* pydatabase = NULL;
        
pydatabase = PyString_FromStringAndSize(database.c_str(), database.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDatabaseUpdated",(char*)"(O)", pydatabase );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onCleanStarted(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        
pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onCleanStarted",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onCleanFinished(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        
pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onCleanFinished",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onAbortRequested(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAbortRequested",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onNotification(  XBMCAddon::String const  sender,  XBMCAddon::String const  method,  XBMCAddon::String const  data  )
      { 
        PyObject* pysender = NULL;
        
pysender = PyString_FromStringAndSize(sender.c_str(), sender.length());

        PyObject* pymethod = NULL;
        
pymethod = PyString_FromStringAndSize(method.c_str(), method.length());

        PyObject* pydata = NULL;
        
pydata = PyString_FromStringAndSize(data.c_str(), data.length());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onNotification",(char*)"(OOO)", pysender , pymethod , pydata );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  PyDoc_STRVAR(log__doc__,
               "log(msg[, level])--Write a string to XBMC's log file and the debug window.\n"
"msg : string - text to output.\n"
"level : [opt] integer - log level to ouput at. (default=LOGNOTICE)\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"Text is written to the log for the following conditions.\n"
"XBMC loglevel == -1 (NONE, nothing at all is logged)\n"
"XBMC loglevel == 0 (NORMAL, shows LOGNOTICE, LOGERROR, LOGSEVERE and LOGFATAL)\n"
"XBMC loglevel == 1 (DEBUG, shows all)\n"
"See pydocs for valid values for level.\n"
"example:\n"
"    - xbmc.log(msg='This is a test string.', level=xbmc.LOGDEBUG));\n");

  static PyObject* xbmc_log (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "msg",
          "level",
          NULL};
         
    char * msg ;         
    int  level  = lLOGNOTICE;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|i",
       (char**)keywords,
         &msg,
         &level
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::log(  msg,  level  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::log\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::log\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(shutdown__doc__,
               "Shutdown()--Shutdown the htpc.\n"
"\n"
"example:\n"
"    - xbmc.shutdown()\n");

  static PyObject* xbmc_shutdown (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::shutdown(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::shutdown\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::shutdown\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(restart__doc__,
               "restart()--Restart the htpc. example:\n"
"    - xbmc.restart()\n");

  static PyObject* xbmc_restart (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::restart(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::restart\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::restart\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(executescript__doc__,
               "executescript(script)--Execute a python script.\n"
"\n"
"script : string - script filename to execute.\n"
"\n"
"example:\n"
"    - xbmc.executescript('special://home/scripts/update.py')\n");

  static PyObject* xbmc_executescript (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "script",
          NULL};
         
    char * script ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &script
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::executescript(  script  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executescript\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executescript\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(executebuiltin__doc__,
               "executebuiltin(function)--Execute a built in XBMC function.\n"
"\n"
"function : string - builtin function to execute.\n"
"\n"
"List of functions -http://kodi.wiki/view/List_of_Built_In_Functions \n"
"\n"
"example:\n"
"    - xbmc.executebuiltin('RunXBE(c:\\avalaunch.xbe)')\n");

  static PyObject* xbmc_executebuiltin (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "function",
          "wait",
          NULL};
         
    char * function ;         
    bool  wait  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &function,
         &wait
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::executebuiltin(  function,  wait  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executebuiltin\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executebuiltin\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(executeJSONRPC__doc__,
               "executeJSONRPC(jsonrpccommand)--Execute an JSONRPC command.\n"
"\n"
"jsonrpccommand : string - jsonrpc command to execute.\n"
"\n"
"List of commands -\n"
"\n"
"example:\n"
"    - response = xbmc.executeJSONRPC('{ \"jsonrpc\": \"2.0\", \"method\": \"JSONRPC.Introspect\", \"id\": 1 }')\n");

  static PyObject* xbmc_executeJSONRPC (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "jsonrpccommand",
          NULL};
         
    char * jsonrpccommand ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &jsonrpccommand
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::executeJSONRPC(  jsonrpccommand  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executeJSONRPC\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executeJSONRPC\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(sleep__doc__,
               "sleep(time)--Sleeps for 'time' msec.\n"
"\n"
"time : integer - number of msec to sleep.\n"
"\n"
"*Note, This is useful if you have for example aPlayer class that is waiting\n"
"for onPlayBackEnded() calls.\n"
"Throws: PyExc_TypeError, if time is not an integer.\n"
"\n"
"example:\n"
"    - xbmc.sleep(2000) # sleeps for 2 seconds\n");

  static PyObject* xbmc_sleep (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "timemillis",
          NULL};
         
    long  timemillis ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &timemillis
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::sleep(  timemillis  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::sleep\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::sleep\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getLocalizedString__doc__,
               "getLocalizedString(id)--Returns a localized 'unicode string'.\n"
"\n"
"id : integer - id# for string you want to localize.\n"
"\n"
"*Note, See strings.xml in }\\ for which id\n"
"you need for a string.\n"
"\n"
"example:\n"
"    - locstr = xbmc.getLocalizedString(6)\n");

  static PyObject* xbmc_getLocalizedString (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    int  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getLocalizedString(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getLocalizedString\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getLocalizedString\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");


    return result; 
  } 

  PyDoc_STRVAR(getSkinDir__doc__,
               "getSkinDir()--Returns the active skin directory as a string.\n"
"\n"
"*Note, This is not the full path like 'special://home/addons/MediaCenter', but only 'MediaCenter'.\n"
"\n"
"example:\n"
"    - skindir = xbmc.getSkinDir()\n");

  static PyObject* xbmc_getSkinDir (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getSkinDir(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getSkinDir\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getSkinDir\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getLanguage__doc__,
               "getLanguage([format], [region])--Returns the active language as a string.\n"
"\n"
"format: [opt] format of the returned language string\n"
"    - xbmc.ISO_639_1: two letter code as defined in ISO 639-1\n"
"    - xbmc.ISO_639_2: three letter code as defined in ISO 639-2/T or ISO 639-2/B\n"
"    - xbmc.ENGLISH_NAME: full language name in English (default)\n"
"\n"
"\n"
"region: [opt] append the region delimited by \"-\" of the language (setting) to the returned language string\n"
"\n"
"example:\n"
"    - language = xbmc.getLanguage(xbmc.ENGLISH_NAME)\n");

  static PyObject* xbmc_getLanguage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "format",
          "region",
          NULL};
         
    int  format  = CLangCodeExpander::ENGLISH_NAME;         
    bool  region  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|ib",
       (char**)keywords,
         &format,
         &region
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getLanguage(  format,  region  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getLanguage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getLanguage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getIPAddress__doc__,
               "getIPAddress()--Returns the current ip address as a string.\n"
"\n"
"example:\n"
"    - ip = xbmc.getIPAddress()\n");

  static PyObject* xbmc_getIPAddress (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getIPAddress(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getIPAddress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getIPAddress\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getDVDState__doc__,
               "getDVDState()--Returns the dvd state as an integer.\n"
"\n"
"return values are:\n"
"    - 1 : xbmc.DRIVE_NOT_READY\n"
"    - 16 : xbmc.TRAY_OPEN\n"
"    - 64 : xbmc.TRAY_CLOSED_NO_MEDIA\n"
"    - 96 : xbmc.TRAY_CLOSED_MEDIA_PRESENT\n"
"\n"
"\n"
"example:\n"
"    - dvdstate = xbmc.getDVDState()\n");

  static PyObject* xbmc_getDVDState (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmc::getDVDState(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getDVDState\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getDVDState\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getFreeMem__doc__,
               "getFreeMem()--Returns the amount of free memory in MB as an integer.\n"
"\n"
"example:\n"
"    - freemem = xbmc.getFreeMem()\n");

  static PyObject* xbmc_getFreeMem (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmc::getFreeMem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getFreeMem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getFreeMem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getInfoLabel__doc__,
               "getInfoLabel(infotag)--Returns an InfoLabel as a string.\n"
"\n"
"infotag : string - infoTag for value you want returned.\n"
"\n"
"List of InfoTags -http://kodi.wiki/view/InfoLabels \n"
"\n"
"example:\n"
"    - label = xbmc.getInfoLabel('Weather.Conditions')\n");

  static PyObject* xbmc_getInfoLabel (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "cLine",
          NULL};
         
    char * cLine ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &cLine
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getInfoLabel(  cLine  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getInfoImage__doc__,
               "getInfoImage(infotag)--Returns a filename including path to the InfoImage's thumbnail as a string.\n"
"\n"
"infotag : string - infotag for value you want returned.\n"
"\n"
"List of InfoTags -http://kodi.wiki/view/InfoLabels \n"
"\n"
"example:\n"
"    - filename = xbmc.getInfoImage('Weather.Conditions')\n");

  static PyObject* xbmc_getInfoImage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "infotag",
          NULL};
         
    char * infotag ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &infotag
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getInfoImage(  infotag  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(playSFX__doc__,
               "playSFX(filename,[useCached])--Plays a wav file by filename\n"
"\n"
"filename : string - filename of the wav file to play.\n"
"useCached : [opt] bool - False = Dump any previously cached wav associated with filename\n"
"\n"
"example:\n"
"    - xbmc.playSFX('special://xbmc/scripts/dingdong.wav')\n"
"\n"
"    - xbmc.playSFX('special://xbmc/scripts/dingdong.wav',False)\n");

  static PyObject* xbmc_playSFX (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          "useCached",
          NULL};
         
    char * filename ;         
    bool  useCached  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &filename,
         &useCached
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::playSFX(  filename,  useCached  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::playSFX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::playSFX\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(stopSFX__doc__,
               "stopSFX()--Stops wav file\n"
"\n"
"example:\n"
"    - xbmc.stopSFX()\n");

  static PyObject* xbmc_stopSFX (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::stopSFX(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::stopSFX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::stopSFX\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(enableNavSounds__doc__,
               "enableNavSounds(yesNo)--Enables/Disables nav sounds\n"
"\n"
"yesNo : integer - enable (True) or disable (False) nav sounds\n"
"\n"
"example:\n"
"    - xbmc.enableNavSounds(True)\n");

  static PyObject* xbmc_enableNavSounds (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "yesNo",
          NULL};
         
    bool  yesNo ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &yesNo
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::enableNavSounds(  yesNo  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::enableNavSounds\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::enableNavSounds\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getCondVisibility__doc__,
               "getCondVisibility(condition)--Returns True (1) or False (0) as a bool.\n"
"\n"
"condition : string - condition to check.\n"
"\n"
"List of Conditions -http://kodi.wiki/view/List_of_Boolean_Conditions \n"
"\n"
"*Note, You can combine two (or more) of the above settings by using \"+\" as an AND operator,\n"
"\"|\" as an OR operator, \"!\" as a NOT operator, and \"[\" and \"]\" to bracket expressions.\n"
"example:\n"
"    - visible = xbmc.getCondVisibility('[Control.IsVisible(41) + !Control.IsVisible(12)]')\n");

  static PyObject* xbmc_getCondVisibility (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "condition",
          NULL};
         
    char * condition ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &condition
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::getCondVisibility(  condition  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCondVisibility\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCondVisibility\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getGlobalIdleTime__doc__,
               "getGlobalIdleTime()--Returns the elapsed idle time in seconds as an integer.\n"
"\n"
"example:\n"
"    - t = xbmc.getGlobalIdleTime()\n");

  static PyObject* xbmc_getGlobalIdleTime (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (int )XBMCAddon::xbmc::getGlobalIdleTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getGlobalIdleTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getGlobalIdleTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getCacheThumbName__doc__,
               "getCacheThumbName(path)--Returns a thumb cache filename.\n"
"\n"
"path : string or unicode - path to file\n"
"\n"
"example:\n"
"    - thumb = xbmc.getCacheThumbName('f:\\videos\\movie.avi')\n");

  static PyObject* xbmc_getCacheThumbName (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::getCacheThumbName"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getCacheThumbName(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCacheThumbName\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCacheThumbName\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(makeLegalFilename__doc__,
               "makeLegalFilename(filename[, fatX])--Returns a legal filename or path as a string.\n"
"\n"
"filename : string or unicode - filename/path to make legal\n"
"fatX : [opt] bool - True=Xbox file system(Default)\n"
"*Note, If fatX is true you should pass a full path. If fatX is false only pass the basename of the path.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - filename = xbmc.makeLegalFilename('F: Age: The Meltdown.avi')\n");

  static PyObject* xbmc_makeLegalFilename (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          "fatX",
          NULL};
         
    std::string  filename ;
    PyObject* pyfilename = NULL;         
    bool  fatX  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyfilename,
         &fatX
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyfilename) PyXBMCGetUnicodeString(filename,pyfilename,false,"filename","XBMCAddon::xbmc::makeLegalFilename"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::makeLegalFilename(  filename,  fatX  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::makeLegalFilename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::makeLegalFilename\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(translatePath__doc__,
               "translatePath(path)--Returns the translated path.\n"
"\n"
"path : string or unicode - Path to format\n"
"\n"
"*Note, Only useful if you are coding for both Linux and Windows.\n"
"e.g. Converts 'special://masterprofile/script_data' -> '/home/user/XBMC/UserData/script_data' on Linux.\n"
"\n"
"example:\n"
"    - fpath = xbmc.translatePath('special://masterprofile/script_data')\n");

  static PyObject* xbmc_translatePath (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::translatePath"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::translatePath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::translatePath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::translatePath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getCleanMovieTitle__doc__,
               "getCleanMovieTitle(path[, usefoldername])--Returns a clean movie title and year string if available.\n"
"\n"
"path : string or unicode - String to clean\n"
"bool : [opt] bool - use folder names (defaults to false)\n"
"\n"
"example:\n"
"    - title, year = xbmc.getCleanMovieTitle('/path/to/moviefolder/test.avi', True)\n");

  static PyObject* xbmc_getCleanMovieTitle (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          "usefoldername",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;         
    bool  usefoldername  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pypath,
         &usefoldername
       ))
    {
      return NULL;
    }

    Tuple< XBMCAddon::String ,XBMCAddon::String  >  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::getCleanMovieTitle"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (Tuple< XBMCAddon::String ,XBMCAddon::String  > )XBMCAddon::xbmc::getCleanMovieTitle(  path,  usefoldername  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCleanMovieTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCleanMovieTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    


    int vecSize = apiResult.GetNumValuesSet();
    result = PyTuple_New(vecSize);
    {
      PyObject* pyentry1; 

      if (vecSize > 0)
      {
        std::string & entry1 = apiResult.first();
        {
          
pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());

        }
        PyTuple_SetItem(result, 0, pyentry1);
      }


      if (vecSize > 1)
      {
        std::string & entry1 = apiResult.second();
        {
          
pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());

        }
        PyTuple_SetItem(result, 1, pyentry1);
      }

    }


    return result; 
  } 

  PyDoc_STRVAR(validatePath__doc__,
               "validatePath(path)--Returns the validated path.\n"
"\n"
"path : string or unicode - Path to format\n"
"\n"
"*Note, Only useful if you are coding for both Linux and Windows for fixing slash problems.\n"
"e.g. Corrects 'Z://something' -> 'Z:'\n"
"example:\n"
"    - fpath = xbmc.validatePath(somepath)\n");

  static PyObject* xbmc_validatePath (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::validatePath"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::validatePath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::validatePath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::validatePath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getRegion__doc__,
               "getRegion(id)--Returns your regions setting as a string for the specified id.\n"
"\n"
"id : string - id of setting to return\n"
"\n"
"*Note, choices are (dateshort, datelong, time, meridiem, tempunit, speedunit)You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - date_long_format = xbmc.getRegion('datelong')\n");

  static PyObject* xbmc_getRegion (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    char * id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getRegion(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getRegion\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getRegion\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(getSupportedMedia__doc__,
               "getSupportedMedia(media)--Returns the supported file types for the specific media as a string.\n"
"\n"
"media : string - media type\n"
"\n"
"*Note, media type can be (video, music, picture).The return value is a pipe separated string of filetypes (eg. '.mov|.avi').\n"
"\n"
"   You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - mTypes = xbmc.getSupportedMedia('video')\n");

  static PyObject* xbmc_getSupportedMedia (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "mediaType",
          NULL};
         
    char * mediaType ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &mediaType
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getSupportedMedia(  mediaType  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getSupportedMedia\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getSupportedMedia\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(skinHasImage__doc__,
               "skinHasImage(image)--Returns True if the image file exists in the skin.\n"
"\n"
"image : string - image filename\n"
"\n"
"*Note, If the media resides in a subfolder include it. (eg. home-myfiles\\home-myfiles2.png)You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - exists = xbmc.skinHasImage('ButtonFocusedTexture.png')\n");

  static PyObject* xbmc_skinHasImage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "image",
          NULL};
         
    char * image ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &image
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::skinHasImage(  image  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::skinHasImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::skinHasImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(startServer__doc__,
               "startServer(typ, bStart, bWait)--start or stop a server.\n"
"\n"
"typ : integer - use SERVER_* constants\n"
"bStart : bool - start (True) or stop (False) a server\n"
"bWait : [opt] bool - wait on stop before returning (not supported by all servers)\n"
"returnValue : bool - True or False\n"
"example:\n"
"    - xbmc.startServer(xbmc.SERVER_AIRPLAYSERVER, False)\n");

  static PyObject* xbmc_startServer (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iTyp",
          "bStart",
          "bWait",
          NULL};
         
    int  iTyp ;         
    bool  bStart ;         
    bool  bWait  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ib|b",
       (char**)keywords,
         &iTyp,
         &bStart,
         &bWait
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::startServer(  iTyp,  bStart,  bWait  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::startServer\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::startServer\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(audioSuspend__doc__,
               "audioSuspend()--Suspend Audio engine.\n"
"\n"
"example:\n"
"    - xbmc.audioSuspend()\n");

  static PyObject* xbmc_audioSuspend (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::audioSuspend(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::audioSuspend\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::audioSuspend\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(audioResume__doc__,
               "audioResume()--Resume Audio engine.\n"
"\n"
"example: xbmc.audioResume()\n");

  static PyObject* xbmc_audioResume (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::audioResume(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::audioResume\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::audioResume\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(convertLanguage__doc__,
               "convertLanguage(language, format)--Returns the given language converted to the given format as a string.\n"
"\n"
"language: string either as name in English, two letter code (ISO 639-1), or three letter code (ISO 639-2/T(B)\n"
"\n"
"format: format of the returned language string\n"
"xbmc.ISO_639_1: two letter code as defined in ISO 639-1\n"
"xbmc.ISO_639_2: three letter code as defined in ISO 639-2/T or ISO 639-2/B\n"
"xbmc.ENGLISH_NAME: full language name in English (default)\n"
"example:\n"
"    - language = xbmc.convertLanguage(English, xbmc.ISO_639_2)\n");

  static PyObject* xbmc_convertLanguage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "language",
          "format",
          NULL};
         
    char * language ;         
    int  format ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"si",
       (char**)keywords,
         &language,
         &format
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::convertLanguage(  language,  format  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::convertLanguage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::convertLanguage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    int  playerCore  = EPC_NONE;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|i",
       
         &playerCore
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::Player * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Player *)(&(TyXBMCAddon_xbmc_Player_Type.pythonType) != pytype) ? new XBMCAddon_xbmc_Player_Director( playerCore ) : new XBMCAddon::xbmc::Player(  playerCore  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Player\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Player\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmc_Player_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmc_Player_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_play__doc__,
               "play([item, listitem, windowed, startpos])--Play this item.\n"
"\n"
"item : [opt] string - filename, url or playlist.\n"
"listitem : [opt] listitem - used with setInfo() to set different infolabels.\n"
"windowed : [opt] bool - true=play video windowed, false=play users preference.(default)\n"
"startpos : [opt] int - starting position when playing a playlist. Default = -1\n"
"\n"
"*Note, If item is not given then thePlayer will try to play the current item\n"
"in the current playlist.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"\n"
"    - listitem =xbmcgui.ListItem ('Ironman')\n"
"\n"
"    - listitem.setInfo('video', {'Title': 'Ironman', 'Genre': 'Science Fiction'})\n"
"\n"
"    - xbmc.Player().play(url, listitem, windowed)\n"
"\n"
"    - xbmc.Player().play(playlist, listitem, windowed, startpos)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_play (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          "listitem",
          "windowed",
          "startpos",
          NULL};
         
    Alternative< XBMCAddon::String ,PlayList const * >  item  = Player::defaultPlayParameter;
    PyObject* pyitem = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem  = NULL;
    PyObject* pylistitem = NULL;         
    bool  windowed  = false;         
    int  startpos  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OObi",
       (char**)keywords,
         &pyitem,
         &pylistitem,
         &windowed,
         &startpos
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyitem;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,false,"entry0_1","play");
        item.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          PlayList * entry1_1;
          entry1_1 = (PlayList *)retrieveApiInstance(pyentry_1,"p.PlayList","XBMCAddon::xbmc::","play");
          item.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.PlayList" );
        }
      }
    }

      
 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","play"); 

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"play","XBMCAddon::xbmc::Player"))-> play(  item,  listitem,  windowed,  startpos  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"play\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"play\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_stop__doc__,
               "stop() --Stop playing.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_stop (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"stop","XBMCAddon::xbmc::Player"))-> stop(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"stop\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"stop\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_pause__doc__,
               "pause() --Pause or resume playing if already paused.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_pause (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"pause","XBMCAddon::xbmc::Player"))-> pause(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"pause\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"pause\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playnext__doc__,
               "playnext() --Play next item in playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playnext (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"playnext","XBMCAddon::xbmc::Player"))-> playnext(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playnext\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playnext\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playprevious__doc__,
               "playprevious() --Play previous item in playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playprevious (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"playprevious","XBMCAddon::xbmc::Player"))-> playprevious(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playprevious\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playprevious\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playselected__doc__,
               "playselected() --Play a certain item from the current playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playselected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    int  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"playselected","XBMCAddon::xbmc::Player"))-> playselected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playselected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playselected\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackStarted__doc__,
               "onPlayBackStarted() --onPlayBackStarted method.\n"
"\n"
"Will be called when xbmc starts playing a file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackStarted","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackStarted(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackEnded__doc__,
               "onPlayBackEnded() --onPlayBackEnded method.\n"
"\n"
"Will be called when xbmc stops playing a file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackEnded (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackEnded","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackEnded(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackEnded\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackEnded\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackStopped__doc__,
               "onPlayBackStopped() --onPlayBackStopped method.\n"
"\n"
"Will be called when user stops xbmc playing a file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackStopped (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackStopped","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackStopped(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackStopped\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackStopped\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackPaused__doc__,
               "onPlayBackPaused() --onPlayBackPaused method.\n"
"\n"
"Will be called when user pauses a playing file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackPaused (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackPaused","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackPaused(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackPaused\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackPaused\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackResumed__doc__,
               "onPlayBackResumed() --onPlayBackResumed method.\n"
"\n"
"Will be called when user resumes a paused file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackResumed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackResumed","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackResumed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackResumed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackResumed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onQueueNextItem__doc__,
               "onQueueNextItem() --onQueueNextItem method.\n"
"\n"
"Will be called when user queues the next item\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onQueueNextItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onQueueNextItem","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onQueueNextItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onQueueNextItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onQueueNextItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackSpeedChanged__doc__,
               "onPlayBackSpeedChanged(speed)--onPlayBackSpeedChanged method.\n"
"\n"
"speed : integer - current speed of player.\n"
"\n"
"*Note, negative speed means player is rewinding, 1 is normal playback speed.\n"
"\n"
"Will be called when players speed changes. (eg. user FF/RW)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSpeedChanged (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "speed",
          NULL};
         
    int  speed ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &speed
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackSpeedChanged","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSpeedChanged(  speed  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSpeedChanged\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSpeedChanged\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackSeek__doc__,
               "onPlayBackSeek(time, seekOffset)--onPlayBackSeek method.\n"
"\n"
"time : integer - time to seek to.\n"
"seekOffset : integer - ?.\n"
"\n"
"Will be called when user seeks to a time\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSeek (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "time",
          "seekOffset",
          NULL};
         
    int  time ;         
    int  seekOffset ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii",
       (char**)keywords,
         &time,
         &seekOffset
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackSeek","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSeek(  time,  seekOffset  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSeek\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSeek\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackSeekChapter__doc__,
               "onPlayBackSeekChapter(chapter)--onPlayBackSeekChapter method.\n"
"\n"
"chapter : integer - chapter to seek to.\n"
"\n"
"Will be called when user performs a chapter seek\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSeekChapter (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "chapter",
          NULL};
         
    int  chapter ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &chapter
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackSeekChapter","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSeekChapter(  chapter  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSeekChapter\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSeekChapter\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_isPlaying__doc__,
               "isPlaying() --returns True is xbmc is playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlaying (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlaying","XBMCAddon::xbmc::Player"))-> isPlaying(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlaying\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlaying\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_isPlayingAudio__doc__,
               "isPlayingAudio() --returns True is xbmc is playing an audio file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingAudio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlayingAudio","XBMCAddon::xbmc::Player"))-> isPlayingAudio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingAudio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingAudio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_isPlayingVideo__doc__,
               "isPlayingVideo() --returns True if xbmc is playing a video.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingVideo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlayingVideo","XBMCAddon::xbmc::Player"))-> isPlayingVideo(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingVideo\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getPlayingFile__doc__,
               "getPlayingFile() --returns the current playing file as a string.\n"
"Note: For LiveTV, returns a pvr:// url which is not translatable to an OS specific file or external url\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getPlayingFile (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getPlayingFile","XBMCAddon::xbmc::Player"))-> getPlayingFile(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayingFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayingFile\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getTime__doc__,
               "getTime() --Returns the current time of the current playing media as fractional seconds.\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getTime","XBMCAddon::xbmc::Player"))-> getTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_seekTime__doc__,
               "seekTime() --Seeks the specified amount of time as fractional seconds. The time specified is relative to the beginning of the currently playing media file.\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_seekTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "seekTime",
          NULL};
         
    double  seekTime ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"d",
       (char**)keywords,
         &seekTime
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"seekTime","XBMCAddon::xbmc::Player"))-> seekTime(  seekTime  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"seekTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"seekTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_setSubtitles__doc__,
               "setSubtitles() --set subtitle file and enable subtitlesn\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "subtitleFile",
          NULL};
         
    char * subtitleFile ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &subtitleFile
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"setSubtitles","XBMCAddon::xbmc::Player"))-> setSubtitles(  subtitleFile  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_showSubtitles__doc__,
               "showSubtitles(visible)--enable/disable subtitles\n"
"\n"
"visible : boolean - True for visible subtitles.\n"
"\n"
"example:\n"
"    - xbmc.Player().showSubtitles(True)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_showSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "bVisible",
          NULL};
         
    bool  bVisible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &bVisible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"showSubtitles","XBMCAddon::xbmc::Player"))-> showSubtitles(  bVisible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"showSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"showSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getSubtitles__doc__,
               "getSubtitles() --get subtitle stream name\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getSubtitles","XBMCAddon::xbmc::Player"))-> getSubtitles(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_disableSubtitles__doc__,
               "DisableSubtitles()--disable subtitles\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_disableSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"disableSubtitles","XBMCAddon::xbmc::Player"))-> disableSubtitles(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"disableSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"disableSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getAvailableSubtitleStreams__doc__,
               "getAvailableSubtitleStreams() --get Subtitle stream names\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getAvailableSubtitleStreams (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::vector< XBMCAddon::String  > * apiResult;
    try
    {

      apiResult = (std::vector< XBMCAddon::String  > *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getAvailableSubtitleStreams","XBMCAddon::xbmc::Player"))-> getAvailableSubtitleStreams(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAvailableSubtitleStreams\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAvailableSubtitleStreams\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    


    result = PyList_New(0);

    if (apiResult != NULL)
    { 

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult->begin(); iter != apiResult->end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        
pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());

        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }

    }



    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_setSubtitleStream__doc__,
               "setSubtitleStream(stream)--set Subtitle Stream\n"
"\n"
"stream : int\n"
"\n"
"example:\n"
"    - setSubtitleStream(1)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setSubtitleStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iStream",
          NULL};
         
    int  iStream ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iStream
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"setSubtitleStream","XBMCAddon::xbmc::Player"))-> setSubtitleStream(  iStream  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitleStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitleStream\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getVideoInfoTag__doc__,
               "getVideoInfoTag() --returns the VideoInfoTag of the current playing Movie.\n"
"\n"
"Throws: Exception, if player is not playing a file or current file is not a movie file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getVideoInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    InfoTagVideo * apiResult;
    try
    {

      apiResult = (InfoTagVideo *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getVideoInfoTag","XBMCAddon::xbmc::Player"))-> getVideoInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVideoInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVideoInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getMusicInfoTag__doc__,
               "getMusicInfoTag() --returns the MusicInfoTag of the current playing 'Song'.\n"
"\n"
"Throws: Exception, if player is not playing a file or current file is not a music file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getMusicInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    InfoTagMusic * apiResult;
    try
    {

      apiResult = (InfoTagMusic *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getMusicInfoTag","XBMCAddon::xbmc::Player"))-> getMusicInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getMusicInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getMusicInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getTotalTime__doc__,
               "getTotalTime() --Returns the total time of the current playing media in seconds. This is only accurate to the full second.\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getTotalTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getTotalTime","XBMCAddon::xbmc::Player"))-> getTotalTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTotalTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTotalTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getAvailableAudioStreams__doc__,
               "getAvailableAudioStreams() --get Audio stream names\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getAvailableAudioStreams (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::vector< XBMCAddon::String  > * apiResult;
    try
    {

      apiResult = (std::vector< XBMCAddon::String  > *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getAvailableAudioStreams","XBMCAddon::xbmc::Player"))-> getAvailableAudioStreams(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAvailableAudioStreams\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAvailableAudioStreams\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    


    result = PyList_New(0);

    if (apiResult != NULL)
    { 

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult->begin(); iter != apiResult->end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        
pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());

        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }

    }



    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_setAudioStream__doc__,
               "setAudioStream(stream)--set Audio Stream.\n"
"\n"
"stream : int\n"
"\n"
"example:\n"
"\n"
"\n"
"    - setAudioStream(1)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setAudioStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iStream",
          NULL};
         
    int  iStream ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iStream
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"setAudioStream","XBMCAddon::xbmc::Player"))-> setAudioStream(  iStream  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setAudioStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setAudioStream\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::RenderCapture * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::RenderCapture *)new XBMCAddon::xbmc::RenderCapture(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::RenderCapture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::RenderCapture\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getWidth__doc__,
               "getWidth() --returns width of captured image as set during\n"
"RenderCapture.capture() . Returns 0 prior to calling capture.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getWidth","XBMCAddon::xbmc::RenderCapture"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getHeight__doc__,
               "getHeight() --returns height of captured image as set during\n"
"RenderCapture.capture() . Returns 0 prior to calling capture.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getHeight","XBMCAddon::xbmc::RenderCapture"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getCaptureState__doc__,
               "getCaptureState() --returns processing state of capture request.\n"
"\n"
"The returned value could be compared against the following constants:\n"
"    - xbmc.CAPTURE_STATE_WORKING : Capture request in progress.\n"
"    - xbmc.CAPTURE_STATE_DONE : Capture request done. The image could be retrieved withgetImage() \n"
"    - xbmc.CAPTURE_STATE_FAILED : Capture request failed.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getCaptureState (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getCaptureState","XBMCAddon::xbmc::RenderCapture"))-> getCaptureState(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCaptureState\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCaptureState\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getAspectRatio__doc__,
               "getAspectRatio() --returns aspect ratio of currently displayed video.\n"
"This may be called prior to callingRenderCapture.capture() .\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getAspectRatio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getAspectRatio","XBMCAddon::xbmc::RenderCapture"))-> getAspectRatio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAspectRatio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAspectRatio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getImageFormat__doc__,
               "getImageFormat() --returns format of captured image: 'BGRA' or 'RGBA'.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getImageFormat (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    char * apiResult;
    try
    {

      apiResult = (char *)((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getImageFormat","XBMCAddon::xbmc::RenderCapture"))-> getImageFormat(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getImageFormat\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getImageFormat\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromString(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getImage__doc__,
               "getImage() --returns captured image as a bytearray.\n"
"\n"
"The size of the image isgetWidth() *getHeight() * 4\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XbmcCommons::Buffer  apiResult;
    try
    {

      apiResult = (XbmcCommons::Buffer )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getImage","XBMCAddon::xbmc::RenderCapture"))-> getImage(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    

    result = PyByteArray_FromStringAndSize((char*)apiResult.curPosition(),apiResult.remaining());

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_capture__doc__,
               "capture(width, height [, flags])--issue capture request.\n"
"\n"
"width : Width capture image should be rendered to\n"
"height : Height capture image should should be rendered to\n"
"flags : Optional. Flags that control the capture processing.\n"
"\n"
"The value for 'flags' could be or'ed from the following constants:\n"
"    - xbmc.CAPTURE_FLAG_CONTINUOUS : after a capture is done, issue a new capture request immediately\n"
"    - xbmc.CAPTURE_FLAG_IMMEDIATELY : read out immediately whencapture() is called, this can cause a busy wait\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_capture (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "width",
          "height",
          "flags",
          NULL};
         
    int  width ;         
    int  height ;         
    int  flags  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii|i",
       (char**)keywords,
         &width,
         &height,
         &flags
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"capture","XBMCAddon::xbmc::RenderCapture"))-> capture(  width,  height,  flags  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"capture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"capture\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent__doc__,
               "waitForCaptureStateChangeEvent([msecs])--wait for capture state change event.\n"
"\n"
"msecs : Milliseconds to wait. Waits forever if not specified.\n"
"\n"
"The method will return 1 if the Event was triggered. Otherwise it will return 0.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "msecs",
          NULL};
         
    unsigned int  msecs  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|I",
       (char**)keywords,
         &msecs
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"waitForCaptureStateChangeEvent","XBMCAddon::xbmc::RenderCapture"))-> waitForCaptureStateChangeEvent(  msecs  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"waitForCaptureStateChangeEvent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"waitForCaptureStateChangeEvent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::InfoTagMusic * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagMusic *)new XBMCAddon::xbmc::InfoTagMusic(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagMusic\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagMusic\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getURL__doc__,
               "getURL() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getURL (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getURL","XBMCAddon::xbmc::InfoTagMusic"))-> getURL(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getURL\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getURL\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getTitle__doc__,
               "getTitle() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getTitle","XBMCAddon::xbmc::InfoTagMusic"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getArtist__doc__,
               "getArtist() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getArtist","XBMCAddon::xbmc::InfoTagMusic"))-> getArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getArtist\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getAlbum__doc__,
               "getAlbum() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbum (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getAlbum","XBMCAddon::xbmc::InfoTagMusic"))-> getAlbum(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbum\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbum\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist__doc__,
               "getAlbumArtist() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getAlbumArtist","XBMCAddon::xbmc::InfoTagMusic"))-> getAlbumArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbumArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbumArtist\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getGenre__doc__,
               "getGenre() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getGenre (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getGenre","XBMCAddon::xbmc::InfoTagMusic"))-> getGenre(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getGenre\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getGenre\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getDuration__doc__,
               "getDuration() --returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getDuration (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getDuration","XBMCAddon::xbmc::InfoTagMusic"))-> getDuration(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDuration\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDuration\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getTrack__doc__,
               "getTrack() --returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getTrack (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getTrack","XBMCAddon::xbmc::InfoTagMusic"))-> getTrack(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTrack\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTrack\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getDisc__doc__,
               "getDisc() --returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getDisc (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getDisc","XBMCAddon::xbmc::InfoTagMusic"))-> getDisc(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDisc\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDisc\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getReleaseDate__doc__,
               "getReleaseDate() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getReleaseDate (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getReleaseDate","XBMCAddon::xbmc::InfoTagMusic"))-> getReleaseDate(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getReleaseDate\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getReleaseDate\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getListeners__doc__,
               "getListeners() --returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getListeners (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getListeners","XBMCAddon::xbmc::InfoTagMusic"))-> getListeners(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListeners\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListeners\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getPlayCount__doc__,
               "getPlayCount() --returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getPlayCount (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getPlayCount","XBMCAddon::xbmc::InfoTagMusic"))-> getPlayCount(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayCount\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayCount\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getLastPlayed__doc__,
               "getLastPlayed() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getLastPlayed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getLastPlayed","XBMCAddon::xbmc::InfoTagMusic"))-> getLastPlayed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLastPlayed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLastPlayed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getComment__doc__,
               "getComment() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getComment (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getComment","XBMCAddon::xbmc::InfoTagMusic"))-> getComment(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getComment\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getComment\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic_getLyrics__doc__,
               "getLyrics() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getLyrics (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getLyrics","XBMCAddon::xbmc::InfoTagMusic"))-> getLyrics(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLyrics\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLyrics\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::InfoTagVideo * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagVideo *)new XBMCAddon::xbmc::InfoTagVideo(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagVideo\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getDirector__doc__,
               "getDirector() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getDirector (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getDirector","XBMCAddon::xbmc::InfoTagVideo"))-> getDirector(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDirector\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDirector\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getWritingCredits__doc__,
               "getWritingCredits() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getWritingCredits (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getWritingCredits","XBMCAddon::xbmc::InfoTagVideo"))-> getWritingCredits(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWritingCredits\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWritingCredits\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getGenre__doc__,
               "getGenre() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getGenre (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getGenre","XBMCAddon::xbmc::InfoTagVideo"))-> getGenre(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getGenre\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getGenre\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getTagLine__doc__,
               "getTagLine() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getTagLine (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getTagLine","XBMCAddon::xbmc::InfoTagVideo"))-> getTagLine(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTagLine\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTagLine\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPlotOutline__doc__,
               "getPlotOutline() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlotOutline (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlotOutline","XBMCAddon::xbmc::InfoTagVideo"))-> getPlotOutline(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlotOutline\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlotOutline\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPlot__doc__,
               "getPlot() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlot (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlot","XBMCAddon::xbmc::InfoTagVideo"))-> getPlot(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlot\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlot\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPictureURL__doc__,
               "getPictureURL() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPictureURL (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPictureURL","XBMCAddon::xbmc::InfoTagVideo"))-> getPictureURL(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPictureURL\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPictureURL\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getTitle__doc__,
               "getTitle() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getTitle","XBMCAddon::xbmc::InfoTagVideo"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getVotes__doc__,
               "getVotes() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getVotes (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getVotes","XBMCAddon::xbmc::InfoTagVideo"))-> getVotes(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVotes\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVotes\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getCast__doc__,
               "getCast() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getCast (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getCast","XBMCAddon::xbmc::InfoTagVideo"))-> getCast(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCast\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCast\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getFile__doc__,
               "getFile() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getFile (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getFile","XBMCAddon::xbmc::InfoTagVideo"))-> getFile(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFile\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPath__doc__,
               "getPath() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPath","XBMCAddon::xbmc::InfoTagVideo"))-> getPath(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber__doc__,
               "getIMDBNumber() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getIMDBNumber","XBMCAddon::xbmc::InfoTagVideo"))-> getIMDBNumber(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getIMDBNumber\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getIMDBNumber\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getYear__doc__,
               "getYear() - returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getYear (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getYear","XBMCAddon::xbmc::InfoTagVideo"))-> getYear(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getYear\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getYear\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getRating__doc__,
               "getRating() - returns a float (double where supported)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getRating (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getRating","XBMCAddon::xbmc::InfoTagVideo"))-> getRating(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getRating\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getRating\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPlayCount__doc__,
               "getPlayCount() --returns a integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlayCount (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlayCount","XBMCAddon::xbmc::InfoTagVideo"))-> getPlayCount(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayCount\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayCount\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getLastPlayed__doc__,
               "getLastPlayed() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getLastPlayed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getLastPlayed","XBMCAddon::xbmc::InfoTagVideo"))-> getLastPlayed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLastPlayed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLastPlayed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle__doc__,
               "getOriginalTitle() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getOriginalTitle","XBMCAddon::xbmc::InfoTagVideo"))-> getOriginalTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getOriginalTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getOriginalTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPremiered__doc__,
               "getPremiered() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPremiered (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPremiered","XBMCAddon::xbmc::InfoTagVideo"))-> getPremiered(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPremiered\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPremiered\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getFirstAired__doc__,
               "getFirstAired() - returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getFirstAired (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getFirstAired","XBMCAddon::xbmc::InfoTagVideo"))-> getFirstAired(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFirstAired\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFirstAired\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    std::string  line  = XBMCAddon::emptyString;
    PyObject* pyline = NULL;         
    std::string  heading  = XBMCAddon::emptyString;
    PyObject* pyheading = NULL;         
    bool  hidden  = false;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|OOb",
       
         &pyline,
         &pyheading,
         &hidden
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::Keyboard * apiResult;
    try
    {
      if (pyline) PyXBMCGetUnicodeString(line,pyline,false,"line","Keyboard"); 
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","Keyboard"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Keyboard *)new XBMCAddon::xbmc::Keyboard(  line,  heading,  hidden  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Keyboard\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Keyboard\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_doModal__doc__,
               "doModal([autoclose])--Show keyboard and wait for user action.\n"
"\n"
"autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)\n"
"\n"
"example:\n"
"    - kb.doModal(30000)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_doModal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "autoclose",
          NULL};
         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|i",
       (char**)keywords,
         &autoclose
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"doModal","XBMCAddon::xbmc::Keyboard"))-> doModal(  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"doModal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"doModal\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_setDefault__doc__,
               "setDefault(default)--Set the default text entry.\n"
"\n"
"default : string - default text entry.\n"
"\n"
"example:\n"
"    - kb.setDefault('password')\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setDefault (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "line",
          NULL};
         
    std::string  line  = XBMCAddon::emptyString;
    PyObject* pyline = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|O",
       (char**)keywords,
         &pyline
       ))
    {
      return NULL;
    }


    try
    {
      if (pyline) PyXBMCGetUnicodeString(line,pyline,false,"line","setDefault"); 

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"setDefault","XBMCAddon::xbmc::Keyboard"))-> setDefault(  line  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDefault\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDefault\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_setHiddenInput__doc__,
               "setHiddenInput(hidden)--Allows hidden text entry.\n"
"\n"
"hidden : boolean - True for hidden text entry.\n"
"example:\n"
"    - kb.setHiddenInput(True)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setHiddenInput (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "hidden",
          NULL};
         
    bool  hidden  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|b",
       (char**)keywords,
         &hidden
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"setHiddenInput","XBMCAddon::xbmc::Keyboard"))-> setHiddenInput(  hidden  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHiddenInput\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHiddenInput\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_setHeading__doc__,
               "setHeading(heading)--Set the keyboard heading.\n"
"\n"
"heading : string - keyboard heading.\n"
"\n"
"example:\n"
"    - kb.setHeading('Enter password')\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setHeading (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyheading
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","setHeading"); 

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"setHeading","XBMCAddon::xbmc::Keyboard"))-> setHeading(  heading  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHeading\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHeading\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_getText__doc__,
               "getText() --Returns the user input as a string.\n"
"\n"
"*Note, This will always return the text entry even if you cancel the keyboard.\n"
"Use theisConfirmed() method to check if user cancelled the keyboard.\n"
"\n"
"example:\n"
"    - text = kb.getText()\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"getText","XBMCAddon::xbmc::Keyboard"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_isConfirmed__doc__,
               "isConfirmed() --Returns False if the user cancelled the input.\n"
"\n"
"example:\n"
"    - if (kb.isConfirmed()):\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_isConfirmed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"isConfirmed","XBMCAddon::xbmc::Keyboard"))-> isConfirmed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isConfirmed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isConfirmed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    int  playList ;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"i",
       
         &playList
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::PlayList * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::PlayList *)new XBMCAddon::xbmc::PlayList(  playList  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::PlayList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::PlayList\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_getPlayListId__doc__,
               "getPlayListId() --returns an integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_getPlayListId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"getPlayListId","XBMCAddon::xbmc::PlayList"))-> getPlayListId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayListId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayListId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_add__doc__,
               "add(url[, listitem, index])--Adds a new file to the playlist.\n"
"\n"
"url : string or unicode - filename or url to add.\n"
"listitem : [opt] listitem - used with setInfo() to set different infolabels.\n"
"index : [opt] integer - position to add playlist item. (default=end)\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - playlist =xbmc.PlayList (xbmc.PLAYLIST_VIDEO)\n"
"    - video = 'F:\\movies\\Ironman.mov'\n"
"    - listitem =xbmcgui.ListItem ('Ironman', thumbnailImage='F:\\movies\\Ironman.tbn')\n"
"    - listitem.setInfo('video', {'Title': 'Ironman', 'Genre': 'Science Fiction'})\n"
"    - playlist.add(url=video, listitem=listitem, index=7)n\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_add (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "url",
          "listitem",
          "index",
          NULL};
         
    std::string  url ;
    PyObject* pyurl = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem  = NULL;
    PyObject* pylistitem = NULL;         
    int  index  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|Oi",
       (char**)keywords,
         &pyurl,
         &pylistitem,
         &index
       ))
    {
      return NULL;
    }


    try
    {
      if (pyurl) PyXBMCGetUnicodeString(url,pyurl,false,"url","add"); 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","add"); 

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"add","XBMCAddon::xbmc::PlayList"))-> add(  url,  listitem,  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"add\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"add\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_load__doc__,
               "load(filename)--Load a playlist.\n"
"\n"
"clear current playlist and copy items from the file to this Playlist filename can be like .pls or .m3u ...\n"
"returns False if unable to load playlist\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_load (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"load","XBMCAddon::xbmc::PlayList"))-> load(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"load\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"load\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_remove__doc__,
               "remove(filename)--remove an item with this filename from the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_remove (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"remove","XBMCAddon::xbmc::PlayList"))-> remove(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"remove\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"remove\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_clear__doc__,
               "clear() --clear all items in the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_clear (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"clear","XBMCAddon::xbmc::PlayList"))-> clear(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clear\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clear\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_size__doc__,
               "size() --returns the total number of PlayListItems in this playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"size","XBMCAddon::xbmc::PlayList"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_shuffle__doc__,
               "shuffle() --shuffle the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_shuffle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"shuffle","XBMCAddon::xbmc::PlayList"))-> shuffle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"shuffle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"shuffle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_unshuffle__doc__,
               "unshuffle() --unshuffle the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_unshuffle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"unshuffle","XBMCAddon::xbmc::PlayList"))-> unshuffle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"unshuffle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"unshuffle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_getposition__doc__,
               "getposition() --returns the position of the current song in this playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_getposition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"getposition","XBMCAddon::xbmc::PlayList"))-> getposition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getposition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getposition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_operatorIndex_ (PyHolder* self , PyObject* pyi )
  {
    XBMC_TRACE;
         
    long  i ;    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {
      i = PyInt_AsLong(pyi); 

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"operator []","XBMCAddon::xbmc::PlayList"))-> operator [](  i  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"operator []\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"operator []\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::Monitor * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Monitor *)(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType) != pytype) ? new XBMCAddon_xbmc_Monitor_Director() : new XBMCAddon::xbmc::Monitor(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Monitor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Monitor\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmc_Monitor_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmc_Monitor_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onSettingsChanged__doc__,
               "onSettingsChanged() --onSettingsChanged method.\n"
"\n"
"Will be called when addon settings are changed\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onSettingsChanged (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onSettingsChanged","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onSettingsChanged(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onSettingsChanged\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onSettingsChanged\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onScreensaverActivated__doc__,
               "onScreensaverActivated() --onScreensaverActivated method.\n"
"\n"
"Will be called when screensaver kicks in\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScreensaverActivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScreensaverActivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScreensaverActivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScreensaverActivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScreensaverActivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onScreensaverDeactivated__doc__,
               "onScreensaverDeactivated() --onScreensaverDeactivated method.\n"
"\n"
"Will be called when screensaver goes off\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScreensaverDeactivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScreensaverDeactivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScreensaverDeactivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScreensaverDeactivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScreensaverDeactivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onDPMSActivated__doc__,
               "onDPMSActivated() --onDPMSActivated method.\n"
"\n"
"Will be called when energysaving/DPMS gets active\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDPMSActivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDPMSActivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDPMSActivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDPMSActivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDPMSActivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onDPMSDeactivated__doc__,
               "onDPMSDeactivated() --onDPMSDeactivated method.\n"
"\n"
"Will be called when energysaving/DPMS is turned off\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDPMSDeactivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDPMSDeactivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDPMSDeactivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDPMSDeactivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDPMSDeactivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onScanStarted__doc__,
               "onScanStarted(library)--onScanStarted method.\n"
"\n"
"library : video/music as string\n"
"\n"
"Will be called when library scan has started and return video or music to indicate which library is being scanned\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScanStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onScanStarted"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScanStarted","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScanStarted(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScanStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScanStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onScanFinished__doc__,
               "onScanFinished(library)--onScanFinished method.\n"
"\n"
"library : video/music as string\n"
"\n"
"Will be called when library scan has ended and return video or music to indicate which library has been scanned\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScanFinished (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onScanFinished"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScanFinished","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScanFinished(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScanFinished\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScanFinished\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onDatabaseScanStarted__doc__,
               "onDatabaseScanStarted(database)--Deprecated, useonScanStarted() .\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDatabaseScanStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "database",
          NULL};
         
    std::string  database ;
    PyObject* pydatabase = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydatabase
       ))
    {
      return NULL;
    }


    try
    {
      if (pydatabase) PyXBMCGetUnicodeString(database,pydatabase,false,"database","onDatabaseScanStarted"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDatabaseScanStarted","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDatabaseScanStarted(  database  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDatabaseScanStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDatabaseScanStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onDatabaseUpdated__doc__,
               "onDatabaseUpdated(database)--Deprecated, useonScanFinished() .\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDatabaseUpdated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "database",
          NULL};
         
    std::string  database ;
    PyObject* pydatabase = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydatabase
       ))
    {
      return NULL;
    }


    try
    {
      if (pydatabase) PyXBMCGetUnicodeString(database,pydatabase,false,"database","onDatabaseUpdated"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDatabaseUpdated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDatabaseUpdated(  database  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDatabaseUpdated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDatabaseUpdated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onCleanStarted__doc__,
               "onCleanStarted(library)--onCleanStarted method.\n"
"\n"
"library : video/music as string\n"
"\n"
"Will be called when library clean has started and return video or music to indicate which library is being cleaned\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onCleanStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onCleanStarted"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onCleanStarted","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onCleanStarted(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onCleanStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onCleanStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onCleanFinished__doc__,
               "onCleanFinished(library)--onCleanFinished method.\n"
"\n"
"library : video/music as string\n"
"\n"
"Will be called when library clean has ended and return video or music to indicate which library has been cleaned\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onCleanFinished (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onCleanFinished"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onCleanFinished","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onCleanFinished(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onCleanFinished\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onCleanFinished\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onAbortRequested__doc__,
               "onAbortRequested() --Deprecated, usewaitForAbort() to be notified about this event.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onAbortRequested (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onAbortRequested","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onAbortRequested(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onAbortRequested\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onAbortRequested\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onNotification__doc__,
               "onNotification(sender, method, data)--onNotification method.\n"
"\n"
"sender : sender of the notification\n"
"method : name of the notification\n"
"data : JSON-encoded data of the notification\n"
"\n"
"Will be called when XBMC receives or sends a notification\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onNotification (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "sender",
          "method",
          "data",
          NULL};
         
    std::string  sender ;
    PyObject* pysender = NULL;         
    std::string  method ;
    PyObject* pymethod = NULL;         
    std::string  data ;
    PyObject* pydata = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OOO",
       (char**)keywords,
         &pysender,
         &pymethod,
         &pydata
       ))
    {
      return NULL;
    }


    try
    {
      if (pysender) PyXBMCGetUnicodeString(sender,pysender,false,"sender","onNotification"); 
      if (pymethod) PyXBMCGetUnicodeString(method,pymethod,false,"method","onNotification"); 
      if (pydata) PyXBMCGetUnicodeString(data,pydata,false,"data","onNotification"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onNotification","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onNotification(  sender,  method,  data  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onNotification\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onNotification\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_waitForAbort__doc__,
               "waitForAbort([timeout])--Block until abort is requested, or until timeout occurs. If an abort requested have already been made, return immediately.\n"
"\n"
"Returns True when abort have been requested, False if a timeout is given and the operation times out.\n"
"\n"
"timeout : [opt] float - timeout in seconds. Default: no timeout.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_waitForAbort (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "timeout",
          NULL};
         
    double  timeout  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|d",
       (char**)keywords,
         &timeout
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"waitForAbort","XBMCAddon::xbmc::Monitor"))-> waitForAbort(  timeout  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"waitForAbort\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"waitForAbort\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_abortRequested__doc__,
               "abortRequested() --Returns True if abort has been requested.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_abortRequested (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"abortRequested","XBMCAddon::xbmc::Monitor"))-> abortRequested(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"abortRequested\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"abortRequested\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static void xbmc_XBMCAddon_xbmc_Player_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::Player* theObj = (XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"~XBMCAddon::xbmc::Player","XBMCAddon::xbmc::Player");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Player\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Player\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_RenderCapture_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::RenderCapture* theObj = (XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"~XBMCAddon::xbmc::RenderCapture","XBMCAddon::xbmc::RenderCapture");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::RenderCapture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::RenderCapture\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagMusic_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagMusic* theObj = (XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"~XBMCAddon::xbmc::InfoTagMusic","XBMCAddon::xbmc::InfoTagMusic");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagMusic\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagMusic\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagVideo_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagVideo* theObj = (XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"~XBMCAddon::xbmc::InfoTagVideo","XBMCAddon::xbmc::InfoTagVideo");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagVideo\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_Keyboard_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::Keyboard* theObj = (XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"~XBMCAddon::xbmc::Keyboard","XBMCAddon::xbmc::Keyboard");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Keyboard\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Keyboard\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_PlayList_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::PlayList* theObj = (XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"~XBMCAddon::xbmc::PlayList","XBMCAddon::xbmc::PlayList");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::PlayList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::PlayList\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_Monitor_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::Monitor* theObj = (XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"~XBMCAddon::xbmc::Monitor","XBMCAddon::xbmc::Monitor");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Monitor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Monitor\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Player
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Player_methods[] = { 
    {(char*)"play", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_play, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_play__doc__ }, 
    {(char*)"stop", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_stop, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_stop__doc__ }, 
    {(char*)"pause", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_pause, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_pause__doc__ }, 
    {(char*)"playnext", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playnext, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playnext__doc__ }, 
    {(char*)"playprevious", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playprevious, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playprevious__doc__ }, 
    {(char*)"playselected", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playselected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playselected__doc__ }, 
    {(char*)"onPlayBackStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackStarted, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackStarted__doc__ }, 
    {(char*)"onPlayBackEnded", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackEnded, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackEnded__doc__ }, 
    {(char*)"onPlayBackStopped", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackStopped, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackStopped__doc__ }, 
    {(char*)"onPlayBackPaused", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackPaused, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackPaused__doc__ }, 
    {(char*)"onPlayBackResumed", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackResumed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackResumed__doc__ }, 
    {(char*)"onQueueNextItem", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onQueueNextItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onQueueNextItem__doc__ }, 
    {(char*)"onPlayBackSpeedChanged", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSpeedChanged, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackSpeedChanged__doc__ }, 
    {(char*)"onPlayBackSeek", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSeek, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackSeek__doc__ }, 
    {(char*)"onPlayBackSeekChapter", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSeekChapter, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackSeekChapter__doc__ }, 
    {(char*)"isPlaying", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlaying, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_isPlaying__doc__ }, 
    {(char*)"isPlayingAudio", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingAudio, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_isPlayingAudio__doc__ }, 
    {(char*)"isPlayingVideo", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingVideo, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_isPlayingVideo__doc__ }, 
    {(char*)"getPlayingFile", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getPlayingFile, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getPlayingFile__doc__ }, 
    {(char*)"getTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getTime, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getTime__doc__ }, 
    {(char*)"seekTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_seekTime, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_seekTime__doc__ }, 
    {(char*)"setSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_setSubtitles__doc__ }, 
    {(char*)"showSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_showSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_showSubtitles__doc__ }, 
    {(char*)"getSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getSubtitles__doc__ }, 
    {(char*)"disableSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_disableSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_disableSubtitles__doc__ }, 
    {(char*)"getAvailableSubtitleStreams", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getAvailableSubtitleStreams, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getAvailableSubtitleStreams__doc__ }, 
    {(char*)"setSubtitleStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setSubtitleStream, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_setSubtitleStream__doc__ }, 
    {(char*)"getVideoInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getVideoInfoTag, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getVideoInfoTag__doc__ }, 
    {(char*)"getMusicInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getMusicInfoTag, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getMusicInfoTag__doc__ }, 
    {(char*)"getTotalTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getTotalTime, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getTotalTime__doc__ }, 
    {(char*)"getAvailableAudioStreams", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getAvailableAudioStreams, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getAvailableAudioStreams__doc__ }, 
    {(char*)"setAudioStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setAudioStream, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_setAudioStream__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Player_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_Player__doc__,
                 "Player class.\n"
"\n"
"Player()--Creates a newPlayer class.\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_Player_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.Player";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Player_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmc_Player__doc__;
    pythonType.tp_methods = XBMCAddon_xbmc_Player_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_Player_New;

    TyXBMCAddon_xbmc_Player_Type.swigType="p.XBMCAddon::xbmc::Player";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_Player_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::RenderCapture
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_RenderCapture_methods[] = { 
    {(char*)"getWidth", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getWidth__doc__ }, 
    {(char*)"getHeight", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getHeight__doc__ }, 
    {(char*)"getCaptureState", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getCaptureState, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getCaptureState__doc__ }, 
    {(char*)"getAspectRatio", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getAspectRatio, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getAspectRatio__doc__ }, 
    {(char*)"getImageFormat", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getImageFormat, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getImageFormat__doc__ }, 
    {(char*)"getImage", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getImage__doc__ }, 
    {(char*)"capture", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_capture, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_capture__doc__ }, 
    {(char*)"waitForCaptureStateChangeEvent", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_RenderCapture_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_RenderCapture_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.RenderCapture";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_RenderCapture_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_RenderCapture_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_RenderCapture_New;

    TyXBMCAddon_xbmc_RenderCapture_Type.swigType="p.XBMCAddon::xbmc::RenderCapture";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_RenderCapture_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagMusic
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagMusic_methods[] = { 
    {(char*)"getURL", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getURL, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getURL__doc__ }, 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getTitle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getTitle__doc__ }, 
    {(char*)"getArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getArtist, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getArtist__doc__ }, 
    {(char*)"getAlbum", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbum, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getAlbum__doc__ }, 
    {(char*)"getAlbumArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist__doc__ }, 
    {(char*)"getGenre", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getGenre, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getGenre__doc__ }, 
    {(char*)"getDuration", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getDuration, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getDuration__doc__ }, 
    {(char*)"getTrack", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getTrack, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getTrack__doc__ }, 
    {(char*)"getDisc", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getDisc, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getDisc__doc__ }, 
    {(char*)"getReleaseDate", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getReleaseDate, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getReleaseDate__doc__ }, 
    {(char*)"getListeners", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getListeners, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getListeners__doc__ }, 
    {(char*)"getPlayCount", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getPlayCount, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getPlayCount__doc__ }, 
    {(char*)"getLastPlayed", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getLastPlayed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getLastPlayed__doc__ }, 
    {(char*)"getComment", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getComment, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getComment__doc__ }, 
    {(char*)"getLyrics", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getLyrics, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagMusic_getLyrics__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagMusic_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagMusic__doc__,
                 "InfoTagMusic class.\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.InfoTagMusic";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagMusic_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmc_InfoTagMusic__doc__;
    pythonType.tp_methods = XBMCAddon_xbmc_InfoTagMusic_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_InfoTagMusic_New;

    TyXBMCAddon_xbmc_InfoTagMusic_Type.swigType="p.XBMCAddon::xbmc::InfoTagMusic";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_InfoTagMusic_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagVideo
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagVideo_methods[] = { 
    {(char*)"getDirector", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getDirector, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getDirector__doc__ }, 
    {(char*)"getWritingCredits", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getWritingCredits, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getWritingCredits__doc__ }, 
    {(char*)"getGenre", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getGenre, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getGenre__doc__ }, 
    {(char*)"getTagLine", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getTagLine, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getTagLine__doc__ }, 
    {(char*)"getPlotOutline", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlotOutline, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPlotOutline__doc__ }, 
    {(char*)"getPlot", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlot, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPlot__doc__ }, 
    {(char*)"getPictureURL", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPictureURL, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPictureURL__doc__ }, 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getTitle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getTitle__doc__ }, 
    {(char*)"getVotes", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getVotes, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getVotes__doc__ }, 
    {(char*)"getCast", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getCast, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getCast__doc__ }, 
    {(char*)"getFile", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getFile, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getFile__doc__ }, 
    {(char*)"getPath", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPath, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPath__doc__ }, 
    {(char*)"getIMDBNumber", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber__doc__ }, 
    {(char*)"getYear", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getYear, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getYear__doc__ }, 
    {(char*)"getRating", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getRating, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getRating__doc__ }, 
    {(char*)"getPlayCount", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlayCount, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPlayCount__doc__ }, 
    {(char*)"getLastPlayed", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getLastPlayed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getLastPlayed__doc__ }, 
    {(char*)"getOriginalTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle__doc__ }, 
    {(char*)"getPremiered", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPremiered, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPremiered__doc__ }, 
    {(char*)"getFirstAired", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getFirstAired, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getFirstAired__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagVideo_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.InfoTagVideo";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagVideo_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_InfoTagVideo_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_InfoTagVideo_New;

    TyXBMCAddon_xbmc_InfoTagVideo_Type.swigType="p.XBMCAddon::xbmc::InfoTagVideo";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_InfoTagVideo_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Keyboard
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Keyboard_methods[] = { 
    {(char*)"doModal", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_doModal, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_doModal__doc__ }, 
    {(char*)"setDefault", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setDefault, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_setDefault__doc__ }, 
    {(char*)"setHiddenInput", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setHiddenInput, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_setHiddenInput__doc__ }, 
    {(char*)"setHeading", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setHeading, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_setHeading__doc__ }, 
    {(char*)"getText", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_getText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_getText__doc__ }, 
    {(char*)"isConfirmed", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_isConfirmed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_isConfirmed__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Keyboard_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard__doc__,
                 "Keyboard class.\n"
"\n"
"Keyboard([default, heading, hidden])--Creates a newKeyboard object with default text\n"
"heading and hidden input flag if supplied.\n"
"\n"
"default : [opt] string - default text entry.\n"
"heading : [opt] string - keyboard heading.\n"
"hidden : [opt] boolean - True for hidden text entry.\n"
"\n"
"example:\n"
"\n"
"    - kb =xbmc.Keyboard ('default', 'heading', True)\n"
"    - kb.setDefault('password') # optional\n"
"    - kb.setHeading('Enter password') # optional\n"
"    - kb.setHiddenInput(True) # optional\n"
"    - kb.doModal()\n"
"    - if (kb.isConfirmed()):\n"
"    - text = kb.getText()\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_Keyboard_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.Keyboard";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Keyboard_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmc_Keyboard__doc__;
    pythonType.tp_methods = XBMCAddon_xbmc_Keyboard_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_Keyboard_New;

    TyXBMCAddon_xbmc_Keyboard_Type.swigType="p.XBMCAddon::xbmc::Keyboard";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_Keyboard_Type);

  }
  //=========================================================================

  static Py_ssize_t xbmc_XBMCAddon_xbmc_PlayList_size_(PyObject* self)
  {
    return (Py_ssize_t)((XBMCAddon::xbmc::PlayList*)retrieveApiInstance(self,&TyXBMCAddon_xbmc_PlayList_Type,"operator []","XBMCAddon::xbmc::PlayList"))-> size();
  }

  //=========================================================================
  // tp_as_mapping struct for XBMCAddon::xbmc::PlayList
  //=========================================================================
  PyMappingMethods xbmc_XBMCAddon_xbmc_PlayList_as_mapping = {
    xbmc_XBMCAddon_xbmc_PlayList_size_,    /* inquiry mp_length;                  __len__ */
    (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_operatorIndex_,   /* binaryfunc mp_subscript             __getitem__ */
    0,                  /* objargproc mp_ass_subscript;     __setitem__ */
  };

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::PlayList
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_PlayList_methods[] = { 
    {(char*)"getPlayListId", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_getPlayListId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_getPlayListId__doc__ }, 
    {(char*)"add", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_add, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_add__doc__ }, 
    {(char*)"load", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_load, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_load__doc__ }, 
    {(char*)"remove", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_remove, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_remove__doc__ }, 
    {(char*)"clear", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_clear, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_clear__doc__ }, 
    {(char*)"size", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_size, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_size__doc__ }, 
    {(char*)"shuffle", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_shuffle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_shuffle__doc__ }, 
    {(char*)"unshuffle", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_unshuffle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_unshuffle__doc__ }, 
    {(char*)"getposition", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_getposition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_getposition__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_PlayList_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_PlayList_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.PlayList";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_PlayList_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_PlayList_methods; 
    pythonType.tp_as_mapping = &xbmc_XBMCAddon_xbmc_PlayList_as_mapping;

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_PlayList_New;

    TyXBMCAddon_xbmc_PlayList_Type.swigType="p.XBMCAddon::xbmc::PlayList";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_PlayList_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Monitor
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Monitor_methods[] = { 
    {(char*)"onSettingsChanged", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onSettingsChanged, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onSettingsChanged__doc__ }, 
    {(char*)"onScreensaverActivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScreensaverActivated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onScreensaverActivated__doc__ }, 
    {(char*)"onScreensaverDeactivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScreensaverDeactivated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onScreensaverDeactivated__doc__ }, 
    {(char*)"onDPMSActivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDPMSActivated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onDPMSActivated__doc__ }, 
    {(char*)"onDPMSDeactivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDPMSDeactivated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onDPMSDeactivated__doc__ }, 
    {(char*)"onScanStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScanStarted, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onScanStarted__doc__ }, 
    {(char*)"onScanFinished", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScanFinished, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onScanFinished__doc__ }, 
    {(char*)"onDatabaseScanStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDatabaseScanStarted, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onDatabaseScanStarted__doc__ }, 
    {(char*)"onDatabaseUpdated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDatabaseUpdated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onDatabaseUpdated__doc__ }, 
    {(char*)"onCleanStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onCleanStarted, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onCleanStarted__doc__ }, 
    {(char*)"onCleanFinished", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onCleanFinished, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onCleanFinished__doc__ }, 
    {(char*)"onAbortRequested", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onAbortRequested, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onAbortRequested__doc__ }, 
    {(char*)"onNotification", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onNotification, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onNotification__doc__ }, 
    {(char*)"waitForAbort", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_waitForAbort, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_waitForAbort__doc__ }, 
    {(char*)"abortRequested", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_abortRequested, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_abortRequested__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Monitor_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_Monitor__doc__,
                 "Monitor class.\n"
"\n"
"Monitor()--Creates a newMonitor to notify addon about changes.\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_Monitor_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.Monitor";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Monitor_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmc_Monitor__doc__;
    pythonType.tp_methods = XBMCAddon_xbmc_Monitor_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_Monitor_New;

    TyXBMCAddon_xbmc_Monitor_Type.swigType="p.XBMCAddon::xbmc::Monitor";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_Monitor_Type);

  }
  //=========================================================================


  static PyMethodDef xbmc_methods[] = { 
    {(char*)"log", (PyCFunction)xbmc_log, METH_VARARGS|METH_KEYWORDS, log__doc__ }, 
    {(char*)"shutdown", (PyCFunction)xbmc_shutdown, METH_VARARGS|METH_KEYWORDS, shutdown__doc__ }, 
    {(char*)"restart", (PyCFunction)xbmc_restart, METH_VARARGS|METH_KEYWORDS, restart__doc__ }, 
    {(char*)"executescript", (PyCFunction)xbmc_executescript, METH_VARARGS|METH_KEYWORDS, executescript__doc__ }, 
    {(char*)"executebuiltin", (PyCFunction)xbmc_executebuiltin, METH_VARARGS|METH_KEYWORDS, executebuiltin__doc__ }, 
    {(char*)"executeJSONRPC", (PyCFunction)xbmc_executeJSONRPC, METH_VARARGS|METH_KEYWORDS, executeJSONRPC__doc__ }, 
    {(char*)"sleep", (PyCFunction)xbmc_sleep, METH_VARARGS|METH_KEYWORDS, sleep__doc__ }, 
    {(char*)"getLocalizedString", (PyCFunction)xbmc_getLocalizedString, METH_VARARGS|METH_KEYWORDS, getLocalizedString__doc__ }, 
    {(char*)"getSkinDir", (PyCFunction)xbmc_getSkinDir, METH_VARARGS|METH_KEYWORDS, getSkinDir__doc__ }, 
    {(char*)"getLanguage", (PyCFunction)xbmc_getLanguage, METH_VARARGS|METH_KEYWORDS, getLanguage__doc__ }, 
    {(char*)"getIPAddress", (PyCFunction)xbmc_getIPAddress, METH_VARARGS|METH_KEYWORDS, getIPAddress__doc__ }, 
    {(char*)"getDVDState", (PyCFunction)xbmc_getDVDState, METH_VARARGS|METH_KEYWORDS, getDVDState__doc__ }, 
    {(char*)"getFreeMem", (PyCFunction)xbmc_getFreeMem, METH_VARARGS|METH_KEYWORDS, getFreeMem__doc__ }, 
    {(char*)"getInfoLabel", (PyCFunction)xbmc_getInfoLabel, METH_VARARGS|METH_KEYWORDS, getInfoLabel__doc__ }, 
    {(char*)"getInfoImage", (PyCFunction)xbmc_getInfoImage, METH_VARARGS|METH_KEYWORDS, getInfoImage__doc__ }, 
    {(char*)"playSFX", (PyCFunction)xbmc_playSFX, METH_VARARGS|METH_KEYWORDS, playSFX__doc__ }, 
    {(char*)"stopSFX", (PyCFunction)xbmc_stopSFX, METH_VARARGS|METH_KEYWORDS, stopSFX__doc__ }, 
    {(char*)"enableNavSounds", (PyCFunction)xbmc_enableNavSounds, METH_VARARGS|METH_KEYWORDS, enableNavSounds__doc__ }, 
    {(char*)"getCondVisibility", (PyCFunction)xbmc_getCondVisibility, METH_VARARGS|METH_KEYWORDS, getCondVisibility__doc__ }, 
    {(char*)"getGlobalIdleTime", (PyCFunction)xbmc_getGlobalIdleTime, METH_VARARGS|METH_KEYWORDS, getGlobalIdleTime__doc__ }, 
    {(char*)"getCacheThumbName", (PyCFunction)xbmc_getCacheThumbName, METH_VARARGS|METH_KEYWORDS, getCacheThumbName__doc__ }, 
    {(char*)"makeLegalFilename", (PyCFunction)xbmc_makeLegalFilename, METH_VARARGS|METH_KEYWORDS, makeLegalFilename__doc__ }, 
    {(char*)"translatePath", (PyCFunction)xbmc_translatePath, METH_VARARGS|METH_KEYWORDS, translatePath__doc__ }, 
    {(char*)"getCleanMovieTitle", (PyCFunction)xbmc_getCleanMovieTitle, METH_VARARGS|METH_KEYWORDS, getCleanMovieTitle__doc__ }, 
    {(char*)"validatePath", (PyCFunction)xbmc_validatePath, METH_VARARGS|METH_KEYWORDS, validatePath__doc__ }, 
    {(char*)"getRegion", (PyCFunction)xbmc_getRegion, METH_VARARGS|METH_KEYWORDS, getRegion__doc__ }, 
    {(char*)"getSupportedMedia", (PyCFunction)xbmc_getSupportedMedia, METH_VARARGS|METH_KEYWORDS, getSupportedMedia__doc__ }, 
    {(char*)"skinHasImage", (PyCFunction)xbmc_skinHasImage, METH_VARARGS|METH_KEYWORDS, skinHasImage__doc__ }, 
    {(char*)"startServer", (PyCFunction)xbmc_startServer, METH_VARARGS|METH_KEYWORDS, startServer__doc__ }, 
    {(char*)"audioSuspend", (PyCFunction)xbmc_audioSuspend, METH_VARARGS|METH_KEYWORDS, audioSuspend__doc__ }, 
    {(char*)"audioResume", (PyCFunction)xbmc_audioResume, METH_VARARGS|METH_KEYWORDS, audioResume__doc__ }, 
    {(char*)"convertLanguage", (PyCFunction)xbmc_convertLanguage, METH_VARARGS|METH_KEYWORDS, convertLanguage__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmc_Player_Type();
      initPyXBMCAddon_xbmc_RenderCapture_Type();
      initPyXBMCAddon_xbmc_InfoTagMusic_Type();
      initPyXBMCAddon_xbmc_InfoTagVideo_Type();
      initPyXBMCAddon_xbmc_Keyboard_Type();
      initPyXBMCAddon_xbmc_PlayList_Type();
      initPyXBMCAddon_xbmc_Monitor_Type();
      if (PyType_Ready(&(TyXBMCAddon_xbmc_Player_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_RenderCapture_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_Keyboard_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_PlayList_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType)) < 0)
        return;
    }
  }

  void initModule_xbmc()
  {
    initTypes();

    // init general xbmc modules
    PyObject* module;


    Py_INCREF(&(TyXBMCAddon_xbmc_Player_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_RenderCapture_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_Keyboard_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_PlayList_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType));

    module = Py_InitModule((char*)"xbmc", xbmc_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"Player", (PyObject*)(&(TyXBMCAddon_xbmc_Player_Type.pythonType)));
    PyModule_AddObject(module, (char*)"RenderCapture", (PyObject*)(&(TyXBMCAddon_xbmc_RenderCapture_Type.pythonType)));
    PyModule_AddObject(module, (char*)"InfoTagMusic", (PyObject*)(&(TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType)));
    PyModule_AddObject(module, (char*)"InfoTagVideo", (PyObject*)(&(TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Keyboard", (PyObject*)(&(TyXBMCAddon_xbmc_Keyboard_Type.pythonType)));
    PyModule_AddObject(module, (char*)"PlayList", (PyObject*)(&(TyXBMCAddon_xbmc_PlayList_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Monitor", (PyObject*)(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType)));

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team XBMC <http://xbmc.org>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Mon Feb 16 02:25:21 EST 2015");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.19.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team XBMC");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"SERVER_WEBSERVER",getSERVER_WEBSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_AIRPLAYSERVER",getSERVER_AIRPLAYSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_UPNPSERVER",getSERVER_UPNPSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_UPNPRENDERER",getSERVER_UPNPRENDERER()); 
   PyModule_AddIntConstant(module,"SERVER_EVENTSERVER",getSERVER_EVENTSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_JSONRPCSERVER",getSERVER_JSONRPCSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_ZEROCONF",getSERVER_ZEROCONF()); 
   PyModule_AddIntConstant(module,"PLAYLIST_MUSIC",getPLAYLIST_MUSIC()); 
   PyModule_AddIntConstant(module,"PLAYLIST_VIDEO",getPLAYLIST_VIDEO()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_AUTO",getPLAYER_CORE_AUTO()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_DVDPLAYER",getPLAYER_CORE_DVDPLAYER()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_MPLAYER",getPLAYER_CORE_MPLAYER()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_PAPLAYER",getPLAYER_CORE_PAPLAYER()); 
   PyModule_AddIntConstant(module,"TRAY_OPEN",getTRAY_OPEN()); 
   PyModule_AddIntConstant(module,"DRIVE_NOT_READY",getDRIVE_NOT_READY()); 
   PyModule_AddIntConstant(module,"TRAY_CLOSED_NO_MEDIA",getTRAY_CLOSED_NO_MEDIA()); 
   PyModule_AddIntConstant(module,"TRAY_CLOSED_MEDIA_PRESENT",getTRAY_CLOSED_MEDIA_PRESENT()); 
   PyModule_AddIntConstant(module,"LOGDEBUG",getLOGDEBUG()); 
   PyModule_AddIntConstant(module,"LOGINFO",getLOGINFO()); 
   PyModule_AddIntConstant(module,"LOGNOTICE",getLOGNOTICE()); 
   PyModule_AddIntConstant(module,"LOGWARNING",getLOGWARNING()); 
   PyModule_AddIntConstant(module,"LOGERROR",getLOGERROR()); 
   PyModule_AddIntConstant(module,"LOGSEVERE",getLOGSEVERE()); 
   PyModule_AddIntConstant(module,"LOGFATAL",getLOGFATAL()); 
   PyModule_AddIntConstant(module,"LOGNONE",getLOGNONE()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_WORKING",getCAPTURE_STATE_WORKING()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_DONE",getCAPTURE_STATE_DONE()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_FAILED",getCAPTURE_STATE_FAILED()); 
   PyModule_AddIntConstant(module,"CAPTURE_FLAG_CONTINUOUS",getCAPTURE_FLAG_CONTINUOUS()); 
   PyModule_AddIntConstant(module,"CAPTURE_FLAG_IMMEDIATELY",getCAPTURE_FLAG_IMMEDIATELY()); 
   PyModule_AddIntConstant(module,"ISO_639_1",getISO_639_1()); 
   PyModule_AddIntConstant(module,"ISO_639_2",getISO_639_2()); 
   PyModule_AddIntConstant(module,"ENGLISH_NAME",getENGLISH_NAME()); 
  }

} // end PythonBindings namespace for python type definitions
