

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmcwsgi" on the template file PythonSwig.template.cpp
// ************************************************************************


#include "system.h"

#ifdef HAS_WEB_SERVER


#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/wsgi/WsgiErrorStream.h"
#include "interfaces/legacy/wsgi/WsgiInputStream.h"
#include "interfaces/legacy/wsgi/WsgiResponse.h"
#include "interfaces/legacy/wsgi/WsgiResponseBody.h"

using namespace XBMCAddon;
using namespace xbmcwsgi;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif



namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcwsgi::WsgiErrorStream
  TypeInfo TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type(typeid(XBMCAddon::xbmcwsgi::WsgiErrorStream));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcwsgi::WsgiInputStreamIterator
  TypeInfo TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type(typeid(XBMCAddon::xbmcwsgi::WsgiInputStreamIterator));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcwsgi::WsgiInputStream
  TypeInfo TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type(typeid(XBMCAddon::xbmcwsgi::WsgiInputStream));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcwsgi::WsgiResponse
  TypeInfo TyXBMCAddon_xbmcwsgi_WsgiResponse_Type(typeid(XBMCAddon::xbmcwsgi::WsgiResponse));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcwsgi::WsgiResponseBody
  TypeInfo TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type(typeid(XBMCAddon::xbmcwsgi::WsgiResponseBody));
  //=========================================================================



  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcwsgi::WsgiErrorStream * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcwsgi::WsgiErrorStream *)new XBMCAddon::xbmcwsgi::WsgiErrorStream(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiErrorStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiErrorStream\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_flush (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcwsgi::WsgiErrorStream*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type,"flush","XBMCAddon::xbmcwsgi::WsgiErrorStream"))-> flush(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"flush\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"flush\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_write (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "str",
          NULL};
         
    std::string  str ;
    PyObject* pystr = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pystr
       ))
    {
      return NULL;
    }


    try
    {
      if (pystr) PyXBMCGetUnicodeString(str,pystr,false,"str","write"); 

      ((XBMCAddon::xbmcwsgi::WsgiErrorStream*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type,"write","XBMCAddon::xbmcwsgi::WsgiErrorStream"))-> write(  str  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"write\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"write\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_writelines (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "seq",
          NULL};
         
    std::vector< XBMCAddon::String  >  seq ;
    PyObject* pyseq = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyseq
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyseq)
    {
      bool isTuple = PyObject_TypeCheck(pyseq,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyseq,&PyList_Type))
        throw WrongTypeException("The parameter \"seq\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyseq) : PyList_Size(pyseq));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyseq, i) : PyList_GetItem(pyseq, i));
        std::string  entry1;
        if (pyentry1) PyXBMCGetUnicodeString(entry1,pyentry1,false,"entry1","writelines");
        seq.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcwsgi::WsgiErrorStream*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type,"writelines","XBMCAddon::xbmcwsgi::WsgiErrorStream"))-> writelines(  seq  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"writelines\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"writelines\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcwsgi::WsgiInputStreamIterator * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcwsgi::WsgiInputStreamIterator *)new XBMCAddon::xbmcwsgi::WsgiInputStreamIterator(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiInputStreamIterator\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiInputStreamIterator\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_read (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "size",
          NULL};
         
    unsigned long  size  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|k",
       (char**)keywords,
         &size
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcwsgi::WsgiInputStreamIterator*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type,"read","XBMCAddon::xbmcwsgi::WsgiInputStreamIterator"))-> read(  size  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"read\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"read\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_readline (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "size",
          NULL};
         
    unsigned long  size  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|k",
       (char**)keywords,
         &size
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcwsgi::WsgiInputStreamIterator*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type,"readline","XBMCAddon::xbmcwsgi::WsgiInputStreamIterator"))-> readline(  size  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"readline\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"readline\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_readlines (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "sizehint",
          NULL};
         
    unsigned long  sizehint  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|k",
       (char**)keywords,
         &sizehint
       ))
    {
      return NULL;
    }

    std::vector< XBMCAddon::String  >  apiResult;
    try
    {

      apiResult = (std::vector< XBMCAddon::String  > )((XBMCAddon::xbmcwsgi::WsgiInputStreamIterator*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type,"readlines","XBMCAddon::xbmcwsgi::WsgiInputStreamIterator"))-> readlines(  sizehint  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"readlines\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"readlines\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
      result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcwsgi::WsgiInputStream * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcwsgi::WsgiInputStream *)new XBMCAddon::xbmcwsgi::WsgiInputStream(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiInputStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiInputStream\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponse_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcwsgi::WsgiResponse * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcwsgi::WsgiResponse *)new XBMCAddon::xbmcwsgi::WsgiResponse(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiResponse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiResponse\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponse_callable_ (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "status",
          "response_headers",
          "exc_info",
          NULL};
         
    std::string  status ;
    PyObject* pystatus = NULL;         
    std::vector< XBMCAddon::xbmcwsgi::WsgiHttpHeader  >  response_headers ;
    PyObject* pyresponse_headers = NULL;         
    void * exc_info  = NULL;
    PyObject* pyexc_info = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|O",
       (char**)keywords,
         &pystatus,
         &pyresponse_headers,
         &pyexc_info
       ))
    {
      return NULL;
    }

    WsgiResponseBody * apiResult;
    try
    {
      if (pystatus) PyXBMCGetUnicodeString(status,pystatus,false,"status","operator ()"); 
      
    if (pyresponse_headers)
    {
      bool isTuple = PyObject_TypeCheck(pyresponse_headers,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyresponse_headers,&PyList_Type))
        throw WrongTypeException("The parameter \"response_headers\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyresponse_headers) : PyList_Size(pyresponse_headers));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyresponse_headers, i) : PyList_GetItem(pyresponse_headers, i));
        Tuple< XBMCAddon::String ,XBMCAddon::String  >  entry1;
        
    if(pyentry1)
    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        std::string  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","operator ()");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        std::string  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","operator ()");
        entry1.second() = entry1_2;
      }

    }

        response_headers.push_back(entry1);
      }
    }
 
      exc_info = (void*)pyexc_info; 

      apiResult = (WsgiResponseBody *)((XBMCAddon::xbmcwsgi::WsgiResponse*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiResponse_Type,"operator ()","XBMCAddon::xbmcwsgi::WsgiResponse"))-> operator ()(  status,  response_headers,  exc_info  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"operator ()\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"operator ()\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponseBody_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcwsgi::WsgiResponseBody * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcwsgi::WsgiResponseBody *)new XBMCAddon::xbmcwsgi::WsgiResponseBody(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiResponseBody\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcwsgi::WsgiResponseBody\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponseBody_callable_ (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "data",
          NULL};
         
    std::string  data ;
    PyObject* pydata = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydata
       ))
    {
      return NULL;
    }


    try
    {
      if (pydata) PyXBMCGetUnicodeString(data,pydata,false,"data","operator ()"); 

      ((XBMCAddon::xbmcwsgi::WsgiResponseBody*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type,"operator ()","XBMCAddon::xbmcwsgi::WsgiResponseBody"))-> operator ()(  data  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"operator ()\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"operator ()\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static void xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcwsgi::WsgiErrorStream* theObj = (XBMCAddon::xbmcwsgi::WsgiErrorStream*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type,"~XBMCAddon::xbmcwsgi::WsgiErrorStream","XBMCAddon::xbmcwsgi::WsgiErrorStream");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiErrorStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiErrorStream\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcwsgi::WsgiInputStreamIterator* theObj = (XBMCAddon::xbmcwsgi::WsgiInputStreamIterator*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type,"~XBMCAddon::xbmcwsgi::WsgiInputStreamIterator","XBMCAddon::xbmcwsgi::WsgiInputStreamIterator");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiInputStreamIterator\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiInputStreamIterator\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcwsgi::WsgiInputStream* theObj = (XBMCAddon::xbmcwsgi::WsgiInputStream*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type,"~XBMCAddon::xbmcwsgi::WsgiInputStream","XBMCAddon::xbmcwsgi::WsgiInputStream");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiInputStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiInputStream\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponse_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcwsgi::WsgiResponse* theObj = (XBMCAddon::xbmcwsgi::WsgiResponse*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiResponse_Type,"~XBMCAddon::xbmcwsgi::WsgiResponse","XBMCAddon::xbmcwsgi::WsgiResponse");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiResponse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiResponse\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponseBody_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcwsgi::WsgiResponseBody* theObj = (XBMCAddon::xbmcwsgi::WsgiResponseBody*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type,"~XBMCAddon::xbmcwsgi::WsgiResponseBody","XBMCAddon::xbmcwsgi::WsgiResponseBody");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiResponseBody\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcwsgi::WsgiResponseBody\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcwsgi::WsgiErrorStream
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcwsgi_WsgiErrorStream_methods[] = { 
    {(char*)"flush", (PyCFunction)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_flush, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"write", (PyCFunction)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_write, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"writelines", (PyCFunction)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_writelines, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcwsgi.WsgiErrorStream";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcwsgi_WsgiErrorStream_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiErrorStream_New;

    TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type.swigType="p.XBMCAddon::xbmcwsgi::WsgiErrorStream";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcwsgi::WsgiInputStreamIterator
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_methods[] = { 
    {(char*)"read", (PyCFunction)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_read, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"readline", (PyCFunction)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_readline, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"readlines", (PyCFunction)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_readlines, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };


  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iter(PyObject* self)
  { 
    return self; 
  }

  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iternext(PyObject* self)
  {
    PyObject* result = NULL;
    try
    {
      XBMCAddon::xbmcwsgi::WsgiInputStreamIterator* iter = (XBMCAddon::xbmcwsgi::WsgiInputStreamIterator*)retrieveApiInstance(self,&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type,"xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iternext","XBMCAddon::xbmcwsgi::WsgiInputStreamIterator");

      // check if we have reached the end
      if (!iter->end())
      {
        ++(*iter);

        std::string apiResult = **iter;
        result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());
      }
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage());
      return NULL;
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage());
      return NULL;
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iternext\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iternext\"");
      return NULL;
    }

    return result;
  }


  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcwsgi.WsgiInputStreamIterator";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_ITER;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_methods; 
    pythonType.tp_iter = (getiterfunc)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iter;
    pythonType.tp_iternext = (iternextfunc)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_iternext;


    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStreamIterator_New;

    TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type.swigType="p.XBMCAddon::xbmcwsgi::WsgiInputStreamIterator";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcwsgi::WsgiInputStream
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcwsgi_WsgiInputStream_methods[] = { 
    {NULL, NULL, 0, NULL}
  };


  static PyObject* xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_iter(PyObject* self)
  { 
    PyObject* result = NULL;
    try
    {
      XBMCAddon::xbmcwsgi::WsgiInputStreamIterator* apiResult = ((XBMCAddon::xbmcwsgi::WsgiInputStream*)retrieveApiInstance(self,&TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type,"xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_iternext","XBMCAddon::xbmcwsgi::WsgiInputStream"))->begin();
      
      result = makePythonInstance(apiResult,true);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage());
      return NULL;
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage());
      return NULL;
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_iternext\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_iternext\"");
      return NULL;
    }

    return result; 
  }


  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcwsgi_WsgiInputStream_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcwsgi.WsgiInputStream";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcwsgi_WsgiInputStream_methods; 
    pythonType.tp_iter = (getiterfunc)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_iter;


    pythonType.tp_base = &(TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type.pythonType);
    pythonType.tp_new = xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiInputStream_New;

    TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type.swigType="p.XBMCAddon::xbmcwsgi::WsgiInputStream";
    TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type.parentType=&TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcwsgi::WsgiResponse
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcwsgi_WsgiResponse_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcwsgi_WsgiResponse_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcwsgi_WsgiResponse_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcwsgi.WsgiResponse";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponse_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcwsgi_WsgiResponse_methods; 
    pythonType.tp_call = (ternaryfunc)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponse_callable_;


    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponse_New;

    TyXBMCAddon_xbmcwsgi_WsgiResponse_Type.swigType="p.XBMCAddon::xbmcwsgi::WsgiResponse";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcwsgi_WsgiResponse_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcwsgi::WsgiResponseBody
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcwsgi_WsgiResponseBody_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcwsgi.WsgiResponseBody";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponseBody_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcwsgi_WsgiResponseBody_methods; 
    pythonType.tp_call = (ternaryfunc)xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponseBody_callable_;


    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcwsgi_XBMCAddon_xbmcwsgi_WsgiResponseBody_New;

    TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type.swigType="p.XBMCAddon::xbmcwsgi::WsgiResponseBody";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type);

  }
  //=========================================================================


  static PyMethodDef xbmcwsgi_methods[] = { 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type();
      initPyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type();
      initPyXBMCAddon_xbmcwsgi_WsgiInputStream_Type();
      initPyXBMCAddon_xbmcwsgi_WsgiResponse_Type();
      initPyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type();
      if (PyType_Ready(&(TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcwsgi_WsgiResponse_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type.pythonType)) < 0)
        return;
    }
  }

  void initModule_xbmcwsgi()
  {
    initTypes();

    // init general xbmcwsgi modules
    PyObject* module;


    Py_INCREF(&(TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcwsgi_WsgiResponse_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type.pythonType));

    module = Py_InitModule((char*)"xbmcwsgi", xbmcwsgi_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"WsgiErrorStream", (PyObject*)(&(TyXBMCAddon_xbmcwsgi_WsgiErrorStream_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WsgiInputStreamIterator", (PyObject*)(&(TyXBMCAddon_xbmcwsgi_WsgiInputStreamIterator_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WsgiInputStream", (PyObject*)(&(TyXBMCAddon_xbmcwsgi_WsgiInputStream_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WsgiResponse", (PyObject*)(&(TyXBMCAddon_xbmcwsgi_WsgiResponse_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WsgiResponseBody", (PyObject*)(&(TyXBMCAddon_xbmcwsgi_WsgiResponseBody_Type.pythonType)));

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team Kodi <http://kodi.tv>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Mon Mar 20 15:14:25 EDT 2017");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.25.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team Kodi");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

  }

} // end PythonBindings namespace for python type definitions


#endif

