

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmcgui" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/Dialog.h"
#include "interfaces/legacy/ModuleXbmcgui.h"
#include "interfaces/legacy/Control.h"
#include "interfaces/legacy/Window.h"
#include "interfaces/legacy/WindowDialog.h"
#include "interfaces/legacy/Dialog.h"
#include "interfaces/legacy/WindowXML.h"
#include "input/Key.h"

using namespace XBMCAddon;
using namespace xbmcgui;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif



namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ListItem
  TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type(typeid(XBMCAddon::xbmcgui::ListItem));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Control
  TypeInfo TyXBMCAddon_xbmcgui_Control_Type(typeid(XBMCAddon::xbmcgui::Control));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlSpin
  TypeInfo TyXBMCAddon_xbmcgui_ControlSpin_Type(typeid(XBMCAddon::xbmcgui::ControlSpin));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlLabel
  TypeInfo TyXBMCAddon_xbmcgui_ControlLabel_Type(typeid(XBMCAddon::xbmcgui::ControlLabel));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlEdit
  TypeInfo TyXBMCAddon_xbmcgui_ControlEdit_Type(typeid(XBMCAddon::xbmcgui::ControlEdit));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlList
  TypeInfo TyXBMCAddon_xbmcgui_ControlList_Type(typeid(XBMCAddon::xbmcgui::ControlList));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlFadeLabel
  TypeInfo TyXBMCAddon_xbmcgui_ControlFadeLabel_Type(typeid(XBMCAddon::xbmcgui::ControlFadeLabel));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlTextBox
  TypeInfo TyXBMCAddon_xbmcgui_ControlTextBox_Type(typeid(XBMCAddon::xbmcgui::ControlTextBox));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlImage
  TypeInfo TyXBMCAddon_xbmcgui_ControlImage_Type(typeid(XBMCAddon::xbmcgui::ControlImage));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlProgress
  TypeInfo TyXBMCAddon_xbmcgui_ControlProgress_Type(typeid(XBMCAddon::xbmcgui::ControlProgress));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlButton
  TypeInfo TyXBMCAddon_xbmcgui_ControlButton_Type(typeid(XBMCAddon::xbmcgui::ControlButton));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlGroup
  TypeInfo TyXBMCAddon_xbmcgui_ControlGroup_Type(typeid(XBMCAddon::xbmcgui::ControlGroup));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlRadioButton
  TypeInfo TyXBMCAddon_xbmcgui_ControlRadioButton_Type(typeid(XBMCAddon::xbmcgui::ControlRadioButton));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlSlider
  TypeInfo TyXBMCAddon_xbmcgui_ControlSlider_Type(typeid(XBMCAddon::xbmcgui::ControlSlider));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Dialog
  TypeInfo TyXBMCAddon_xbmcgui_Dialog_Type(typeid(XBMCAddon::xbmcgui::Dialog));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::DialogProgress
  TypeInfo TyXBMCAddon_xbmcgui_DialogProgress_Type(typeid(XBMCAddon::xbmcgui::DialogProgress));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::DialogBusy
  TypeInfo TyXBMCAddon_xbmcgui_DialogBusy_Type(typeid(XBMCAddon::xbmcgui::DialogBusy));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::DialogProgressBG
  TypeInfo TyXBMCAddon_xbmcgui_DialogProgressBG_Type(typeid(XBMCAddon::xbmcgui::DialogProgressBG));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Action
  TypeInfo TyXBMCAddon_xbmcgui_Action_Type(typeid(XBMCAddon::xbmcgui::Action));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Window
  TypeInfo TyXBMCAddon_xbmcgui_Window_Type(typeid(XBMCAddon::xbmcgui::Window));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowDialog
  TypeInfo TyXBMCAddon_xbmcgui_WindowDialog_Type(typeid(XBMCAddon::xbmcgui::WindowDialog));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowXML
  TypeInfo TyXBMCAddon_xbmcgui_WindowXML_Type(typeid(XBMCAddon::xbmcgui::WindowXML));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowXMLDialog
  TypeInfo TyXBMCAddon_xbmcgui_WindowXMLDialog_Type(typeid(XBMCAddon::xbmcgui::WindowXMLDialog));
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmc::InfoTagVideo from another module 
  extern TypeInfo TyXBMCAddon_xbmc_InfoTagVideo_Type;
  //=========================================================================

  //=========================================================================
  // These variables define the type xbmc::InfoTagMusic from another module 
  extern TypeInfo Tyxbmc_InfoTagMusic_Type;
  //=========================================================================



  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::Window. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_Window_Director : public Director, public XBMCAddon::xbmcgui::Window
  {
    public:

      inline XBMCAddon_xbmcgui_Window_Director(int  existingWindowId ) : XBMCAddon::xbmcgui::Window( existingWindowId ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowDialog. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowDialog_Director : public Director, public XBMCAddon::xbmcgui::WindowDialog
  {
    public:

      inline XBMCAddon_xbmcgui_WindowDialog_Director() : XBMCAddon::xbmcgui::WindowDialog() { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowXML. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowXML_Director : public Director, public XBMCAddon::xbmcgui::WindowXML
  {
    public:

      inline XBMCAddon_xbmcgui_WindowXML_Director(XBMCAddon::String const & xmlFilename, XBMCAddon::String const & scriptPath, XBMCAddon::String const & defaultSkin, XBMCAddon::String const & defaultRes ) : XBMCAddon::xbmcgui::WindowXML( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowXMLDialog. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowXMLDialog_Director : public Director, public XBMCAddon::xbmcgui::WindowXMLDialog
  {
    public:

      inline XBMCAddon_xbmcgui_WindowXMLDialog_Director(XBMCAddon::String const & xmlFilename, XBMCAddon::String const & scriptPath, XBMCAddon::String const & defaultSkin, XBMCAddon::String const & defaultRes ) : XBMCAddon::xbmcgui::WindowXMLDialog( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  static PyObject* xbmcgui_getCurrentWindowId (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmcgui::getCurrentWindowId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_getCurrentWindowDialogId (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmcgui::getCurrentWindowDialogId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowDialogId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowDialogId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "label2",
          "iconImage",
          "thumbnailImage",
          "path",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;         
    std::string  iconImage  = XBMCAddon::emptyString;
    PyObject* pyiconImage = NULL;         
    std::string  thumbnailImage  = XBMCAddon::emptyString;
    PyObject* pythumbnailImage = NULL;         
    std::string  path  = XBMCAddon::emptyString;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OOOOO",
       (char**)keywords,
         &pylabel,
         &pylabel2,
         &pyiconImage,
         &pythumbnailImage,
         &pypath
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ListItem"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","ListItem"); 
      if (pyiconImage) PyXBMCGetUnicodeString(iconImage,pyiconImage,false,"iconImage","ListItem"); 
      if (pythumbnailImage) PyXBMCGetUnicodeString(thumbnailImage,pythumbnailImage,false,"thumbnailImage","ListItem"); 
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","ListItem"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ListItem *)new XBMCAddon::xbmcgui::ListItem(  label,  label2,  iconImage,  thumbnailImage,  path  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ListItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getLabel","XBMCAddon::xbmcgui::ListItem"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getLabel2","XBMCAddon::xbmcgui::ListItem"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    std::string  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setLabel","XBMCAddon::xbmcgui::ListItem"))-> setLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    std::string  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel2"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setLabel2","XBMCAddon::xbmcgui::ListItem"))-> setLabel2(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel2\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setIconImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iconImage",
          NULL};
         
    std::string  iconImage ;
    PyObject* pyiconImage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyiconImage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyiconImage) PyXBMCGetUnicodeString(iconImage,pyiconImage,false,"iconImage","setIconImage"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setIconImage","XBMCAddon::xbmcgui::ListItem"))-> setIconImage(  iconImage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setIconImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setIconImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setThumbnailImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "thumbFilename",
          NULL};
         
    std::string  thumbFilename ;
    PyObject* pythumbFilename = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pythumbFilename
       ))
    {
      return NULL;
    }


    try
    {
      if (pythumbFilename) PyXBMCGetUnicodeString(thumbFilename,pythumbFilename,false,"thumbFilename","setThumbnailImage"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setThumbnailImage","XBMCAddon::xbmcgui::ListItem"))-> setThumbnailImage(  thumbFilename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setThumbnailImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setThumbnailImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setArt (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "dictionary",
          NULL};
         
    XBMCAddon::Dictionary< XBMCAddon::StringOrInt  >  dictionary ;
    PyObject* pydictionary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydictionary
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pydictionary, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"dictionary","setArt");
        std::string  value;
        if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,PyInt_Check(pyvalue) || PyLong_Check(pyvalue) || PyFloat_Check(pyvalue),"value","setArt");
        dictionary[key] = value;
      }
    } 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setArt","XBMCAddon::xbmcgui::ListItem"))-> setArt(  dictionary  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setArt\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setArt\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setUniqueIDs (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "dictionary",
          NULL};
         
    XBMCAddon::Dictionary< XBMCAddon::StringOrInt  >  dictionary ;
    PyObject* pydictionary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydictionary
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pydictionary, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"dictionary","setUniqueIDs");
        std::string  value;
        if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,PyInt_Check(pyvalue) || PyLong_Check(pyvalue) || PyFloat_Check(pyvalue),"value","setUniqueIDs");
        dictionary[key] = value;
      }
    } 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setUniqueIDs","XBMCAddon::xbmcgui::ListItem"))-> setUniqueIDs(  dictionary  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setUniqueIDs\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setUniqueIDs\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setRating (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "rating",
          "votes",
          "defaultt",
          NULL};
         
    std::string  type ;
    PyObject* pytype = NULL;         
    float  rating ;         
    int  votes  = 0;         
    bool  defaultt  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"Of|ib",
       (char**)keywords,
         &pytype,
         &rating,
         &votes,
         &defaultt
       ))
    {
      return NULL;
    }


    try
    {
      if (pytype) PyXBMCGetUnicodeString(type,pytype,false,"type","setRating"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setRating","XBMCAddon::xbmcgui::ListItem"))-> setRating(  type,  rating,  votes,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setRating\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setRating\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getArt (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getArt","XBMCAddon::xbmcgui::ListItem"))-> getArt(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getArt\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getArt\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getUniqueID (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getUniqueID","XBMCAddon::xbmcgui::ListItem"))-> getUniqueID(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getUniqueID\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getUniqueID\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getRating (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getRating","XBMCAddon::xbmcgui::ListItem"))-> getRating(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getRating\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getRating\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getVotes (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getVotes","XBMCAddon::xbmcgui::ListItem"))-> getVotes(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVotes\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVotes\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_select (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"select","XBMCAddon::xbmcgui::ListItem"))-> select(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"select\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"select\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"isSelected","XBMCAddon::xbmcgui::ListItem"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setInfo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "infoLabels",
          NULL};
         
    char * type ;         
    XBMCAddon::Dictionary< XBMCAddon::xbmcgui::InfoLabelValue  >  infoLabels ;
    PyObject* pyinfoLabels = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &type,
         &pyinfoLabels
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pyinfoLabels, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"infoLabels","setInfo");
        Alternative< XBMCAddon::StringOrInt ,std::vector< XBMCAddon::xbmcgui::InfoLabelStringOrTuple  >  >  value;
        
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyvalue;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,PyInt_Check(pyentry_1) || PyLong_Check(pyentry_1) || PyFloat_Check(pyentry_1),"entry0_1","setInfo");
        value.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          std::vector< XBMCAddon::xbmcgui::InfoLabelStringOrTuple  >  entry1_1;
          
    if (pyentry_1)
    {
      bool isTuple = PyObject_TypeCheck(pyentry_1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry_1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1_1\" must be either a Tuple or a List.");

      
      PyObject *pyentry2 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyentry_1) : PyList_Size(pyentry_1));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry2 = (isTuple ? PyTuple_GetItem(pyentry_1, i) : PyList_GetItem(pyentry_1, i));
        Alternative< XBMCAddon::StringOrInt ,Tuple< XBMCAddon::String ,XBMCAddon::StringOrInt  >  >  entry2;
        
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_3 = pyentry2;
      try
      {
        std::string  entry0_3;
        if (pyentry_3) PyXBMCGetUnicodeString(entry0_3,pyentry_3,PyInt_Check(pyentry_3) || PyLong_Check(pyentry_3) || PyFloat_Check(pyentry_3),"entry0_3","setInfo");
        entry2.former() = entry0_3;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          Tuple< XBMCAddon::String ,XBMCAddon::StringOrInt  >  entry1_3;
          
    if(pyentry_3)
    {
      bool isTuple = PyObject_TypeCheck(pyentry_3,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry_3,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1_3\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry_3) : PyList_Size(pyentry_3));

      if (vecSize > 0)
      {
        PyObject *pyentry0_4 = NULL;
        pyentry0_4 = (isTuple ? PyTuple_GetItem(pyentry_3, 0) : PyList_GetItem(pyentry_3, 0));
        std::string  entry0_4;
        if (pyentry0_4) PyXBMCGetUnicodeString(entry0_4,pyentry0_4,false,"entry0_4","setInfo");
        entry1_3.first() = entry0_4;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_4 = NULL;
        pyentry1_4 = (isTuple ? PyTuple_GetItem(pyentry_3, 1) : PyList_GetItem(pyentry_3, 1));
        std::string  entry1_4;
        if (pyentry1_4) PyXBMCGetUnicodeString(entry1_4,pyentry1_4,PyInt_Check(pyentry1_4) || PyLong_Check(pyentry1_4) || PyFloat_Check(pyentry1_4),"entry1_4","setInfo");
        entry1_3.second() = entry1_4;
      }

    }

          entry2.later() = entry1_3;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "Tuple<(XBMCAddon::String,XBMCAddon::StringOrInt)>" );
        }
      }
    }
        entry1_1.push_back(entry2);
      }
    }

          value.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "std::vector<(XBMCAddon::xbmcgui::InfoLabelStringOrTuple)>" );
        }
      }
    }
        infoLabels[key] = value;
      }
    } 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setInfo","XBMCAddon::xbmcgui::ListItem"))-> setInfo(  type,  infoLabels  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setInfo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setInfo\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setCast (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "actors",
          NULL};
         
    std::vector< XBMCAddon::Properties  >  actors ;
    PyObject* pyactors = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyactors
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyactors)
    {
      bool isTuple = PyObject_TypeCheck(pyactors,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyactors,&PyList_Type))
        throw WrongTypeException("The parameter \"actors\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyactors) : PyList_Size(pyactors));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyactors, i) : PyList_GetItem(pyactors, i));
        XBMCAddon::Dictionary< XBMCAddon::StringOrInt  >  entry1;
        
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pyentry1, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"entry1","setCast");
        std::string  value;
        if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,PyInt_Check(pyvalue) || PyLong_Check(pyvalue) || PyFloat_Check(pyvalue),"value","setCast");
        entry1[key] = value;
      }
    }
        actors.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setCast","XBMCAddon::xbmcgui::ListItem"))-> setCast(  actors  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCast\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCast\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_addStreamInfo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "cType",
          "dictionary",
          NULL};
         
    char * cType ;         
    XBMCAddon::Dictionary< XBMCAddon::StringOrInt  >  dictionary ;
    PyObject* pydictionary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &cType,
         &pydictionary
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pydictionary, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"dictionary","addStreamInfo");
        std::string  value;
        if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,PyInt_Check(pyvalue) || PyLong_Check(pyvalue) || PyFloat_Check(pyvalue),"value","addStreamInfo");
        dictionary[key] = value;
      }
    } 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"addStreamInfo","XBMCAddon::xbmcgui::ListItem"))-> addStreamInfo(  cType,  dictionary  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addStreamInfo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addStreamInfo\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_addContextMenuItems (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          "replaceItems",
          NULL};
         
    std::vector< Tuple< XBMCAddon::String ,XBMCAddon::String  >  >  items ;
    PyObject* pyitems = NULL;         
    bool  replaceItems  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyitems,
         &replaceItems
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyitems)
    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Tuple< XBMCAddon::String ,XBMCAddon::String  >  entry1;
        
    if(pyentry1)
    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        std::string  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","addContextMenuItems");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        std::string  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","addContextMenuItems");
        entry1.second() = entry1_2;
      }

    }

        items.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"addContextMenuItems","XBMCAddon::xbmcgui::ListItem"))-> addContextMenuItems(  items,  replaceItems  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addContextMenuItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addContextMenuItems\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          "value",
          NULL};
         
    char * key ;         
    std::string  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","setProperty"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setProperty","XBMCAddon::xbmcgui::ListItem"))-> setProperty(  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getProperty","XBMCAddon::xbmcgui::ListItem"))-> getProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProperty\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }


    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","setPath"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setPath","XBMCAddon::xbmcgui::ListItem"))-> setPath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setMimeType (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "mimetype",
          NULL};
         
    std::string  mimetype ;
    PyObject* pymimetype = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pymimetype
       ))
    {
      return NULL;
    }


    try
    {
      if (pymimetype) PyXBMCGetUnicodeString(mimetype,pymimetype,false,"mimetype","setMimeType"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setMimeType","XBMCAddon::xbmcgui::ListItem"))-> setMimeType(  mimetype  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setMimeType\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setMimeType\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setContentLookup (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "enable",
          NULL};
         
    bool  enable ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &enable
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setContentLookup","XBMCAddon::xbmcgui::ListItem"))-> setContentLookup(  enable  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setContentLookup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setContentLookup\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "subtitleFiles",
          NULL};
         
    std::vector< XBMCAddon::String  >  subtitleFiles ;
    PyObject* pysubtitleFiles = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pysubtitleFiles
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pysubtitleFiles)
    {
      bool isTuple = PyObject_TypeCheck(pysubtitleFiles,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pysubtitleFiles,&PyList_Type))
        throw WrongTypeException("The parameter \"subtitleFiles\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pysubtitleFiles) : PyList_Size(pysubtitleFiles));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pysubtitleFiles, i) : PyList_GetItem(pysubtitleFiles, i));
        std::string  entry1;
        if (pyentry1) PyXBMCGetUnicodeString(entry1,pyentry1,false,"entry1","setSubtitles");
        subtitleFiles.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setSubtitles","XBMCAddon::xbmcgui::ListItem"))-> setSubtitles(  subtitleFiles  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getdescription (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getdescription","XBMCAddon::xbmcgui::ListItem"))-> getdescription(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getdescription\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getdescription\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getduration (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getduration","XBMCAddon::xbmcgui::ListItem"))-> getduration(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getduration\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getduration\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getfilename (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getfilename","XBMCAddon::xbmcgui::ListItem"))-> getfilename(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getfilename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getfilename\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getPath","XBMCAddon::xbmcgui::ListItem"))-> getPath(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getVideoInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    xbmc::InfoTagVideo * apiResult;
    try
    {

      apiResult = (xbmc::InfoTagVideo *)((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getVideoInfoTag","XBMCAddon::xbmcgui::ListItem"))-> getVideoInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVideoInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVideoInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getMusicInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    xbmc::InfoTagMusic * apiResult;
    try
    {

      apiResult = (xbmc::InfoTagMusic *)((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getMusicInfoTag","XBMCAddon::xbmcgui::ListItem"))-> getMusicInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getMusicInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getMusicInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 


  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_canAcceptMessages (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "actionId",
          NULL};
         
    int  actionId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &actionId
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"canAcceptMessages","XBMCAddon::xbmcgui::Control"))-> canAcceptMessages(  actionId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"canAcceptMessages\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"canAcceptMessages\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getId","XBMCAddon::xbmcgui::Control"))-> getId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 




  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::vector< int  >  apiResult;
    try
    {

      apiResult = (std::vector< int  > )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getPosition","XBMCAddon::xbmcgui::Control"))-> getPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPosition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
      result = PyList_New(0);

      for (std::vector<int >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        int & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = Py_BuildValue((char*)"i", entry1);
        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getX (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getX","XBMCAddon::xbmcgui::Control"))-> getX(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getX\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getY (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getY","XBMCAddon::xbmcgui::Control"))-> getY(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getY\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getY\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getHeight","XBMCAddon::xbmcgui::Control"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getWidth","XBMCAddon::xbmcgui::Control"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setEnabled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "enabled",
          NULL};
         
    bool  enabled ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &enabled
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setEnabled","XBMCAddon::xbmcgui::Control"))-> setEnabled(  enabled  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setEnabled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setEnabled\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setVisible","XBMCAddon::xbmcgui::Control"))-> setVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setVisible\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setVisibleCondition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "visible",
          "allowHiddenFocus",
          NULL};
         
    char * visible ;         
    bool  allowHiddenFocus  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &visible,
         &allowHiddenFocus
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setVisibleCondition","XBMCAddon::xbmcgui::Control"))-> setVisibleCondition(  visible,  allowHiddenFocus  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setVisibleCondition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setVisibleCondition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setEnableCondition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "enable",
          NULL};
         
    char * enable ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &enable
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setEnableCondition","XBMCAddon::xbmcgui::Control"))-> setEnableCondition(  enable  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setEnableCondition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setEnableCondition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setAnimations (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "eventAttr",
          NULL};
         
    std::vector< Tuple< XBMCAddon::String ,XBMCAddon::String  >  >  eventAttr ;
    PyObject* pyeventAttr = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyeventAttr
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyeventAttr)
    {
      bool isTuple = PyObject_TypeCheck(pyeventAttr,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyeventAttr,&PyList_Type))
        throw WrongTypeException("The parameter \"eventAttr\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyeventAttr) : PyList_Size(pyeventAttr));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyeventAttr, i) : PyList_GetItem(pyeventAttr, i));
        Tuple< XBMCAddon::String ,XBMCAddon::String  >  entry1;
        
    if(pyentry1)
    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        std::string  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","setAnimations");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        std::string  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","setAnimations");
        entry1.second() = entry1_2;
      }

    }

        eventAttr.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setAnimations","XBMCAddon::xbmcgui::Control"))-> setAnimations(  eventAttr  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setAnimations\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setAnimations\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          NULL};
         
    long  x ;         
    long  y ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &x,
         &y
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setPosition","XBMCAddon::xbmcgui::Control"))-> setPosition(  x,  y  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPosition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "width",
          NULL};
         
    long  width ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &width
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setWidth","XBMCAddon::xbmcgui::Control"))-> setWidth(  width  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setWidth\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setHeight","XBMCAddon::xbmcgui::Control"))-> setHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setNavigation (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "left",
          "right",
          NULL};
         
    XBMCAddon::xbmcgui::Control * up ;
    PyObject* pyup = NULL;         
    XBMCAddon::xbmcgui::Control * down ;
    PyObject* pydown = NULL;         
    XBMCAddon::xbmcgui::Control * left ;
    PyObject* pyleft = NULL;         
    XBMCAddon::xbmcgui::Control * right ;
    PyObject* pyright = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OOOO",
       (char**)keywords,
         &pyup,
         &pydown,
         &pyleft,
         &pyright
       ))
    {
      return NULL;
    }


    try
    {
      up = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyup,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      down = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pydown,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      left = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyleft,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      right = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyright,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setNavigation","XBMCAddon::xbmcgui::Control"))-> setNavigation(  up,  down,  left,  right  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setNavigation\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setNavigation\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlUp (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "up",
          NULL};
         
    XBMCAddon::xbmcgui::Control * up ;
    PyObject* pyup = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyup
       ))
    {
      return NULL;
    }


    try
    {
      up = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyup,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlUp"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlUp","XBMCAddon::xbmcgui::Control"))-> controlUp(  up  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlUp\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlUp\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlDown (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlDown"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlDown","XBMCAddon::xbmcgui::Control"))-> controlDown(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlDown\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlDown\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlLeft (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlLeft"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlLeft","XBMCAddon::xbmcgui::Control"))-> controlLeft(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlLeft\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlLeft\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlRight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlRight"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlRight","XBMCAddon::xbmcgui::Control"))-> controlRight(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlRight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlRight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSpin_setTextures (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "upFocus",
          "downFocus",
          "upDisabled",
          "downDisabled",
          NULL};
         
    char * up ;         
    char * down ;         
    char * upFocus ;         
    char * downFocus ;         
    char * upDisabled ;         
    char * downDisabled ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ssssss",
       (char**)keywords,
         &up,
         &down,
         &upFocus,
         &downFocus,
         &upDisabled,
         &downDisabled
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlSpin*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSpin_Type,"setTextures","XBMCAddon::xbmcgui::ControlSpin"))-> setTextures(  up,  down,  upFocus,  downFocus,  upDisabled,  downDisabled  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setTextures\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setTextures\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 


  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "font",
          "textColor",
          "disabledColor",
          "alignment",
          "hasPath",
          "angle",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  alignment  = XBFONT_LEFT;         
    bool  hasPath  = false;         
    long  angle  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|ssslbl",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &alignment,
         &hasPath,
         &angle
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlLabel * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlLabel"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlLabel *)new XBMCAddon::xbmcgui::ControlLabel(  x,  y,  width,  height,  label,  font,  textColor,  disabledColor,  alignment,  hasPath,  angle  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlLabel_Type,"getLabel","XBMCAddon::xbmcgui::ControlLabel"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlLabel_Type,"setLabel","XBMCAddon::xbmcgui::ControlLabel"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "font",
          "textColor",
          "disabledColor",
          "_alignment",
          "focusTexture",
          "noFocusTexture",
          "isPassword",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  _alignment  = XBFONT_LEFT;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    bool  isPassword  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|ssslssb",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &_alignment,
         &focusTexture,
         &noFocusTexture,
         &isPassword
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlEdit * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlEdit"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlEdit *)new XBMCAddon::xbmcgui::ControlEdit(  x,  y,  width,  height,  label,  font,  textColor,  disabledColor,  _alignment,  focusTexture,  noFocusTexture,  isPassword  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlEdit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlEdit\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"setLabel","XBMCAddon::xbmcgui::ControlEdit"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"getLabel","XBMCAddon::xbmcgui::ControlEdit"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    std::string  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"setText","XBMCAddon::xbmcgui::ControlEdit"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"getText","XBMCAddon::xbmcgui::ControlEdit"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          "buttonTexture",
          "buttonFocusTexture",
          "selectedColor",
          "_imageWidth",
          "_imageHeight",
          "_itemTextXOffset",
          "_itemTextYOffset",
          "_itemHeight",
          "_space",
          "_alignmentY",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * buttonTexture  = NULL;         
    char * buttonFocusTexture  = NULL;         
    char * selectedColor  = NULL;         
    long  _imageWidth  = 10;         
    long  _imageHeight  = 10;         
    long  _itemTextXOffset  = 10;         
    long  _itemTextYOffset  = 2;         
    long  _itemHeight  = 27;         
    long  _space  = 2;         
    long  _alignmentY  = XBFONT_CENTER_Y;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ssssslllllll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor,
         &buttonTexture,
         &buttonFocusTexture,
         &selectedColor,
         &_imageWidth,
         &_imageHeight,
         &_itemTextXOffset,
         &_itemTextYOffset,
         &_itemHeight,
         &_space,
         &_alignmentY
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlList * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlList *)new XBMCAddon::xbmcgui::ControlList(  x,  y,  width,  height,  font,  textColor,  buttonTexture,  buttonFocusTexture,  selectedColor,  _imageWidth,  _imageHeight,  _itemTextXOffset,  _itemTextYOffset,  _itemHeight,  _space,  _alignmentY  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlList\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_addItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          "sendMessage",
          NULL};
         
    Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  item ;
    PyObject* pyitem = NULL;         
    bool  sendMessage  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyitem,
         &sendMessage
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyitem;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,false,"entry0_1","addItem");
        item.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_1;
          entry1_1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItem");
          item.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    } 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"addItem","XBMCAddon::xbmcgui::ControlList"))-> addItem(  item,  sendMessage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_addItems (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  >  items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyitems)
    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  entry1;
        
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_2 = pyentry1;
      try
      {
        std::string  entry0_2;
        if (pyentry_2) PyXBMCGetUnicodeString(entry0_2,pyentry_2,false,"entry0_2","addItems");
        entry1.former() = entry0_2;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_2;
          entry1_2 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_2,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItems");
          entry1.later() = entry1_2;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }
        items.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"addItems","XBMCAddon::xbmcgui::ControlList"))-> addItems(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItems\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_selectItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          NULL};
         
    long  item ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &item
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"selectItem","XBMCAddon::xbmcgui::ControlList"))-> selectItem(  item  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"selectItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"selectItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_removeItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "index",
          NULL};
         
    int  index ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &index
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"removeItem","XBMCAddon::xbmcgui::ControlList"))-> removeItem(  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"reset","XBMCAddon::xbmcgui::ControlList"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpinControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSpinControl","XBMCAddon::xbmcgui::ControlList"))-> getSpinControl(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpinControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpinControl\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSelectedPosition","XBMCAddon::xbmcgui::ControlList"))-> getSelectedPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedPosition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSelectedItem","XBMCAddon::xbmcgui::ControlList"))-> getSelectedItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setImageDimensions (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "imageWidth",
          "imageHeight",
          NULL};
         
    long  imageWidth ;         
    long  imageHeight ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &imageWidth,
         &imageHeight
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setImageDimensions","XBMCAddon::xbmcgui::ControlList"))-> setImageDimensions(  imageWidth,  imageHeight  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImageDimensions\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImageDimensions\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setItemHeight","XBMCAddon::xbmcgui::ControlList"))-> setItemHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setItemHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "space",
          NULL};
         
    int  space ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &space
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setSpace","XBMCAddon::xbmcgui::ControlList"))-> setSpace(  space  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSpace\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setPageControlVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setPageControlVisible","XBMCAddon::xbmcgui::ControlList"))-> setPageControlVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPageControlVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPageControlVisible\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"size","XBMCAddon::xbmcgui::ControlList"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getItemHeight","XBMCAddon::xbmcgui::ControlList"))-> getItemHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getItemHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSpace","XBMCAddon::xbmcgui::ControlList"))-> getSpace(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpace\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "index",
          NULL};
         
    int  index ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &index
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getListItem","XBMCAddon::xbmcgui::ControlList"))-> getListItem(  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setStaticContent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::ListItem * > * items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyitems)
    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      items = new std::vector<XBMCAddon::xbmcgui::ListItem *>();
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        XBMCAddon::xbmcgui::ListItem * entry1;
        entry1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","setStaticContent");
        items->push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setStaticContent","XBMCAddon::xbmcgui::ControlList"))-> setStaticContent(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setStaticContent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setStaticContent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          "_alignment",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    long  _alignment  = XBFONT_LEFT;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ssl",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor,
         &_alignment
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlFadeLabel * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlFadeLabel *)new XBMCAddon::xbmcgui::ControlFadeLabel(  x,  y,  width,  height,  font,  textColor,  _alignment  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlFadeLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlFadeLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_addLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    std::string  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","addLabel"); 

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"addLabel","XBMCAddon::xbmcgui::ControlFadeLabel"))-> addLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_setScrolling (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "scroll",
          NULL};
         
    bool  scroll ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &scroll
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"setScrolling","XBMCAddon::xbmcgui::ControlFadeLabel"))-> setScrolling(  scroll  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setScrolling\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setScrolling\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"reset","XBMCAddon::xbmcgui::ControlFadeLabel"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlTextBox * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlTextBox *)new XBMCAddon::xbmcgui::ControlTextBox(  x,  y,  width,  height,  font,  textColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlTextBox\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlTextBox\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    std::string  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"setText","XBMCAddon::xbmcgui::ControlTextBox"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"getText","XBMCAddon::xbmcgui::ControlTextBox"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"reset","XBMCAddon::xbmcgui::ControlTextBox"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_scroll (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    long  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"scroll","XBMCAddon::xbmcgui::ControlTextBox"))-> scroll(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"scroll\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"scroll\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_autoScroll (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "delay",
          "time",
          "repeat",
          NULL};
         
    int  delay ;         
    int  time ;         
    int  repeat ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iii",
       (char**)keywords,
         &delay,
         &time,
         &repeat
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"autoScroll","XBMCAddon::xbmcgui::ControlTextBox"))-> autoScroll(  delay,  time,  repeat  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"autoScroll\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"autoScroll\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "filename",
          "aspectRatio",
          "colorDiffuse",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * filename ;         
    long  aspectRatio  = 0;         
    char * colorDiffuse  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"lllls|ls",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &filename,
         &aspectRatio,
         &colorDiffuse
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlImage * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlImage *)new XBMCAddon::xbmcgui::ControlImage(  x,  y,  width,  height,  filename,  aspectRatio,  colorDiffuse  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_setImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "imageFilename",
          "useCache",
          NULL};
         
    char * imageFilename ;         
    bool  useCache  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &imageFilename,
         &useCache
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlImage_Type,"setImage","XBMCAddon::xbmcgui::ControlImage"))-> setImage(  imageFilename,  useCache  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_setColorDiffuse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "hexString",
          NULL};
         
    char * hexString ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &hexString
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlImage_Type,"setColorDiffuse","XBMCAddon::xbmcgui::ControlImage"))-> setColorDiffuse(  hexString  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setColorDiffuse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setColorDiffuse\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "texturebg",
          "textureleft",
          "texturemid",
          "textureright",
          "textureoverlay",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * texturebg  = NULL;         
    char * textureleft  = NULL;         
    char * texturemid  = NULL;         
    char * textureright  = NULL;         
    char * textureoverlay  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|sssss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &texturebg,
         &textureleft,
         &texturemid,
         &textureright,
         &textureoverlay
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlProgress * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlProgress *)new XBMCAddon::xbmcgui::ControlProgress(  x,  y,  width,  height,  texturebg,  textureleft,  texturemid,  textureright,  textureoverlay  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlProgress\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlProgress_Type,"setPercent","XBMCAddon::xbmcgui::ControlProgress"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlProgress_Type,"getPercent","XBMCAddon::xbmcgui::ControlProgress"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusTexture",
          "noFocusTexture",
          "textOffsetX",
          "textOffsetY",
          "alignment",
          "font",
          "textColor",
          "disabledColor",
          "angle",
          "shadowColor",
          "focusedColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  textOffsetX  = 10;         
    long  textOffsetY  = 2;         
    long  alignment  = (XBFONT_LEFT|XBFONT_CENTER_Y);         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  angle  = 0;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sslllssslss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusTexture,
         &noFocusTexture,
         &textOffsetX,
         &textOffsetY,
         &alignment,
         &font,
         &textColor,
         &disabledColor,
         &angle,
         &shadowColor,
         &focusedColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlButton * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlButton"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlButton *)new XBMCAddon::xbmcgui::ControlButton(  x,  y,  width,  height,  label,  focusTexture,  noFocusTexture,  textOffsetX,  textOffsetY,  alignment,  font,  textColor,  disabledColor,  angle,  shadowColor,  focusedColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlButton\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"setLabel","XBMCAddon::xbmcgui::ControlButton"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_setDisabledColor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "color",
          NULL};
         
    char * color ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &color
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"setDisabledColor","XBMCAddon::xbmcgui::ControlButton"))-> setDisabledColor(  color  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDisabledColor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDisabledColor\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"getLabel","XBMCAddon::xbmcgui::ControlButton"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"getLabel2","XBMCAddon::xbmcgui::ControlButton"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlGroup_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlGroup * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlGroup *)new XBMCAddon::xbmcgui::ControlGroup(  x,  y,  width,  height  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlGroup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlGroup\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusOnTexture",
          "noFocusOnTexture",
          "focusOffTexture",
          "noFocusOffTexture",
          "focusTexture",
          "noFocusTexture",
          "textOffsetX",
          "textOffsetY",
          "_alignment",
          "font",
          "textColor",
          "disabledColor",
          "angle",
          "shadowColor",
          "focusedColor",
          "disabledOnTexture",
          "disabledOffTexture",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * focusOnTexture  = NULL;         
    char * noFocusOnTexture  = NULL;         
    char * focusOffTexture  = NULL;         
    char * noFocusOffTexture  = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  textOffsetX  = 10;         
    long  textOffsetY  = 2;         
    long  _alignment  = (XBFONT_LEFT|XBFONT_CENTER_Y);         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  angle  = 0;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    char * disabledOnTexture  = NULL;         
    char * disabledOffTexture  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sssssslllssslssss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusOnTexture,
         &noFocusOnTexture,
         &focusOffTexture,
         &noFocusOffTexture,
         &focusTexture,
         &noFocusTexture,
         &textOffsetX,
         &textOffsetY,
         &_alignment,
         &font,
         &textColor,
         &disabledColor,
         &angle,
         &shadowColor,
         &focusedColor,
         &disabledOnTexture,
         &disabledOffTexture
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlRadioButton * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlRadioButton"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlRadioButton *)new XBMCAddon::xbmcgui::ControlRadioButton(  x,  y,  width,  height,  label,  focusOnTexture,  noFocusOnTexture,  focusOffTexture,  noFocusOffTexture,  focusTexture,  noFocusTexture,  textOffsetX,  textOffsetY,  _alignment,  font,  textColor,  disabledColor,  angle,  shadowColor,  focusedColor,  disabledOnTexture,  disabledOffTexture  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlRadioButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlRadioButton\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setSelected","XBMCAddon::xbmcgui::ControlRadioButton"))-> setSelected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSelected\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"isSelected","XBMCAddon::xbmcgui::ControlRadioButton"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setLabel","XBMCAddon::xbmcgui::ControlRadioButton"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setRadioDimension","XBMCAddon::xbmcgui::ControlRadioButton"))-> setRadioDimension(  x,  y,  width,  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setRadioDimension\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setRadioDimension\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "textureback",
          "texture",
          "texturefocus",
          "orientation",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * textureback  = NULL;         
    char * texture  = NULL;         
    char * texturefocus  = NULL;         
    int  orientation  = 1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|sssi",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &textureback,
         &texture,
         &texturefocus,
         &orientation
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlSlider * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlSlider *)new XBMCAddon::xbmcgui::ControlSlider(  x,  y,  width,  height,  textureback,  texture,  texturefocus,  orientation  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlSlider\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlSlider\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSlider_Type,"getPercent","XBMCAddon::xbmcgui::ControlSlider"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSlider_Type,"setPercent","XBMCAddon::xbmcgui::ControlSlider"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Dialog * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Dialog *)new XBMCAddon::xbmcgui::Dialog(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Dialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Dialog\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_yesno (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          "nolabel",
          "yeslabel",
          "autoclose",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  line1 ;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;         
    std::string  nolabel  = XBMCAddon::emptyString;
    PyObject* pynolabel = NULL;         
    std::string  yeslabel  = XBMCAddon::emptyString;
    PyObject* pyyeslabel = NULL;         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|OOOOi",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3,
         &pynolabel,
         &pyyeslabel,
         &autoclose
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","yesno"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","yesno"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","yesno"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","yesno"); 
      if (pynolabel) PyXBMCGetUnicodeString(nolabel,pynolabel,false,"nolabel","yesno"); 
      if (pyyeslabel) PyXBMCGetUnicodeString(yeslabel,pyyeslabel,false,"yeslabel","yesno"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"yesno","XBMCAddon::xbmcgui::Dialog"))-> yesno(  heading,  line1,  line2,  line3,  nolabel,  yeslabel,  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"yesno\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"yesno\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_info (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          NULL};
         
    XBMCAddon::xbmcgui::ListItem * item ;
    PyObject* pyitem = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitem
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      item = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","info"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"info","XBMCAddon::xbmcgui::Dialog"))-> info(  item  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"info\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"info\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_select (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "list",
          "autoclose",
          "preselect",
          "useDetails",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::vector< Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  >  list ;
    PyObject* pylist = NULL;         
    int  autoclose  = 0;         
    int  preselect  = -1;         
    bool  useDetails  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|iib",
       (char**)keywords,
         &pyheading,
         &pylist,
         &autoclose,
         &preselect,
         &useDetails
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","select"); 
      
    if (pylist)
    {
      bool isTuple = PyObject_TypeCheck(pylist,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pylist,&PyList_Type))
        throw WrongTypeException("The parameter \"list\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pylist) : PyList_Size(pylist));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pylist, i) : PyList_GetItem(pylist, i));
        Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  entry1;
        
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_2 = pyentry1;
      try
      {
        std::string  entry0_2;
        if (pyentry_2) PyXBMCGetUnicodeString(entry0_2,pyentry_2,false,"entry0_2","select");
        entry1.former() = entry0_2;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_2;
          entry1_2 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_2,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","select");
          entry1.later() = entry1_2;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }
        list.push_back(entry1);
      }
    }
 

      apiResult = (int )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"select","XBMCAddon::xbmcgui::Dialog"))-> select(  heading,  list,  autoclose,  preselect,  useDetails  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"select\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"select\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_contextmenu (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "list",
          NULL};
         
    std::vector< XBMCAddon::String  >  list ;
    PyObject* pylist = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylist
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {
      
    if (pylist)
    {
      bool isTuple = PyObject_TypeCheck(pylist,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pylist,&PyList_Type))
        throw WrongTypeException("The parameter \"list\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pylist) : PyList_Size(pylist));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pylist, i) : PyList_GetItem(pylist, i));
        std::string  entry1;
        if (pyentry1) PyXBMCGetUnicodeString(entry1,pyentry1,false,"entry1","contextmenu");
        list.push_back(entry1);
      }
    }
 

      apiResult = (int )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"contextmenu","XBMCAddon::xbmcgui::Dialog"))-> contextmenu(  list  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"contextmenu\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"contextmenu\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_multiselect (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "options",
          "autoclose",
          "preselect",
          "useDetails",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::vector< Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  >  options ;
    PyObject* pyoptions = NULL;         
    int  autoclose  = 0;         
    std::vector< int  >  preselect  = std::vector< int >();
    PyObject* pypreselect = NULL;         
    bool  useDetails  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|iOb",
       (char**)keywords,
         &pyheading,
         &pyoptions,
         &autoclose,
         &pypreselect,
         &useDetails
       ))
    {
      return NULL;
    }

    std::unique_ptr< std::vector< int  >  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","multiselect"); 
      
    if (pyoptions)
    {
      bool isTuple = PyObject_TypeCheck(pyoptions,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyoptions,&PyList_Type))
        throw WrongTypeException("The parameter \"options\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyoptions) : PyList_Size(pyoptions));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyoptions, i) : PyList_GetItem(pyoptions, i));
        Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  entry1;
        
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_2 = pyentry1;
      try
      {
        std::string  entry0_2;
        if (pyentry_2) PyXBMCGetUnicodeString(entry0_2,pyentry_2,false,"entry0_2","multiselect");
        entry1.former() = entry0_2;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_2;
          entry1_2 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_2,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","multiselect");
          entry1.later() = entry1_2;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }
        options.push_back(entry1);
      }
    }
 
      
    if (pypreselect)
    {
      bool isTuple = PyObject_TypeCheck(pypreselect,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypreselect,&PyList_Type))
        throw WrongTypeException("The parameter \"preselect\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypreselect) : PyList_Size(pypreselect));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypreselect, i) : PyList_GetItem(pypreselect, i));
        int  entry1;
        entry1 = (int)PyInt_AsLong(pyentry1);
        preselect.push_back(entry1);
      }
    }
 

      apiResult = (std::unique_ptr< std::vector< int  >  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"multiselect","XBMCAddon::xbmcgui::Dialog"))-> multiselect(  heading,  options,  autoclose,  preselect,  useDetails  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"multiselect\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"multiselect\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
    std::vector< int  > * entry1 = apiResult.get();
    
    if (entry1 != NULL)
    { 

      result = PyList_New(0);

      for (std::vector<int >::iterator iter = entry1->begin(); iter != entry1->end(); ++iter)
      {
        int & entry2 = *iter;
        PyObject* pyentry2;
        pyentry2 = Py_BuildValue((char*)"i", entry2);
        PyList_Append(result, pyentry2);
        Py_DECREF(pyentry2);
      }

    }




    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_ok (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  line1 ;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|OO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","ok"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","ok"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","ok"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","ok"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"ok","XBMCAddon::xbmcgui::Dialog"))-> ok(  heading,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"ok\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"ok\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_textviewer (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "text",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO",
       (char**)keywords,
         &pyheading,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","textviewer"); 
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","textviewer"); 

      ((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"textviewer","XBMCAddon::xbmcgui::Dialog"))-> textviewer(  heading,  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"textviewer\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"textviewer\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          "enableMultiple",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  shares ;
    PyObject* pyshares = NULL;         
    std::string  mask  = XBMCAddon::emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;         
    bool  enableMultiple  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbOb",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt,
         &enableMultiple
       ))
    {
      return NULL;
    }

    Alternative< XBMCAddon::String ,std::vector< XBMCAddon::String  >  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browse"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browse"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browse"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browse"); 

      apiResult = (Alternative< XBMCAddon::String ,std::vector< XBMCAddon::String  >  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"browse","XBMCAddon::xbmcgui::Dialog"))-> browse(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt,  enableMultiple  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browse\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
    WhichAlternative pos = apiResult.which();

    if (pos != XBMCAddon::none)
    { 
      if (pos == XBMCAddon::first)
      {
        std::string & entry1 = apiResult.former();
        {
          result = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        }
      }

      if (pos == XBMCAddon::second)
      {
        std::vector< XBMCAddon::String  > & entry1 = apiResult.later();
        {
          
      result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = entry1.begin(); iter != entry1.end(); ++iter)
      {
        std::string & entry2 = *iter;
        PyObject* pyentry2;
        pyentry2 = PyString_FromStringAndSize(entry2.c_str(), entry2.length());
        PyList_Append(result, pyentry2);
        Py_DECREF(pyentry2);
      }


        }
      }

    }
    else
      result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browseSingle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  shares ;
    PyObject* pyshares = NULL;         
    std::string  mask  = XBMCAddon::emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbO",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browseSingle"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browseSingle"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browseSingle"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browseSingle"); 

      apiResult = (std::string )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"browseSingle","XBMCAddon::xbmcgui::Dialog"))-> browseSingle(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browseSingle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browseSingle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browseMultiple (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  shares ;
    PyObject* pyshares = NULL;         
    std::string  mask  = XBMCAddon::emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbO",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::vector< XBMCAddon::String  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browseMultiple"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browseMultiple"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browseMultiple"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browseMultiple"); 

      apiResult = (std::vector< XBMCAddon::String  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"browseMultiple","XBMCAddon::xbmcgui::Dialog"))-> browseMultiple(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browseMultiple\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browseMultiple\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
      result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_numeric (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "defaultt",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iO|O",
       (char**)keywords,
         &type,
         &pyheading,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","numeric"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","numeric"); 

      apiResult = (std::string )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"numeric","XBMCAddon::xbmcgui::Dialog"))-> numeric(  type,  heading,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"numeric\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"numeric\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_notification (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "message",
          "icon",
          "time",
          "sound",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  message ;
    PyObject* pymessage = NULL;         
    std::string  icon  = XBMCAddon::emptyString;
    PyObject* pyicon = NULL;         
    int  time  = 0;         
    bool  sound  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|Oib",
       (char**)keywords,
         &pyheading,
         &pymessage,
         &pyicon,
         &time,
         &sound
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","notification"); 
      if (pymessage) PyXBMCGetUnicodeString(message,pymessage,false,"message","notification"); 
      if (pyicon) PyXBMCGetUnicodeString(icon,pyicon,false,"icon","notification"); 

      ((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"notification","XBMCAddon::xbmcgui::Dialog"))-> notification(  heading,  message,  icon,  time,  sound  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"notification\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"notification\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_input (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "defaultt",
          "type",
          "option",
          "autoclose",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;         
    int  type  = 0;         
    int  option  = 0;         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|Oiii",
       (char**)keywords,
         &pyheading,
         &pydefaultt,
         &type,
         &option,
         &autoclose
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","input"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","input"); 

      apiResult = (std::string )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"input","XBMCAddon::xbmcgui::Dialog"))-> input(  heading,  defaultt,  type,  option,  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"input\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"input\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::DialogProgress * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::DialogProgress *)new XBMCAddon::xbmcgui::DialogProgress(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgress\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_create (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  line1  = XBMCAddon::emptyString;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|OOO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","create"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","create"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","create"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","create"); 

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"create","XBMCAddon::xbmcgui::DialogProgress"))-> create(  heading,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"create\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"create\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_update (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "percent",
          "line1",
          "line2",
          "line3",
          NULL};
         
    int  percent ;         
    std::string  line1  = XBMCAddon::emptyString;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i|OOO",
       (char**)keywords,
         &percent,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }


    try
    {
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","update"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","update"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","update"); 

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"update","XBMCAddon::xbmcgui::DialogProgress"))-> update(  percent,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"update\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"update\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"close","XBMCAddon::xbmcgui::DialogProgress"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_iscanceled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"iscanceled","XBMCAddon::xbmcgui::DialogProgress"))-> iscanceled(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"iscanceled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"iscanceled\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogBusy_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::DialogBusy * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::DialogBusy *)new XBMCAddon::xbmcgui::DialogBusy(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogBusy\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogBusy\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogBusy_create (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogBusy*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogBusy_Type,"create","XBMCAddon::xbmcgui::DialogBusy"))-> create(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"create\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"create\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogBusy_update (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "percent",
          NULL};
         
    int  percent ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &percent
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::DialogBusy*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogBusy_Type,"update","XBMCAddon::xbmcgui::DialogBusy"))-> update(  percent  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"update\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"update\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogBusy_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogBusy*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogBusy_Type,"close","XBMCAddon::xbmcgui::DialogBusy"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogBusy_iscanceled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::DialogBusy*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogBusy_Type,"iscanceled","XBMCAddon::xbmcgui::DialogBusy"))-> iscanceled(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"iscanceled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"iscanceled\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::DialogProgressBG * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::DialogProgressBG *)new XBMCAddon::xbmcgui::DialogProgressBG(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgressBG\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgressBG\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_create (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "message",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  message  = XBMCAddon::emptyString;
    PyObject* pymessage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|O",
       (char**)keywords,
         &pyheading,
         &pymessage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","create"); 
      if (pymessage) PyXBMCGetUnicodeString(message,pymessage,false,"message","create"); 

      ((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"create","XBMCAddon::xbmcgui::DialogProgressBG"))-> create(  heading,  message  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"create\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"create\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_update (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "percent",
          "heading",
          "message",
          NULL};
         
    int  percent  = 0;         
    std::string  heading  = XBMCAddon::emptyString;
    PyObject* pyheading = NULL;         
    std::string  message  = XBMCAddon::emptyString;
    PyObject* pymessage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|iOO",
       (char**)keywords,
         &percent,
         &pyheading,
         &pymessage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","update"); 
      if (pymessage) PyXBMCGetUnicodeString(message,pymessage,false,"message","update"); 

      ((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"update","XBMCAddon::xbmcgui::DialogProgressBG"))-> update(  percent,  heading,  message  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"update\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"update\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"close","XBMCAddon::xbmcgui::DialogProgressBG"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_isFinished (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"isFinished","XBMCAddon::xbmcgui::DialogProgressBG"))-> isFinished(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isFinished\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isFinished\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Action * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Action *)new XBMCAddon::xbmcgui::Action(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Action\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Action\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getId","XBMCAddon::xbmcgui::Action"))-> getId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getButtonCode (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getButtonCode","XBMCAddon::xbmcgui::Action"))-> getButtonCode(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getButtonCode\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getButtonCode\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getAmount1 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getAmount1","XBMCAddon::xbmcgui::Action"))-> getAmount1(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAmount1\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAmount1\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getAmount2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getAmount2","XBMCAddon::xbmcgui::Action"))-> getAmount2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAmount2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAmount2\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    int  existingWindowId  = -1;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|i",
       
         &existingWindowId
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Window * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Window *)(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_Window_Director( existingWindowId ) : new XBMCAddon::xbmcgui::Window(  existingWindowId  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Window\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Window\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_Window_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_Window_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onAction (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "action",
          NULL};
         
    XBMCAddon::xbmcgui::Action * action ;
    PyObject* pyaction = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyaction
       ))
    {
      return NULL;
    }


    try
    {
      action = (XBMCAddon::xbmcgui::Action *)retrieveApiInstance(pyaction,"p.XBMCAddon::xbmcgui::Action","XBMCAddon::xbmcgui::","onAction"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onAction","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onAction(  action  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onAction\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onAction\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","onControl"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onControl","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onControl(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onControl\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onClick (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onClick","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onClick(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onClick\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onClick\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onDoubleClick (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onDoubleClick","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onDoubleClick(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDoubleClick\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDoubleClick\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onFocus","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onFocus(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onFocus\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onInit (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onInit","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onInit(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onInit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onInit\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_show (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"show","XBMCAddon::xbmcgui::Window"))-> show(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"show\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"show\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setFocus"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setFocus","XBMCAddon::xbmcgui::Window"))-> setFocus(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setFocus\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setFocusId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iControlId",
          NULL};
         
    int  iControlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iControlId
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setFocusId","XBMCAddon::xbmcgui::Window"))-> setFocusId(  iControlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setFocusId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setFocusId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getFocus","XBMCAddon::xbmcgui::Window"))-> getFocus(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFocus\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getFocusId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getFocusId","XBMCAddon::xbmcgui::Window"))-> getFocusId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFocusId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFocusId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_removeControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","removeControl"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"removeControl","XBMCAddon::xbmcgui::Window"))-> removeControl(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeControl\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_removeControls (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControls",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::Control * >  pControls ;
    PyObject* pypControls = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControls
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pypControls)
    {
      bool isTuple = PyObject_TypeCheck(pypControls,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypControls,&PyList_Type))
        throw WrongTypeException("The parameter \"pControls\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypControls) : PyList_Size(pypControls));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypControls, i) : PyList_GetItem(pypControls, i));
        XBMCAddon::xbmcgui::Control * entry1;
        entry1 = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","removeControls");
        pControls.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"removeControls","XBMCAddon::xbmcgui::Window"))-> removeControls(  pControls  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeControls\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeControls\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getHeight","XBMCAddon::xbmcgui::Window"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getWidth","XBMCAddon::xbmcgui::Window"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getResolution (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getResolution","XBMCAddon::xbmcgui::Window"))-> getResolution(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getResolution\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getResolution\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setCoordinateResolution (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "res",
          NULL};
         
    long  res ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &res
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setCoordinateResolution","XBMCAddon::xbmcgui::Window"))-> setCoordinateResolution(  res  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCoordinateResolution\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCoordinateResolution\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          "value",
          NULL};
         
    char * key ;         
    std::string  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","setProperty"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setProperty","XBMCAddon::xbmcgui::Window"))-> setProperty(  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getProperty","XBMCAddon::xbmcgui::Window"))-> getProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProperty\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_clearProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"clearProperty","XBMCAddon::xbmcgui::Window"))-> clearProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearProperty\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_clearProperties (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"clearProperties","XBMCAddon::xbmcgui::Window"))-> clearProperties(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearProperties\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearProperties\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"close","XBMCAddon::xbmcgui::Window"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_doModal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"doModal","XBMCAddon::xbmcgui::Window"))-> doModal(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"doModal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"doModal\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_addControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","addControl"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"addControl","XBMCAddon::xbmcgui::Window"))-> addControl(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addControl\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_addControls (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControls",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::Control * >  pControls ;
    PyObject* pypControls = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControls
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pypControls)
    {
      bool isTuple = PyObject_TypeCheck(pypControls,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypControls,&PyList_Type))
        throw WrongTypeException("The parameter \"pControls\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypControls) : PyList_Size(pypControls));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypControls, i) : PyList_GetItem(pypControls, i));
        XBMCAddon::xbmcgui::Control * entry1;
        entry1 = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","addControls");
        pControls.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"addControls","XBMCAddon::xbmcgui::Window"))-> addControls(  pControls  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addControls\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addControls\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iControlId",
          NULL};
         
    int  iControlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iControlId
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getControl","XBMCAddon::xbmcgui::Window"))-> getControl(  iControlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getControl\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowDialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::WindowDialog * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowDialog *)(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_WindowDialog_Director() : new XBMCAddon::xbmcgui::WindowDialog(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowDialog\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_WindowDialog_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    std::string  xmlFilename ;
    PyObject* pyxmlFilename = NULL;         
    std::string  scriptPath ;
    PyObject* pyscriptPath = NULL;         
    std::string  defaultSkin  = "Default";
    PyObject* pydefaultSkin = NULL;         
    std::string  defaultRes  = "720p";
    PyObject* pydefaultRes = NULL;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"OO|OO",
       
         &pyxmlFilename,
         &pyscriptPath,
         &pydefaultSkin,
         &pydefaultRes
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::WindowXML * apiResult;
    try
    {
      if (pyxmlFilename) PyXBMCGetUnicodeString(xmlFilename,pyxmlFilename,false,"xmlFilename","WindowXML"); 
      if (pyscriptPath) PyXBMCGetUnicodeString(scriptPath,pyscriptPath,false,"scriptPath","WindowXML"); 
      if (pydefaultSkin) PyXBMCGetUnicodeString(defaultSkin,pydefaultSkin,false,"defaultSkin","WindowXML"); 
      if (pydefaultRes) PyXBMCGetUnicodeString(defaultRes,pydefaultRes,false,"defaultRes","WindowXML"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowXML *)(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_WindowXML_Director( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) : new XBMCAddon::xbmcgui::WindowXML(  xmlFilename,  scriptPath,  defaultSkin,  defaultRes  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXML\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXML\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_WindowXML_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          "position",
          NULL};
         
    Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  item ;
    PyObject* pyitem = NULL;         
    int  position  = INT_MAX;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|i",
       (char**)keywords,
         &pyitem,
         &position
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyitem;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,false,"entry0_1","addItem");
        item.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_1;
          entry1_1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItem");
          item.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    } 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"addItem","XBMCAddon::xbmcgui::WindowXML"))-> addItem(  item,  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItems (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  >  items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      
    if (pyitems)
    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  entry1;
        
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_2 = pyentry1;
      try
      {
        std::string  entry0_2;
        if (pyentry_2) PyXBMCGetUnicodeString(entry0_2,pyentry_2,false,"entry0_2","addItems");
        entry1.former() = entry0_2;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_2;
          entry1_2 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_2,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItems");
          entry1.later() = entry1_2;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }
        items.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"addItems","XBMCAddon::xbmcgui::WindowXML"))-> addItems(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItems\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_removeItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"removeItem","XBMCAddon::xbmcgui::WindowXML"))-> removeItem(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getCurrentListPosition","XBMCAddon::xbmcgui::WindowXML"))-> getCurrentListPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCurrentListPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCurrentListPosition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"setCurrentListPosition","XBMCAddon::xbmcgui::WindowXML"))-> setCurrentListPosition(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCurrentListPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCurrentListPosition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getListItem","XBMCAddon::xbmcgui::WindowXML"))-> getListItem(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListSize (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getListSize","XBMCAddon::xbmcgui::WindowXML"))-> getListSize(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListSize\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListSize\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_clearList (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"clearList","XBMCAddon::xbmcgui::WindowXML"))-> clearList(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearList\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_setContainerProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "strProperty",
          "strValue",
          NULL};
         
    std::string  strProperty ;
    PyObject* pystrProperty = NULL;         
    std::string  strValue ;
    PyObject* pystrValue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO",
       (char**)keywords,
         &pystrProperty,
         &pystrValue
       ))
    {
      return NULL;
    }


    try
    {
      if (pystrProperty) PyXBMCGetUnicodeString(strProperty,pystrProperty,false,"strProperty","setContainerProperty"); 
      if (pystrValue) PyXBMCGetUnicodeString(strValue,pystrValue,false,"strValue","setContainerProperty"); 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"setContainerProperty","XBMCAddon::xbmcgui::WindowXML"))-> setContainerProperty(  strProperty,  strValue  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setContainerProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setContainerProperty\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentContainerId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getCurrentContainerId","XBMCAddon::xbmcgui::WindowXML"))-> getCurrentContainerId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCurrentContainerId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCurrentContainerId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    std::string  xmlFilename ;
    PyObject* pyxmlFilename = NULL;         
    std::string  scriptPath ;
    PyObject* pyscriptPath = NULL;         
    std::string  defaultSkin  = "Default";
    PyObject* pydefaultSkin = NULL;         
    std::string  defaultRes  = "720p";
    PyObject* pydefaultRes = NULL;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"OO|OO",
       
         &pyxmlFilename,
         &pyscriptPath,
         &pydefaultSkin,
         &pydefaultRes
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::WindowXMLDialog * apiResult;
    try
    {
      if (pyxmlFilename) PyXBMCGetUnicodeString(xmlFilename,pyxmlFilename,false,"xmlFilename","WindowXMLDialog"); 
      if (pyscriptPath) PyXBMCGetUnicodeString(scriptPath,pyscriptPath,false,"scriptPath","WindowXMLDialog"); 
      if (pydefaultSkin) PyXBMCGetUnicodeString(defaultSkin,pydefaultSkin,false,"defaultSkin","WindowXMLDialog"); 
      if (pydefaultRes) PyXBMCGetUnicodeString(defaultRes,pydefaultRes,false,"defaultRes","WindowXMLDialog"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowXMLDialog *)(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_WindowXMLDialog_Director( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) : new XBMCAddon::xbmcgui::WindowXMLDialog(  xmlFilename,  scriptPath,  defaultSkin,  defaultRes  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXMLDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXMLDialog\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_WindowXMLDialog_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static void xbmcgui_XBMCAddon_xbmcgui_ListItem_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ListItem* theObj = (XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"~XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::ListItem");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ListItem\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Control_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Control* theObj = (XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"~XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::Control");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Control\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Control\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlSpin_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlSpin* theObj = (XBMCAddon::xbmcgui::ControlSpin*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSpin_Type,"~XBMCAddon::xbmcgui::ControlSpin","XBMCAddon::xbmcgui::ControlSpin");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSpin\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSpin\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlLabel_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlLabel* theObj = (XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlLabel_Type,"~XBMCAddon::xbmcgui::ControlLabel","XBMCAddon::xbmcgui::ControlLabel");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlLabel\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlEdit_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlEdit* theObj = (XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"~XBMCAddon::xbmcgui::ControlEdit","XBMCAddon::xbmcgui::ControlEdit");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlEdit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlEdit\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlList_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlList* theObj = (XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"~XBMCAddon::xbmcgui::ControlList","XBMCAddon::xbmcgui::ControlList");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlList\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlFadeLabel* theObj = (XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"~XBMCAddon::xbmcgui::ControlFadeLabel","XBMCAddon::xbmcgui::ControlFadeLabel");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlFadeLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlFadeLabel\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlTextBox* theObj = (XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"~XBMCAddon::xbmcgui::ControlTextBox","XBMCAddon::xbmcgui::ControlTextBox");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlTextBox\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlTextBox\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlImage_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlImage* theObj = (XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlImage_Type,"~XBMCAddon::xbmcgui::ControlImage","XBMCAddon::xbmcgui::ControlImage");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlImage\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlProgress_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlProgress* theObj = (XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlProgress_Type,"~XBMCAddon::xbmcgui::ControlProgress","XBMCAddon::xbmcgui::ControlProgress");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlProgress\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlButton_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlButton* theObj = (XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"~XBMCAddon::xbmcgui::ControlButton","XBMCAddon::xbmcgui::ControlButton");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlButton\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlGroup_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlGroup* theObj = (XBMCAddon::xbmcgui::ControlGroup*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlGroup_Type,"~XBMCAddon::xbmcgui::ControlGroup","XBMCAddon::xbmcgui::ControlGroup");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlGroup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlGroup\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlRadioButton* theObj = (XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"~XBMCAddon::xbmcgui::ControlRadioButton","XBMCAddon::xbmcgui::ControlRadioButton");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlRadioButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlRadioButton\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlSlider_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlSlider* theObj = (XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSlider_Type,"~XBMCAddon::xbmcgui::ControlSlider","XBMCAddon::xbmcgui::ControlSlider");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSlider\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSlider\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Dialog_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Dialog* theObj = (XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"~XBMCAddon::xbmcgui::Dialog","XBMCAddon::xbmcgui::Dialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Dialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Dialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_DialogProgress_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::DialogProgress* theObj = (XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"~XBMCAddon::xbmcgui::DialogProgress","XBMCAddon::xbmcgui::DialogProgress");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgress\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_DialogBusy_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::DialogBusy* theObj = (XBMCAddon::xbmcgui::DialogBusy*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogBusy_Type,"~XBMCAddon::xbmcgui::DialogBusy","XBMCAddon::xbmcgui::DialogBusy");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogBusy\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogBusy\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::DialogProgressBG* theObj = (XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"~XBMCAddon::xbmcgui::DialogProgressBG","XBMCAddon::xbmcgui::DialogProgressBG");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgressBG\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgressBG\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Action_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Action* theObj = (XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"~XBMCAddon::xbmcgui::Action","XBMCAddon::xbmcgui::Action");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Action\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Action\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Window_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Window* theObj = (XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"~XBMCAddon::xbmcgui::Window","XBMCAddon::xbmcgui::Window");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Window\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Window\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowDialog_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowDialog* theObj = (XBMCAddon::xbmcgui::WindowDialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowDialog_Type,"~XBMCAddon::xbmcgui::WindowDialog","XBMCAddon::xbmcgui::WindowDialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowDialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowXML_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowXML* theObj = (XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"~XBMCAddon::xbmcgui::WindowXML","XBMCAddon::xbmcgui::WindowXML");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXML\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXML\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowXMLDialog* theObj = (XBMCAddon::xbmcgui::WindowXMLDialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXMLDialog_Type,"~XBMCAddon::xbmcgui::WindowXMLDialog","XBMCAddon::xbmcgui::WindowXMLDialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXMLDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXMLDialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ListItem
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ListItem_methods[] = { 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel2, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel2, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setIconImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setIconImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setThumbnailImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setThumbnailImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setArt", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setArt, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setUniqueIDs", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setUniqueIDs, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setRating", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setRating, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getArt", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getArt, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getUniqueID", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getUniqueID, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getRating", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getRating, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getVotes", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getVotes, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"select", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_select, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_isSelected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setInfo", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setInfo, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setCast", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setCast, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addStreamInfo", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_addStreamInfo, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addContextMenuItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_addContextMenuItems, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setPath", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setPath, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setMimeType", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setMimeType, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setContentLookup", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setContentLookup, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setSubtitles", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setSubtitles, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getdescription", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getdescription, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getduration", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getduration, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getfilename", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getfilename, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPath", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getPath, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getVideoInfoTag", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getVideoInfoTag, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getMusicInfoTag", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getMusicInfoTag, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ListItem_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ListItem_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ListItem";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ListItem_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ListItem_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ListItem_New;

    TyXBMCAddon_xbmcgui_ListItem_Type.swigType="p.XBMCAddon::xbmcgui::ListItem";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ListItem_Type);

  }
  //=========================================================================

  static int xbmcgui_XBMCAddon_xbmcgui_Control_cmp(PyObject* obj1, PyObject* obj2)
  {
    return PythonCompare<XBMCAddon::xbmcgui::Control>::compare(obj1,obj2,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","compare on XBMCAddon::xbmcgui::Control");
  }

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Control
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Control_methods[] = { 
    {(char*)"canAcceptMessages", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_canAcceptMessages, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getX", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getX, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getY", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getY, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getWidth, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setEnabled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setEnabled, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setVisible, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setVisibleCondition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setVisibleCondition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setEnableCondition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setEnableCondition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setAnimations", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setAnimations, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setWidth, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setNavigation", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setNavigation, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"controlUp", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlUp, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"controlDown", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlDown, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"controlLeft", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlLeft, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"controlRight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlRight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Control_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Control_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Control";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Control_Dealloc; 
    pythonType.tp_compare=xbmcgui_XBMCAddon_xbmcgui_Control_cmp;


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Control_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = NULL;

    TyXBMCAddon_xbmcgui_Control_Type.swigType="p.XBMCAddon::xbmcgui::Control";
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlSpin
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlSpin_methods[] = { 
    {(char*)"setTextures", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSpin_setTextures, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlSpin_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlSpin";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlSpin_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlSpin_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = NULL;

    TyXBMCAddon_xbmcgui_ControlSpin_Type.swigType="p.XBMCAddon::xbmcgui::ControlSpin";
    TyXBMCAddon_xbmcgui_ControlSpin_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlLabel
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlLabel_methods[] = { 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_getLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_setLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlLabel_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlLabel";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlLabel_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlLabel_New;

    TyXBMCAddon_xbmcgui_ControlLabel_Type.swigType="p.XBMCAddon::xbmcgui::ControlLabel";
    TyXBMCAddon_xbmcgui_ControlLabel_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlLabel_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlEdit
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlEdit_methods[] = { 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlEdit_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlEdit";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlEdit_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlEdit_New;

    TyXBMCAddon_xbmcgui_ControlEdit_Type.swigType="p.XBMCAddon::xbmcgui::ControlEdit";
    TyXBMCAddon_xbmcgui_ControlEdit_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlEdit_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlList
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlList_methods[] = { 
    {(char*)"addItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_addItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_addItems, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"selectItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_selectItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"removeItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_removeItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_reset, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSpinControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpinControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSelectedPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSelectedItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setImageDimensions", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setImageDimensions, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setItemHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setSpace, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setPageControlVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setPageControlVisible, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"size", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_size, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getItemHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpace, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setStaticContent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setStaticContent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlList_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlList_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlList";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlList_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlList_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlList_New;

    TyXBMCAddon_xbmcgui_ControlList_Type.swigType="p.XBMCAddon::xbmcgui::ControlList";
    TyXBMCAddon_xbmcgui_ControlList_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlList_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlFadeLabel
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlFadeLabel_methods[] = { 
    {(char*)"addLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_addLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setScrolling", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_setScrolling, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_reset, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlFadeLabel_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlFadeLabel";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlFadeLabel_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_New;

    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.swigType="p.XBMCAddon::xbmcgui::ControlFadeLabel";
    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlTextBox
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlTextBox_methods[] = { 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_setText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_getText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_reset, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"scroll", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_scroll, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"autoScroll", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_autoScroll, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlTextBox_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlTextBox";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlTextBox_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_New;

    TyXBMCAddon_xbmcgui_ControlTextBox_Type.swigType="p.XBMCAddon::xbmcgui::ControlTextBox";
    TyXBMCAddon_xbmcgui_ControlTextBox_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlTextBox_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlImage
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlImage_methods[] = { 
    {(char*)"setImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlImage_setImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setColorDiffuse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlImage_setColorDiffuse, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlImage_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlImage";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlImage_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlImage_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlImage_New;

    TyXBMCAddon_xbmcgui_ControlImage_Type.swigType="p.XBMCAddon::xbmcgui::ControlImage";
    TyXBMCAddon_xbmcgui_ControlImage_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlImage_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlProgress
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlProgress_methods[] = { 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_setPercent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_getPercent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlProgress_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlProgress";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlProgress_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlProgress_New;

    TyXBMCAddon_xbmcgui_ControlProgress_Type.swigType="p.XBMCAddon::xbmcgui::ControlProgress";
    TyXBMCAddon_xbmcgui_ControlProgress_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlProgress_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlButton
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlButton_methods[] = { 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_setLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setDisabledColor", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_setDisabledColor, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel2, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlButton_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlButton";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlButton_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlButton_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlButton_New;

    TyXBMCAddon_xbmcgui_ControlButton_Type.swigType="p.XBMCAddon::xbmcgui::ControlButton";
    TyXBMCAddon_xbmcgui_ControlButton_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlButton_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlGroup
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlGroup_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlGroup_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlGroup";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlGroup_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlGroup_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlGroup_New;

    TyXBMCAddon_xbmcgui_ControlGroup_Type.swigType="p.XBMCAddon::xbmcgui::ControlGroup";
    TyXBMCAddon_xbmcgui_ControlGroup_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlGroup_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlRadioButton
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlRadioButton_methods[] = { 
    {(char*)"setSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setSelected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_isSelected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setRadioDimension", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlRadioButton_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlRadioButton";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlRadioButton_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_New;

    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.swigType="p.XBMCAddon::xbmcgui::ControlRadioButton";
    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlRadioButton_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlSlider
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlSlider_methods[] = { 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_getPercent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_setPercent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlSlider_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlSlider";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlSlider_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlSlider_New;

    TyXBMCAddon_xbmcgui_ControlSlider_Type.swigType="p.XBMCAddon::xbmcgui::ControlSlider";
    TyXBMCAddon_xbmcgui_ControlSlider_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlSlider_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Dialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Dialog_methods[] = { 
    {(char*)"yesno", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_yesno, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"info", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_info, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"select", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_select, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"contextmenu", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_contextmenu, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"multiselect", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_multiselect, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"ok", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_ok, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"textviewer", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_textviewer, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"browse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browse, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"browseSingle", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browseSingle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"browseMultiple", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browseMultiple, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"numeric", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_numeric, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"notification", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_notification, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"input", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_input, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Dialog_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Dialog_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Dialog";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Dialog_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Dialog_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_Dialog_New;

    TyXBMCAddon_xbmcgui_Dialog_Type.swigType="p.XBMCAddon::xbmcgui::Dialog";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_Dialog_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::DialogProgress
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_DialogProgress_methods[] = { 
    {(char*)"create", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_create, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"update", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_update, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"iscanceled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_iscanceled, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_DialogProgress_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.DialogProgress";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_DialogProgress_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_DialogProgress_New;

    TyXBMCAddon_xbmcgui_DialogProgress_Type.swigType="p.XBMCAddon::xbmcgui::DialogProgress";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_DialogProgress_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::DialogBusy
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_DialogBusy_methods[] = { 
    {(char*)"create", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogBusy_create, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"update", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogBusy_update, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogBusy_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"iscanceled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogBusy_iscanceled, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_DialogBusy_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_DialogBusy_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.DialogBusy";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_DialogBusy_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_DialogBusy_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_DialogBusy_New;

    TyXBMCAddon_xbmcgui_DialogBusy_Type.swigType="p.XBMCAddon::xbmcgui::DialogBusy";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_DialogBusy_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::DialogProgressBG
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_DialogProgressBG_methods[] = { 
    {(char*)"create", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_create, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"update", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_update, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isFinished", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_isFinished, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_DialogProgressBG_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.DialogProgressBG";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_DialogProgressBG_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_New;

    TyXBMCAddon_xbmcgui_DialogProgressBG_Type.swigType="p.XBMCAddon::xbmcgui::DialogProgressBG";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_DialogProgressBG_Type);

  }
  //=========================================================================

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_rcmp(PyObject* obj1, PyObject *obj2, int method)
  { XBMC_TRACE;
    if (method == Py_EQ)
    {
      XBMCAddon::xbmcgui::Action* a1 = (Action*)retrieveApiInstance(obj1,&TyXBMCAddon_xbmcgui_Action_Type,"rcmp","XBMCAddon::xbmcgui::Action");
      if (PyObject_TypeCheck(obj2, &(TyXBMCAddon_xbmcgui_Action_Type.pythonType)))
      {
        // both are Action objects
        XBMCAddon::xbmcgui::Action* a2 = (Action*)retrieveApiInstance(obj2,&TyXBMCAddon_xbmcgui_Action_Type,"rcmp","XBMCAddon::xbmcgui::Action");

        if (a1->id == a2->id &&
            a1->buttonCode == a2->buttonCode &&
            a1->fAmount1 == a2->fAmount1 &&
            a1->fAmount2 == a2->fAmount2 &&
            a1->fRepeat == a2->fRepeat &&
            a1->strAction == a2->strAction)
        {
          Py_RETURN_TRUE;
        }
        else
        {
          Py_RETURN_FALSE;
        }
      }
      else
      {
        // for backwards compatability in python scripts
        PyObject* o1 = PyLong_FromLong(a1->id);
        return PyObject_RichCompare(o1, obj2, method);
      }
    }
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
  }

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Action
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Action_methods[] = { 
    {(char*)"getId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getButtonCode", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getButtonCode, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAmount1", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getAmount1, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAmount2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getAmount2, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Action_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Action_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Action";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Action_Dealloc; 
    pythonType.tp_richcompare=(richcmpfunc)xbmcgui_XBMCAddon_xbmcgui_Action_rcmp;


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Action_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_Action_New;

    TyXBMCAddon_xbmcgui_Action_Type.swigType="p.XBMCAddon::xbmcgui::Action";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_Action_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Window
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Window_methods[] = { 
    {(char*)"onAction", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onAction, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onClick", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onClick, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onDoubleClick", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onDoubleClick, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onFocus, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onInit", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onInit, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"show", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_show, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setFocus, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setFocusId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setFocusId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getFocus, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFocusId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getFocusId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"removeControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_removeControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"removeControls", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_removeControls, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getWidth, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getResolution", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getResolution, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setCoordinateResolution", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setCoordinateResolution, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"clearProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_clearProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"clearProperties", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_clearProperties, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"doModal", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_doModal, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_addControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addControls", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_addControls, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Window_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Window_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Window";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Window_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Window_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_Window_New;

    TyXBMCAddon_xbmcgui_Window_Type.swigType="p.XBMCAddon::xbmcgui::Window";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_Window_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowDialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowDialog_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowDialog_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.WindowDialog";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowDialog_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_WindowDialog_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Window_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowDialog_New;

    TyXBMCAddon_xbmcgui_WindowDialog_Type.swigType="p.XBMCAddon::xbmcgui::WindowDialog";
    TyXBMCAddon_xbmcgui_WindowDialog_Type.parentType=&TyXBMCAddon_xbmcgui_Window_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_WindowDialog_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowXML
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowXML_methods[] = { 
    {(char*)"addItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItems, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"removeItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_removeItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCurrentListPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setCurrentListPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListSize", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListSize, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"clearList", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_clearList, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setContainerProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_setContainerProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCurrentContainerId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentContainerId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowXML_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.WindowXML";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowXML_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_WindowXML_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Window_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowXML_New;

    TyXBMCAddon_xbmcgui_WindowXML_Type.swigType="p.XBMCAddon::xbmcgui::WindowXML";
    TyXBMCAddon_xbmcgui_WindowXML_Type.parentType=&TyXBMCAddon_xbmcgui_Window_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_WindowXML_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowXMLDialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowXMLDialog_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowXMLDialog_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.WindowXMLDialog";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_WindowXMLDialog_methods; 

    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_New;

    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.swigType="p.XBMCAddon::xbmcgui::WindowXMLDialog";
    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.parentType=&TyXBMCAddon_xbmcgui_WindowXML_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_WindowXMLDialog_Type);

  }
  //=========================================================================


  static PyMethodDef xbmcgui_methods[] = { 
    {(char*)"getCurrentWindowId", (PyCFunction)xbmcgui_getCurrentWindowId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCurrentWindowDialogId", (PyCFunction)xbmcgui_getCurrentWindowDialogId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmcgui_ListItem_Type();
      initPyXBMCAddon_xbmcgui_Control_Type();
      initPyXBMCAddon_xbmcgui_ControlSpin_Type();
      initPyXBMCAddon_xbmcgui_ControlLabel_Type();
      initPyXBMCAddon_xbmcgui_ControlEdit_Type();
      initPyXBMCAddon_xbmcgui_ControlList_Type();
      initPyXBMCAddon_xbmcgui_ControlFadeLabel_Type();
      initPyXBMCAddon_xbmcgui_ControlTextBox_Type();
      initPyXBMCAddon_xbmcgui_ControlImage_Type();
      initPyXBMCAddon_xbmcgui_ControlProgress_Type();
      initPyXBMCAddon_xbmcgui_ControlButton_Type();
      initPyXBMCAddon_xbmcgui_ControlGroup_Type();
      initPyXBMCAddon_xbmcgui_ControlRadioButton_Type();
      initPyXBMCAddon_xbmcgui_ControlSlider_Type();
      initPyXBMCAddon_xbmcgui_Dialog_Type();
      initPyXBMCAddon_xbmcgui_DialogProgress_Type();
      initPyXBMCAddon_xbmcgui_DialogBusy_Type();
      initPyXBMCAddon_xbmcgui_DialogProgressBG_Type();
      initPyXBMCAddon_xbmcgui_Action_Type();
      initPyXBMCAddon_xbmcgui_Window_Type();
      initPyXBMCAddon_xbmcgui_WindowDialog_Type();
      initPyXBMCAddon_xbmcgui_WindowXML_Type();
      initPyXBMCAddon_xbmcgui_WindowXMLDialog_Type();
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ListItem_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Control_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlList_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Dialog_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_DialogBusy_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Action_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType)) < 0)
        return;
    }
  }

  void initModule_xbmcgui()
  {
    initTypes();

    // init general xbmcgui modules
    PyObject* module;


    Py_INCREF(&(TyXBMCAddon_xbmcgui_ListItem_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Control_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlList_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Dialog_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_DialogBusy_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Action_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType));

    module = Py_InitModule((char*)"xbmcgui", xbmcgui_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"ListItem", (PyObject*)(&(TyXBMCAddon_xbmcgui_ListItem_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Control", (PyObject*)(&(TyXBMCAddon_xbmcgui_Control_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlSpin", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlLabel", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlEdit", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlList", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlList_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlFadeLabel", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlTextBox", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlImage", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlProgress", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlButton", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlGroup", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlRadioButton", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlSlider", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Dialog", (PyObject*)(&(TyXBMCAddon_xbmcgui_Dialog_Type.pythonType)));
    PyModule_AddObject(module, (char*)"DialogProgress", (PyObject*)(&(TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType)));
    PyModule_AddObject(module, (char*)"DialogBusy", (PyObject*)(&(TyXBMCAddon_xbmcgui_DialogBusy_Type.pythonType)));
    PyModule_AddObject(module, (char*)"DialogProgressBG", (PyObject*)(&(TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Action", (PyObject*)(&(TyXBMCAddon_xbmcgui_Action_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Window", (PyObject*)(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WindowDialog", (PyObject*)(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WindowXML", (PyObject*)(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WindowXMLDialog", (PyObject*)(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType)));

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team Kodi <http://kodi.tv>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Thu Feb 23 15:51:09 EST 2017");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.25.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team Kodi");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"ICON_OVERLAY_NONE",CGUIListItem::ICON_OVERLAY_NONE); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_RAR",CGUIListItem::ICON_OVERLAY_RAR); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_ZIP",CGUIListItem::ICON_OVERLAY_ZIP); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_LOCKED",CGUIListItem::ICON_OVERLAY_LOCKED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_UNWATCHED",CGUIListItem::ICON_OVERLAY_UNWATCHED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_WATCHED",CGUIListItem::ICON_OVERLAY_WATCHED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_HD",CGUIListItem::ICON_OVERLAY_HD); 
   PyModule_AddStringConstant(module,"NOTIFICATION_INFO",getNOTIFICATION_INFO()); 
   PyModule_AddStringConstant(module,"NOTIFICATION_WARNING",getNOTIFICATION_WARNING()); 
   PyModule_AddStringConstant(module,"NOTIFICATION_ERROR",getNOTIFICATION_ERROR()); 
   PyModule_AddIntConstant(module,"INPUT_ALPHANUM",INPUT_ALPHANUM); 
   PyModule_AddIntConstant(module,"INPUT_NUMERIC",INPUT_NUMERIC); 
   PyModule_AddIntConstant(module,"INPUT_DATE",INPUT_DATE); 
   PyModule_AddIntConstant(module,"INPUT_TIME",INPUT_TIME); 
   PyModule_AddIntConstant(module,"INPUT_IPADDRESS",INPUT_IPADDRESS); 
   PyModule_AddIntConstant(module,"INPUT_PASSWORD",INPUT_PASSWORD); 
   PyModule_AddIntConstant(module,"HORIZONTAL",HORIZONTAL); 
   PyModule_AddIntConstant(module,"VERTICAL",VERTICAL); 
   PyModule_AddIntConstant(module,"PASSWORD_VERIFY",PASSWORD_VERIFY); 
   PyModule_AddIntConstant(module,"ALPHANUM_HIDE_INPUT",ALPHANUM_HIDE_INPUT); 
   PyModule_AddIntConstant(module,"CONTROL_TEXT_OFFSET_X",10); 
   PyModule_AddIntConstant(module,"CONTROL_TEXT_OFFSET_Y",2); 
   PyModule_AddIntConstant(module,"INPUT_ALPHANUM",0); 
   PyModule_AddIntConstant(module,"INPUT_NUMERIC",1); 
   PyModule_AddIntConstant(module,"INPUT_DATE",2); 
   PyModule_AddIntConstant(module,"INPUT_TIME",3); 
   PyModule_AddIntConstant(module,"INPUT_IPADDRESS",4); 
   PyModule_AddIntConstant(module,"INPUT_PASSWORD",5); 
   PyModule_AddIntConstant(module,"PASSWORD_VERIFY",1); 
   PyModule_AddIntConstant(module,"ALPHANUM_HIDE_INPUT",2); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_A",256); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_B",257); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_X",258); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_Y",259); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_BLACK",260); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_WHITE",261); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_TRIGGER",262); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_TRIGGER",263); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK",264); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK",265); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_UP",266); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_DOWN",267); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_LEFT",268); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_RIGHT",269); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_UP",270); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_DOWN",271); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_LEFT",272); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_RIGHT",273); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_START",274); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_BACK",275); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_BUTTON",276); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_BUTTON",277); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_ANALOG_TRIGGER",278); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_ANALOG_TRIGGER",279); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_UP",280); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_DOWN",281); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_LEFT",282); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_RIGHT",283); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_A",284); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_B",285); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_X",286); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_Y",287); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_SHOULDER",288); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_SHOULDER",289); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_TRIGGER",290); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_TRIGGER",291); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_STICK_BUTTON",292); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_STICK_BUTTON",293); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_THUMB_STICK_UP",294); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_THUMB_STICK_DOWN",295); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_THUMB_STICK_LEFT",296); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_RIGHT_THUMB_STICK_RIGHT",297); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_DPAD_UP",298); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_DPAD_DOWN",299); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_DPAD_LEFT",300); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_DPAD_RIGHT",301); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_START",302); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_BACK",303); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_THUMB_STICK_UP",304); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_THUMB_STICK_DOWN",305); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_THUMB_STICK_LEFT",306); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_LEFT_THUMB_STICK_RIGHT",307); 
   PyModule_AddIntConstant(module,"KEY_JOYSTICK_BUTTON_GUIDE",308); 
   PyModule_AddIntConstant(module,"KEY_VKEY",0xF000); 
   PyModule_AddIntConstant(module,"KEY_ASCII",0xF100); 
   PyModule_AddIntConstant(module,"KEY_UNICODE",0xF200); 
   PyModule_AddIntConstant(module,"KEY_VMOUSE",0xEFFF); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_START",0xE000); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_CLICK",0xE000); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_RIGHTCLICK",0xE001); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_MIDDLECLICK",0xE002); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_DOUBLE_CLICK",0xE010); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_LONG_CLICK",0xE020); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_WHEEL_UP",0xE101); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_WHEEL_DOWN",0xE102); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_MOVE",0xE103); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_DRAG",0xE104); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_DRAG_START",0xE105); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_DRAG_END",0xE106); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_RDRAG",0xE107); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_RDRAG_START",0xE108); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_RDRAG_END",0xE109); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_NOOP",0xEFFF); 
   PyModule_AddIntConstant(module,"KEY_MOUSE_END",0xEFFF); 
   PyModule_AddIntConstant(module,"KEY_APPCOMMAND",0xD000); 
   PyModule_AddIntConstant(module,"KEY_TOUCH",0xF000); 
   PyModule_AddIntConstant(module,"KEY_INVALID",0xFFFF); 
   PyModule_AddIntConstant(module,"ACTION_NONE",0); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_LEFT",1); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_RIGHT",2); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_UP",3); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_DOWN",4); 
   PyModule_AddIntConstant(module,"ACTION_PAGE_UP",5); 
   PyModule_AddIntConstant(module,"ACTION_PAGE_DOWN",6); 
   PyModule_AddIntConstant(module,"ACTION_SELECT_ITEM",7); 
   PyModule_AddIntConstant(module,"ACTION_HIGHLIGHT_ITEM",8); 
   PyModule_AddIntConstant(module,"ACTION_PARENT_DIR",9); 
   PyModule_AddIntConstant(module,"ACTION_PREVIOUS_MENU",10); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_INFO",11); 
   PyModule_AddIntConstant(module,"ACTION_PAUSE",12); 
   PyModule_AddIntConstant(module,"ACTION_STOP",13); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_ITEM",14); 
   PyModule_AddIntConstant(module,"ACTION_PREV_ITEM",15); 
   PyModule_AddIntConstant(module,"ACTION_FORWARD",16); 
   PyModule_AddIntConstant(module,"ACTION_REWIND",17); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_GUI",18); 
   PyModule_AddIntConstant(module,"ACTION_ASPECT_RATIO",19); 
   PyModule_AddIntConstant(module,"ACTION_STEP_FORWARD",20); 
   PyModule_AddIntConstant(module,"ACTION_STEP_BACK",21); 
   PyModule_AddIntConstant(module,"ACTION_BIG_STEP_FORWARD",22); 
   PyModule_AddIntConstant(module,"ACTION_BIG_STEP_BACK",23); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_OSD",24); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_SUBTITLES",25); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_SUBTITLE",26); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_DEBUG",27); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_PICTURE",28); 
   PyModule_AddIntConstant(module,"ACTION_PREV_PICTURE",29); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_OUT",30); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_IN",31); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_SOURCE_DEST",32); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_PLAYLIST",33); 
   PyModule_AddIntConstant(module,"ACTION_QUEUE_ITEM",34); 
   PyModule_AddIntConstant(module,"ACTION_REMOVE_ITEM",35); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_FULLSCREEN",36); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_NORMAL",37); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_1",38); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_2",39); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_3",40); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_4",41); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_5",42); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_6",43); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_7",44); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_8",45); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_9",46); 
   PyModule_AddIntConstant(module,"ACTION_CALIBRATE_SWAP_ARROWS",47); 
   PyModule_AddIntConstant(module,"ACTION_CALIBRATE_RESET",48); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_MOVE",49); 
   PyModule_AddIntConstant(module,"ACTION_ROTATE_PICTURE_CW",50); 
   PyModule_AddIntConstant(module,"ACTION_ROTATE_PICTURE_CCW",51); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_DELAY_MIN",52); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_DELAY_PLUS",53); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_DELAY_MIN",54); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_DELAY_PLUS",55); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_NEXT_LANGUAGE",56); 
   PyModule_AddIntConstant(module,"ACTION_CHANGE_RESOLUTION",57); 
   PyModule_AddIntConstant(module,"REMOTE_0",58); 
   PyModule_AddIntConstant(module,"REMOTE_1",59); 
   PyModule_AddIntConstant(module,"REMOTE_2",60); 
   PyModule_AddIntConstant(module,"REMOTE_3",61); 
   PyModule_AddIntConstant(module,"REMOTE_4",62); 
   PyModule_AddIntConstant(module,"REMOTE_5",63); 
   PyModule_AddIntConstant(module,"REMOTE_6",64); 
   PyModule_AddIntConstant(module,"REMOTE_7",65); 
   PyModule_AddIntConstant(module,"REMOTE_8",66); 
   PyModule_AddIntConstant(module,"REMOTE_9",67); 
   PyModule_AddIntConstant(module,"ACTION_PLAY",68); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_PROCESS_INFO",69); 
   PyModule_AddIntConstant(module,"ACTION_SMALL_STEP_BACK",76); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_FORWARD",77); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_REWIND",78); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_PLAY",79); 
   PyModule_AddIntConstant(module,"ACTION_DELETE_ITEM",80); 
   PyModule_AddIntConstant(module,"ACTION_COPY_ITEM",81); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_ITEM",82); 
   PyModule_AddIntConstant(module,"ACTION_TAKE_SCREENSHOT",85); 
   PyModule_AddIntConstant(module,"ACTION_RENAME_ITEM",87); 
   PyModule_AddIntConstant(module,"ACTION_VOLUME_UP",88); 
   PyModule_AddIntConstant(module,"ACTION_VOLUME_DOWN",89); 
   PyModule_AddIntConstant(module,"ACTION_VOLAMP",90); 
   PyModule_AddIntConstant(module,"ACTION_MUTE",91); 
   PyModule_AddIntConstant(module,"ACTION_NAV_BACK",92); 
   PyModule_AddIntConstant(module,"ACTION_VOLAMP_UP",93); 
   PyModule_AddIntConstant(module,"ACTION_VOLAMP_DOWN",94); 
   PyModule_AddIntConstant(module,"ACTION_CREATE_EPISODE_BOOKMARK",95); 
   PyModule_AddIntConstant(module,"ACTION_CREATE_BOOKMARK",96); 
   PyModule_AddIntConstant(module,"ACTION_CHAPTER_OR_BIG_STEP_FORWARD",97); 
   PyModule_AddIntConstant(module,"ACTION_CHAPTER_OR_BIG_STEP_BACK",98); 
   PyModule_AddIntConstant(module,"ACTION_CYCLE_SUBTITLE",99); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_START",100); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_LEFT_CLICK",100); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_RIGHT_CLICK",101); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_MIDDLE_CLICK",102); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_DOUBLE_CLICK",103); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_WHEEL_UP",104); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_WHEEL_DOWN",105); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_DRAG",106); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_MOVE",107); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_LONG_CLICK",108); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_END",109); 
   PyModule_AddIntConstant(module,"ACTION_BACKSPACE",110); 
   PyModule_AddIntConstant(module,"ACTION_SCROLL_UP",111); 
   PyModule_AddIntConstant(module,"ACTION_SCROLL_DOWN",112); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_FORWARD",113); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_REWIND",114); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_ITEM_UP",115); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_ITEM_DOWN",116); 
   PyModule_AddIntConstant(module,"ACTION_CONTEXT_MENU",117); 
   PyModule_AddIntConstant(module,"ACTION_SHIFT",118); 
   PyModule_AddIntConstant(module,"ACTION_SYMBOLS",119); 
   PyModule_AddIntConstant(module,"ACTION_CURSOR_LEFT",120); 
   PyModule_AddIntConstant(module,"ACTION_CURSOR_RIGHT",121); 
   PyModule_AddIntConstant(module,"ACTION_BUILT_IN_FUNCTION",122); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_OSD_TIME",123); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_SEEK_FORWARD",124); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_SEEK_BACK",125); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_SHOW",126); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_NEXT",128); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_PREV",129); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_LOCK",130); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_RANDOM",131); 
   PyModule_AddIntConstant(module,"ACTION_VIS_RATE_PRESET_PLUS",132); 
   PyModule_AddIntConstant(module,"ACTION_VIS_RATE_PRESET_MINUS",133); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_VIDEOMENU",134); 
   PyModule_AddIntConstant(module,"ACTION_ENTER",135); 
   PyModule_AddIntConstant(module,"ACTION_INCREASE_RATING",136); 
   PyModule_AddIntConstant(module,"ACTION_DECREASE_RATING",137); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_SCENE",138); 
   PyModule_AddIntConstant(module,"ACTION_PREV_SCENE",139); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_LETTER",140); 
   PyModule_AddIntConstant(module,"ACTION_PREV_LETTER",141); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS2",142); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS3",143); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS4",144); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS5",145); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS6",146); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS7",147); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS8",148); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS9",149); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_CLEAR",150); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS2",151); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS3",152); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS4",153); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS5",154); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS6",155); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS7",156); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS8",157); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS9",158); 
   PyModule_AddIntConstant(module,"ACTION_FIRST_PAGE",159); 
   PyModule_AddIntConstant(module,"ACTION_LAST_PAGE",160); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_DELAY",161); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_DELAY",162); 
   PyModule_AddIntConstant(module,"ACTION_MENU",163); 
   PyModule_AddIntConstant(module,"ACTION_SET_RATING",164); 
   PyModule_AddIntConstant(module,"ACTION_RECORD",170); 
   PyModule_AddIntConstant(module,"ACTION_PASTE",180); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_CONTROL",181); 
   PyModule_AddIntConstant(module,"ACTION_PREV_CONTROL",182); 
   PyModule_AddIntConstant(module,"ACTION_CHANNEL_SWITCH",183); 
   PyModule_AddIntConstant(module,"ACTION_CHANNEL_UP",184); 
   PyModule_AddIntConstant(module,"ACTION_CHANNEL_DOWN",185); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_CHANNELGROUP",186); 
   PyModule_AddIntConstant(module,"ACTION_PREVIOUS_CHANNELGROUP",187); 
   PyModule_AddIntConstant(module,"ACTION_PVR_PLAY",188); 
   PyModule_AddIntConstant(module,"ACTION_PVR_PLAY_TV",189); 
   PyModule_AddIntConstant(module,"ACTION_PVR_PLAY_RADIO",190); 
   PyModule_AddIntConstant(module,"ACTION_PVR_SHOW_TIMER_RULE",191); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_FULLSCREEN",199); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_WATCHED",200); 
   PyModule_AddIntConstant(module,"ACTION_SCAN_ITEM",201); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_DIGITAL_ANALOG",202); 
   PyModule_AddIntConstant(module,"ACTION_RELOAD_KEYMAPS",203); 
   PyModule_AddIntConstant(module,"ACTION_GUIPROFILE_BEGIN",204); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_RED",215); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_GREEN",216); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_YELLOW",217); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_BLUE",218); 
   PyModule_AddIntConstant(module,"ACTION_INCREASE_PAR",219); 
   PyModule_AddIntConstant(module,"ACTION_DECREASE_PAR",220); 
   PyModule_AddIntConstant(module,"ACTION_VSHIFT_UP",227); 
   PyModule_AddIntConstant(module,"ACTION_VSHIFT_DOWN",228); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_PLAYPAUSE",229); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_VSHIFT_UP",230); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_VSHIFT_DOWN",231); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_ALIGN",232); 
   PyModule_AddIntConstant(module,"ACTION_FILTER",233); 
   PyModule_AddIntConstant(module,"ACTION_SWITCH_PLAYER",234); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_NEXT",235); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_PREVIOUS",236); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_TOGGLE",237); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_SELECT",238); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_TOMONO",239); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_SET",240); 
   PyModule_AddIntConstant(module,"ACTION_SETTINGS_RESET",241); 
   PyModule_AddIntConstant(module,"ACTION_SETTINGS_LEVEL_CHANGE",242); 
   PyModule_AddIntConstant(module,"ACTION_TRIGGER_OSD",243); 
   PyModule_AddIntConstant(module,"ACTION_INPUT_TEXT",244); 
   PyModule_AddIntConstant(module,"ACTION_VOLUME_SET",245); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_COMMSKIP",246); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_TAP",401); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_TAP_TEN",410); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_LONGPRESS",411); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_LONGPRESS_TEN",420); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_NOTIFY",500); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_BEGIN",501); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_ZOOM",502); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_ROTATE",503); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_PAN",504); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_LEFT",511); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_LEFT_TEN",520); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_RIGHT",521); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_RIGHT_TEN",530); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_UP",531); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_UP_TEN",540); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_DOWN",541); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_DOWN_TEN",550); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_END",599); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_MOVE_X",601); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_MOVE_Y",602); 
   PyModule_AddIntConstant(module,"ACTION_ERROR",998); 
   PyModule_AddIntConstant(module,"ACTION_NOOP",999); 
   PyModule_AddIntConstant(module,"ICON_TYPE_NONE",101); 
   PyModule_AddIntConstant(module,"ICON_TYPE_PROGRAMS",102); 
   PyModule_AddIntConstant(module,"ICON_TYPE_MUSIC",103); 
   PyModule_AddIntConstant(module,"ICON_TYPE_PICTURES",104); 
   PyModule_AddIntConstant(module,"ICON_TYPE_VIDEOS",105); 
   PyModule_AddIntConstant(module,"ICON_TYPE_FILES",106); 
   PyModule_AddIntConstant(module,"ICON_TYPE_WEATHER",107); 
   PyModule_AddIntConstant(module,"ICON_TYPE_SETTINGS",109); 
  }

} // end PythonBindings namespace for python type definitions


