

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmcvfs" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/ModuleXbmcvfs.h"
#include "interfaces/legacy/File.h"
#include "interfaces/legacy/Stat.h"
#include "utils/log.h"

using namespace XBMCAddon;
using namespace xbmcvfs;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif



namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcvfs::File
  TypeInfo TyXBMCAddon_xbmcvfs_File_Type(typeid(XBMCAddon::xbmcvfs::File));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcvfs::Stat
  TypeInfo TyXBMCAddon_xbmcvfs_Stat_Type(typeid(XBMCAddon::xbmcvfs::Stat));
  //=========================================================================



  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filepath",
          "mode",
          NULL};
         
    std::string  filepath ;
    PyObject* pyfilepath = NULL;         
    char * mode  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|s",
       (char**)keywords,
         &pyfilepath,
         &mode
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcvfs::File * apiResult;
    try
    {
      if (pyfilepath) PyXBMCGetUnicodeString(filepath,pyfilepath,false,"filepath","File"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcvfs::File *)new XBMCAddon::xbmcvfs::File(  filepath,  mode  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcvfs::File\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcvfs::File\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_read (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "numBytes",
          NULL};
         
    unsigned long  numBytes  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|k",
       (char**)keywords,
         &numBytes
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"read","XBMCAddon::xbmcvfs::File"))-> read(  numBytes  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"read\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"read\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_readBytes (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "numBytes",
          NULL};
         
    unsigned long  numBytes  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|k",
       (char**)keywords,
         &numBytes
       ))
    {
      return NULL;
    }

    XbmcCommons::Buffer  apiResult;
    try
    {

      apiResult = (XbmcCommons::Buffer )((XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"readBytes","XBMCAddon::xbmcvfs::File"))-> readBytes(  numBytes  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"readBytes\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"readBytes\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyByteArray_FromStringAndSize((char*)apiResult.curPosition(),apiResult.remaining());

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_write (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "buffer",
          NULL};
         
    XbmcCommons::Buffer  buffer ;
    PyObject* pybuffer = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pybuffer
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      
    if (PyString_Check(pybuffer))
    {
      const char* str = PyString_AsString(pybuffer);
      size_t size = (size_t)PyString_Size(pybuffer);
      buffer.allocate(size);
      buffer.put(str,size);
      buffer.flip(); // prepare the buffer for reading from
    }
    else if (PyByteArray_Check(pybuffer))
    {
      size_t size = PyByteArray_Size(pybuffer);
      buffer.allocate(size);
      buffer.put(PyByteArray_AsString(pybuffer),size);
      buffer.flip(); // prepare the buffer for reading from
    }
    else
      throw XBMCAddon::WrongTypeException("argument \"%s\" for \"%s\" must be a string or a bytearray", "buffer", "write"); 

      apiResult = (bool )((XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"write","XBMCAddon::xbmcvfs::File"))-> write(  buffer  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"write\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"write\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"size","XBMCAddon::xbmcvfs::File"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_seek (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "seekBytes",
          "iWhence",
          NULL};
         
    long long  seekBytes ;         
    int  iWhence ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"Li",
       (char**)keywords,
         &seekBytes,
         &iWhence
       ))
    {
      return NULL;
    }

    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"seek","XBMCAddon::xbmcvfs::File"))-> seek(  seekBytes,  iWhence  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"seek\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"seek\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_File_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"close","XBMCAddon::xbmcvfs::File"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcvfs::Stat * apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","Stat"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcvfs::Stat *)new XBMCAddon::xbmcvfs::Stat(  path  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcvfs::Stat\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcvfs::Stat\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_mode (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_mode","XBMCAddon::xbmcvfs::Stat"))-> st_mode(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_mode\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_mode\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_ino (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_ino","XBMCAddon::xbmcvfs::Stat"))-> st_ino(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_ino\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_ino\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_dev (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_dev","XBMCAddon::xbmcvfs::Stat"))-> st_dev(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_dev\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_dev\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_nlink (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_nlink","XBMCAddon::xbmcvfs::Stat"))-> st_nlink(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_nlink\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_nlink\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_uid (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_uid","XBMCAddon::xbmcvfs::Stat"))-> st_uid(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_uid\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_uid\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_gid (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_gid","XBMCAddon::xbmcvfs::Stat"))-> st_gid(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_gid\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_gid\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"st_size","XBMCAddon::xbmcvfs::Stat"))-> st_size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"st_size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"st_size\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_atime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"atime","XBMCAddon::xbmcvfs::Stat"))-> atime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"atime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"atime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_mtime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"mtime","XBMCAddon::xbmcvfs::Stat"))-> mtime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"mtime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"mtime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_ctime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long long  apiResult;
    try
    {

      apiResult = (long long )((XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"ctime","XBMCAddon::xbmcvfs::Stat"))-> ctime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"ctime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"ctime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"L", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_copy (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "strSource",
          "strDestnation",
          NULL};
         
    std::string  strSource ;
    PyObject* pystrSource = NULL;         
    std::string  strDestnation ;
    PyObject* pystrDestnation = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO",
       (char**)keywords,
         &pystrSource,
         &pystrDestnation
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pystrSource) PyXBMCGetUnicodeString(strSource,pystrSource,false,"strSource","XBMCAddon::xbmcvfs::copy"); 
      if (pystrDestnation) PyXBMCGetUnicodeString(strDestnation,pystrDestnation,false,"strDestnation","XBMCAddon::xbmcvfs::copy"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::copy(  strSource,  strDestnation  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::copy\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::copy\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_delete (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "file",
          NULL};
         
    std::string  file ;
    PyObject* pyfile = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyfile
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyfile) PyXBMCGetUnicodeString(file,pyfile,false,"file","XBMCAddon::xbmcvfs::deleteFile"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::deleteFile(  file  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::deleteFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::deleteFile\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_rename (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "file",
          "newFile",
          NULL};
         
    std::string  file ;
    PyObject* pyfile = NULL;         
    std::string  newFile ;
    PyObject* pynewFile = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO",
       (char**)keywords,
         &pyfile,
         &pynewFile
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyfile) PyXBMCGetUnicodeString(file,pyfile,false,"file","XBMCAddon::xbmcvfs::rename"); 
      if (pynewFile) PyXBMCGetUnicodeString(newFile,pynewFile,false,"newFile","XBMCAddon::xbmcvfs::rename"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::rename(  file,  newFile  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::rename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::rename\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_exists (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmcvfs::exists"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::exists(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::exists\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::exists\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_mkdir (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmcvfs::mkdir"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::mkdir(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::mkdir\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::mkdir\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_mkdirs (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmcvfs::mkdirs"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::mkdirs(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::mkdirs\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::mkdirs\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_rmdir (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          "force",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;         
    bool  force  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pypath,
         &force
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmcvfs::rmdir"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcvfs::rmdir(  path,  force  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::rmdir\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::rmdir\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcvfs_listdir (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    Tuple< std::vector< XBMCAddon::String  > ,std::vector< XBMCAddon::String  >  >  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmcvfs::listdir"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (Tuple< std::vector< XBMCAddon::String  > ,std::vector< XBMCAddon::String  >  > )XBMCAddon::xbmcvfs::listdir(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::listdir\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::listdir\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
    int vecSize = apiResult.GetNumValuesSet();
    result = PyTuple_New(vecSize);
    {
      PyObject* pyentry1; 

      if (vecSize > 0)
      {
        std::vector< XBMCAddon::String  > & entry1 = apiResult.first();
        {
          
      pyentry1 = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = entry1.begin(); iter != entry1.end(); ++iter)
      {
        std::string & entry2 = *iter;
        PyObject* pyentry2;
        pyentry2 = PyString_FromStringAndSize(entry2.c_str(), entry2.length());
        PyList_Append(pyentry1, pyentry2);
        Py_DECREF(pyentry2);
      }


        }
        PyTuple_SetItem(result, 0, pyentry1);
      }


      if (vecSize > 1)
      {
        std::vector< XBMCAddon::String  > & entry1 = apiResult.second();
        {
          
      pyentry1 = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = entry1.begin(); iter != entry1.end(); ++iter)
      {
        std::string & entry3 = *iter;
        PyObject* pyentry3;
        pyentry3 = PyString_FromStringAndSize(entry3.c_str(), entry3.length());
        PyList_Append(pyentry1, pyentry3);
        Py_DECREF(pyentry3);
      }


        }
        PyTuple_SetItem(result, 1, pyentry1);
      }

    }

    return result; 
  } 

  static void xbmcvfs_XBMCAddon_xbmcvfs_File_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcvfs::File* theObj = (XBMCAddon::xbmcvfs::File*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_File_Type,"~XBMCAddon::xbmcvfs::File","XBMCAddon::xbmcvfs::File");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::File\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::File\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcvfs_XBMCAddon_xbmcvfs_Stat_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcvfs::Stat* theObj = (XBMCAddon::xbmcvfs::Stat*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcvfs_Stat_Type,"~XBMCAddon::xbmcvfs::Stat","XBMCAddon::xbmcvfs::Stat");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::Stat\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcvfs::Stat\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcvfs::File
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcvfs_File_methods[] = { 
    {(char*)"read", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_File_read, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"readBytes", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_File_readBytes, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"write", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_File_write, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"size", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_File_size, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"seek", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_File_seek, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_File_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcvfs_File_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcvfs_File_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcvfs.File";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcvfs_XBMCAddon_xbmcvfs_File_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcvfs_File_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcvfs_XBMCAddon_xbmcvfs_File_New;

    TyXBMCAddon_xbmcvfs_File_Type.swigType="p.XBMCAddon::xbmcvfs::File";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcvfs_File_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcvfs::Stat
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcvfs_Stat_methods[] = { 
    {(char*)"st_mode", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_mode, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_ino", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_ino, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_dev", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_dev, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_nlink", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_nlink, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_uid", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_uid, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_gid", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_gid, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_size", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_size, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_atime", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_atime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_mtime", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_mtime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"st_ctime", (PyCFunction)xbmcvfs_XBMCAddon_xbmcvfs_Stat_st_ctime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcvfs_Stat_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcvfs_Stat_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcvfs.Stat";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcvfs_XBMCAddon_xbmcvfs_Stat_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcvfs_Stat_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcvfs_XBMCAddon_xbmcvfs_Stat_New;

    TyXBMCAddon_xbmcvfs_Stat_Type.swigType="p.XBMCAddon::xbmcvfs::Stat";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcvfs_Stat_Type);

  }
  //=========================================================================


  static PyMethodDef xbmcvfs_methods[] = { 
    {(char*)"copy", (PyCFunction)xbmcvfs_copy, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"delete", (PyCFunction)xbmcvfs_delete, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"rename", (PyCFunction)xbmcvfs_rename, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"exists", (PyCFunction)xbmcvfs_exists, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"mkdir", (PyCFunction)xbmcvfs_mkdir, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"mkdirs", (PyCFunction)xbmcvfs_mkdirs, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"rmdir", (PyCFunction)xbmcvfs_rmdir, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"listdir", (PyCFunction)xbmcvfs_listdir, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmcvfs_File_Type();
      initPyXBMCAddon_xbmcvfs_Stat_Type();
      if (PyType_Ready(&(TyXBMCAddon_xbmcvfs_File_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcvfs_Stat_Type.pythonType)) < 0)
        return;
    }
  }

  void initModule_xbmcvfs()
  {
    initTypes();

    // init general xbmcvfs modules
    PyObject* module;


    Py_INCREF(&(TyXBMCAddon_xbmcvfs_File_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcvfs_Stat_Type.pythonType));

    module = Py_InitModule((char*)"xbmcvfs", xbmcvfs_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"File", (PyObject*)(&(TyXBMCAddon_xbmcvfs_File_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Stat", (PyObject*)(&(TyXBMCAddon_xbmcvfs_Stat_Type.pythonType)));

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team Kodi <http://kodi.tv>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Thu Feb 23 15:51:07 EST 2017");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.25.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team Kodi");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

  }

} // end PythonBindings namespace for python type definitions


