# **Code of Kodi**

## **Introduction:**

-   This document should hopefully be entirely common sense and how most
    people would normally act anyway.
-   In an ideal world it would be entirely unnecessary, but with the impersonal
    nature of internet communications and with differing viewpoints on certain
    sensitive topics, some guidelines have proven to be necessary at times.

## **Our Aims:**

-   Our primary aim is to make Kodi the best open source media player
    product that it can be.

-   To achieve this, we aim to create a supportive, welcoming and
    open team environment where anyone can participate and submit code or
    time/knowledge to help improve things.

-   Our team environment should be welcoming and safe, free of
    harassment, discrimination and undesirable behaviour to individual
    or groups of members.

-   Whilst we do not expect everyone to get along and agree all of the
    time, we do expect people to be civil and professional to one
    another.

## **Our Expectations:**

1. Contributions from anyone are welcome, and should be encouraged.
    Where criticism or correction is needed, try to make it respectful,
    constructive, supportive and positive.

1. Contributors should act in the best interest of the community and of
    the Kodi project.

1. We're all volunteers -- people will give whatever time and effort
    they wish to. No-one should be made to do anything they don't want
    to.

1. Discrimination, harassment, threatening/bullying behaviour, trolling
    or insulting/derogatory language will not be tolerated in any form
    via any Kodi channel or site.

1. Respect the contribution and efforts of others -- treat them as
    you'd like them to treat you.

1. Publication and sharing of confidential information, both relating
    to Kodi and to individual's personal data, is only by explicit permission
    of the relevant information owner and person(s) concerned, as applicable.

1. Work on Kodi is a team effort.
    Individual contributions are highly appreciated and to be respected,
    but they do not empower those contributors to make decisions
    affecting the overall management of the project.

1. If you are a team member, you may have the title of "Team Kodi Member"
   (or variants thereof) in environments like the Kodi forum. You are of
   course free to state your own opinions on topics, but for more
   controversial ones, please ensure to explicitly state that what you
   post is your own opinion and not that of the team or the project.

1. Discussions, debate and disagreement are a natural part of a working
    team. Account should be taken though for the impersonal nature of
    internet discussions, and for things like language and cultural
    norms. Don't be too quick to assume ill intent or to take offense,
    and respect people's boundaries and feelings.

1. Where you can, be helpful to fellow contributors and share your
    knowledge and skills. We all have to start somewhere, and they may
    be able to return the favour later or contribute more fully as a
    result.

1. No-one is perfect -- tolerate honest mistakes that may be made,
    learn from them and help to repair them when you can. And if they're
    yours, be honest about them and apologise.

1. Submitted code and other important documentation will be peer
    reviewed. Comments, suggestions and constructive criticism should be
    taken with good grace and not as a slight or insult to the work and
    effort put in.

1. There is an over-riding principle that accepted work, postings or commits
   should not be reverted, edited or otherwise rejected without discussion 
   with the original author.

    Recognising that changes do sometimes need to be made (for example, code
    commits which break master compilation or simple typos that shouldn't be
    left and forgotten), a reasonable attempt - reflecting the spirit of the
    change/reversion - should be made to liaise with the original author prior
    to making any modifications. If this isn't practical, it is considered good
    practice to appropriately peer review any potential changes prior to 
    application to minimise risks of further breakage.
    
1. In case of dispute the working group or the board should be asked
    to mediate.

## **Scope:**

-   This code covers all services supplied by and used by Team Kodi,
    such as:

    -   The official GitHub repos.

    -   The Kodi forum.

    -   The Kodi wiki.

    -   The Kodi Slack and IRC channels.

    -   Official Kodi social media channels.

    -   Devcon.

-   Anyone who contributes to the Kodi project on any of these channels
    is expected to abide by this code.

## **Enforcement:**

-   Violations of this code which cannot be dealt with by simple
    discussion should be reported to the working group via conduct@kodi.tv .
    The group will then review the issue and mediate between the parties involved.

-   The identity of the reporter and where appropriate the nature of the issue
    should remain confidential and be handled with care and sensitivity.

-   The procedure upon receiving a report should be:

    1.  The group should review the report, and any member directly
        involved or having a vested interest in the outcome should
        recuse themselves.

    1.  Any public disputes or discussions should be brought to a close
        with a clear statement that the issue is under review, and that
        any further 3rd party comment should be directed to the group
        via the group email address.

    1.  All individuals concerned with the issue will be contacted
        privately and an attempt made to clarify their individual
        viewpoints and concerns. Particular emphasis on identifying and
        resolving any misunderstandings, mistranslations or
        misinterpretations will be made.

    1.  In case of such identifications, the group will attempt to
        mediate between the parties involved to resolve the problem if
        possible.

    1.  The behaviour of all parties involved will be reviewed, and in
        cases where the code has been broken (e.g. harassment,
        discrimination or aggression) further action will be discussed
        against the individual(s) concerned.

    1.  This action will depend on the severity of the transgression and
        on the history of the individual. Some guidelines for
        appropriate measures for team members are:

        -   First offence -- a warning.

        -   Second offence -- loss of privileges for a week.

        -   Third offence -- loss of privileges for a month.

        -   Fourth offence -- permanent revoking of privileges.

        -   Final offence -- banning from all Kodi services.

        -   Privileges will depend on the nature of the issue, but may
            include team membership, GitHub repo push access, forum
            moderator powers, wiki account access and social media
            account access.
            
        For individuals that are not members of Team Kodi, there are no
        privileges that could be revoked. Appropriate measures therefore
        include warnings and revoking access to services such as the
        forum or the `xbmc` organization on GitHub temporarily or
        permanently.

## **Stakeholders:**

-   *Kodi Foundation Board* -- the elected five directors and management
    of the XBMC Foundation.

-   *Working Group* -- the team assigned by the board to create this
    document and to oversee its administration.

-   *Contributors* -- volunteers who give input into the upkeep and
    improvement of Kodi and its community, be they Team Members or
    interested third parties. This includes both code and posts made to
    the forum, the wiki or on official social media channels.

## **Related Documents:**

-   [Forum rules](https://kodi.wiki/view/Official:Forum_rules)
-   [Moderation rules (the basics)](https://github.com/xbmc/xbmc/blob/master/docs/codeofconduct/ModerationRules.md)
-   [Moderator guidelines](https://github.com/xbmc/xbmc/blob/master/docs/codeofconduct/ModeratorGuidelines.md)
-   [Forum banning code of conduct](https://github.com/xbmc/xbmc/blob/master/docs/codeofconduct/ForumUserBanning.md)