/*
 * Decompiled with CFR 0.152.
 */
package apple.dts.samplecode.osxadapter;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXAdapter
implements InvocationHandler {
    private Object targetObject;
    private Method targetMethod;
    private String proxySignature;
    private static Object macOSXApplication;

    public static void setQuitHandler(Object object, Method method) {
        OSXAdapter.setHandler(new OSXAdapter("handleQuit", object, method));
    }

    public static void setAboutHandler(Object object, Method method) {
        boolean bl = object != null && method != null;
        if (bl) {
            OSXAdapter.setHandler(new OSXAdapter("handleAbout", object, method));
        }
        try {
            object = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
            ((Method)object).invoke(macOSXApplication, bl);
            return;
        }
        catch (Exception exception) {
            System.err.println("OSXAdapter could not access the About Menu");
            exception.printStackTrace();
            return;
        }
    }

    private static void setHandler(OSXAdapter object) {
        try {
            GenericDeclaration genericDeclaration = Class.forName("com.apple.eawt.Application");
            if (macOSXApplication == null) {
                macOSXApplication = ((Class)genericDeclaration).getConstructor(null).newInstance(null);
            }
            Class<?> clazz = Class.forName("com.apple.eawt.ApplicationListener");
            genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("addApplicationListener", clazz);
            object = Proxy.newProxyInstance(OSXAdapter.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            ((Method)genericDeclaration).invoke(macOSXApplication, object);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  ApplicationEvent handling has been disabled (" + classNotFoundException + ")");
            return;
        }
        catch (Exception exception) {
            System.err.println("Mac OS X Adapter could not talk to EAWT:");
            exception.printStackTrace();
            return;
        }
    }

    private OSXAdapter(String string, Object object, Method method) {
        this.proxySignature = string;
        this.targetObject = object;
        this.targetMethod = method;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] object2) throws Throwable {
        Object object3 = object2;
        object = this;
        if (((OSXAdapter)object).targetMethod != null && ((OSXAdapter)object).proxySignature.equals(method.getName()) && ((Object[])object3).length == 1) {
            boolean bl;
            object = this;
            object3 = ((OSXAdapter)object).targetMethod.invoke(((OSXAdapter)object).targetObject, null);
            boolean bl2 = bl = object3 == null ? true : Boolean.valueOf(object3.toString());
            Object object4 = object2[0];
            if (object4 != null) {
                try {
                    object2 = object4.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                    object2.invoke(object4, bl2);
                }
                catch (Exception exception) {
                    System.err.println("OSXAdapter was unable to handle an ApplicationEvent: " + object4);
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }
}

