/*
 *  Copyright 2012  Sebastian Gottfried <sebastiangottfried@web.de>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef DATAACCESS_H
#define DATAACCESS_H

#include <QObject>

class Course;
class DataIndex;
class DataIndexCourse;
class DataIndexKeyboardLayout;
class KeyboardLayout;

class DataAccess : public QObject
{
    Q_OBJECT
public:
    explicit DataAccess(QObject* parent = 0);
    Q_INVOKABLE bool loadDataIndex(DataIndex* target);
    Q_INVOKABLE bool loadCourse(DataIndexCourse* dataIndexCourse, Course* target);
    Q_INVOKABLE bool loadKeyboardLayout(DataIndexKeyboardLayout* dataIndexKeyboardLayout, KeyboardLayout* target);
};

#endif // DATAACCESS_H
