//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	v1alpha1 "k8s.io/api/resource/v1alpha1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	core "k8s.io/kubernetes/pkg/apis/core"
	resource "k8s.io/kubernetes/pkg/apis/resource"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1alpha1.AllocationResult)(nil), (*resource.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AllocationResult_To_resource_AllocationResult(a.(*v1alpha1.AllocationResult), b.(*resource.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.AllocationResult)(nil), (*v1alpha1.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_AllocationResult_To_v1alpha1_AllocationResult(a.(*resource.AllocationResult), b.(*v1alpha1.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.PodScheduling)(nil), (*resource.PodScheduling)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodScheduling_To_resource_PodScheduling(a.(*v1alpha1.PodScheduling), b.(*resource.PodScheduling), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodScheduling)(nil), (*v1alpha1.PodScheduling)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodScheduling_To_v1alpha1_PodScheduling(a.(*resource.PodScheduling), b.(*v1alpha1.PodScheduling), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.PodSchedulingList)(nil), (*resource.PodSchedulingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodSchedulingList_To_resource_PodSchedulingList(a.(*v1alpha1.PodSchedulingList), b.(*resource.PodSchedulingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingList)(nil), (*v1alpha1.PodSchedulingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingList_To_v1alpha1_PodSchedulingList(a.(*resource.PodSchedulingList), b.(*v1alpha1.PodSchedulingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.PodSchedulingSpec)(nil), (*resource.PodSchedulingSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodSchedulingSpec_To_resource_PodSchedulingSpec(a.(*v1alpha1.PodSchedulingSpec), b.(*resource.PodSchedulingSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingSpec)(nil), (*v1alpha1.PodSchedulingSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingSpec_To_v1alpha1_PodSchedulingSpec(a.(*resource.PodSchedulingSpec), b.(*v1alpha1.PodSchedulingSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.PodSchedulingStatus)(nil), (*resource.PodSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodSchedulingStatus_To_resource_PodSchedulingStatus(a.(*v1alpha1.PodSchedulingStatus), b.(*resource.PodSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingStatus)(nil), (*v1alpha1.PodSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingStatus_To_v1alpha1_PodSchedulingStatus(a.(*resource.PodSchedulingStatus), b.(*v1alpha1.PodSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaim)(nil), (*resource.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaim_To_resource_ResourceClaim(a.(*v1alpha1.ResourceClaim), b.(*resource.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaim)(nil), (*v1alpha1.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaim_To_v1alpha1_ResourceClaim(a.(*resource.ResourceClaim), b.(*v1alpha1.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimConsumerReference)(nil), (*resource.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(a.(*v1alpha1.ResourceClaimConsumerReference), b.(*resource.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimConsumerReference)(nil), (*v1alpha1.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimConsumerReference_To_v1alpha1_ResourceClaimConsumerReference(a.(*resource.ResourceClaimConsumerReference), b.(*v1alpha1.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimList)(nil), (*resource.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimList_To_resource_ResourceClaimList(a.(*v1alpha1.ResourceClaimList), b.(*resource.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimList)(nil), (*v1alpha1.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimList_To_v1alpha1_ResourceClaimList(a.(*resource.ResourceClaimList), b.(*v1alpha1.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimParametersReference)(nil), (*resource.ResourceClaimParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(a.(*v1alpha1.ResourceClaimParametersReference), b.(*resource.ResourceClaimParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimParametersReference)(nil), (*v1alpha1.ResourceClaimParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimParametersReference_To_v1alpha1_ResourceClaimParametersReference(a.(*resource.ResourceClaimParametersReference), b.(*v1alpha1.ResourceClaimParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimSchedulingStatus)(nil), (*resource.ResourceClaimSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(a.(*v1alpha1.ResourceClaimSchedulingStatus), b.(*resource.ResourceClaimSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSchedulingStatus)(nil), (*v1alpha1.ResourceClaimSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha1_ResourceClaimSchedulingStatus(a.(*resource.ResourceClaimSchedulingStatus), b.(*v1alpha1.ResourceClaimSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimSpec)(nil), (*resource.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec(a.(*v1alpha1.ResourceClaimSpec), b.(*resource.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSpec)(nil), (*v1alpha1.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec(a.(*resource.ResourceClaimSpec), b.(*v1alpha1.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimStatus)(nil), (*resource.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimStatus_To_resource_ResourceClaimStatus(a.(*v1alpha1.ResourceClaimStatus), b.(*resource.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimStatus)(nil), (*v1alpha1.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimStatus_To_v1alpha1_ResourceClaimStatus(a.(*resource.ResourceClaimStatus), b.(*v1alpha1.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimTemplate)(nil), (*resource.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(a.(*v1alpha1.ResourceClaimTemplate), b.(*resource.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplate)(nil), (*v1alpha1.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplate_To_v1alpha1_ResourceClaimTemplate(a.(*resource.ResourceClaimTemplate), b.(*v1alpha1.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimTemplateList)(nil), (*resource.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(a.(*v1alpha1.ResourceClaimTemplateList), b.(*resource.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateList)(nil), (*v1alpha1.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateList_To_v1alpha1_ResourceClaimTemplateList(a.(*resource.ResourceClaimTemplateList), b.(*v1alpha1.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClaimTemplateSpec)(nil), (*resource.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(a.(*v1alpha1.ResourceClaimTemplateSpec), b.(*resource.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateSpec)(nil), (*v1alpha1.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateSpec_To_v1alpha1_ResourceClaimTemplateSpec(a.(*resource.ResourceClaimTemplateSpec), b.(*v1alpha1.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClass)(nil), (*resource.ResourceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClass_To_resource_ResourceClass(a.(*v1alpha1.ResourceClass), b.(*resource.ResourceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClass)(nil), (*v1alpha1.ResourceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClass_To_v1alpha1_ResourceClass(a.(*resource.ResourceClass), b.(*v1alpha1.ResourceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClassList)(nil), (*resource.ResourceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClassList_To_resource_ResourceClassList(a.(*v1alpha1.ResourceClassList), b.(*resource.ResourceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassList)(nil), (*v1alpha1.ResourceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassList_To_v1alpha1_ResourceClassList(a.(*resource.ResourceClassList), b.(*v1alpha1.ResourceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceClassParametersReference)(nil), (*resource.ResourceClassParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(a.(*v1alpha1.ResourceClassParametersReference), b.(*resource.ResourceClassParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassParametersReference)(nil), (*v1alpha1.ResourceClassParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassParametersReference_To_v1alpha1_ResourceClassParametersReference(a.(*resource.ResourceClassParametersReference), b.(*v1alpha1.ResourceClassParametersReference), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_AllocationResult_To_resource_AllocationResult(in *v1alpha1.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	out.ResourceHandle = in.ResourceHandle
	out.AvailableOnNodes = (*core.NodeSelector)(unsafe.Pointer(in.AvailableOnNodes))
	out.Shareable = in.Shareable
	return nil
}

// Convert_v1alpha1_AllocationResult_To_resource_AllocationResult is an autogenerated conversion function.
func Convert_v1alpha1_AllocationResult_To_resource_AllocationResult(in *v1alpha1.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha1_AllocationResult_To_resource_AllocationResult(in, out, s)
}

func autoConvert_resource_AllocationResult_To_v1alpha1_AllocationResult(in *resource.AllocationResult, out *v1alpha1.AllocationResult, s conversion.Scope) error {
	out.ResourceHandle = in.ResourceHandle
	out.AvailableOnNodes = (*v1.NodeSelector)(unsafe.Pointer(in.AvailableOnNodes))
	out.Shareable = in.Shareable
	return nil
}

// Convert_resource_AllocationResult_To_v1alpha1_AllocationResult is an autogenerated conversion function.
func Convert_resource_AllocationResult_To_v1alpha1_AllocationResult(in *resource.AllocationResult, out *v1alpha1.AllocationResult, s conversion.Scope) error {
	return autoConvert_resource_AllocationResult_To_v1alpha1_AllocationResult(in, out, s)
}

func autoConvert_v1alpha1_PodScheduling_To_resource_PodScheduling(in *v1alpha1.PodScheduling, out *resource.PodScheduling, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_PodSchedulingSpec_To_resource_PodSchedulingSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_PodSchedulingStatus_To_resource_PodSchedulingStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_PodScheduling_To_resource_PodScheduling is an autogenerated conversion function.
func Convert_v1alpha1_PodScheduling_To_resource_PodScheduling(in *v1alpha1.PodScheduling, out *resource.PodScheduling, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodScheduling_To_resource_PodScheduling(in, out, s)
}

func autoConvert_resource_PodScheduling_To_v1alpha1_PodScheduling(in *resource.PodScheduling, out *v1alpha1.PodScheduling, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_PodSchedulingSpec_To_v1alpha1_PodSchedulingSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_PodSchedulingStatus_To_v1alpha1_PodSchedulingStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_PodScheduling_To_v1alpha1_PodScheduling is an autogenerated conversion function.
func Convert_resource_PodScheduling_To_v1alpha1_PodScheduling(in *resource.PodScheduling, out *v1alpha1.PodScheduling, s conversion.Scope) error {
	return autoConvert_resource_PodScheduling_To_v1alpha1_PodScheduling(in, out, s)
}

func autoConvert_v1alpha1_PodSchedulingList_To_resource_PodSchedulingList(in *v1alpha1.PodSchedulingList, out *resource.PodSchedulingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.PodScheduling)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_PodSchedulingList_To_resource_PodSchedulingList is an autogenerated conversion function.
func Convert_v1alpha1_PodSchedulingList_To_resource_PodSchedulingList(in *v1alpha1.PodSchedulingList, out *resource.PodSchedulingList, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodSchedulingList_To_resource_PodSchedulingList(in, out, s)
}

func autoConvert_resource_PodSchedulingList_To_v1alpha1_PodSchedulingList(in *resource.PodSchedulingList, out *v1alpha1.PodSchedulingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha1.PodScheduling)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_PodSchedulingList_To_v1alpha1_PodSchedulingList is an autogenerated conversion function.
func Convert_resource_PodSchedulingList_To_v1alpha1_PodSchedulingList(in *resource.PodSchedulingList, out *v1alpha1.PodSchedulingList, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingList_To_v1alpha1_PodSchedulingList(in, out, s)
}

func autoConvert_v1alpha1_PodSchedulingSpec_To_resource_PodSchedulingSpec(in *v1alpha1.PodSchedulingSpec, out *resource.PodSchedulingSpec, s conversion.Scope) error {
	out.SelectedNode = in.SelectedNode
	out.PotentialNodes = *(*[]string)(unsafe.Pointer(&in.PotentialNodes))
	return nil
}

// Convert_v1alpha1_PodSchedulingSpec_To_resource_PodSchedulingSpec is an autogenerated conversion function.
func Convert_v1alpha1_PodSchedulingSpec_To_resource_PodSchedulingSpec(in *v1alpha1.PodSchedulingSpec, out *resource.PodSchedulingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodSchedulingSpec_To_resource_PodSchedulingSpec(in, out, s)
}

func autoConvert_resource_PodSchedulingSpec_To_v1alpha1_PodSchedulingSpec(in *resource.PodSchedulingSpec, out *v1alpha1.PodSchedulingSpec, s conversion.Scope) error {
	out.SelectedNode = in.SelectedNode
	out.PotentialNodes = *(*[]string)(unsafe.Pointer(&in.PotentialNodes))
	return nil
}

// Convert_resource_PodSchedulingSpec_To_v1alpha1_PodSchedulingSpec is an autogenerated conversion function.
func Convert_resource_PodSchedulingSpec_To_v1alpha1_PodSchedulingSpec(in *resource.PodSchedulingSpec, out *v1alpha1.PodSchedulingSpec, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingSpec_To_v1alpha1_PodSchedulingSpec(in, out, s)
}

func autoConvert_v1alpha1_PodSchedulingStatus_To_resource_PodSchedulingStatus(in *v1alpha1.PodSchedulingStatus, out *resource.PodSchedulingStatus, s conversion.Scope) error {
	out.ResourceClaims = *(*[]resource.ResourceClaimSchedulingStatus)(unsafe.Pointer(&in.ResourceClaims))
	return nil
}

// Convert_v1alpha1_PodSchedulingStatus_To_resource_PodSchedulingStatus is an autogenerated conversion function.
func Convert_v1alpha1_PodSchedulingStatus_To_resource_PodSchedulingStatus(in *v1alpha1.PodSchedulingStatus, out *resource.PodSchedulingStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodSchedulingStatus_To_resource_PodSchedulingStatus(in, out, s)
}

func autoConvert_resource_PodSchedulingStatus_To_v1alpha1_PodSchedulingStatus(in *resource.PodSchedulingStatus, out *v1alpha1.PodSchedulingStatus, s conversion.Scope) error {
	out.ResourceClaims = *(*[]v1alpha1.ResourceClaimSchedulingStatus)(unsafe.Pointer(&in.ResourceClaims))
	return nil
}

// Convert_resource_PodSchedulingStatus_To_v1alpha1_PodSchedulingStatus is an autogenerated conversion function.
func Convert_resource_PodSchedulingStatus_To_v1alpha1_PodSchedulingStatus(in *resource.PodSchedulingStatus, out *v1alpha1.PodSchedulingStatus, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingStatus_To_v1alpha1_PodSchedulingStatus(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaim_To_resource_ResourceClaim(in *v1alpha1.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ResourceClaimStatus_To_resource_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ResourceClaim_To_resource_ResourceClaim is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaim_To_resource_ResourceClaim(in *v1alpha1.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaim_To_resource_ResourceClaim(in, out, s)
}

func autoConvert_resource_ResourceClaim_To_v1alpha1_ResourceClaim(in *resource.ResourceClaim, out *v1alpha1.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_ResourceClaimStatus_To_v1alpha1_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaim_To_v1alpha1_ResourceClaim is an autogenerated conversion function.
func Convert_resource_ResourceClaim_To_v1alpha1_ResourceClaim(in *resource.ResourceClaim, out *v1alpha1.ResourceClaim, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaim_To_v1alpha1_ResourceClaim(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *v1alpha1.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1alpha1_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *v1alpha1.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha1_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *v1alpha1.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_resource_ResourceClaimConsumerReference_To_v1alpha1_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimConsumerReference_To_v1alpha1_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *v1alpha1.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha1_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimList_To_resource_ResourceClaimList(in *v1alpha1.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ResourceClaimList_To_resource_ResourceClaimList is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimList_To_resource_ResourceClaimList(in *v1alpha1.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimList_To_resource_ResourceClaimList(in, out, s)
}

func autoConvert_resource_ResourceClaimList_To_v1alpha1_ResourceClaimList(in *resource.ResourceClaimList, out *v1alpha1.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha1.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimList_To_v1alpha1_ResourceClaimList is an autogenerated conversion function.
func Convert_resource_ResourceClaimList_To_v1alpha1_ResourceClaimList(in *resource.ResourceClaimList, out *v1alpha1.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimList_To_v1alpha1_ResourceClaimList(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in *v1alpha1.ResourceClaimParametersReference, out *resource.ResourceClaimParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in *v1alpha1.ResourceClaimParametersReference, out *resource.ResourceClaimParametersReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in, out, s)
}

func autoConvert_resource_ResourceClaimParametersReference_To_v1alpha1_ResourceClaimParametersReference(in *resource.ResourceClaimParametersReference, out *v1alpha1.ResourceClaimParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	return nil
}

// Convert_resource_ResourceClaimParametersReference_To_v1alpha1_ResourceClaimParametersReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimParametersReference_To_v1alpha1_ResourceClaimParametersReference(in *resource.ResourceClaimParametersReference, out *v1alpha1.ResourceClaimParametersReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimParametersReference_To_v1alpha1_ResourceClaimParametersReference(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in *v1alpha1.ResourceClaimSchedulingStatus, out *resource.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	out.Name = in.Name
	out.UnsuitableNodes = *(*[]string)(unsafe.Pointer(&in.UnsuitableNodes))
	return nil
}

// Convert_v1alpha1_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in *v1alpha1.ResourceClaimSchedulingStatus, out *resource.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimSchedulingStatus_To_v1alpha1_ResourceClaimSchedulingStatus(in *resource.ResourceClaimSchedulingStatus, out *v1alpha1.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	out.Name = in.Name
	out.UnsuitableNodes = *(*[]string)(unsafe.Pointer(&in.UnsuitableNodes))
	return nil
}

// Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha1_ResourceClaimSchedulingStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha1_ResourceClaimSchedulingStatus(in *resource.ResourceClaimSchedulingStatus, out *v1alpha1.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSchedulingStatus_To_v1alpha1_ResourceClaimSchedulingStatus(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *v1alpha1.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	out.ResourceClassName = in.ResourceClassName
	out.ParametersRef = (*resource.ResourceClaimParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.AllocationMode = resource.AllocationMode(in.AllocationMode)
	return nil
}

// Convert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *v1alpha1.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *v1alpha1.ResourceClaimSpec, s conversion.Scope) error {
	out.ResourceClassName = in.ResourceClassName
	out.ParametersRef = (*v1alpha1.ResourceClaimParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.AllocationMode = v1alpha1.AllocationMode(in.AllocationMode)
	return nil
}

// Convert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *v1alpha1.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *v1alpha1.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Allocation = (*resource.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]resource.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.DeallocationRequested = in.DeallocationRequested
	return nil
}

// Convert_v1alpha1_ResourceClaimStatus_To_resource_ResourceClaimStatus is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *v1alpha1.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimStatus_To_resource_ResourceClaimStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimStatus_To_v1alpha1_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *v1alpha1.ResourceClaimStatus, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Allocation = (*v1alpha1.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]v1alpha1.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.DeallocationRequested = in.DeallocationRequested
	return nil
}

// Convert_resource_ResourceClaimStatus_To_v1alpha1_ResourceClaimStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimStatus_To_v1alpha1_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *v1alpha1.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimStatus_To_v1alpha1_ResourceClaimStatus(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *v1alpha1.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ResourceClaimTemplate_To_resource_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *v1alpha1.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplate_To_v1alpha1_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *v1alpha1.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimTemplateSpec_To_v1alpha1_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplate_To_v1alpha1_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplate_To_v1alpha1_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *v1alpha1.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplate_To_v1alpha1_ResourceClaimTemplate(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *v1alpha1.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *v1alpha1.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateList_To_v1alpha1_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *v1alpha1.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha1.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimTemplateList_To_v1alpha1_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateList_To_v1alpha1_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *v1alpha1.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateList_To_v1alpha1_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_v1alpha1_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *v1alpha1.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *v1alpha1.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha1_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *v1alpha1.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha1_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplateSpec_To_v1alpha1_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateSpec_To_v1alpha1_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *v1alpha1.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha1_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_v1alpha1_ResourceClass_To_resource_ResourceClass(in *v1alpha1.ResourceClass, out *resource.ResourceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DriverName = in.DriverName
	out.ParametersRef = (*resource.ResourceClassParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.SuitableNodes = (*core.NodeSelector)(unsafe.Pointer(in.SuitableNodes))
	return nil
}

// Convert_v1alpha1_ResourceClass_To_resource_ResourceClass is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClass_To_resource_ResourceClass(in *v1alpha1.ResourceClass, out *resource.ResourceClass, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClass_To_resource_ResourceClass(in, out, s)
}

func autoConvert_resource_ResourceClass_To_v1alpha1_ResourceClass(in *resource.ResourceClass, out *v1alpha1.ResourceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DriverName = in.DriverName
	out.ParametersRef = (*v1alpha1.ResourceClassParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.SuitableNodes = (*v1.NodeSelector)(unsafe.Pointer(in.SuitableNodes))
	return nil
}

// Convert_resource_ResourceClass_To_v1alpha1_ResourceClass is an autogenerated conversion function.
func Convert_resource_ResourceClass_To_v1alpha1_ResourceClass(in *resource.ResourceClass, out *v1alpha1.ResourceClass, s conversion.Scope) error {
	return autoConvert_resource_ResourceClass_To_v1alpha1_ResourceClass(in, out, s)
}

func autoConvert_v1alpha1_ResourceClassList_To_resource_ResourceClassList(in *v1alpha1.ResourceClassList, out *resource.ResourceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ResourceClassList_To_resource_ResourceClassList is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClassList_To_resource_ResourceClassList(in *v1alpha1.ResourceClassList, out *resource.ResourceClassList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClassList_To_resource_ResourceClassList(in, out, s)
}

func autoConvert_resource_ResourceClassList_To_v1alpha1_ResourceClassList(in *resource.ResourceClassList, out *v1alpha1.ResourceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha1.ResourceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClassList_To_v1alpha1_ResourceClassList is an autogenerated conversion function.
func Convert_resource_ResourceClassList_To_v1alpha1_ResourceClassList(in *resource.ResourceClassList, out *v1alpha1.ResourceClassList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassList_To_v1alpha1_ResourceClassList(in, out, s)
}

func autoConvert_v1alpha1_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in *v1alpha1.ResourceClassParametersReference, out *resource.ResourceClassParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1alpha1_ResourceClassParametersReference_To_resource_ResourceClassParametersReference is an autogenerated conversion function.
func Convert_v1alpha1_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in *v1alpha1.ResourceClassParametersReference, out *resource.ResourceClassParametersReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in, out, s)
}

func autoConvert_resource_ResourceClassParametersReference_To_v1alpha1_ResourceClassParametersReference(in *resource.ResourceClassParametersReference, out *v1alpha1.ResourceClassParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_resource_ResourceClassParametersReference_To_v1alpha1_ResourceClassParametersReference is an autogenerated conversion function.
func Convert_resource_ResourceClassParametersReference_To_v1alpha1_ResourceClassParametersReference(in *resource.ResourceClassParametersReference, out *v1alpha1.ResourceClassParametersReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassParametersReference_To_v1alpha1_ResourceClassParametersReference(in, out, s)
}
