//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	v1alpha2 "k8s.io/api/resource/v1alpha2"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	core "k8s.io/kubernetes/pkg/apis/core"
	resource "k8s.io/kubernetes/pkg/apis/resource"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1alpha2.AllocationResult)(nil), (*resource.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AllocationResult_To_resource_AllocationResult(a.(*v1alpha2.AllocationResult), b.(*resource.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.AllocationResult)(nil), (*v1alpha2.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_AllocationResult_To_v1alpha2_AllocationResult(a.(*resource.AllocationResult), b.(*v1alpha2.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContext)(nil), (*resource.PodSchedulingContext)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(a.(*v1alpha2.PodSchedulingContext), b.(*resource.PodSchedulingContext), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContext)(nil), (*v1alpha2.PodSchedulingContext)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(a.(*resource.PodSchedulingContext), b.(*v1alpha2.PodSchedulingContext), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContextList)(nil), (*resource.PodSchedulingContextList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(a.(*v1alpha2.PodSchedulingContextList), b.(*resource.PodSchedulingContextList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContextList)(nil), (*v1alpha2.PodSchedulingContextList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(a.(*resource.PodSchedulingContextList), b.(*v1alpha2.PodSchedulingContextList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContextSpec)(nil), (*resource.PodSchedulingContextSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(a.(*v1alpha2.PodSchedulingContextSpec), b.(*resource.PodSchedulingContextSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContextSpec)(nil), (*v1alpha2.PodSchedulingContextSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(a.(*resource.PodSchedulingContextSpec), b.(*v1alpha2.PodSchedulingContextSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.PodSchedulingContextStatus)(nil), (*resource.PodSchedulingContextStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(a.(*v1alpha2.PodSchedulingContextStatus), b.(*resource.PodSchedulingContextStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.PodSchedulingContextStatus)(nil), (*v1alpha2.PodSchedulingContextStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(a.(*resource.PodSchedulingContextStatus), b.(*v1alpha2.PodSchedulingContextStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaim)(nil), (*resource.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(a.(*v1alpha2.ResourceClaim), b.(*resource.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaim)(nil), (*v1alpha2.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(a.(*resource.ResourceClaim), b.(*v1alpha2.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimConsumerReference)(nil), (*resource.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(a.(*v1alpha2.ResourceClaimConsumerReference), b.(*resource.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimConsumerReference)(nil), (*v1alpha2.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(a.(*resource.ResourceClaimConsumerReference), b.(*v1alpha2.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimList)(nil), (*resource.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(a.(*v1alpha2.ResourceClaimList), b.(*resource.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimList)(nil), (*v1alpha2.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(a.(*resource.ResourceClaimList), b.(*v1alpha2.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimParametersReference)(nil), (*resource.ResourceClaimParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(a.(*v1alpha2.ResourceClaimParametersReference), b.(*resource.ResourceClaimParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimParametersReference)(nil), (*v1alpha2.ResourceClaimParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(a.(*resource.ResourceClaimParametersReference), b.(*v1alpha2.ResourceClaimParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimSchedulingStatus)(nil), (*resource.ResourceClaimSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(a.(*v1alpha2.ResourceClaimSchedulingStatus), b.(*resource.ResourceClaimSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSchedulingStatus)(nil), (*v1alpha2.ResourceClaimSchedulingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(a.(*resource.ResourceClaimSchedulingStatus), b.(*v1alpha2.ResourceClaimSchedulingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimSpec)(nil), (*resource.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(a.(*v1alpha2.ResourceClaimSpec), b.(*resource.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSpec)(nil), (*v1alpha2.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(a.(*resource.ResourceClaimSpec), b.(*v1alpha2.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimStatus)(nil), (*resource.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(a.(*v1alpha2.ResourceClaimStatus), b.(*resource.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimStatus)(nil), (*v1alpha2.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(a.(*resource.ResourceClaimStatus), b.(*v1alpha2.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimTemplate)(nil), (*resource.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(a.(*v1alpha2.ResourceClaimTemplate), b.(*resource.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplate)(nil), (*v1alpha2.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(a.(*resource.ResourceClaimTemplate), b.(*v1alpha2.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimTemplateList)(nil), (*resource.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(a.(*v1alpha2.ResourceClaimTemplateList), b.(*resource.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateList)(nil), (*v1alpha2.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(a.(*resource.ResourceClaimTemplateList), b.(*v1alpha2.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClaimTemplateSpec)(nil), (*resource.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(a.(*v1alpha2.ResourceClaimTemplateSpec), b.(*resource.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateSpec)(nil), (*v1alpha2.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(a.(*resource.ResourceClaimTemplateSpec), b.(*v1alpha2.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClass)(nil), (*resource.ResourceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClass_To_resource_ResourceClass(a.(*v1alpha2.ResourceClass), b.(*resource.ResourceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClass)(nil), (*v1alpha2.ResourceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClass_To_v1alpha2_ResourceClass(a.(*resource.ResourceClass), b.(*v1alpha2.ResourceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClassList)(nil), (*resource.ResourceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(a.(*v1alpha2.ResourceClassList), b.(*resource.ResourceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassList)(nil), (*v1alpha2.ResourceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(a.(*resource.ResourceClassList), b.(*v1alpha2.ResourceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceClassParametersReference)(nil), (*resource.ResourceClassParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(a.(*v1alpha2.ResourceClassParametersReference), b.(*resource.ResourceClassParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClassParametersReference)(nil), (*v1alpha2.ResourceClassParametersReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(a.(*resource.ResourceClassParametersReference), b.(*v1alpha2.ResourceClassParametersReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ResourceHandle)(nil), (*resource.ResourceHandle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(a.(*v1alpha2.ResourceHandle), b.(*resource.ResourceHandle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceHandle)(nil), (*v1alpha2.ResourceHandle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(a.(*resource.ResourceHandle), b.(*v1alpha2.ResourceHandle), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_AllocationResult_To_resource_AllocationResult(in *v1alpha2.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	out.ResourceHandles = *(*[]resource.ResourceHandle)(unsafe.Pointer(&in.ResourceHandles))
	out.AvailableOnNodes = (*core.NodeSelector)(unsafe.Pointer(in.AvailableOnNodes))
	out.Shareable = in.Shareable
	return nil
}

// Convert_v1alpha2_AllocationResult_To_resource_AllocationResult is an autogenerated conversion function.
func Convert_v1alpha2_AllocationResult_To_resource_AllocationResult(in *v1alpha2.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha2_AllocationResult_To_resource_AllocationResult(in, out, s)
}

func autoConvert_resource_AllocationResult_To_v1alpha2_AllocationResult(in *resource.AllocationResult, out *v1alpha2.AllocationResult, s conversion.Scope) error {
	out.ResourceHandles = *(*[]v1alpha2.ResourceHandle)(unsafe.Pointer(&in.ResourceHandles))
	out.AvailableOnNodes = (*v1.NodeSelector)(unsafe.Pointer(in.AvailableOnNodes))
	out.Shareable = in.Shareable
	return nil
}

// Convert_resource_AllocationResult_To_v1alpha2_AllocationResult is an autogenerated conversion function.
func Convert_resource_AllocationResult_To_v1alpha2_AllocationResult(in *resource.AllocationResult, out *v1alpha2.AllocationResult, s conversion.Scope) error {
	return autoConvert_resource_AllocationResult_To_v1alpha2_AllocationResult(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(in *v1alpha2.PodSchedulingContext, out *resource.PodSchedulingContext, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(in *v1alpha2.PodSchedulingContext, out *resource.PodSchedulingContext, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContext_To_resource_PodSchedulingContext(in, out, s)
}

func autoConvert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(in *resource.PodSchedulingContext, out *v1alpha2.PodSchedulingContext, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext is an autogenerated conversion function.
func Convert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(in *resource.PodSchedulingContext, out *v1alpha2.PodSchedulingContext, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContext_To_v1alpha2_PodSchedulingContext(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(in *v1alpha2.PodSchedulingContextList, out *resource.PodSchedulingContextList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.PodSchedulingContext)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(in *v1alpha2.PodSchedulingContextList, out *resource.PodSchedulingContextList, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContextList_To_resource_PodSchedulingContextList(in, out, s)
}

func autoConvert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(in *resource.PodSchedulingContextList, out *v1alpha2.PodSchedulingContextList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.PodSchedulingContext)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList is an autogenerated conversion function.
func Convert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(in *resource.PodSchedulingContextList, out *v1alpha2.PodSchedulingContextList, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContextList_To_v1alpha2_PodSchedulingContextList(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(in *v1alpha2.PodSchedulingContextSpec, out *resource.PodSchedulingContextSpec, s conversion.Scope) error {
	out.SelectedNode = in.SelectedNode
	out.PotentialNodes = *(*[]string)(unsafe.Pointer(&in.PotentialNodes))
	return nil
}

// Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(in *v1alpha2.PodSchedulingContextSpec, out *resource.PodSchedulingContextSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContextSpec_To_resource_PodSchedulingContextSpec(in, out, s)
}

func autoConvert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(in *resource.PodSchedulingContextSpec, out *v1alpha2.PodSchedulingContextSpec, s conversion.Scope) error {
	out.SelectedNode = in.SelectedNode
	out.PotentialNodes = *(*[]string)(unsafe.Pointer(&in.PotentialNodes))
	return nil
}

// Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec is an autogenerated conversion function.
func Convert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(in *resource.PodSchedulingContextSpec, out *v1alpha2.PodSchedulingContextSpec, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContextSpec_To_v1alpha2_PodSchedulingContextSpec(in, out, s)
}

func autoConvert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(in *v1alpha2.PodSchedulingContextStatus, out *resource.PodSchedulingContextStatus, s conversion.Scope) error {
	out.ResourceClaims = *(*[]resource.ResourceClaimSchedulingStatus)(unsafe.Pointer(&in.ResourceClaims))
	return nil
}

// Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus is an autogenerated conversion function.
func Convert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(in *v1alpha2.PodSchedulingContextStatus, out *resource.PodSchedulingContextStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_PodSchedulingContextStatus_To_resource_PodSchedulingContextStatus(in, out, s)
}

func autoConvert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(in *resource.PodSchedulingContextStatus, out *v1alpha2.PodSchedulingContextStatus, s conversion.Scope) error {
	out.ResourceClaims = *(*[]v1alpha2.ResourceClaimSchedulingStatus)(unsafe.Pointer(&in.ResourceClaims))
	return nil
}

// Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus is an autogenerated conversion function.
func Convert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(in *resource.PodSchedulingContextStatus, out *v1alpha2.PodSchedulingContextStatus, s conversion.Scope) error {
	return autoConvert_resource_PodSchedulingContextStatus_To_v1alpha2_PodSchedulingContextStatus(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(in *v1alpha2.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(in *v1alpha2.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaim_To_resource_ResourceClaim(in, out, s)
}

func autoConvert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(in *resource.ResourceClaim, out *v1alpha2.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim is an autogenerated conversion function.
func Convert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(in *resource.ResourceClaim, out *v1alpha2.ResourceClaim, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaim_To_v1alpha2_ResourceClaim(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *v1alpha2.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *v1alpha2.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *v1alpha2.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *v1alpha2.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha2_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(in *v1alpha2.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(in *v1alpha2.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimList_To_resource_ResourceClaimList(in, out, s)
}

func autoConvert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(in *resource.ResourceClaimList, out *v1alpha2.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList is an autogenerated conversion function.
func Convert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(in *resource.ResourceClaimList, out *v1alpha2.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimList_To_v1alpha2_ResourceClaimList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in *v1alpha2.ResourceClaimParametersReference, out *resource.ResourceClaimParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	return nil
}

// Convert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in *v1alpha2.ResourceClaimParametersReference, out *resource.ResourceClaimParametersReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimParametersReference_To_resource_ResourceClaimParametersReference(in, out, s)
}

func autoConvert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(in *resource.ResourceClaimParametersReference, out *v1alpha2.ResourceClaimParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	return nil
}

// Convert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(in *resource.ResourceClaimParametersReference, out *v1alpha2.ResourceClaimParametersReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimParametersReference_To_v1alpha2_ResourceClaimParametersReference(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in *v1alpha2.ResourceClaimSchedulingStatus, out *resource.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	out.Name = in.Name
	out.UnsuitableNodes = *(*[]string)(unsafe.Pointer(&in.UnsuitableNodes))
	return nil
}

// Convert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in *v1alpha2.ResourceClaimSchedulingStatus, out *resource.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimSchedulingStatus_To_resource_ResourceClaimSchedulingStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(in *resource.ResourceClaimSchedulingStatus, out *v1alpha2.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	out.Name = in.Name
	out.UnsuitableNodes = *(*[]string)(unsafe.Pointer(&in.UnsuitableNodes))
	return nil
}

// Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(in *resource.ResourceClaimSchedulingStatus, out *v1alpha2.ResourceClaimSchedulingStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSchedulingStatus_To_v1alpha2_ResourceClaimSchedulingStatus(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *v1alpha2.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	out.ResourceClassName = in.ResourceClassName
	out.ParametersRef = (*resource.ResourceClaimParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.AllocationMode = resource.AllocationMode(in.AllocationMode)
	return nil
}

// Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *v1alpha2.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *v1alpha2.ResourceClaimSpec, s conversion.Scope) error {
	out.ResourceClassName = in.ResourceClassName
	out.ParametersRef = (*v1alpha2.ResourceClaimParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.AllocationMode = v1alpha2.AllocationMode(in.AllocationMode)
	return nil
}

// Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *v1alpha2.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *v1alpha2.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Allocation = (*resource.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]resource.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.DeallocationRequested = in.DeallocationRequested
	return nil
}

// Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *v1alpha2.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimStatus_To_resource_ResourceClaimStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *v1alpha2.ResourceClaimStatus, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Allocation = (*v1alpha2.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]v1alpha2.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.DeallocationRequested = in.DeallocationRequested
	return nil
}

// Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *v1alpha2.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimStatus_To_v1alpha2_ResourceClaimStatus(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *v1alpha2.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *v1alpha2.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *v1alpha2.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *v1alpha2.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplate_To_v1alpha2_ResourceClaimTemplate(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *v1alpha2.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *v1alpha2.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *v1alpha2.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *v1alpha2.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateList_To_v1alpha2_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *v1alpha2.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *v1alpha2.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *v1alpha2.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha2_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *v1alpha2.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha2_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_v1alpha2_ResourceClass_To_resource_ResourceClass(in *v1alpha2.ResourceClass, out *resource.ResourceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DriverName = in.DriverName
	out.ParametersRef = (*resource.ResourceClassParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.SuitableNodes = (*core.NodeSelector)(unsafe.Pointer(in.SuitableNodes))
	return nil
}

// Convert_v1alpha2_ResourceClass_To_resource_ResourceClass is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClass_To_resource_ResourceClass(in *v1alpha2.ResourceClass, out *resource.ResourceClass, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClass_To_resource_ResourceClass(in, out, s)
}

func autoConvert_resource_ResourceClass_To_v1alpha2_ResourceClass(in *resource.ResourceClass, out *v1alpha2.ResourceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DriverName = in.DriverName
	out.ParametersRef = (*v1alpha2.ResourceClassParametersReference)(unsafe.Pointer(in.ParametersRef))
	out.SuitableNodes = (*v1.NodeSelector)(unsafe.Pointer(in.SuitableNodes))
	return nil
}

// Convert_resource_ResourceClass_To_v1alpha2_ResourceClass is an autogenerated conversion function.
func Convert_resource_ResourceClass_To_v1alpha2_ResourceClass(in *resource.ResourceClass, out *v1alpha2.ResourceClass, s conversion.Scope) error {
	return autoConvert_resource_ResourceClass_To_v1alpha2_ResourceClass(in, out, s)
}

func autoConvert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(in *v1alpha2.ResourceClassList, out *resource.ResourceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha2_ResourceClassList_To_resource_ResourceClassList is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(in *v1alpha2.ResourceClassList, out *resource.ResourceClassList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClassList_To_resource_ResourceClassList(in, out, s)
}

func autoConvert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(in *resource.ResourceClassList, out *v1alpha2.ResourceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha2.ResourceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClassList_To_v1alpha2_ResourceClassList is an autogenerated conversion function.
func Convert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(in *resource.ResourceClassList, out *v1alpha2.ResourceClassList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassList_To_v1alpha2_ResourceClassList(in, out, s)
}

func autoConvert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in *v1alpha2.ResourceClassParametersReference, out *resource.ResourceClassParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference is an autogenerated conversion function.
func Convert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in *v1alpha2.ResourceClassParametersReference, out *resource.ResourceClassParametersReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceClassParametersReference_To_resource_ResourceClassParametersReference(in, out, s)
}

func autoConvert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(in *resource.ResourceClassParametersReference, out *v1alpha2.ResourceClassParametersReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Kind = in.Kind
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference is an autogenerated conversion function.
func Convert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(in *resource.ResourceClassParametersReference, out *v1alpha2.ResourceClassParametersReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClassParametersReference_To_v1alpha2_ResourceClassParametersReference(in, out, s)
}

func autoConvert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(in *v1alpha2.ResourceHandle, out *resource.ResourceHandle, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Data = in.Data
	return nil
}

// Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle is an autogenerated conversion function.
func Convert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(in *v1alpha2.ResourceHandle, out *resource.ResourceHandle, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceHandle_To_resource_ResourceHandle(in, out, s)
}

func autoConvert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(in *resource.ResourceHandle, out *v1alpha2.ResourceHandle, s conversion.Scope) error {
	out.DriverName = in.DriverName
	out.Data = in.Data
	return nil
}

// Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle is an autogenerated conversion function.
func Convert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(in *resource.ResourceHandle, out *v1alpha2.ResourceHandle, s conversion.Scope) error {
	return autoConvert_resource_ResourceHandle_To_v1alpha2_ResourceHandle(in, out, s)
}
