// $Id: request1.cc,v 1.1.1.1.2.1 2001/10/29 04:32:58 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include "mpi2c++_test.h"
extern "C" {
#if !MPI2CPP_AIX 
#include <unistd.h>
#else
  // #@%$#@%$@#%$#@% AIX!!!
typedef unsigned int   useconds_t;
unsigned int sleep (useconds_t Seconds);
#endif
}

void
request1()
{
  char msg[150];
  int data;
  int i;
  MPI::Request request;
  MPI::Status status;

  request = MPI::REQUEST_NULL;

  Testing("Wait w/o Status");

  if ((my_rank % 2) == 0) {
    data = my_rank;

    MPI::COMM_WORLD.Send(&data, 1, MPI::INT, my_rank + 1, my_rank);
  } else if ((my_rank % 2) == 1) {
    data = -1;

    request = MPI::COMM_WORLD.Irecv(&data, 1, MPI::INT, my_rank - 1, my_rank - 1);
    request.Wait();

    if (data != my_rank - 1) {
      sprintf(msg, "NODE %d - 1) ERROR in Irecv, data = %d, should be %d", my_rank, data, my_rank - 1);
      Fail(msg);
    }
  }
    
  Pass(); // Wait w/o Status

  Testing("Wait w/ Status");

  if ((my_rank % 2) == 0) {
    data = my_rank;

    MPI::COMM_WORLD.Send(&data, 1, MPI::INT, my_rank + 1, my_rank);
  } else if ((my_rank % 2) == 1) {
    data = -1;

    request = MPI::COMM_WORLD.Irecv(&data, 1, MPI::INT, my_rank - 1, my_rank - 1);
    request.Wait(status);

    if (data != my_rank - 1) {
      sprintf(msg, "NODE %d - 2) ERROR in Irecv, data = %d, should be %d", my_rank, data, my_rank - 1);
      Fail(msg);
    }

    if (status.Get_source() != my_rank - 1) {
      sprintf(msg, "NODE %d - 3) ERROR in Wait, status.Get_source = %d, should be %d", my_rank, status.Get_source(), my_rank - 1);
      Fail(msg);
    }

    if (status.Get_tag() != my_rank - 1) {
      sprintf(msg, "NODE %d - 4) ERROR in Wait, status.Get_tag = %d, should be %d", my_rank, status.Get_tag(), my_rank - 1);
      Fail(msg);
    }
  }
  Pass(); // Wait w/ Status

  Testing("Test w/o Status");
  if ((my_rank % 2) == 0) {
    data = my_rank;

    MPI::COMM_WORLD.Send(&data, 1, MPI::INT, my_rank + 1, my_rank);
  } else if ((my_rank % 2) == 1) {
    data = -1;
    i = 0;

    request = MPI::COMM_WORLD.Irecv(&data, 1, MPI::INT, my_rank - 1, my_rank - 1);
    while (request.Test() == 0) {
      //      usleep(1);
      sleep(1);
      i++;
      if (i == 5000) {
	sprintf(msg, "NODE %d - 5) ERROR in Test, 5000 iterations have passed, and Test has not returned true yet.", my_rank);
	Fail(msg);
      }
    }

    if (data != my_rank - 1) {
      sprintf(msg, "NODE %d - 6) ERROR in Irecv, data = %d, should be %d", my_rank, data, my_rank - 1);
      Fail(msg);
    }
  }
  Pass(); // Test w/o Status

  Testing("Test w/ Status");
  if ((my_rank % 2) == 0) {
    data = my_rank;

    MPI::COMM_WORLD.Send(&data, 1, MPI::INT, my_rank + 1, my_rank);
  } else if ((my_rank % 2) == 1) {
    data = -1;

    request = MPI::COMM_WORLD.Irecv(&data, 1, MPI::INT, my_rank - 1, my_rank - 1);
    while (request.Test(status) == 0) {
      //usleep(1);
      sleep(1);
      i++;
      if (i == 5000) {
	sprintf(msg, "NODE %d - 7) ERROR in Test, 5000 iterations have passed, and Test has not returned true yet.", my_rank);
	Fail(msg);
      }
    }

    if (data != my_rank - 1) {
      sprintf(msg, "NODE %d - 8) ERROR in Irecv, data = %d, should be %d", my_rank, data, my_rank - 1);
      Fail(msg);
    }

    if (status.Get_source() != my_rank - 1) {
      sprintf(msg, "NODE %d - 9) ERROR in Wait, status.Get_source = %d, should be %d", my_rank, status.Get_source(), my_rank - 1);
      Fail(msg);
    }

    if (status.Get_tag() != my_rank - 1) {
      sprintf(msg, "NODE %d - 10) ERROR in Wait, status.Get_tag = %d, should be %d", my_rank, status.Get_tag(), my_rank - 1);
      Fail(msg);
    }
  }

  Pass(); // Test w/ Status

  if(request != MPI::REQUEST_NULL)
    request.Free();
}
